/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.recover;

import dna.play.util.exceptions.ServiceException;
import dna.play.util.recover.ErrorResponse;
import org.codehaus.jackson.JsonNode;
import play.Logger;
import play.api.PlayException;
import play.libs.Json;
import play.mvc.Result;
import play.mvc.Results;

public final class DefaultExceptionHandler {
    private DefaultExceptionHandler() {
    }

    public static Result handle(Throwable t) {
        Logger.debug((String)"DefaultExceptionHandler : handle(..) ");
        if (t == null) {
            System.err.println("Error: null Message : Unexpected internal error.");
            Logger.error((String)"Unexpected internal error.");
            ErrorResponse errorResponse = new ErrorResponse(901, "Service Exception");
            return Results.status((int)500, (JsonNode)Json.toJson((Object)errorResponse));
        }
        if (t instanceof PlayException && t.getCause() != null) {
            t = t.getCause();
        }
        String message = t.getMessage() != null ? t.getMessage() : "An error occurred.";
        System.err.println("Error: " + t.getClass().getName() + " Message: " + t.getMessage());
        Logger.error((String)message, (Throwable)t);
        if (t instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)t;
            int errorCode = serviceException.getDefaultHttpStatusCode();
            String accountId = serviceException.getAccountId();
            ErrorResponse errorResponse = new ErrorResponse(serviceException.getReasonCode(), serviceException.getDescription());
            Logger.error((String)("DefaultExceptionHandler : handle(..) : return result with errorCode : " + errorCode + " and errorResponse json : " + errorResponse.toString() + " accountId : " + accountId));
            return Results.status((int)errorCode, (JsonNode)Json.toJson((Object)errorResponse));
        }
        Logger.debug((String)"DefaultExceptionHandler : handle(..) : return result with errorCode : 500 message : Unexpected internal error.");
        ErrorResponse errorResponse = new ErrorResponse(901, "Service Exception");
        return Results.status((int)500, (JsonNode)Json.toJson((Object)errorResponse));
    }
}

