/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.identity.codec;

import dna.play.util.identity.codec.Base16Coder;
import dna.play.util.identity.codec.Hash;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypt {
    private static final String keyScheme = "AES";
    private static final String scheme = "AES/CBC/PKCS5Padding";
    private Key secretKey;
    private IvParameterSpec ivKey;
    ThreadLocal<Cipher> encryptCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                Cipher cipher = Cipher.getInstance(Crypt.scheme);
                cipher.init(1, Crypt.this.secretKey, Crypt.this.ivKey);
                return cipher;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    ThreadLocal<Cipher> decryptCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                Cipher cipher = Cipher.getInstance(Crypt.scheme);
                cipher.init(2, Crypt.this.secretKey, Crypt.this.ivKey);
                return cipher;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    public byte[] encrypt(byte[] value) {
        try {
            return this.encryptCipher.get().doFinal(value);
        }
        catch (Exception e) {
            try {
                this.encryptCipher.get().doFinal();
            }
            catch (IllegalBlockSizeException e1) {
                e1.printStackTrace();
            }
            catch (BadPaddingException e1) {
                e1.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    public byte[] decrypt(byte[] encryptedValue) {
        try {
            return this.decryptCipher.get().doFinal(encryptedValue);
        }
        catch (Exception e) {
            try {
                this.decryptCipher.get().doFinal();
            }
            catch (IllegalBlockSizeException e1) {
                e1.printStackTrace();
            }
            catch (BadPaddingException e1) {
                e1.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    public String encryptAndBase16EncodeByte(byte[] value) {
        byte[] result = this.encrypt(value);
        return Base16Coder.encodeBytes(result);
    }

    public byte[] decryptAndBase16DecodeByte(String encodedValue) {
        byte[] temp = Base16Coder.decodeBytes(encodedValue);
        byte[] result = this.decrypt(temp);
        return result;
    }

    public String encryptAndBase16Encode(String value) {
        byte[] temp = null;
        try {
            temp = value.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.encryptAndBase16EncodeByte(temp);
    }

    public String decryptAndBase16Decode(String encodedValue) {
        return new String(this.decryptAndBase16DecodeByte(encodedValue));
    }

    public Crypt(String password, String salt) {
        byte[] sha256 = Hash.sha256.hash(salt + password);
        byte[] key128 = new byte[16];
        byte[] iv128 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            key128[i] = sha256[i * 2];
            iv128[i] = sha256[i * 2 + 1];
        }
        this.secretKey = new SecretKeySpec(key128, keyScheme);
        this.ivKey = new IvParameterSpec(iv128);
    }

    public static String generateRandomPassword() {
        SecureRandom random = new SecureRandom();
        char[] password = new char[20];
        for (int i = 0; i < password.length; ++i) {
            password[i] = (char)(random.nextInt(94) + 33);
        }
        return new String(password);
    }
}

