/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.identity;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import dna.play.util.exceptions.ForbiddenException;
import dna.play.util.identity.codec.Base16Coder;
import dna.play.util.identity.codec.Crypt;
import dna.play.util.identity.codec.Hash;
import java.util.Arrays;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class Token {
    private static Crypt crypt = new Crypt("YAy9GYHrbnRCVbdddXEJLYqWX4Mnf6dDVbwEBKerZgQAYSzCRFHsfC3PWnyCJXSERAYqc9cLyTb2jvhGnxEXFZWEc26XrUeyMscJHccKYgZ5vLz3rVnmaTyp", "3mbgmrYbhuxK4L7yrK4BTaS6");
    private static final int CURRENT_VERSION = 1;
    public static final int ACCESS_TOKEN_EXPIRATION = 900;
    private String accountId;
    private DateTime creationTime;
    private DateTime expirationTime;
    private Device client = null;

    public Token() {
    }

    private Token(byte[] tokenByteArray) {
        Token tmpToken = new Token();
        Schema tokenSchema = RuntimeSchema.getSchema(Token.class);
        ProtostuffIOUtil.mergeFrom((byte[])tokenByteArray, (Object)tmpToken, (Schema)tokenSchema);
        this.accountId = tmpToken.accountId;
        this.creationTime = tmpToken.creationTime;
        this.expirationTime = tmpToken.expirationTime;
        this.client = tmpToken.client;
    }

    private Token(String accountId) {
        this.accountId = accountId;
        this.creationTime = DateTime.now();
        this.expirationTime = this.creationTime.plusSeconds(900);
    }

    public static Token createAccessToken(String accountId, String deviceType, String clientVersion, String os, String osVersion) {
        Device device;
        Token token = new Token(accountId);
        token.client = device = new Device(deviceType, clientVersion, os, osVersion);
        return token;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public DateTime getCreationTime() {
        return this.creationTime;
    }

    public DateTime getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isExpired() {
        return this.expirationTime.isBefore((ReadableInstant)DateTime.now());
    }

    public int getExpiresIn() {
        long diff = this.expirationTime.getMillis() - this.creationTime.getMillis();
        return (int)(diff / 1000L);
    }

    public String getDeviceType() {
        return this.client.deviceType;
    }

    public String getClientVersion() {
        return this.client.clientVersion;
    }

    public String getOs() {
        return this.client.os;
    }

    public String getOsVersion() {
        return this.client.osVersion;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Token other) {
        if (!this.accountId.equals(other.accountId)) {
            return false;
        }
        if (!this.expirationTime.equals((Object)other.expirationTime)) {
            return false;
        }
        if (!this.creationTime.equals((Object)other.creationTime)) {
            return false;
        }
        return !(this.client != null && other.client != null ? !this.client.equals(other.client) : this.client != null || other.client != null);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("accountId=");
        b.append(this.accountId);
        b.append(", expiration=");
        b.append(this.expirationTime);
        b.append(", creation=");
        b.append(this.creationTime);
        b.append(", client=");
        if (this.client != null) {
            b.append(this.client.toString());
        } else {
            b.append("null");
        }
        return b.toString();
    }

    public static Token decode(String encodeToken) {
        if (encodeToken == null || encodeToken.isEmpty()) {
            throw new ForbiddenException("Empty or null Access Token", null);
        }
        try {
            byte[] temp = Token.verifyAndRemoveSignature(crypt.decrypt(Token.symmetricScramble(Base16Coder.decodeBytes(encodeToken))));
            return new Token(temp);
        }
        catch (Exception e) {
            throw new ForbiddenException("Decode access token failed. ", e, null);
        }
    }

    private static byte[] symmetricScramble(byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)(value[i] ^ 79 + i * 12 & 0xFF);
        }
        return value;
    }

    private static byte[] verifyAndRemoveSignature(byte[] encodedValueWithSignature) {
        byte[] signature = new byte[16];
        int length = encodedValueWithSignature.length;
        for (int i = 0; i < 8; ++i) {
            signature[i] = encodedValueWithSignature[length - i - 1];
            signature[i + 8] = encodedValueWithSignature[i];
        }
        byte[] encodedValueWithoutSignature = Arrays.copyOfRange(encodedValueWithSignature, 8, length - 8);
        byte[] calculatedSignature = Hash.sha1.hash(encodedValueWithoutSignature);
        for (int i = 0; i < 16; ++i) {
            if (signature[i] == calculatedSignature[i]) continue;
            throw new ForbiddenException("Failed to deserialize token, attempted tampering.", null);
        }
        return encodedValueWithoutSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() {
        Schema tokenSchema = RuntimeSchema.getSchema(Token.class);
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            byte[] serialized = ProtostuffIOUtil.toByteArray((Object)this, (Schema)tokenSchema, (LinkedBuffer)buffer);
            String string = Base16Coder.encodeBytes(Token.symmetricScramble(crypt.encrypt(Token.signAndAddSignature(serialized))));
            return string;
        }
        finally {
            buffer.clear();
        }
    }

    private static byte[] signAndAddSignature(byte[] encodedValueWithoutSignature) {
        byte[] encodedValueWithSignature = new byte[encodedValueWithoutSignature.length + 16];
        byte[] calculatedSignature = Hash.sha1.hash(encodedValueWithoutSignature);
        int length = encodedValueWithSignature.length;
        for (int i = 0; i < 8; ++i) {
            encodedValueWithSignature[length - i - 1] = calculatedSignature[i];
            encodedValueWithSignature[i] = calculatedSignature[i + 8];
        }
        System.arraycopy(encodedValueWithoutSignature, 0, encodedValueWithSignature, 8, encodedValueWithoutSignature.length);
        return encodedValueWithSignature;
    }

    public static class Device {
        private String deviceType;
        private String clientVersion;
        private String os;
        private String osVersion;

        public Device(String deviceType, String clientVersion, String os, String osVersion) {
            if (deviceType == null) {
                deviceType = "";
            }
            if (clientVersion == null) {
                clientVersion = "";
            }
            if (os == null) {
                os = "";
            }
            if (osVersion == null) {
                osVersion = "";
            }
            this.deviceType = deviceType;
            this.clientVersion = clientVersion;
            this.os = os;
            this.osVersion = osVersion;
        }

        public boolean equals(Device other) {
            if (!this.clientVersion.equals(other.clientVersion)) {
                return false;
            }
            if (!this.deviceType.equals(other.deviceType)) {
                return false;
            }
            if (!this.os.equals(other.os)) {
                return false;
            }
            return this.osVersion.equals(other.osVersion);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("clientVersion=");
            buffer.append(this.clientVersion);
            buffer.append("os=");
            buffer.append(this.os);
            buffer.append("osVersion=");
            buffer.append(this.osVersion);
            buffer.append("deviceType=");
            buffer.append(this.deviceType);
            return buffer.toString();
        }
    }
}

