/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.action;

import dna.play.util.action.LogStatistics;
import play.Logger;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogStatisticsAction
extends Action<LogStatistics> {
    public Result call(Http.Context ctx) throws Throwable {
        final long startTime = System.currentTimeMillis();
        final String path = ctx.request().path();
        Result result = this.delegate.call(ctx);
        if (result instanceof Results.AsyncResult) {
            Results.AsyncResult asyncResult = (Results.AsyncResult)result;
            return asyncResult.transform((F.Function)new F.Function<Result, Result>(){

                public Result apply(Result a) throws Throwable {
                    long endTime = System.currentTimeMillis();
                    LogStatisticsAction.this.reportTime(path, startTime, endTime);
                    return a;
                }
            });
        }
        long endTime = System.currentTimeMillis();
        this.reportTime(path, startTime, endTime);
        return result;
    }

    private void reportTime(String path, long startTime, long endTime) {
        long dt = endTime - startTime;
        Logger.debug((String)("Path : " + path + " took " + dt + " millis."));
    }
}

