/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.action;

import dna.play.util.Constants;
import dna.play.util.RequestHelper;
import dna.play.util.action.Authorize;
import dna.play.util.exceptions.MissingParameterException;
import dna.play.util.exceptions.UnauthorizedException;
import dna.play.util.identity.Token;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizeAction
extends Action<Authorize> {
    private static final String PARAM_ACCESS_TOKEN = "accessToken";

    public Result call(Http.Context context) throws Throwable {
        Token token = AuthorizeAction.authorize(RequestHelper.parseParameter(Constants.HTTP_PARAM_ACCESS_TOKEN.asString(), context.request()));
        context.args.put("token", token);
        return this.delegate.call(context);
    }

    public static Token authorize(String accessToken) {
        if (accessToken == null) {
            throw new MissingParameterException("Missing access token", PARAM_ACCESS_TOKEN, null);
        }
        Token token = Token.decode(accessToken);
        if (token.isExpired()) {
            throw new UnauthorizedException("Token has been expired.", null);
        }
        return token;
    }
}

