/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.google.common.collect.Lists;
import constants.SocialNetworks;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SocialNetworkPermissions {
    FB_USER_SUBSCRIPTIONS("user_subscriptions"),
    FB_FRIENDS_SUBSCRIPTIONS("friends_subscriptions"),
    FB_READ_STREAM("read_stream"),
    FB_USER_LIKES("user_likes"),
    FB_FRIENDS_LIKES("friends_likes"),
    FB_PUBLISH_ACTIONS("publish_actions"),
    VK_FRIENDS("friends"),
    VK_WALL("wall"),
    VK_OFFLINE("offline"),
    VK_REQUIRED_PREMISSION_BIT_MASK("73730");

    private String permission;

    private SocialNetworkPermissions(String permission) {
        this.permission = permission;
    }

    public String asString() {
        return this.permission;
    }

    public static List<String> requiredPermissionListOfString(SocialNetworks socialNetworks) {
        switch (socialNetworks) {
            case Facebook: {
                return Lists.newArrayList((Object[])new String[]{FB_USER_SUBSCRIPTIONS.asString(), FB_FRIENDS_SUBSCRIPTIONS.asString(), FB_USER_LIKES.asString(), FB_FRIENDS_LIKES.asString(), FB_READ_STREAM.asString()});
            }
            case Vkontakte: {
                return Lists.newArrayList((Object[])new String[]{VK_FRIENDS.asString(), VK_WALL.asString(), VK_OFFLINE.asString()});
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static List<String> permissionListOfStringIncludeOptional(SocialNetworks socialNetworks) {
        switch (socialNetworks) {
            case Facebook: {
                return Lists.newArrayList((Object[])new String[]{FB_USER_SUBSCRIPTIONS.asString(), FB_FRIENDS_SUBSCRIPTIONS.asString(), FB_USER_LIKES.asString(), FB_FRIENDS_LIKES.asString(), FB_READ_STREAM.asString(), FB_PUBLISH_ACTIONS.asString()});
            }
            case Vkontakte: {
                return Lists.newArrayList((Object[])new String[]{VK_FRIENDS.asString(), VK_WALL.asString(), VK_OFFLINE.asString()});
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }
}

