/*
 * Decompiled with CFR 0.152.
 */
package util;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import constants.SocialNetworks;
import entities.common.Level2AccountEntity;
import entities.common.Level3DNAAccountEntity;
import entities.interfaces.Level2Account;
import entities.interfaces.UserProfile;
import entities.interfaces.UserState;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import riak.Riak;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import util.AccountIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FriendsHelper {
    private static final String FRIENDS = "friends";
    private static final String DNA_FRIENDS = "dna-friends";

    public static Future<Level3DNAAccountEntity.FriendBundle> divideFriends(final String sourceLevel2AccountId, UserState userState, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: FriendsHelper.divideFriends");
        final Set<? extends UserProfile> friends = userState.getFriends();
        ArrayList<Future<Level2Account>> futureList = new ArrayList<Future<Level2Account>>();
        for (UserProfile userProfile : friends) {
            String userLevel2Id = AccountIdGenerator.createIdBasedOnSocialNetwork(userProfile.getId(), SocialNetworks.valueOf(userProfile.getSocialNetworkName()));
            futureList.add(Level2AccountEntity.fetch(userLevel2Id, token));
        }
        Future sequence = Futures.sequence(futureList, (ExecutionContext)Riak.getExecutionContext());
        Future future = sequence.flatMap((Function1)new Mapper<Iterable<Level2Account>, Future<List<Level2Account>>>(){

            public Future<List<Level2Account>> apply(final Iterable<Level2Account> level2AccountIterable) {
                return Futures.future((Callable)new Callable<List<Level2Account>>(){

                    @Override
                    public List<Level2Account> call() throws Exception {
                        ArrayList<Level2Account> resultList = new ArrayList<Level2Account>();
                        if (level2AccountIterable != null) {
                            for (Level2Account eachLevel2AccountFromIterable : level2AccountIterable) {
                                if (eachLevel2AccountFromIterable == null || eachLevel2AccountFromIterable.getLevel3DNAAccountId() == null) continue;
                                resultList.add(eachLevel2AccountFromIterable);
                            }
                        }
                        return resultList;
                    }
                }, (ExecutionContext)Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
        Future twoSetsFuture = future.flatMap((Function1)new Mapper<List<Level2Account>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(List<Level2Account> level2AccountList) {
                Set socialFriends = FriendsHelper.filterById(friends, level2AccountList);
                return FriendsHelper.futureMap(socialFriends, level2AccountList, token);
            }
        }, Riak.getExecutionContext());
        return twoSetsFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Level3DNAAccountEntity.FriendBundle>>(){

            public Future<Level3DNAAccountEntity.FriendBundle> apply(final Map<String, Object> map) {
                return Futures.future((Callable)new Callable<Level3DNAAccountEntity.FriendBundle>(){

                    @Override
                    public Level3DNAAccountEntity.FriendBundle call() throws Exception {
                        Set socialFriends = (Set)map.get(FriendsHelper.FRIENDS);
                        Set level3Hash = (Set)map.get(FriendsHelper.DNA_FRIENDS);
                        HashSet<Level3DNAAccountEntity.SocialDnaProfile> socialDnaSet = new HashSet<Level3DNAAccountEntity.SocialDnaProfile>();
                        for (Level3DNAAccountEntity eachL3 : level3Hash) {
                            Level3DNAAccountEntity.SocialDnaProfile socialDnaProfile = new Level3DNAAccountEntity.SocialDnaProfile(eachL3.getLevel3DNAAccountId(), eachL3.getName(), eachL3.getGender(), eachL3.getLocale(), eachL3.getEmail(), eachL3.getPictureUrl(), eachL3.getContextBundleForEachNetworkMap());
                            socialDnaSet.add(socialDnaProfile);
                        }
                        Level3DNAAccountEntity.FriendBundle bundle = new Level3DNAAccountEntity.FriendBundle(sourceLevel2AccountId, socialFriends, socialDnaSet);
                        return bundle;
                    }
                }, (ExecutionContext)Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity.FriendBundle>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity.FriendBundle friendBundle) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    private static Future<Map<String, Object>> futureMap(final Set<UserProfile> socialFriends, List<Level2Account> level2AccountList, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: FriendsHelper.futureMap");
        ArrayList<Future<Level3DNAAccountEntity>> dnaAccountEntityListFuture = new ArrayList<Future<Level3DNAAccountEntity>>();
        for (Level2Account eachLevel2 : level2AccountList) {
            dnaAccountEntityListFuture.add(Level3DNAAccountEntity.fetch(eachLevel2.getLevel3DNAAccountId(), token));
        }
        Future sequenceList = Futures.sequence(dnaAccountEntityListFuture, (ExecutionContext)Riak.getExecutionContext());
        return sequenceList.flatMap((Function1)new Mapper<Iterable<Level3DNAAccountEntity>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Iterable<Level3DNAAccountEntity> level3DNAAccountEntityIterable) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        HashSet<Level3DNAAccountEntity> level3Hash = new HashSet<Level3DNAAccountEntity>();
                        if (level3DNAAccountEntityIterable != null) {
                            for (Level3DNAAccountEntity each : level3DNAAccountEntityIterable) {
                                level3Hash.add(each);
                            }
                        }
                        result.put(FriendsHelper.FRIENDS, socialFriends);
                        result.put(FriendsHelper.DNA_FRIENDS, level3Hash);
                        return result;
                    }
                }, (ExecutionContext)Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Map<String, Object>>(){

            public void onComplete(Throwable throwable, Map<String, Object> stringObjectMap) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    private static Set<UserProfile> filterById(Set<? extends UserProfile> friends, List<Level2Account> level2AccountList) {
        HashSet<UserProfile> socialFriends = new HashSet<UserProfile>();
        for (UserProfile userProfile : friends) {
            if (FriendsHelper.existIntoList(level2AccountList, userProfile.getId())) continue;
            socialFriends.add(userProfile);
        }
        return socialFriends;
    }

    private static boolean existIntoList(List<Level2Account> level2AccountList, String socialNetworkUserId) {
        for (Level2Account eachLevel2Account : level2AccountList) {
            if (!eachLevel2Account.getSocialNetworkUserId().equals(socialNetworkUserId)) continue;
            return true;
        }
        return false;
    }
}

