/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import com.basho.riak.client.convert.RiakKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import constants.Dates;
import constants.SocialNetworks;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import riak.Riak;
import riak.RiakCommon;
import riak.RiakEntity;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RiakEntity(bucketName="state.history", allowSiblings=true)
public class StateHistoryEntity {
    @JsonProperty
    @RiakKey
    private final String historyId;
    @JsonProperty
    private final Map<String, Set<String>> historyForEachNetwork;

    @JsonCreator
    public StateHistoryEntity(@JsonProperty(value="historyId") String historyId, @JsonProperty(value="historyForEachNetwork") Map<String, Set<String>> historyForEachNetwork) {
        this.historyId = historyId;
        this.historyForEachNetwork = new HashMap<String, Set<String>>();
        for (SocialNetworks eachNetwork : SocialNetworks.values()) {
            HashSet set = new HashSet();
            this.historyForEachNetwork.put(eachNetwork.name(), set);
        }
        if (historyForEachNetwork != null && !historyForEachNetwork.isEmpty()) {
            for (String eachKey : historyForEachNetwork.keySet()) {
                Set<String> eachSet = historyForEachNetwork.get(eachKey);
                if (eachSet == null || eachSet.isEmpty()) continue;
                this.historyForEachNetwork.get(eachKey).addAll(eachSet);
            }
        }
    }

    @JsonIgnore
    public String getHistoryId() {
        return this.historyId;
    }

    @JsonIgnore
    public Map<String, Set<String>> getHistoryForEachNetwork() {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        for (SocialNetworks eachNetwork : SocialNetworks.values()) {
            HashSet set = new HashSet();
            resultMap.put(eachNetwork.name(), set);
        }
        if (this.historyForEachNetwork != null && !this.historyForEachNetwork.isEmpty()) {
            for (String eachKey : this.historyForEachNetwork.keySet()) {
                Set<String> eachSet = this.historyForEachNetwork.get(eachKey);
                if (eachSet == null || eachSet.isEmpty()) continue;
                ((Set)resultMap.get(eachKey)).addAll(eachSet);
            }
        }
        return resultMap;
    }

    @JsonIgnore
    public Future<StateHistoryEntity> addUserStateId(String userStateId, SocialNetworks socialNetwork, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: StateHistoryEntity.addUserStateId");
        Map<String, Set<String>> map = this.getHistoryForEachNetwork();
        map.get(socialNetwork.name()).add(userStateId);
        final StateHistoryEntity result = new StateHistoryEntity(this.historyId, map);
        return RiakCommon.storeEntity(result, token).flatMap((Function1)new Mapper<Void, Future<StateHistoryEntity>>(){

            public Future<StateHistoryEntity> apply(Void parameter) {
                return Futures.successful((Object)result);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<StateHistoryEntity>(){

            public void onComplete(Throwable throwable, StateHistoryEntity stateHistoryEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    @JsonIgnore
    public StateHistoryEntity addUserStateIdSync(String userStateId, SocialNetworks socialNetwork, Token token) {
        Map<String, Set<String>> map = this.getHistoryForEachNetwork();
        map.get(socialNetwork.name()).add(userStateId);
        StateHistoryEntity result = new StateHistoryEntity(this.historyId, map);
        RiakCommon.storeEntitySync(result, token);
        return result;
    }

    public static Future<Void> addUserStateIdToHistory(final String userStateId, final SocialNetworks socialNetwork, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: StateHistoryEntity.addUserStateIdToHistory");
        final String historyId = LocalDate.now().toString();
        return RiakCommon.fetchEntityById(historyId, StateHistoryEntity.class, token).flatMap((Function1)new Mapper<StateHistoryEntity, Future<Void>>(){

            public Future<Void> apply(StateHistoryEntity fetchedStateHistory) {
                if (fetchedStateHistory == null) {
                    HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
                    HashSet<String> set = new HashSet<String>();
                    set.add(userStateId);
                    map.put(socialNetwork.name(), set);
                    StateHistoryEntity newStateHistoryEntity = new StateHistoryEntity(historyId, map);
                    return RiakCommon.storeEntity(newStateHistoryEntity, token);
                }
                return fetchedStateHistory.addUserStateId(userStateId, socialNetwork, token).flatMap((Function1)new Mapper<StateHistoryEntity, Future<Void>>(){

                    public Future<Void> apply(StateHistoryEntity parameter) {
                        return null;
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Void>(){

            public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static void addUserStateIdToHistorySync(String userStateId, SocialNetworks socialNetwork, Token token) {
        String historyId = LocalDate.now().toString();
        StateHistoryEntity fetchedStateHistory = RiakCommon.fetchEntityByIdSync(historyId, StateHistoryEntity.class, token);
        if (fetchedStateHistory == null) {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            HashSet<String> set = new HashSet<String>();
            set.add(userStateId);
            map.put(socialNetwork.name(), set);
            StateHistoryEntity newStateHistoryEntity = new StateHistoryEntity(historyId, map);
            RiakCommon.storeEntitySync(newStateHistoryEntity, token);
            return;
        }
        fetchedStateHistory.addUserStateIdSync(userStateId, socialNetwork, token);
    }

    public static Future<Set<String>> grabAllKeysByDate(LocalDate localDate, final SocialNetworks socialNetwork, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: StateHistoryEntity.grabAllKeysByDate");
        return RiakCommon.fetchEntityById(localDate.toString(), StateHistoryEntity.class, token).flatMap((Function1)new Mapper<StateHistoryEntity, Future<Set<String>>>(){

            public Future<Set<String>> apply(final StateHistoryEntity fetchedStateHistory) {
                return Futures.future((Callable)new Callable<Set<String>>(){

                    @Override
                    public Set<String> call() throws Exception {
                        if (fetchedStateHistory == null) {
                            return new HashSet<String>();
                        }
                        return fetchedStateHistory.getHistoryForEachNetwork().get(socialNetwork.name());
                    }
                }, (ExecutionContext)Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Set<String>>(){

            public void onComplete(Throwable throwable, Set<String> strings) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Iterable<Set<String>>> grabAllKeysFromBeginningOfTime(SocialNetworks socialNetwork, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: StateHistoryEntity.grabAllKeysFromBeginningOfTime");
        LocalDate now = LocalDate.now();
        LocalDate tmpDate = Dates.BEGINNING_OF_TIME.asDate();
        ArrayList<Future<Set<String>>> futureList = new ArrayList<Future<Set<String>>>();
        while (tmpDate.isBefore((ReadablePartial)now) || tmpDate.isEqual((ReadablePartial)now)) {
            futureList.add(StateHistoryEntity.grabAllKeysByDate(tmpDate, socialNetwork, token));
            tmpDate = tmpDate.plusDays(1);
        }
        return Futures.sequence(futureList, (ExecutionContext)Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Iterable<Set<String>>>(){

            public void onComplete(Throwable throwable, Iterable<Set<String>> sets) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }
}

