/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventVO
implements Comparable<EventVO> {
    @JsonProperty
    private final String title_ru;
    @JsonProperty
    private final String description_ru;
    @JsonProperty
    private final String title_en;
    @JsonProperty
    private final String description_en;
    @JsonProperty
    private final String pictureUrl;
    @JsonProperty
    private final String pictureUrlRetina;
    @JsonProperty
    private final long timeStamp;
    @JsonProperty
    private final String eventId;

    @JsonCreator
    public EventVO(@JsonProperty(value="title_ru") String title_ru, @JsonProperty(value="description_ru") String description_ru, @JsonProperty(value="title_en") String title_en, @JsonProperty(value="description_en") String description_en, @JsonProperty(value="pictureUrl") String pictureUrl, @JsonProperty(value="pictureUrlRetina") String pictureUrlRetina) {
        this.title_ru = title_ru;
        this.description_ru = description_ru;
        this.title_en = title_en;
        this.description_en = description_en;
        this.pictureUrl = pictureUrl;
        this.pictureUrlRetina = pictureUrlRetina;
        this.timeStamp = DateTime.now().getMillis();
        this.eventId = UUID.randomUUID().toString();
    }

    @JsonIgnore
    public String getTitle_ru() {
        return this.title_ru;
    }

    @JsonIgnore
    public String getDescription_ru() {
        return this.description_ru;
    }

    @JsonIgnore
    public String getTitle_en() {
        return this.title_en;
    }

    @JsonIgnore
    public String getDescription_en() {
        return this.description_en;
    }

    @JsonIgnore
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @JsonIgnore
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @JsonIgnore
    public String getEventId() {
        return this.eventId;
    }

    @JsonIgnore
    public String getPictureUrlRetina() {
        return this.pictureUrlRetina;
    }

    @JsonIgnore
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventVO eventVO = (EventVO)o;
        return this.eventId.equals(eventVO.eventId);
    }

    @JsonIgnore
    public int hashCode() {
        return this.eventId.hashCode();
    }

    @Override
    @JsonIgnore
    public int compareTo(EventVO o) {
        if (this.timeStamp == o.timeStamp) {
            return 0;
        }
        if (this.timeStamp > o.timeStamp) {
            return 1;
        }
        return -1;
    }

    @JsonIgnore
    public String toString() {
        return "EventVO{title_ru='" + this.title_ru + '\'' + ", description_ru='" + this.description_ru + '\'' + ", title_en='" + this.title_en + '\'' + ", description_en='" + this.description_en + '\'' + ", pictureUrl='" + this.pictureUrl + '\'' + ", pictureUrlRetina='" + this.pictureUrlRetina + '\'' + ", timeStamp=" + this.timeStamp + ", eventId='" + this.eventId + '\'' + '}';
    }
}

