/*
 * Decompiled with CFR 0.152.
 */
package util;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import constants.Contexts;
import constants.EventCollection;
import constants.SocialNetworks;
import entities.common.ContextVO;
import entities.common.EventQueueEntity;
import entities.common.EventVO;
import entities.common.Level3DNAAccountEntity;
import identity.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import riak.Riak;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventQueueBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EventQueueBuilder.class);

    public static Future<Level3DNAAccountEntity> welcome(final Level3DNAAccountEntity dnaAccountEntity, final Token token) {
        logger.info("welcome() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: EventQueueBuilder.welcome");
        Future constructEvent = Futures.future((Callable)new Callable<List<EventVO>>(){

            @Override
            public List<EventVO> call() throws Exception {
                ArrayList<EventVO> eventVOList = new ArrayList<EventVO>();
                ContextVO finalMainContext = EventQueueBuilder.findMainContext(dnaAccountEntity.getDnaContexts());
                EventCollection eventCollection = EventCollection.WELCOME;
                EventVO welcomeEvent = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescription_ru(finalMainContext.getScore()), eventCollection.getTitle_en(), eventCollection.getDescription_en(finalMainContext.getScore()), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                eventVOList.add(welcomeEvent);
                eventCollection = EventCollection.NEW_RANK_PLUS;
                EventVO newRankEvent = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescriptionWithoutScores_ru(finalMainContext.getRank().getRank_ru()), eventCollection.getTitle_en(), eventCollection.getDescriptionWithoutScores_en(finalMainContext.getRank().getRank_en()), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                eventVOList.add(newRankEvent);
                return eventVOList;
            }
        }, (ExecutionContext)Riak.getExecutionContext());
        return constructEvent.flatMap((Function1)new Mapper<List<EventVO>, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(List<EventVO> eventList) {
                return EventQueueEntity.addEventList(dnaAccountEntity.getLevel3DNAAccountId(), eventList, token).flatMap((Function1)new Mapper<EventQueueEntity, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(EventQueueEntity parameter) {
                        return Futures.successful((Object)dnaAccountEntity);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity dnaAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Level3DNAAccountEntity> compare(final Level3DNAAccountEntity old, final Level3DNAAccountEntity newOne, final Token token) {
        logger.info("compare() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: EventQueueBuilder.compare");
        Future finalScoreFuture = Futures.future((Callable)new Callable<Changes>(){

            @Override
            public Changes call() throws Exception {
                Set<ContextVO> oldContexts = old.getDnaContexts();
                Set<ContextVO> newContexts = newOne.getDnaContexts();
                ContextVO oldMainContext = EventQueueBuilder.findMainContext(oldContexts);
                ContextVO newMainContext = EventQueueBuilder.findMainContext(newContexts);
                double oldScore = oldMainContext != null ? oldMainContext.getScore() : 0.0;
                double newScore = newMainContext != null ? newMainContext.getScore() : 0.0;
                ContextVO.Rank oldRank = oldMainContext != null ? oldMainContext.getRank() : null;
                ContextVO.Rank newRank = newMainContext != null ? newMainContext.getRank() : null;
                Map<String, Level3DNAAccountEntity.ContextBundle> oldMapForEachNetwork = old.getContextBundleForEachNetworkMap();
                Map<String, Level3DNAAccountEntity.ContextBundle> newMapForEachNetwork = newOne.getContextBundleForEachNetworkMap();
                HashSet<String> oldNetworks = new HashSet<String>();
                HashSet<String> newNetworks = new HashSet<String>();
                for (String eachNetwork : oldMapForEachNetwork.keySet()) {
                    if (oldMapForEachNetwork.get(eachNetwork) == null || eachNetwork.equals(SocialNetworks.SocialDNA.name())) continue;
                    oldNetworks.add(eachNetwork);
                }
                for (String eachNetwork : newMapForEachNetwork.keySet()) {
                    if (newMapForEachNetwork.get(eachNetwork) == null || eachNetwork.equals(SocialNetworks.SocialDNA.name())) continue;
                    newNetworks.add(eachNetwork);
                }
                HashSet<Level3DNAAccountEntity.SocialDnaProfile> oldDnaFriends = new HashSet<Level3DNAAccountEntity.SocialDnaProfile>();
                HashSet<Level3DNAAccountEntity.SocialDnaProfile> newDnaFriends = new HashSet<Level3DNAAccountEntity.SocialDnaProfile>();
                Map<String, Level3DNAAccountEntity.FriendBundle> oldfriendsBundleForEachNetworkMap = old.getFriendsBundleForEachNetworkMap();
                for (String eachNetwork : oldfriendsBundleForEachNetworkMap.keySet()) {
                    Level3DNAAccountEntity.FriendBundle friendBundle;
                    if (eachNetwork.equals(SocialNetworks.SocialDNA.name()) || (friendBundle = oldfriendsBundleForEachNetworkMap.get(eachNetwork)) == null) continue;
                    oldDnaFriends.addAll(friendBundle.getSocialDNAfriends());
                }
                Map<String, Level3DNAAccountEntity.FriendBundle> newfriendsBundleForEachNetworkMap = newOne.getFriendsBundleForEachNetworkMap();
                for (String eachNetwork : newfriendsBundleForEachNetworkMap.keySet()) {
                    Level3DNAAccountEntity.FriendBundle friendBundle;
                    if (eachNetwork.equals(SocialNetworks.SocialDNA.name()) || (friendBundle = newfriendsBundleForEachNetworkMap.get(eachNetwork)) == null) continue;
                    newDnaFriends.addAll(friendBundle.getSocialDNAfriends());
                }
                Changes result = new Changes(oldScore, newScore, oldRank, newRank, oldNetworks, newNetworks, oldDnaFriends, newDnaFriends);
                return result;
            }
        }, (ExecutionContext)Riak.getExecutionContext());
        return finalScoreFuture.flatMap((Function1)new Mapper<Changes, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Changes changes) {
                EventVO eventVO;
                EventVO wasAdded;
                EventCollection eventCollection;
                ArrayList<EventVO> eventVOList = new ArrayList<EventVO>();
                double delta = changes.getNewScore() - changes.getOldScore();
                if (delta > -1.0 && delta < 1.0) {
                    delta = 0.0;
                }
                if (delta <= -1.0) {
                    delta = -1.0 * delta;
                }
                Set<String> oldNetworks = changes.getOldNetworks();
                Set<String> newNetworks = changes.getNewNetworks();
                boolean changesInSocialNetworks = false;
                if (newNetworks.size() > oldNetworks.size()) {
                    changesInSocialNetworks = true;
                    eventCollection = EventCollection.CONNECT_SOCIAL_NETWORK;
                    wasAdded = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescription_ru(delta), eventCollection.getTitle_en(), eventCollection.getDescription_en(delta), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                    eventVOList.add(wasAdded);
                } else if (newNetworks.size() < oldNetworks.size()) {
                    changesInSocialNetworks = true;
                    eventCollection = EventCollection.DISCONNECT_SOCIAL_NETWORK;
                    wasAdded = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescription_ru(delta), eventCollection.getTitle_en(), eventCollection.getDescription_en(delta), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                    eventVOList.add(wasAdded);
                }
                if (changes.getNewRank() != null && !changes.getNewRank().equals(changes.getOldRank())) {
                    if (changes.getNewScore() > changes.getOldScore()) {
                        eventCollection = EventCollection.NEW_RANK_PLUS;
                        eventVO = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescriptionWithoutScores_ru(changes.getNewRank().getRank_ru()), eventCollection.getTitle_en(), eventCollection.getDescriptionWithoutScores_en(changes.getNewRank().getRank_en()), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                        eventVOList.add(eventVO);
                    } else {
                        eventCollection = EventCollection.NEW_RANK_MINUS;
                        eventVO = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescriptionWithoutScores_ru(changes.getNewRank().getRank_ru()), eventCollection.getTitle_en(), eventCollection.getDescriptionWithoutScores_en(changes.getNewRank().getRank_en()), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                        eventVOList.add(eventVO);
                    }
                }
                if (!changesInSocialNetworks && delta >= 1.0) {
                    if (changes.getNewScore() > changes.getOldScore()) {
                        eventCollection = EventCollection.INCREASE_OWN_SCORE;
                        eventVO = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescription_ru(delta), eventCollection.getTitle_en(), eventCollection.getDescription_en(delta), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                        eventVOList.add(eventVO);
                    } else {
                        eventCollection = EventCollection.DECREASE_OWN_SCORE;
                        eventVO = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescription_ru(delta), eventCollection.getTitle_en(), eventCollection.getDescription_en(delta), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                        eventVOList.add(eventVO);
                    }
                }
                Set<Level3DNAAccountEntity.SocialDnaProfile> oldDnaFriends = changes.getOldDnaFriends();
                Set<Level3DNAAccountEntity.SocialDnaProfile> newDnaFriends = changes.getNewDnaFriends();
                newDnaFriends.removeAll(oldDnaFriends);
                for (Level3DNAAccountEntity.SocialDnaProfile eachNewFriend : newDnaFriends) {
                    EventCollection eventCollection2 = EventCollection.FRIEND_HAS_JOINED;
                    EventVO eventVO2 = new EventVO(eventCollection2.getTitle_ru(), eventCollection2.getDescriptionWithoutScores_ru(eachNewFriend.getName()), eventCollection2.getTitle_en(), eventCollection2.getDescriptionWithoutScores_en(eachNewFriend.getName()), eventCollection2.getPictureUrl(), eventCollection2.getPictureRetinaUrl());
                    eventVOList.add(eventVO2);
                }
                if (eventVOList.size() > 0) {
                    return EventQueueEntity.addEventList(newOne.getLevel3DNAAccountId(), eventVOList, token).flatMap((Function1)new Mapper<EventQueueEntity, Future<Level3DNAAccountEntity>>(){

                        public Future<Level3DNAAccountEntity> apply(EventQueueEntity parameter) {
                            return Futures.successful((Object)newOne);
                        }
                    }, Riak.getExecutionContext());
                }
                return Futures.successful((Object)newOne);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    private static ContextVO findMainContext(Set<ContextVO> contexts) {
        for (ContextVO eachContext : contexts) {
            if (!eachContext.getContextName().equals(Contexts.MAIN.name())) continue;
            return eachContext;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Changes {
        private final double oldScore;
        private final double newScore;
        private final ContextVO.Rank oldRank;
        private final ContextVO.Rank newRank;
        private final Set<String> oldNetworks;
        private final Set<String> newNetworks;
        private final Set<Level3DNAAccountEntity.SocialDnaProfile> oldDnaFriends;
        private final Set<Level3DNAAccountEntity.SocialDnaProfile> newDnaFriends;

        public Changes(double oldScore, double newScore, ContextVO.Rank oldRank, ContextVO.Rank newRank, Set<String> oldNetworks, Set<String> newNetworks, Set<Level3DNAAccountEntity.SocialDnaProfile> oldDnaFriends, Set<Level3DNAAccountEntity.SocialDnaProfile> newDnaFriends) {
            this.oldScore = oldScore;
            this.newScore = newScore;
            this.oldRank = oldRank;
            this.newRank = newRank;
            this.oldNetworks = oldNetworks;
            this.newNetworks = newNetworks;
            this.oldDnaFriends = oldDnaFriends;
            this.newDnaFriends = newDnaFriends;
        }

        public double getOldScore() {
            return this.oldScore;
        }

        public double getNewScore() {
            return this.newScore;
        }

        public ContextVO.Rank getOldRank() {
            return this.oldRank;
        }

        public ContextVO.Rank getNewRank() {
            return this.newRank;
        }

        public Set<String> getOldNetworks() {
            return this.oldNetworks;
        }

        public Set<String> getNewNetworks() {
            return this.newNetworks;
        }

        public Set<Level3DNAAccountEntity.SocialDnaProfile> getOldDnaFriends() {
            return new HashSet<Level3DNAAccountEntity.SocialDnaProfile>(this.oldDnaFriends);
        }

        public Set<Level3DNAAccountEntity.SocialDnaProfile> getNewDnaFriends() {
            return new HashSet<Level3DNAAccountEntity.SocialDnaProfile>(this.newDnaFriends);
        }
    }
}

