/*
 * Decompiled with CFR 0.152.
 */
package util;

import constants.SocialNetworks;
import exceptions.ServiceException;
import identity.codec.Base16Coder;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.joda.time.DateTime;

public class AccountIdGenerator {
    private static final String firstSalt = "Agah8698HJfTmm";
    private static final String secondSalt = "KHtnet97JhjAg";

    public static String createIdBasedOnSocialNetworkWithDate(String socialNetworkUserId, SocialNetworks socialNetwork) {
        String id = AccountIdGenerator.createId(socialNetworkUserId);
        String dateTime = DateTime.now().toString();
        return socialNetwork.name().concat(id).concat("-").concat(dateTime);
    }

    public static String createIdBasedOnSocialNetwork(String socialNetworkUserId, SocialNetworks socialNetwork) {
        String id = AccountIdGenerator.createId(socialNetworkUserId);
        return socialNetwork.name().concat(id);
    }

    public static String createRandomIdWithSocialNetworkPrefix(SocialNetworks socialNetwork) {
        String id = AccountIdGenerator.createId(UUID.randomUUID().toString());
        return socialNetwork.name().concat(id);
    }

    public static String createLevel1AccountId(String uniqueDeviceId) {
        String id = AccountIdGenerator.createId(uniqueDeviceId);
        return "BA".concat(id);
    }

    private static String createId(String base) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(firstSalt);
        buffer.append(base);
        buffer.append(secondSalt);
        try {
            byte[] guid = buffer.toString().getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(guid);
            return Base16Coder.encodeBytes((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException("Generating account id failed.", (Throwable)e, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Generating account id failed.", (Throwable)e, null);
        }
    }
}

