/*
 * Decompiled with CFR 0.152.
 */
package helpers.inside.fb;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import constants.FbConstants;
import constants.LocaleCollection;
import constants.MessageCollection;
import constants.SocialNetworks;
import entities.interfaces.Comment;
import entities.interfaces.NetworkProvider;
import entities.interfaces.Post;
import entities.interfaces.UserProfile;
import exceptions.ForbiddenException;
import exceptions.NotEnoughPermissionsException;
import exceptions.ServiceException;
import exceptions.SocialNetworkException;
import exceptions.internal.SessionHasExpiredException;
import helpers.inside.CommentHelper;
import helpers.inside.PostHelper;
import helpers.inside.UserProfileHelper;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.Response;
import play.libs.WS;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.Await;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FbNetwokProvider
implements NetworkProvider {
    private static final Logger logger = LoggerFactory.getLogger(FbNetwokProvider.class);
    private static final String BASE_REQUEST = FbConstants.HTTPS_SCHEMA.asString() + "://" + FbConstants.FACEBOOK_GRAPH_HOST.asString() + "/fql?";
    private static FbNetwokProvider INSTANCE;
    private static ExecutionContext executionContext;
    private static final String FACEBOOK_USER_PROFILE_FIELDS = "id,name,locale,gender,email,picture";

    public static FbNetwokProvider getInstance(ExecutionContext context) {
        if (INSTANCE == null) {
            return new FbNetwokProvider(context);
        }
        return INSTANCE;
    }

    private FbNetwokProvider(ExecutionContext context) {
        executionContext = context;
    }

    private static String fqlQueryFetchPermissionsStatus(List<String> permissions) {
        StringBuilder permissionStringBuilder = new StringBuilder();
        for (String eachPermission : permissions) {
            permissionStringBuilder.append(eachPermission);
            permissionStringBuilder.append(",");
        }
        int indexOfLastComma = permissionStringBuilder.lastIndexOf(",");
        String permissionString = permissionStringBuilder.deleteCharAt(indexOfLastComma).toString();
        return "SELECT+" + permissionString + "+from+permissions+where+uid=me()";
    }

    private static String fqlQueryFetchAllLikesByAccessToken() {
        return "SELECT+object_id+FROM+like+WHERE+user_id=me()+LIMIT+500";
    }

    private static String fqlQueryFetchUserProfileByAccessToken() {
        return "SELECT+uid,+name,+locale,+email,+pic,+sex,+friend_count+FROM+user+WHERE+uid=me()";
    }

    private static String fqlQueryFetchUserProfileByUserId(String userId) {
        return "SELECT+uid,+name,+locale,+email,+pic,+sex,+friend_count+FROM+user+WHERE+uid=" + userId;
    }

    private static String fqlQueryFetchAllFriendsByAccessToken() {
        return "SELECT+uid,+name,+locale,+email,+pic,+sex,+friend_count+FROM+user+WHERE+uid+IN+(SELECT+uid2+FROM+friend+WHERE+uid1=me())";
    }

    private static String fqlQueryFetchAllCommentsFromOwnWall(int allAfterDaysAgo) {
        DateTime now = DateTime.now().minusDays(allAfterDaysAgo);
        long unixTimeInSeconds = now.getMillis() / 1000L;
        String postsId = "SELECT+post_id+FROM+stream+WHERE+source_id=me()+AND+actor_id=me()+AND+created_time+%3E+" + unixTimeInSeconds + "+LIMIT+500";
        return "SELECT+id,+post_id,+text,+time,+fromid,+likes+FROM+comment+WHERE+post_id+IN+(" + postsId + ")";
    }

    private static String fqlQueryFetchAllCommentsFromFriendsWall(String friendFacebookId, int allAfterDaysAgo) {
        DateTime now = DateTime.now().minusDays(allAfterDaysAgo);
        long unixTimeInSeconds = now.getMillis() / 1000L;
        String postsId = "SELECT+post_id+FROM+stream+WHERE+source_id=" + friendFacebookId + "+AND+actor_id=" + friendFacebookId + "+AND+created_time+%3E+" + unixTimeInSeconds + "+LIMIT+500";
        return "SELECT+id,+post_id,+text,+time,+fromid,+likes+FROM+comment+WHERE+post_id+IN+(" + postsId + ")";
    }

    private static String fqlQueryFetchPostsFromOwnWall(int allAfterDaysAgo) {
        DateTime now = DateTime.now().minusDays(allAfterDaysAgo);
        long unixTimeInSeconds = now.getMillis() / 1000L;
        String finalQuery = "SELECT+post_id,+message,+likes.count,+comment_info.comment_count+FROM+stream+WHERE+source_id=me()+AND+actor_id=me()+AND+created_time+%3E+" + unixTimeInSeconds + "+LIMIT+500";
        return finalQuery;
    }

    private static String fqlQueryFetchPostsFromFriendWall(String friendFacebookId, int allAfterDaysAgo) {
        DateTime now = DateTime.now().minusDays(allAfterDaysAgo);
        long unixTimeInSeconds = now.getMillis() / 1000L;
        String finalQuery = "SELECT+post_id,+message,+likes.count,+comment_info.comment_count+FROM+stream+WHERE+source_id=" + friendFacebookId + "+AND+actor_id=" + friendFacebookId + "+AND+created_time+%3E+" + unixTimeInSeconds + "+LIMIT+500";
        return finalQuery;
    }

    private static String createFullRequestWithFql(String accessToken, String fqlRequest) {
        StringBuilder queryBuilder = new StringBuilder(BASE_REQUEST);
        queryBuilder.append("q=");
        queryBuilder.append(fqlRequest);
        queryBuilder.append("&access_token=");
        queryBuilder.append(accessToken);
        return queryBuilder.toString();
    }

    @Override
    public Future<Map<String, Boolean>> checkPermissionsStatusByAccessToken(String socialNetworkAccessToken, final List<String> permissions, final Token token) {
        logger.info("FbNetwokProvider : checkPermissionsStatusByAccessToken()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.checkPermissionsStatusByAccessToken");
        String url = FbNetwokProvider.createFullRequestWithFql(socialNetworkAccessToken, FbNetwokProvider.fqlQueryFetchPermissionsStatus(permissions));
        return play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<Map<String, Boolean>>>(){

            public Future<Map<String, Boolean>> apply(final Response response) {
                return Futures.future((Callable)new Callable<Map<String, Boolean>>(){

                    @Override
                    public Map<String, Boolean> call() throws Exception {
                        try {
                            JSONObject object;
                            int statusCode = response.status();
                            if (statusCode != 200) {
                                object = new JSONObject(response.body());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            object = new JSONObject(response.body());
                            JSONArray jsonMainArr = object.getJSONArray("data");
                            HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
                            if (jsonMainArr.length() > 1) {
                                throw new ServiceException("Cannot parse Facebook fql response : " + object.toString(), token.getAccountId());
                            }
                            JSONObject childJSONObject = jsonMainArr.getJSONObject(0);
                            for (String eachPermission : permissions) {
                                if (childJSONObject.has(eachPermission)) {
                                    int perm = childJSONObject.getInt(eachPermission);
                                    if (perm == 0) {
                                        resultMap.put(eachPermission, Boolean.FALSE);
                                        continue;
                                    }
                                    resultMap.put(eachPermission, Boolean.TRUE);
                                    continue;
                                }
                                resultMap.put(eachPermission, Boolean.FALSE);
                            }
                            return resultMap;
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : checkPermissionsStatusByAccessToken() : error : Cannot parse Facebook fql response");
                            throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext).andThen((PartialFunction)new OnComplete<Map<String, Boolean>>(){

            public void onComplete(Throwable throwable, Map<String, Boolean> stringBooleanMap) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public Map<String, Boolean> checkPermissionsStatusByAccessTokenSync(String socialNetworkAccessToken, List<String> permissions, Token token) throws Exception {
        return (Map)Await.result(this.checkPermissionsStatusByAccessToken(socialNetworkAccessToken, permissions, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Override
    public Future<Set<String>> fetchUserAllUserLikesByAccessToken(String socialNetworkAccessToken, final Token token) {
        logger.info("FbNetwokProvider : fetchUserAllUserLikesByAccessToken()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.fetchUserAllUserLikesByAccessToken");
        String url = FbNetwokProvider.createFullRequestWithFql(socialNetworkAccessToken, FbNetwokProvider.fqlQueryFetchAllLikesByAccessToken());
        return play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<Set<String>>>(){

            public Future<Set<String>> apply(final Response response) {
                return Futures.future((Callable)new Callable<Set<String>>(){

                    @Override
                    public Set<String> call() throws Exception {
                        try {
                            JSONObject object;
                            int statusCode = response.status();
                            if (statusCode != 200) {
                                object = new JSONObject(response.body());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            object = new JSONObject(response.body());
                            JSONArray jsonMainArr = object.getJSONArray("data");
                            HashSet<String> allLikes = new HashSet<String>();
                            for (int i = 0; i < jsonMainArr.length(); ++i) {
                                JSONObject childJSONObject = jsonMainArr.getJSONObject(i);
                                if (!childJSONObject.has("object_id") || childJSONObject.getString("object_id").isEmpty()) continue;
                                allLikes.add(childJSONObject.getString("object_id"));
                            }
                            return allLikes;
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : fetchUserAllUserLikesByAccessToken() : Cannot parse Facebook fql response");
                            throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext).andThen((PartialFunction)new OnComplete<Set<String>>(){

            public void onComplete(Throwable throwable, Set<String> strings) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public Set<String> fetchUserAllUserLikesByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        return (Set)Await.result(this.fetchUserAllUserLikesByAccessToken(socialNetworkAccessToken, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Override
    public Set<String> fetchUserAllUserLikesByUserId(String userId, String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Unsupported operation");
    }

    @Override
    public Future<UserProfile> fetchUserProfileByAccessToken(String socialNetworkAccessToken, final Token token) {
        logger.info("FbNetwokProvider : fetchUserProfileByAccessToken()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.fetchUserProfileByAccessToken");
        String url = FbNetwokProvider.createFullRequestWithFql(socialNetworkAccessToken, FbNetwokProvider.fqlQueryFetchUserProfileByAccessToken());
        return play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<UserProfile>>(){

            public Future<UserProfile> apply(final Response response) {
                return Futures.future((Callable)new Callable<UserProfile>(){

                    @Override
                    public UserProfile call() throws Exception {
                        try {
                            JSONObject object;
                            int statusCode = response.status();
                            if (statusCode != 200) {
                                object = new JSONObject(response.body());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            object = new JSONObject(response.body());
                            JSONArray jsonMainArr = object.getJSONArray("data");
                            ArrayList<UserProfile> friendList = new ArrayList<UserProfile>();
                            for (int i = 0; i < jsonMainArr.length(); ++i) {
                                JSONObject childJSONObject = jsonMainArr.getJSONObject(i);
                                UserProfile userProfile = UserProfileHelper.constructUserProfile(childJSONObject.toString(), SocialNetworks.Facebook, token);
                                friendList.add(userProfile);
                            }
                            if (friendList.isEmpty() || friendList.size() != 1) {
                                logger.error("FbNetwokProvider : fetchUserProfileByAccessToken() : error : Can not parse user profile");
                                throw new SocialNetworkException("Can not parse user profile : response : " + response.body(), token.getAccountId());
                            }
                            return (UserProfile)friendList.get(0);
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : fetchUserProfileByAccessToken() : error : Cannot parse Facebook profile response");
                            throw new ServiceException("Cannot parse Facebook profile response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext).andThen((PartialFunction)new OnComplete<UserProfile>(){

            public void onComplete(Throwable throwable, UserProfile userProfile) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public UserProfile fetchUserProfileByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        return (UserProfile)Await.result(this.fetchUserProfileByAccessToken(socialNetworkAccessToken, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Override
    public Future<UserProfile> fetchUserProfileByUserId(String userId, String socialNetworkAccessToken, final Token token) {
        logger.info("FbNetwokProvider : fetchUserProfileByUserId()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.fetchUserProfileByUserId");
        String url = FbNetwokProvider.createFullRequestWithFql(socialNetworkAccessToken, FbNetwokProvider.fqlQueryFetchUserProfileByUserId(userId));
        return play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<UserProfile>>(){

            public Future<UserProfile> apply(final Response response) {
                return Futures.future((Callable)new Callable<UserProfile>(){

                    @Override
                    public UserProfile call() throws Exception {
                        try {
                            JSONObject object;
                            int statusCode = response.status();
                            if (statusCode != 200) {
                                object = new JSONObject(response.body());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            object = new JSONObject(response.body());
                            JSONArray jsonMainArr = object.getJSONArray("data");
                            ArrayList<UserProfile> friendList = new ArrayList<UserProfile>();
                            for (int i = 0; i < jsonMainArr.length(); ++i) {
                                JSONObject childJSONObject = jsonMainArr.getJSONObject(i);
                                UserProfile userProfile = UserProfileHelper.constructUserProfile(childJSONObject.toString(), SocialNetworks.Facebook, token);
                                friendList.add(userProfile);
                            }
                            if (friendList.isEmpty() || friendList.size() != 1) {
                                logger.error("FbNetwokProvider : fetchUserProfileByUserId() : error : Can not parse user profile");
                                throw new SocialNetworkException("Can not parse user profile : response : " + response.body(), token.getAccountId());
                            }
                            return (UserProfile)friendList.get(0);
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : fetchUserProfileByUserId() : error : Cannot parse Facebook profile response");
                            throw new ServiceException("Cannot parse Facebook profile response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext).andThen((PartialFunction)new OnComplete<UserProfile>(){

            public void onComplete(Throwable throwable, UserProfile userProfile) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public UserProfile fetchUserProfileByUserIdSync(String userId, String socialNetworkAccessToken, Token token) throws Exception {
        return (UserProfile)Await.result(this.fetchUserProfileByUserId(userId, socialNetworkAccessToken, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Override
    public Future<Set<Post>> fetchUserPostsFromOwnWallByAccessToken(String socialNetworkAccessToken, final Token token) {
        logger.info("FbNetwokProvider : fetchUserPostsFromOwnWallByAccessToken()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.fetchUserPostsFromOwnWallByAccessToken");
        String url = FbNetwokProvider.createFullRequestWithFql(socialNetworkAccessToken, FbNetwokProvider.fqlQueryFetchPostsFromOwnWall(90));
        final String urlForComments = FbNetwokProvider.createFullRequestWithFql(socialNetworkAccessToken, FbNetwokProvider.fqlQueryFetchAllCommentsFromOwnWall(90));
        Future postsWithoutCommentsFuture = play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<Set<Post>>>(){

            public Future<Set<Post>> apply(final Response response) {
                return Futures.future((Callable)new Callable<Set<Post>>(){

                    @Override
                    public Set<Post> call() throws Exception {
                        try {
                            JSONObject object;
                            int statusCode = response.status();
                            if (statusCode != 200) {
                                object = new JSONObject(response.body());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            object = new JSONObject(response.body());
                            JSONArray jsonMainArr = object.getJSONArray("data");
                            HashSet<Post> postList = new HashSet<Post>();
                            for (int i = 0; i < jsonMainArr.length(); ++i) {
                                JSONObject childJSONObject = jsonMainArr.getJSONObject(i);
                                Post postVO = PostHelper.constructPost(childJSONObject.toString(), SocialNetworks.Facebook, token);
                                postList.add(postVO);
                            }
                            return postList;
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : fetchUserPostsFromOwnWallByAccessToken() : error : Cannot parse Facebook fql response");
                            throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future postWithComments = postsWithoutCommentsFuture.flatMap((Function1)new Mapper<Set<Post>, Future<Set<Post>>>(){

            public Future<Set<Post>> apply(final Set<Post> fetchedPosts) {
                return play.api.libs.ws.WS.url((String)urlForComments).get().flatMap((Function1)new Mapper<Response, Future<Set<Post>>>(){

                    public Future<Set<Post>> apply(final Response response) {
                        return Futures.future((Callable)new Callable<Set<Post>>(){

                            @Override
                            public Set<Post> call() throws Exception {
                                try {
                                    JSONObject object;
                                    int statusCode = response.status();
                                    if (statusCode != 200) {
                                        object = new JSONObject(response.body());
                                        FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                                    }
                                    object = new JSONObject(response.body());
                                    Map<String, Set<Comment>> map = CommentHelper.parseComments(object.toString(), token);
                                    HashSet<Post> resultPosts = new HashSet<Post>();
                                    for (Post eachPost : fetchedPosts) {
                                        if (map.get(eachPost.getPostId()) != null) {
                                            Post newPost = eachPost.attachComments(map.get(eachPost.getPostId()));
                                            resultPosts.add(newPost);
                                            continue;
                                        }
                                        resultPosts.add(eachPost);
                                    }
                                    return resultPosts;
                                }
                                catch (JSONException e) {
                                    logger.error("FbNetwokProvider : fetchUserPostsFromOwnWallByAccessToken() : error : Cannot parse Facebook fql response");
                                    throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                                }
                            }
                        }, (ExecutionContext)executionContext);
                    }
                }, executionContext);
            }
        }, executionContext);
        return postWithComments.andThen((PartialFunction)new OnComplete<Set<Post>>(){

            public void onComplete(Throwable throwable, Set<Post> posts) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public Set<Post> fetchUserPostsFromOwnWallByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        return (Set)Await.result(this.fetchUserPostsFromOwnWallByAccessToken(socialNetworkAccessToken, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Override
    public Future<Set<Post>> fetchUserPostsFromFriendWallByUserId(String userId, String socialNetworkAccessToken, final Token token) {
        logger.info("FbNetwokProvider : fetchUserPostsFromFriendWallByUserId()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.fetchUserPostsFromFriendWallByUserId");
        String url = FbNetwokProvider.createFullRequestWithFql(socialNetworkAccessToken, FbNetwokProvider.fqlQueryFetchPostsFromFriendWall(userId, 90));
        final String urlForComments = FbNetwokProvider.createFullRequestWithFql(socialNetworkAccessToken, FbNetwokProvider.fqlQueryFetchAllCommentsFromFriendsWall(userId, 90));
        Future postsWithoutCommentsFuture = play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<Set<Post>>>(){

            public Future<Set<Post>> apply(final Response response) {
                return Futures.future((Callable)new Callable<Set<Post>>(){

                    @Override
                    public Set<Post> call() throws Exception {
                        try {
                            JSONObject object;
                            int statusCode = response.status();
                            if (statusCode != 200) {
                                object = new JSONObject(response.body());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            object = new JSONObject(response.body());
                            JSONArray jsonMainArr = object.getJSONArray("data");
                            HashSet<Post> postList = new HashSet<Post>();
                            for (int i = 0; i < jsonMainArr.length(); ++i) {
                                JSONObject childJSONObject = jsonMainArr.getJSONObject(i);
                                Post postVO = PostHelper.constructPost(childJSONObject.toString(), SocialNetworks.Facebook, token);
                                postList.add(postVO);
                            }
                            return postList;
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : fetchUserPostsFromFriendWallByUserId() : error : Cannot parse Facebook fql response");
                            throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future postWithComments = postsWithoutCommentsFuture.flatMap((Function1)new Mapper<Set<Post>, Future<Set<Post>>>(){

            public Future<Set<Post>> apply(final Set<Post> fetchedPosts) {
                return play.api.libs.ws.WS.url((String)urlForComments).get().flatMap((Function1)new Mapper<Response, Future<Set<Post>>>(){

                    public Future<Set<Post>> apply(final Response response) {
                        return Futures.future((Callable)new Callable<Set<Post>>(){

                            @Override
                            public Set<Post> call() throws Exception {
                                try {
                                    JSONObject object;
                                    int statusCode = response.status();
                                    if (statusCode != 200) {
                                        object = new JSONObject(response.body());
                                        FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                                    }
                                    object = new JSONObject(response.body());
                                    Map<String, Set<Comment>> map = CommentHelper.parseComments(object.toString(), token);
                                    HashSet<Post> resultPosts = new HashSet<Post>();
                                    for (Post eachPost : fetchedPosts) {
                                        if (map.get(eachPost.getPostId()) != null) {
                                            Post newPost = eachPost.attachComments(map.get(eachPost.getPostId()));
                                            resultPosts.add(newPost);
                                            continue;
                                        }
                                        resultPosts.add(eachPost);
                                    }
                                    return resultPosts;
                                }
                                catch (JSONException e) {
                                    logger.error("FbNetwokProvider : fetchUserPostsFromFriendWallByUserId() : error : Cannot parse Facebook fql response");
                                    throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                                }
                            }
                        }, (ExecutionContext)executionContext);
                    }
                }, executionContext);
            }
        }, executionContext);
        return postWithComments.andThen((PartialFunction)new OnComplete<Set<Post>>(){

            public void onComplete(Throwable throwable, Set<Post> posts) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public Set<Post> fetchUserPostsFromFriendWallByUserIdSync(String userId, String socialNetworkAccessToken, Token token) throws Exception {
        return (Set)Await.result(this.fetchUserPostsFromFriendWallByUserId(userId, socialNetworkAccessToken, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Override
    public Future<Set<UserProfile>> fetchUserSubscribersByAccessToken(String socialNetworkAccessToken, final Token token) {
        logger.info("FbNetwokProvider : fetchUserSubscribersByAccessToken()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.fetchUserSubscribersByAccessToken");
        String url = FbConstants.HTTPS_SCHEMA.asString() + "://" + FbConstants.FACEBOOK_GRAPH_HOST.asString() + "/me/subscribers?fields=id,name,locale,gender,email,picture";
        url = url + "&access_token=" + socialNetworkAccessToken;
        return play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<Set<UserProfile>>>(){

            public Future<Set<UserProfile>> apply(final Response response) {
                return Futures.future((Callable)new Callable<Set<UserProfile>>(){

                    @Override
                    public Set<UserProfile> call() throws Exception {
                        try {
                            JSONObject object;
                            int statusCode = response.status();
                            if (statusCode != 200) {
                                object = new JSONObject(response.body());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            object = new JSONObject(response.body());
                            JSONArray jsonMainArr = object.getJSONArray("data");
                            HashSet<UserProfile> friendSet = new HashSet<UserProfile>();
                            for (int i = 0; i < jsonMainArr.length(); ++i) {
                                JSONObject childJSONObject = jsonMainArr.getJSONObject(i);
                                UserProfile userProfile = UserProfileHelper.constructUserSubscriberProfile(childJSONObject.toString(), SocialNetworks.Facebook, token);
                                friendSet.add(userProfile);
                            }
                            return friendSet;
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : fetchUserSubscribersByAccessToken() : error : Cannot parse Facebook fql response");
                            throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext).andThen((PartialFunction)new OnComplete<Set<UserProfile>>(){

            public void onComplete(Throwable throwable, Set<UserProfile> userProfiles) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public Set<UserProfile> fetchUserSubscribersByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        return (Set)Await.result(this.fetchUserSubscribersByAccessToken(socialNetworkAccessToken, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Override
    public Future<Set<UserProfile>> fetchUserSubscribersByUserId(String userId, String socialNetworkAccessToken, final Token token) {
        logger.info("FbNetwokProvider : fetchUserSubscribersByUserId()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.fetchUserSubscribersByUserId");
        String url = FbConstants.HTTPS_SCHEMA.asString() + "://" + FbConstants.FACEBOOK_GRAPH_HOST.asString() + "/" + userId + "/subscribers?fields=id,name,locale,gender,email,picture";
        url = url + "?access_token=" + socialNetworkAccessToken;
        url = url + "&fields=" + FACEBOOK_USER_PROFILE_FIELDS;
        return play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<Set<UserProfile>>>(){

            public Future<Set<UserProfile>> apply(final Response response) {
                return Futures.future((Callable)new Callable<Set<UserProfile>>(){

                    @Override
                    public Set<UserProfile> call() throws Exception {
                        try {
                            JSONObject object;
                            int statusCode = response.status();
                            if (statusCode != 200) {
                                object = new JSONObject(response.body());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            object = new JSONObject(response.body());
                            JSONArray jsonMainArr = object.getJSONArray("data");
                            HashSet<UserProfile> friendSet = new HashSet<UserProfile>();
                            for (int i = 0; i < jsonMainArr.length(); ++i) {
                                JSONObject childJSONObject = jsonMainArr.getJSONObject(i);
                                UserProfile userProfile = UserProfileHelper.constructUserSubscriberProfile(childJSONObject.toString(), SocialNetworks.Facebook, token);
                                friendSet.add(userProfile);
                            }
                            return friendSet;
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : fetchUserSubscribersByUserId() : error : Cannot parse Facebook fql response");
                            throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext).andThen((PartialFunction)new OnComplete<Set<UserProfile>>(){

            public void onComplete(Throwable throwable, Set<UserProfile> userProfiles) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public Set<UserProfile> fetchUserSubscribersByUserIdSync(String userId, String socialNetworkAccessToken, Token token) throws Exception {
        return (Set)Await.result(this.fetchUserSubscribersByUserId(userId, socialNetworkAccessToken, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Override
    public Future<Set<UserProfile>> fetchUserFriendsByAccessToken(String socialNetworkAccessToken, final Token token) {
        logger.info("FbNetwokProvider : fetchUserFriendsByAccessToken()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.fetchUserFriendsByAccessToken");
        String url = FbNetwokProvider.createFullRequestWithFql(socialNetworkAccessToken, FbNetwokProvider.fqlQueryFetchAllFriendsByAccessToken());
        return play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<Set<UserProfile>>>(){

            public Future<Set<UserProfile>> apply(final Response response) {
                return Futures.future((Callable)new Callable<Set<UserProfile>>(){

                    @Override
                    public Set<UserProfile> call() throws Exception {
                        try {
                            JSONObject object;
                            int statusCode = response.status();
                            if (statusCode != 200) {
                                object = new JSONObject(response.body());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            object = new JSONObject(response.body());
                            JSONArray jsonMainArr = object.getJSONArray("data");
                            HashSet<UserProfile> friendSet = new HashSet<UserProfile>();
                            for (int i = 0; i < jsonMainArr.length(); ++i) {
                                JSONObject childJSONObject = jsonMainArr.getJSONObject(i);
                                UserProfile userProfile = UserProfileHelper.constructUserProfile(childJSONObject.toString(), SocialNetworks.Facebook, token);
                                friendSet.add(userProfile);
                            }
                            return friendSet;
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : fetchUserFriendsByAccessToken() : error : Cannot parse Facebook fql response");
                            throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext).andThen((PartialFunction)new OnComplete<Set<UserProfile>>(){

            public void onComplete(Throwable throwable, Set<UserProfile> userProfiles) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public Future<Void> shareOnOwnWall(String eventCode, String locale, String socialNetworkAccessToken, final Token token) {
        logger.info("FbNetwokProvider : shareOnOwnWall()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.shareOnOwnWall");
        String url = FbConstants.HTTPS_SCHEMA.asString() + "://" + FbConstants.FACEBOOK_GRAPH_HOST.asString() + "/me/feed";
        StringBuilder contentBuilder = new StringBuilder("access_token=");
        contentBuilder.append(socialNetworkAccessToken);
        contentBuilder.append("&");
        contentBuilder.append("message=");
        MessageCollection message = MessageCollection.findByEventCode(eventCode);
        if (locale.equals(LocaleCollection.en.name())) {
            contentBuilder.append(message.getMessage_en());
        } else if (locale.equals(LocaleCollection.ru.name())) {
            contentBuilder.append(message.getMessage_ru());
        }
        contentBuilder.append("&");
        contentBuilder.append("link=");
        contentBuilder.append(message.getFbUrl());
        Future responseFuture = WS.url((String)url).setContentType("application/x-www-form-urlencoded").post(contentBuilder.toString()).getWrappedPromise();
        return responseFuture.flatMap((Function1)new Mapper<WS.Response, Future<Void>>(){

            public Future<Void> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            int statusCode = response.getStatus();
                            if (statusCode != 200) {
                                JSONObject object = new JSONObject(response.getBody());
                                FbNetwokProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            return null;
                        }
                        catch (JSONException e) {
                            logger.error("FbNetwokProvider : shareOnOwnWall() : error : Cannot parse Facebook fql response");
                            throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext).andThen((PartialFunction)new OnComplete<Void>(){

            public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public Future<Void> shareOnUserWall(String eventCode, String locale, String socialNetworkAccessToken, String userId, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Set<UserProfile> fetchUserFriendsByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        return (Set)Await.result(this.fetchUserFriendsByAccessToken(socialNetworkAccessToken, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Override
    public Set<UserProfile> fetchUserFriendsByUserId(String userId, String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Unsupported operation");
    }

    @Override
    public Future<Map<String, String>> extendSocialNetworkAccessToken(String sourceShortLivedToken, final Token token) {
        logger.info("FbNetwokProvider : extendSocialNetworkAccessToken()");
        final JMonitor monitor = JMonitorFactory.start((String)"Network: FbNetwokProvider.extendSocialNetworkAccessToken");
        StringBuilder queryBuilder = new StringBuilder(FbConstants.HTTPS_SCHEMA.asString() + "://" + FbConstants.FACEBOOK_GRAPH_HOST.asString() + FbConstants.FACEBOOK_TOCKEN_PATH.asString());
        queryBuilder.append("?");
        queryBuilder.append(FbConstants.PARAM_GRANT_TYPE.asString());
        queryBuilder.append("=");
        queryBuilder.append(FbConstants.PARAM_FB_EXCHANGE_TOKEN.asString());
        queryBuilder.append("&");
        queryBuilder.append(FbConstants.PARAM_CLIENT_ID.asString());
        queryBuilder.append("=");
        queryBuilder.append(FbConstants.APPLICATION_ID.asString());
        queryBuilder.append("&");
        queryBuilder.append(FbConstants.PARAM_CLIENT_SECRET.asString());
        queryBuilder.append("=");
        queryBuilder.append(FbConstants.APPLICATION_SECRET.asString());
        queryBuilder.append("&");
        queryBuilder.append(FbConstants.PARAM_FB_EXCHANGE_TOKEN.asString());
        queryBuilder.append("=");
        queryBuilder.append(sourceShortLivedToken);
        String url = queryBuilder.toString();
        return play.api.libs.ws.WS.url((String)url).get().flatMap((Function1)new Mapper<Response, Future<Map<String, String>>>(){

            public Future<Map<String, String>> apply(final Response responseWS) {
                return Futures.future((Callable)new Callable<Map<String, String>>(){

                    @Override
                    public Map<String, String> call() throws Exception {
                        int statusCode = responseWS.status();
                        if (statusCode != 200) {
                            throw new SocialNetworkException("Facebook request returned error status code : " + statusCode + " response : " + responseWS.body(), token.getAccountId());
                        }
                        String response = responseWS.body();
                        String[] responseArray = response.split("&");
                        if (responseArray.length < 2) {
                            throw new SocialNetworkException("Facebook request returned response in wrong format : " + response, token.getAccountId());
                        }
                        HashMap<String, String> result = new HashMap<String, String>();
                        for (String eachString : responseArray) {
                            if (eachString.startsWith("access_token=")) {
                                result.put("access_token", eachString.replaceFirst("access_token=", ""));
                                continue;
                            }
                            if (!eachString.startsWith("expires=")) continue;
                            result.put("expires", eachString.replaceFirst("expires=", ""));
                        }
                        if (result.get("access_token") == null || result.get("expires") == null) {
                            logger.error("FbNetwokProvider : extendSocialNetworkAccessToken() : Facebook request returned response in wrong format");
                            throw new SocialNetworkException("Facebook request returned response in wrong format : " + response, token.getAccountId());
                        }
                        return result;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext).andThen((PartialFunction)new OnComplete<Map<String, String>>(){

            public void onComplete(Throwable throwable, Map<String, String> stringStringMap) throws Throwable {
                monitor.stop();
            }
        }, executionContext);
    }

    @Override
    public Map<String, String> extendSocialNetworkAccessTokenSync(String sourceShortLivedToken, Token token) throws Exception {
        return (Map)Await.result(this.extendSocialNetworkAccessToken(sourceShortLivedToken, token), (Duration)Duration.create((long)15L, (TimeUnit)TimeUnit.SECONDS));
    }

    private void throwExceptionDependsOnError(JSONObject object, Token token) {
        try {
            JSONObject errorObject;
            if (object.has("error") && (errorObject = object.getJSONObject("error")).has("code")) {
                int code = errorObject.getInt("code");
                if (code == 190) {
                    if (errorObject.has("error_subcode")) {
                        int subcode = errorObject.getInt("error_subcode");
                        if (subcode == 463) {
                            logger.error("FbNetwokProvider : throwExceptionDependsOnError() : Session has expired");
                            throw new SessionHasExpiredException("Session has expired", token.getAccountId());
                        }
                        logger.error("FbNetwokProvider : throwExceptionDependsOnError() : Facebook communication failed");
                        throw new ForbiddenException("Facebook communication failed" + object.getString("error"), token.getAccountId());
                    }
                    logger.error("FbNetwokProvider : throwExceptionDependsOnError() : Facebook communication failed");
                    throw new ForbiddenException("Facebook communication failed" + object.getString("error"), token.getAccountId());
                }
                if (code == 200 && errorObject.has("message")) {
                    String errorMessage = errorObject.getString("message");
                    logger.error(errorMessage);
                    throw new NotEnoughPermissionsException(errorMessage, token.getAccountId());
                }
            }
        }
        catch (JSONException e) {
            logger.error("FbNetwokProvider : throwExceptionDependsOnError() : Cannot parse Facebook fql response");
            throw new ServiceException("Cannot parse Facebook fql response", (Throwable)e, token.getAccountId());
        }
        logger.error("FbNetwokProvider : throwExceptionDependsOnError() : Facebook request returned response in wrong format");
        throw new SocialNetworkException("Facebook request returned response in wrong format : " + object.toString(), token.getAccountId());
    }
}

