/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import com.basho.riak.client.convert.RiakIndex;
import com.basho.riak.client.convert.RiakKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import constants.Dates;
import constants.SocialNetworks;
import entities.common.StateHistoryEntity;
import entities.interfaces.Level2Account;
import identity.Token;
import java.util.ArrayList;
import java.util.List;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import riak.Riak;
import riak.RiakCommon;
import riak.RiakEntity;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import util.AccountIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RiakEntity(bucketName="level2.account", lastWriteWins=true)
public class Level2AccountEntity
implements Level2Account {
    private static final Logger logger = LoggerFactory.getLogger(Level2AccountEntity.class);
    public static final String CREATION_TIME_INDEX_NAME = "creationTime";
    @JsonProperty
    @RiakKey
    private final String level2AcountId;
    @JsonProperty
    private final String socialNetworkUserId;
    @JsonProperty
    private final String userStateId;
    @JsonProperty
    private final String level3DNAAccountId;
    @JsonProperty
    private final String socialNetworkName;
    @JsonProperty
    private final String accessToken;
    @JsonProperty
    private final long timeWhenTokenWillBeExpiredMillis;
    @JsonProperty
    private final String refreshDate;
    @JsonProperty
    @RiakIndex(name="creationTime")
    private final String creationTime;

    @Deprecated
    @JsonCreator
    public Level2AccountEntity(@JsonProperty(value="level2AcountId") String level2AcountId, @JsonProperty(value="socialNetworkUserId") String socialNetworkUserId, @JsonProperty(value="userStateId") String userStateId, @JsonProperty(value="socialNetworkName") String socialNetworkName, @JsonProperty(value="accessToken") String accessToken, @JsonProperty(value="timeWhenTokenWillBeExpiredMillis") long timeWhenTokenWillBeExpiredMillis, @JsonProperty(value="refreshDate") String refreshDate) {
        this.level2AcountId = level2AcountId;
        this.socialNetworkUserId = socialNetworkUserId;
        this.userStateId = userStateId;
        this.level3DNAAccountId = null;
        this.socialNetworkName = socialNetworkName;
        this.accessToken = accessToken;
        this.timeWhenTokenWillBeExpiredMillis = timeWhenTokenWillBeExpiredMillis;
        this.refreshDate = refreshDate;
        this.creationTime = LocalDate.now().toString();
    }

    public Level2AccountEntity(Level2Account baseAccount, String level3DNAAccountId) {
        this.level2AcountId = baseAccount.getLevel2AcountId();
        this.socialNetworkUserId = baseAccount.getSocialNetworkUserId();
        this.userStateId = baseAccount.getUserStateId();
        this.level3DNAAccountId = level3DNAAccountId;
        this.socialNetworkName = baseAccount.getSocialNetworkName();
        this.accessToken = baseAccount.getAccessToken();
        this.timeWhenTokenWillBeExpiredMillis = baseAccount.getTimeWhenTokenWillBeExpiredMillis();
        this.refreshDate = baseAccount.getRefreshDate();
        this.creationTime = baseAccount.getCreationTime();
    }

    public Level2AccountEntity(String userStateId, Level2Account baseAccount) {
        this.level2AcountId = baseAccount.getLevel2AcountId();
        this.socialNetworkUserId = baseAccount.getSocialNetworkUserId();
        this.userStateId = userStateId;
        this.level3DNAAccountId = baseAccount.getLevel3DNAAccountId();
        this.socialNetworkName = baseAccount.getSocialNetworkName();
        this.accessToken = baseAccount.getAccessToken();
        this.timeWhenTokenWillBeExpiredMillis = baseAccount.getTimeWhenTokenWillBeExpiredMillis();
        this.refreshDate = baseAccount.getRefreshDate();
        this.creationTime = baseAccount.getCreationTime();
    }

    public Level2AccountEntity(Level2Account baseAccount, String socialNetworkAccessToken, String numberOfSecondsUntilTokenExpire, String refreshDate) {
        this.level2AcountId = baseAccount.getLevel2AcountId();
        this.socialNetworkUserId = baseAccount.getSocialNetworkUserId();
        this.userStateId = baseAccount.getUserStateId();
        this.level3DNAAccountId = baseAccount.getLevel3DNAAccountId();
        this.socialNetworkName = baseAccount.getSocialNetworkName();
        this.creationTime = baseAccount.getCreationTime();
        this.accessToken = socialNetworkAccessToken;
        this.timeWhenTokenWillBeExpiredMillis = numberOfSecondsUntilTokenExpire.equals("0") ? LocalDate.now().plusYears(50).toDateTimeAtCurrentTime().getMillis() : DateTime.now().plusSeconds(Integer.parseInt(numberOfSecondsUntilTokenExpire)).getMillis();
        this.refreshDate = refreshDate;
    }

    @Override
    @JsonIgnore
    public String getLevel2AcountId() {
        return this.level2AcountId;
    }

    @Override
    @JsonIgnore
    public String getUserStateId() {
        return this.userStateId;
    }

    @Override
    @JsonIgnore
    public String getLevel3DNAAccountId() {
        return this.level3DNAAccountId;
    }

    @Override
    @JsonIgnore
    public String getSocialNetworkName() {
        return this.socialNetworkName;
    }

    @Override
    @JsonIgnore
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public long getTimeWhenTokenWillBeExpiredMillis() {
        return this.timeWhenTokenWillBeExpiredMillis;
    }

    @Override
    @JsonIgnore
    public String getRefreshDate() {
        return this.refreshDate;
    }

    @Override
    @JsonIgnore
    public String getSocialNetworkUserId() {
        return this.socialNetworkUserId;
    }

    @Override
    @JsonIgnore
    public Class getClazz() {
        return Level2AccountEntity.class;
    }

    @Override
    @JsonIgnore
    public String getCreationTime() {
        return this.creationTime;
    }

    @JsonIgnore
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Level2AccountEntity that = (Level2AccountEntity)o;
        return this.level2AcountId.equals(that.level2AcountId);
    }

    @JsonIgnore
    public int hashCode() {
        return this.level2AcountId.hashCode();
    }

    @Override
    @JsonIgnore
    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Level2AccountEntity that = (Level2AccountEntity)o;
        if (this.timeWhenTokenWillBeExpiredMillis != that.timeWhenTokenWillBeExpiredMillis) {
            return false;
        }
        if (this.refreshDate != null ? !this.refreshDate.equals(that.refreshDate) : that.refreshDate != null) {
            return false;
        }
        if (!this.accessToken.equals(that.accessToken)) {
            return false;
        }
        if (!this.level2AcountId.equals(that.level2AcountId)) {
            return false;
        }
        if (this.level3DNAAccountId != null ? !this.level3DNAAccountId.equals(that.level3DNAAccountId) : that.level3DNAAccountId != null) {
            return false;
        }
        if (!this.socialNetworkName.equals(that.socialNetworkName)) {
            return false;
        }
        if (!this.socialNetworkUserId.equals(that.socialNetworkUserId)) {
            return false;
        }
        return this.userStateId.equals(that.userStateId);
    }

    @Override
    @JsonIgnore
    public Future<Void> attachLevel3DNAAccount(String level3DNAAccountId, Token token) {
        logger.info("attachLevel3DNAAccount() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level2AccountEntity.attachLevel3DNAAccount");
        Level2AccountEntity newLevel2Account = new Level2AccountEntity(this, level3DNAAccountId);
        return RiakCommon.storeEntity(newLevel2Account, token).andThen((PartialFunction)new OnComplete<Void>(){

            public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    @Override
    @JsonIgnore
    public Future<Void> updateUserStateId(String userStateId, final Token token) {
        logger.info("updateUserStateId() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level2AccountEntity.updateUserStateId");
        final String previousUserStateId = this.userStateId;
        Level2AccountEntity newLevel2Account = new Level2AccountEntity(userStateId, this);
        return RiakCommon.storeEntity(newLevel2Account, token).flatMap((Function1)new Mapper<Void, Future<Void>>(){

            public Future<Void> apply(Void parameter) {
                logger.info("updateUserStateId() : addUserStateIdToHistory");
                return StateHistoryEntity.addUserStateIdToHistory(previousUserStateId, SocialNetworks.valueOf(Level2AccountEntity.this.socialNetworkName), token);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Void>(){

            public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JsonIgnore
    public void updateUserStateIdSync(String userStateId, Token token) {
        logger.info("updateUserStateIdSync() : start");
        JMonitor monitor = JMonitorFactory.start((String)"DATA: Level2AccountEntity.updateUserStateIdSync");
        try {
            String previousUserStateId = this.userStateId;
            Level2AccountEntity newLevel2Account = new Level2AccountEntity(userStateId, this);
            RiakCommon.storeEntitySync(newLevel2Account, token);
            StateHistoryEntity.addUserStateIdToHistorySync(previousUserStateId, SocialNetworks.valueOf(this.socialNetworkName), token);
        }
        finally {
            monitor.stop();
        }
    }

    @Override
    @JsonIgnore
    public Future<Void> detachFromLevel3DNAAccount(Token token) {
        logger.info("detachFromLevel3DNAAccount() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level2AccountEntity.detachFromLevel3DNAAccount");
        Level2AccountEntity newLevel2Account = new Level2AccountEntity(this, null);
        return RiakCommon.storeEntity(newLevel2Account, token).andThen((PartialFunction)new OnComplete<Void>(){

            public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    @Override
    @JsonIgnore
    public void detachFromLevel3DNAAccountSync(Token token) {
        Level2AccountEntity newLevel2Account = new Level2AccountEntity(this, null);
        RiakCommon.storeEntitySync(newLevel2Account, token);
    }

    @Override
    @JsonIgnore
    public Future<Level2Account> updateAccessToken(String socialNetworkAccessToken, String numberOfSecondsUntilTokenExpire, String refreshDate, Token token) {
        logger.info("updateAccessToken() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level2AccountEntity.updateAccessToken");
        final Level2AccountEntity newLevel2Account = new Level2AccountEntity(this, socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDate);
        return RiakCommon.storeEntity(newLevel2Account, token).flatMap((Function1)new Mapper<Void, Future<Level2Account>>(){

            public Future<Level2Account> apply(Void parameter) {
                return Futures.successful((Object)newLevel2Account);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level2Account>(){

            public void onComplete(Throwable throwable, Level2Account level2Account) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Level2Account> create(String socialNetworkUserId, String userStateId, SocialNetworks socialNetwor, String accessToken, long timeWhenTokenWillBeExpiredMillis, String refreshDate, Token token) {
        logger.info("create() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level2AccountEntity.create");
        String level2AcountId = AccountIdGenerator.createIdBasedOnSocialNetwork(socialNetworkUserId, socialNetwor);
        final Level2AccountEntity level2Account = new Level2AccountEntity(level2AcountId, socialNetworkUserId, userStateId, socialNetwor.name(), accessToken, timeWhenTokenWillBeExpiredMillis, refreshDate);
        return RiakCommon.storeEntity(level2Account, token).flatMap((Function1)new Mapper<Void, Future<Level2Account>>(){

            public Future<Level2Account> apply(Void parameter) {
                return Futures.successful((Object)level2Account);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level2Account>(){

            public void onComplete(Throwable throwable, Level2Account level2Account) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Level2Account> fetchOrCreate(final String socialNetworkUserId, final String userStateId, final SocialNetworks socialNetwor, final String accessToken, final long timeWhenTokenWillBeExpiredMillis, final String refreshDate, final Token token) {
        logger.info("fetchOrCreate() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level2AccountEntity.fetchOrCreate");
        String level2AcountId = AccountIdGenerator.createIdBasedOnSocialNetwork(socialNetworkUserId, socialNetwor);
        return RiakCommon.fetchEntityById(level2AcountId, Level2AccountEntity.class, token).flatMap((Function1)new Mapper<Level2AccountEntity, Future<Level2Account>>(){

            public Future<Level2Account> apply(Level2AccountEntity fetchedLevel2AccountEntity) {
                if (fetchedLevel2AccountEntity == null) {
                    return Level2AccountEntity.create(socialNetworkUserId, userStateId, socialNetwor, accessToken, timeWhenTokenWillBeExpiredMillis, refreshDate, token);
                }
                return Futures.successful((Object)fetchedLevel2AccountEntity);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level2Account>(){

            public void onComplete(Throwable throwable, Level2Account level2Account) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Level2Account> fetch(String level2AccountId, Token token) {
        return RiakCommon.fetchEntityById(level2AccountId, Level2AccountEntity.class, token).flatMap((Function1)new Mapper<Level2AccountEntity, Future<Level2Account>>(){

            public Future<Level2Account> apply(Level2AccountEntity fetchedLevel2AccountEntity) {
                return Futures.successful((Object)fetchedLevel2AccountEntity);
            }
        }, Riak.getExecutionContext());
    }

    public static Level2Account fetchSync(String level2AccountId, Token token) {
        return RiakCommon.fetchEntityByIdSync(level2AccountId, Level2AccountEntity.class, token);
    }

    public static Future<List<String>> grabAllKeysByDate(LocalDate localDate, Token token) {
        logger.info("grabAllKeysByDate() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level2AccountEntity.grabAllKeysByDate");
        return RiakCommon.binaryIndexSearch(Level2AccountEntity.class, CREATION_TIME_INDEX_NAME, localDate.toString(), token).andThen((PartialFunction)new OnComplete<List<String>>(){

            public void onComplete(Throwable throwable, List<String> strings) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Iterable<List<String>>> grabAllKeysFromBeginningOfTime(Token token) {
        logger.info("grabAllKeysFromBeginningOfTime() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level2AccountEntity.grabAllKeysFromBeginningOfTime");
        LocalDate now = LocalDate.now();
        LocalDate tmpDate = Dates.BEGINNING_OF_TIME.asDate();
        ArrayList<Future<List<String>>> futureList = new ArrayList<Future<List<String>>>();
        while (tmpDate.isBefore((ReadablePartial)now) || tmpDate.isEqual((ReadablePartial)now)) {
            futureList.add(Level2AccountEntity.grabAllKeysByDate(tmpDate, token));
            tmpDate = tmpDate.plusDays(1);
        }
        return Futures.sequence(futureList, (ExecutionContext)Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Iterable<List<String>>>(){

            public void onComplete(Throwable throwable, Iterable<List<String>> listIterable) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }
}

