/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import com.basho.riak.client.cap.ConflictResolver;
import entities.common.EventQueueEntity;
import entities.common.EventVO;
import java.util.Collection;
import java.util.HashSet;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventQueueEntityConflictResolver
implements ConflictResolver<EventQueueEntity> {
    public EventQueueEntity resolve(Collection<EventQueueEntity> siblings) {
        if (siblings.size() > 1) {
            String eventQueueId = null;
            PriorityQueue<EventVO> queue = new PriorityQueue<EventVO>();
            HashSet<EventVO> queueSet = new HashSet<EventVO>();
            HashSet<EventVO> history = new HashSet<EventVO>();
            int previousArchivedEventQueueIdx = 0;
            for (EventQueueEntity eachEventQueue : siblings) {
                eventQueueId = eachEventQueue.getEventQueueId();
                previousArchivedEventQueueIdx = eachEventQueue.getPreviousArchivedEventQueueIdx();
                queueSet.addAll(eachEventQueue.getQueue());
                history.addAll(eachEventQueue.getHistory());
            }
            queue.addAll(queueSet);
            EventQueueEntity newEntity = new EventQueueEntity(eventQueueId, queue, history, previousArchivedEventQueueIdx);
            return newEntity;
        }
        if (siblings.size() == 1) {
            return siblings.iterator().next();
        }
        return null;
    }
}

