/*
 * Decompiled with CFR 0.152.
 */
package calculator;

import constants.Contexts;
import constants.SocialNetworks;
import entities.common.ContextVO;
import entities.common.Level3DNAAccountEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnaScoreCalculator {
    private static final Logger logger = LoggerFactory.getLogger(DnaScoreCalculator.class);
    private static final int RANGE = 100;
    private static final Map<String, Integer> networkOrder = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ContextVO> calculateDnaScores(Map<String, Level3DNAAccountEntity.ContextBundle> contextBundleMap) {
        JMonitor monitor = JMonitorFactory.start((String)"DATA: DnaScoreCalculator.calculateDnaScores");
        try {
            boolean enablePenalty;
            ContextVO[] contextVoInOrderArray = new ContextVO[]{new ContextVO(Contexts.MAIN.name(), 0.0), new ContextVO(Contexts.MAIN.name(), 0.0)};
            if (contextBundleMap.isEmpty()) {
                HashSet<ContextVO> hashSet = new HashSet<ContextVO>();
                return hashSet;
            }
            double penalty = 1.0;
            boolean bl = enablePenalty = contextBundleMap.values().size() <= 1;
            if (enablePenalty) {
                penalty = 0.25;
            }
            logger.debug("penalty will be : " + penalty);
            HashMap contextVOMap = new HashMap();
            for (String eachNetwork : contextBundleMap.keySet()) {
                Level3DNAAccountEntity.ContextBundle eachContextBundle = contextBundleMap.get(eachNetwork);
                Set<ContextVO> eachContextSet = eachContextBundle.getContexts();
                for (ContextVO eachContext : eachContextSet) {
                    if (!eachContext.getContextName().equals(Contexts.MAIN.name())) continue;
                    int networkOrderIndex = networkOrder.get(eachNetwork);
                    contextVoInOrderArray[networkOrderIndex] = eachContext;
                }
            }
            double finalScore = 0.0;
            for (int i = 0; i < contextVoInOrderArray.length; ++i) {
                if (i == 0) {
                    finalScore += contextVoInOrderArray[i].getScore();
                    continue;
                }
                finalScore += (100.0 - finalScore) / 100.0 * contextVoInOrderArray[i].getScore();
            }
            ContextVO mainContext = new ContextVO(Contexts.MAIN.name(), finalScore);
            mainContext = mainContext.applyPenalty(penalty);
            HashSet<ContextVO> finalDnaContextSet = new HashSet<ContextVO>();
            finalDnaContextSet.add(mainContext);
            HashSet<ContextVO> hashSet = finalDnaContextSet;
            return hashSet;
        }
        finally {
            monitor.stop();
        }
    }

    static {
        networkOrder.put(SocialNetworks.Vkontakte.name(), 0);
        networkOrder.put(SocialNetworks.Facebook.name(), 1);
    }
}

