/*
 * Decompiled with CFR 0.152.
 */
package util;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import constants.SocialNetworks;
import entities.common.Level1AccountEntity;
import entities.common.Level2AccountEntity;
import entities.common.Level3DNAAccountEntity;
import entities.interfaces.Level2Account;
import entities.interfaces.UserState;
import exceptions.ServiceException;
import helpers.UserStateHelper;
import identity.Token;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import riak.Riak;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import util.DNAAccountConflictResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialNetworkService {
    private static final Logger logger = LoggerFactory.getLogger(SocialNetworkService.class);

    public static Future<Level3DNAAccountEntity> registerSocialNetwork(String socialNetworkAccessToken, String numberOfSecondsUntilTokenExpire, String refreshDate, SocialNetworks socialNetwork, final Token token) {
        logger.info("SocialNetworkService : registerSocialNetwork()");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: SocialNetworkService.registerSocialNetwork");
        Future<UserState> userStateFuture = UserStateHelper.constructUserStateFromSocialNetworkWithAccessToken(socialNetworkAccessToken, socialNetwork, token);
        Future<Bundle> firstBundleFuture = SocialNetworkService.findLevel3ByUserStateAndUpdateAccessTokeInsideLevel2OrCreateLevel2(userStateFuture, socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDate, token);
        Future<Bundle> completedBundleFuture = SocialNetworkService.findLevel3AccountAtachedToThisLevel1AccountAndCreateLevel1AccountIfNotExist(firstBundleFuture, token);
        return completedBundleFuture.flatMap((Function1)new Mapper<Bundle, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Bundle completedBundle) {
                if (completedBundle.level3relatedToSocialNetwork == null && completedBundle.level3relatedToLevel1account == null) {
                    logger.info("SocialNetworkService : registerSocialNetwork() : new user with new device");
                    return Level3DNAAccountEntity.create(completedBundle.userState, completedBundle.level1AccountEntity, completedBundle.level2Account, token);
                }
                if (completedBundle.level3relatedToSocialNetwork != null && completedBundle.level3relatedToLevel1account == null) {
                    logger.info("SocialNetworkService : registerSocialNetwork() : user try to use previously attached network on new device");
                    return completedBundle.level3relatedToSocialNetwork.attachLevel1Account(completedBundle.level1AccountEntity, token);
                }
                if (completedBundle.level3relatedToSocialNetwork == null && completedBundle.level3relatedToLevel1account != null) {
                    logger.info("SocialNetworkService : registerSocialNetwork() : user try to attach new network to existing level3 account");
                    return completedBundle.level3relatedToLevel1account.updateWithSocialNetwork(completedBundle.userState, completedBundle.level2Account, token);
                }
                if (completedBundle.level3relatedToSocialNetwork != null && completedBundle.level3relatedToLevel1account != null && completedBundle.level3relatedToSocialNetwork.getLevel3DNAAccountId().equals(completedBundle.level3relatedToLevel1account.getLevel3DNAAccountId())) {
                    logger.info("SocialNetworkService : registerSocialNetwork() : user try to attach existing network to existing level3 without conflicts (possible only by mistake)");
                    return Futures.successful((Object)completedBundle.level3relatedToSocialNetwork);
                }
                if (completedBundle.level3relatedToSocialNetwork != null && completedBundle.level3relatedToLevel1account != null && !completedBundle.level3relatedToSocialNetwork.getLevel3DNAAccountId().equals(completedBundle.level3relatedToLevel1account.getLevel3DNAAccountId())) {
                    logger.info("SocialNetworkService : registerSocialNetwork() : case of mergering level3 accounts");
                    return DNAAccountConflictResolver.mergeTwoConflictsAccounts(completedBundle.level3relatedToSocialNetwork, completedBundle.level3relatedToLevel1account, token);
                }
                throw new ServiceException("Unable connect the network", token.getAccountId());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    private static Future<Bundle> findLevel3ByUserStateAndUpdateAccessTokeInsideLevel2OrCreateLevel2(Future<UserState> userStateFuture, final String socialNetworkAccessToken, final String numberOfSecondsUntilTokenExpire, final String refreshDate, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: SocialNetworkService.findLevel3ByUserStateAndUpdateAccessTokeInsideLevel2OrCreateLevel2");
        return userStateFuture.flatMap((Function1)new Mapper<UserState, Future<Bundle>>(){

            public Future<Bundle> apply(final UserState userState) {
                logger.info("SocialNetworkService : findLevel3ByUserStateAndUpdateAccessTokeInsideLevel2OrCreateLevel2() : fetch or create new level2account");
                Future<Level2Account> level2AccountFuture = Level2AccountEntity.fetchOrCreate(userState.getSocialNetworkUserId(), userState.getUserStateId(), SocialNetworks.valueOf(userState.getSocialNetworkName()), socialNetworkAccessToken, DateTime.now().plusSeconds(Integer.parseInt(numberOfSecondsUntilTokenExpire)).getMillis(), refreshDate, token);
                Future level3DNAAccountEntityBundleFuture = level2AccountFuture.flatMap((Function1)new Mapper<Level2Account, Future<Bundle>>(){

                    public Future<Bundle> apply(Level2Account fetchedOrCreatedLevel2Account) {
                        logger.info("SocialNetworkService : findLevel3ByUserStateAndUpdateAccessTokeInsideLevel2OrCreateLevel2() : update accessToken in level2account");
                        Future<Level2Account> updateAccessTokenFuture = fetchedOrCreatedLevel2Account.updateAccessToken(socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDate, token);
                        Future fetchLevel3DNAAccountEntityFuture = updateAccessTokenFuture.flatMap((Function1)new Mapper<Level2Account, Future<Bundle>>(){

                            public Future<Bundle> apply(final Level2Account updatedLevel2account) {
                                if (updatedLevel2account.getLevel3DNAAccountId() == null) {
                                    logger.info("SocialNetworkService : findLevel3ByUserStateAndUpdateAccessTokeInsideLevel2OrCreateLevel2() : current level2account does not related to dnaAccount");
                                    Bundle resultBundle = new Bundle(userState, null, updatedLevel2account, null, null);
                                    return Futures.successful((Object)resultBundle);
                                }
                                logger.info("SocialNetworkService : findLevel3ByUserStateAndUpdateAccessTokeInsideLevel2OrCreateLevel2() : current level2account has related to dnaAccount : lets check if it exist");
                                return Level3DNAAccountEntity.fetch(updatedLevel2account.getLevel3DNAAccountId(), token).flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Bundle>>(){

                                    public Future<Bundle> apply(Level3DNAAccountEntity fetchedLevel3) {
                                        if (fetchedLevel3 == null) {
                                            logger.info("SocialNetworkService : findLevel3ByUserStateAndUpdateAccessTokeInsideLevel2OrCreateLevel2() : there is no dnaAccount");
                                            Bundle resultBundle = new Bundle(userState, null, updatedLevel2account, null, null);
                                            return Futures.successful((Object)resultBundle);
                                        }
                                        logger.info("SocialNetworkService : findLevel3ByUserStateAndUpdateAccessTokeInsideLevel2OrCreateLevel2() : there is dnaAccount");
                                        Bundle resultBundle = new Bundle(userState, null, updatedLevel2account, fetchedLevel3, null);
                                        return Futures.successful((Object)resultBundle);
                                    }
                                }, Riak.getExecutionContext());
                            }
                        }, Riak.getExecutionContext());
                        return fetchLevel3DNAAccountEntityFuture;
                    }
                }, Riak.getExecutionContext());
                return level3DNAAccountEntityBundleFuture;
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Bundle>(){

            public void onComplete(Throwable throwable, Bundle bundle) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    private static Future<Bundle> findLevel3AccountAtachedToThisLevel1AccountAndCreateLevel1AccountIfNotExist(Future<Bundle> bundleFuture, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: SocialNetworkService.findLevel3AccountAtachedToThisLevel1AccountAndCreateLevel1AccountIfNotExist");
        return bundleFuture.flatMap((Function1)new Mapper<Bundle, Future<Bundle>>(){

            public Future<Bundle> apply(final Bundle givenBundle) {
                logger.info("SocialNetworkService : findLevel3AccountAtachedToThisLevel1AccountAndCreateLevel1AccountIfNotExist() : first check is user already have level1account on this device connected to dnaAccount");
                Future<Level1AccountEntity> level1AccountFuture = Level1AccountEntity.fetchOrCreate(token);
                Future resultBundle = level1AccountFuture.flatMap((Function1)new Mapper<Level1AccountEntity, Future<Bundle>>(){

                    public Future<Bundle> apply(final Level1AccountEntity fetchedOrCreatedLevel1account) {
                        if (fetchedOrCreatedLevel1account.getLevel3DNAAccountId() == null) {
                            logger.info("SocialNetworkService : findLevel3AccountAtachedToThisLevel1AccountAndCreateLevel1AccountIfNotExist() : user does not have level1account on this device connected to dnaAccount");
                            return Futures.future((Callable)new Callable<Bundle>(){

                                @Override
                                public Bundle call() throws Exception {
                                    Bundle newBundle = new Bundle(givenBundle.userState, fetchedOrCreatedLevel1account, givenBundle.level2Account, givenBundle.level3relatedToSocialNetwork, null);
                                    return newBundle;
                                }
                            }, (ExecutionContext)Riak.getExecutionContext());
                        }
                        logger.info("SocialNetworkService : findLevel3AccountAtachedToThisLevel1AccountAndCreateLevel1AccountIfNotExist() : user has level1account on this device connected to dnaAccount");
                        return Level3DNAAccountEntity.fetch(fetchedOrCreatedLevel1account.getLevel3DNAAccountId(), token).flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Bundle>>(){

                            public Future<Bundle> apply(final Level3DNAAccountEntity fetchedOldLevel3account) {
                                return Futures.future((Callable)new Callable<Bundle>(){

                                    @Override
                                    public Bundle call() throws Exception {
                                        Bundle newBundle = new Bundle(givenBundle.userState, fetchedOrCreatedLevel1account, givenBundle.level2Account, givenBundle.level3relatedToSocialNetwork, fetchedOldLevel3account);
                                        return newBundle;
                                    }
                                }, (ExecutionContext)Riak.getExecutionContext());
                            }
                        }, Riak.getExecutionContext());
                    }
                }, Riak.getExecutionContext());
                return resultBundle;
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Bundle>(){

            public void onComplete(Throwable throwable, Bundle bundle) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static class Bundle {
        public final UserState userState;
        public final Level1AccountEntity level1AccountEntity;
        public final Level2Account level2Account;
        public final Level3DNAAccountEntity level3relatedToSocialNetwork;
        public final Level3DNAAccountEntity level3relatedToLevel1account;

        public Bundle(UserState userState, Level1AccountEntity level1AccountEntity, Level2Account level2Account, Level3DNAAccountEntity level3relatedToSocialNetwork, Level3DNAAccountEntity level3relatedToLevel1account) {
            this.userState = userState;
            this.level1AccountEntity = level1AccountEntity;
            this.level2Account = level2Account;
            this.level3relatedToSocialNetwork = level3relatedToSocialNetwork;
            this.level3relatedToLevel1account = level3relatedToLevel1account;
        }
    }
}

