/*
 * Decompiled with CFR 0.152.
 */
package riak;

import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import com.basho.riak.client.IRiakClient;
import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakLink;
import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.cap.ConflictResolver;
import com.basho.riak.client.query.MultiFetchFuture;
import com.basho.riak.client.query.indexes.BinIndex;
import com.basho.riak.client.query.indexes.RiakIndex;
import com.google.common.collect.Lists;
import constants.SocialNetworks;
import constants.Tags;
import entities.common.Level1AccountEntity;
import entities.common.Level2AccountEntity;
import entities.common.Level3DNAAccountEntity;
import exceptions.EntityNotFoundException;
import exceptions.ServiceException;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import riak.Riak;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakCommon {
    public static <T> Future<Void> deleteEntity(final T entity, final Token token) {
        return Futures.future((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RiakCommon.deleteEntitySync(entity, token);
                return null;
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }

    public static <T> void deleteEntitySync(T entity, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.deleteEntitySync : " + entity.getClass().getName()));
        try {
            if (entity == null || token == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            String finalBucketName = Riak.getFinalBucketName(entity.getClass());
            IRiakClient pbRiakClient = Riak.pbcClient();
            Bucket bucket = pbRiakClient.fetchBucket(finalBucketName).lazyLoadBucketProperties().execute();
            bucket.delete(entity).execute();
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during storing " + entity.getClass().getName(), throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static <T> Future<T> fetchEntityById(final String id, final Class<T> clazz, final Token token) {
        return Futures.future((Callable)new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RiakCommon.fetchEntityByIdSync(id, clazz, token);
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }

    public static <T> List<T> multiFetchSync(Set<String> ids, Class<T> clazz, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.multiFetchSync : " + clazz.getName()));
        ArrayList<Object> resultList = new ArrayList<Object>();
        try {
            String finalBucketName = Riak.getFinalBucketName(clazz);
            ConflictResolver<Level1AccountEntity> conflictResolver = Riak.getConflictResolver(Level1AccountEntity.class);
            IRiakClient pbRiakClient = Riak.pbcClient();
            Bucket bucket = pbRiakClient.fetchBucket(finalBucketName).lazyLoadBucketProperties().execute();
            List futures = null;
            futures = conflictResolver == null ? bucket.multiFetch((List)Lists.newArrayList(ids), clazz).execute() : bucket.multiFetch((List)Lists.newArrayList(ids), clazz).withResolver(conflictResolver).execute();
            for (MultiFetchFuture f : futures) {
                Object entity = f.get();
                resultList.add(entity);
            }
            ArrayList<Object> arrayList = resultList;
            return arrayList;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during multy fetching " + clazz.getName(), throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static <T> T fetchEntityByIdSync(String id, Class<T> clazz, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.fetchEntityByIdSync : " + clazz.getName()));
        try {
            Object result;
            if (id == null || id.isEmpty() || clazz == null || token == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            String finalBucketName = Riak.getFinalBucketName(clazz);
            IRiakClient pbRiakClient = Riak.pbcClient();
            Bucket bucket = pbRiakClient.fetchBucket(finalBucketName).lazyLoadBucketProperties().execute();
            ConflictResolver<T> conflictResolver = Riak.getConflictResolver(clazz);
            if (conflictResolver == null) {
                Object result2;
                Object object = result2 = bucket.fetch(id, clazz).execute();
                return (T)object;
            }
            Object object = result = bucket.fetch(id, clazz).withResolver(conflictResolver).execute();
            return (T)object;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during fetching " + clazz.getName(), throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static <T> Future<Void> storeEntity(final T entity, final Token token) {
        return Futures.future((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RiakCommon.storeEntitySync(entity, token);
                return null;
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }

    public static <T> void storeEntitySync(T entity, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.storeEntitySync : " + entity.getClass().getName()));
        try {
            if (entity == null || token == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            String finalBucketName = Riak.getFinalBucketName(entity.getClass());
            IRiakClient pbRiakClient = Riak.pbcClient();
            Bucket bucket = pbRiakClient.fetchBucket(finalBucketName).lazyLoadBucketProperties().execute();
            ConflictResolver<?> conflictResolver = Riak.getConflictResolver(entity.getClass());
            if (conflictResolver == null) {
                bucket.store(entity).returnBody(false).execute();
            } else {
                bucket.store(entity).returnBody(true).withResolver(conflictResolver).execute();
            }
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during storing " + entity.getClass().getName(), throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static Future<Map<String, Object>> linkWalk(final String fromEntityId, final Class fromClazz, final Class targetClazz, final String tag, final Token token) {
        return Futures.future((Callable)new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                return RiakCommon.linkWalkSync(fromEntityId, fromClazz, targetClazz, tag, token);
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }

    public static Map<String, Object> linkWalkWithMultiFetchSync(String fromEntityId, String tag, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.linkWalkWithMultiFetchSync fromClazz : " + Level3DNAAccountEntity.class.getName() + " tag : " + tag));
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Set<String> level2_ids;
            Set<String> level1_ids;
            Level3DNAAccountEntity dnaAccountEntity = RiakCommon.fetchEntityByIdSync(fromEntityId, Level3DNAAccountEntity.class, token);
            Map<String, Set<String>> accountLinks = dnaAccountEntity.getAccountLinks();
            ArrayList<Level1AccountEntity> level1AccountEntities = new ArrayList<Level1AccountEntity>();
            ArrayList<Level2AccountEntity> level2AccountEntitiesVK = new ArrayList<Level2AccountEntity>();
            ArrayList<Level2AccountEntity> level2AccountEntitiesFb = new ArrayList<Level2AccountEntity>();
            if ((tag == null || tag.equals("_") || tag.equals(Tags.LEVEL_1_ACCOUNTS.name())) && (level1_ids = accountLinks.get(Tags.LEVEL_1_ACCOUNTS.name())) != null && !level1_ids.isEmpty()) {
                level1AccountEntities.addAll(RiakCommon.multiFetchSync(level1_ids, Level1AccountEntity.class, token));
            }
            if ((tag == null || tag.equals("_") || tag.equals(Tags.LEVEL_2_ACCOUNTS.name())) && (level2_ids = accountLinks.get(Tags.LEVEL_2_ACCOUNTS.name())) != null && !level2_ids.isEmpty()) {
                List<Level2AccountEntity> mixedList = RiakCommon.multiFetchSync(level2_ids, Level2AccountEntity.class, token);
                for (Level2AccountEntity each : mixedList) {
                    if (each.getSocialNetworkName().equals(SocialNetworks.Facebook.name())) {
                        level2AccountEntitiesFb.add(each);
                        continue;
                    }
                    if (!each.getSocialNetworkName().equals(SocialNetworks.Vkontakte.name())) continue;
                    level2AccountEntitiesVK.add(each);
                }
            }
            result.put("BA", level1AccountEntities);
            result.put(SocialNetworks.Facebook.name(), level2AccountEntitiesFb);
            result.put(SocialNetworks.Vkontakte.name(), level2AccountEntitiesVK);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during linkWalkWithMultiFetchSync from : " + Level3DNAAccountEntity.class.getName() + " by tag : " + tag, throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static Map<String, Object> linkWalkSync(String fromEntityId, Class fromClazz, Class targetClazz, String tag, Token token) {
        String targetClassName = targetClazz != null ? targetClazz.getName() : "null";
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.linkWalkSync fromClazz : " + fromClazz.getName() + ": targetClazz : " + targetClassName + " tag : " + tag));
        String finalFromBucketName = null;
        String finalTargetBucketName = null;
        Object finalTag = null;
        try {
            if (fromEntityId == null || fromEntityId.isEmpty() || fromClazz == null || token == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            Map<String, Object> map = RiakCommon.linkWalkWithMultiFetchSync(fromEntityId, tag, token);
            return map;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during link walking from : " + finalFromBucketName + " to : " + finalTargetBucketName, throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static Future<Void> addLinkTo(final String fromId, final Class fromClazz, final Class toAccountClazz, final String targetAccountId, final String tag, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.addLinkTo toAccountClazz : " + toAccountClazz.getName() + " tag : " + tag));
        return Futures.future((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (fromId == null || fromId.isEmpty() || fromClazz == null || toAccountClazz == null || targetAccountId == null || targetAccountId.isEmpty() || tag == null || tag.isEmpty() || token == null) {
                    throw new IllegalArgumentException("Argument null or empty string");
                }
                String finalFromBucketName = Riak.getFinalBucketName(fromClazz);
                String finalToBucketName = Riak.getFinalBucketName(toAccountClazz);
                IRiakClient httpClient = Riak.httpClient();
                try {
                    Bucket bucket = httpClient.fetchBucket(finalFromBucketName).execute();
                    ConflictResolver conflictResolver = Riak.getConflictResolver(fromClazz);
                    IRiakObject fromObject = null;
                    Object obj = bucket.fetch(fromId, fromClazz).withResolver(conflictResolver).execute();
                    bucket.store(fromId, obj).withResolver(conflictResolver).execute();
                    fromObject = (IRiakObject)bucket.fetch(fromId).execute();
                    if (fromObject == null) {
                        throw new EntityNotFoundException("Error during make a link from : " + finalFromBucketName + " to : " + finalToBucketName, token.getAccountId());
                    }
                    fromObject.addLink(new RiakLink(finalToBucketName, targetAccountId, tag));
                    bucket.store((Object)fromObject).returnBody(false).execute();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new ServiceException("Error during linking Level2FacebookAccountEntity", throwable, token.getAccountId());
                }
            }
        }, (ExecutionContext)Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Void>(){

            public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static List<String> binaryIndexSearchSync(Class clazz, String indexName, String indexValue, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.binaryIndexSearchSync : " + clazz.getName()));
        try {
            List result;
            if (indexName == null || indexName.isEmpty() || clazz == null || token == null || indexValue == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            String finalBucketName = Riak.getFinalBucketName(clazz);
            IRiakClient pbRiakClient = Riak.pbcClient();
            Bucket bucket = pbRiakClient.fetchBucket(finalBucketName).lazyLoadBucketProperties().execute();
            List list = result = bucket.fetchIndex((RiakIndex)BinIndex.named((String)indexName)).withValue((Object)indexValue).execute();
            return list;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during search by binary index " + clazz.getName(), throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static Future<List<String>> binaryIndexSearch(final Class clazz, final String indexName, final String indexValue, final Token token) {
        return Futures.future((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return RiakCommon.binaryIndexSearchSync(clazz, indexName, indexValue, token);
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }
}

