/*
 * Decompiled with CFR 0.152.
 */
package riak;

import com.basho.riak.client.IRiakClient;
import com.basho.riak.client.RiakException;
import com.basho.riak.client.RiakFactory;
import com.basho.riak.client.cap.ConflictResolver;
import com.basho.riak.client.cap.DefaultRetrier;
import com.basho.riak.client.raw.config.Configuration;
import com.basho.riak.client.raw.http.HTTPClientConfig;
import com.basho.riak.client.raw.pbc.PBClientConfig;
import exceptions.ServiceException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import riak.RiakEntity;
import scala.concurrent.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Riak {
    private static final Logger logger = LoggerFactory.getLogger(Riak.class);
    private static final String CONFLICT_RESOLVER_CLASS_END = "ConflictResolver";
    private static IRiakClient httpClient = null;
    private static IRiakClient pbClient = null;
    private static ExecutionContext executionContext = null;
    private static final int MAX_CONNECTIONS = 50;
    private static final int INITIAL_POOL_SIZE = 5;
    private static final int POOL_SIZE = 50;
    private static final int MAX_ATTEMPTS = 3;
    private static HashMap<String, Boolean> bucketMap = new HashMap();
    private static HashMap<String, Class> finalBucketNamesByClassMap = new HashMap();
    private static HashMap<Class, ConflictResolver> conflictResolverMap = new HashMap();
    private static String databaseName;

    public static void isInitialized() {
        if (httpClient == null || pbClient == null || executionContext == null || databaseName == null || databaseName.isEmpty()) {
            throw new ServiceException("Riak has not been initialized correctly", null);
        }
    }

    public static void initialize(String name, ExecutionContext context) {
        logger.info("Initialize Riak with databaseName : " + name);
        executionContext = context;
        try {
            HTTPClientConfig httpClientConfig = new HTTPClientConfig.Builder().withMaxConnections(50).build();
            httpClient = RiakFactory.newClient((Configuration)httpClientConfig);
            PBClientConfig pbClientConfig = new PBClientConfig.Builder().withInitialPoolSize(5).withPoolSize(50).build();
            pbClient = RiakFactory.newClient((Configuration)pbClientConfig);
            databaseName = name;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Riak has not been initialized correctly", throwable, null);
        }
    }

    public static void tearDown() {
        logger.info("Riak tearDown");
        Riak.isInitialized();
        httpClient.shutdown();
        pbClient.shutdown();
    }

    public static <T> String getFinalBucketName(Class<T> clazz) {
        Riak.isInitialized();
        if (clazz.getAnnotation(RiakEntity.class) == null) {
            throw new ServiceException(clazz.getName() + " is not the Entity", null);
        }
        String bucketName = clazz.getAnnotation(RiakEntity.class).bucketName();
        String finalBucketName = databaseName + "-" + bucketName;
        if (bucketMap.get(finalBucketName) == null) {
            throw new ServiceException("Bucket has not been initialized correctly", null);
        }
        finalBucketNamesByClassMap.put(finalBucketName, clazz);
        return finalBucketName;
    }

    public static Class getClassByFinalBucketName(String finalBucketName) {
        Riak.isInitialized();
        return finalBucketNamesByClassMap.get(finalBucketName);
    }

    protected static <T> ConflictResolver<T> getConflictResolver(Class<T> clazz) {
        Riak.isInitialized();
        if (clazz.getAnnotation(RiakEntity.class) == null) {
            throw new ServiceException(clazz.getName() + " is not the Entity", null);
        }
        String bucketName = clazz.getAnnotation(RiakEntity.class).bucketName();
        String finalBucketName = databaseName + "-" + bucketName;
        if (bucketMap.get(finalBucketName) == null) {
            throw new ServiceException("Bucket has not been initialized correctly", null);
        }
        return conflictResolverMap.get(clazz);
    }

    public static <T> void addEntityClass(Class<T> clazz) {
        logger.info("Add entity class : " + clazz.getName());
        Riak.isInitialized();
        if (clazz.getAnnotation(RiakEntity.class) == null) {
            throw new ServiceException(clazz.getName() + " is not the Entity", null);
        }
        String bucketName = clazz.getAnnotation(RiakEntity.class).bucketName();
        boolean allowSiblings = clazz.getAnnotation(RiakEntity.class).allowSiblings();
        boolean lastWriteWins = clazz.getAnnotation(RiakEntity.class).lastWriteWins();
        int r = clazz.getAnnotation(RiakEntity.class).R();
        int w = clazz.getAnnotation(RiakEntity.class).W();
        int n = clazz.getAnnotation(RiakEntity.class).N();
        if (r > n || w > n) {
            r = n;
            w = n;
        }
        if (allowSiblings) {
            String conflictResolverClassName = clazz.getName() + CONFLICT_RESOLVER_CLASS_END;
            try {
                ConflictResolver resolverIml = (ConflictResolver)Class.forName(conflictResolverClassName).newInstance();
                conflictResolverMap.put(clazz, resolverIml);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to create bucket with conflict resolver : " + conflictResolverClassName, (Throwable)e, null);
            }
        }
        String finalBucketName = databaseName + "-" + bucketName;
        logger.info("Creating bucket with finalBucketName : " + finalBucketName);
        try {
            httpClient.createBucket(finalBucketName).allowSiblings(allowSiblings).lastWriteWins(lastWriteWins).disableSearch().r(r).w(w).nVal(n).lazyLoadBucketProperties().withRetrier(DefaultRetrier.attempts((int)3)).execute();
        }
        catch (RiakException e) {
            throw new ServiceException("Unable to create bucket with finalName : " + finalBucketName, (Throwable)e, null);
        }
        bucketMap.put(finalBucketName, true);
    }

    public static IRiakClient httpClient() {
        Riak.isInitialized();
        return httpClient;
    }

    public static IRiakClient pbcClient() {
        Riak.isInitialized();
        return pbClient;
    }

    public static ExecutionContext getExecutionContext() {
        Riak.isInitialized();
        return executionContext;
    }
}

