/*
 * Decompiled with CFR 0.152.
 */
package helpers.inside;

import constants.SocialNetworks;
import entities.common.CommentVO;
import entities.interfaces.Comment;
import exceptions.ForbiddenException;
import identity.Token;
import org.json.JSONException;
import org.json.JSONObject;

public class CommentHelper {
    public static Comment constructComment(String sourceObject, SocialNetworks socialNetwork, Token token) throws JSONException {
        switch (socialNetwork) {
            case Facebook: {
                return CommentHelper.createFacebookCommentFromJSON(sourceObject, token);
            }
            case Vkontakte: {
                return CommentHelper.createVkontakteCommentFromJSON(sourceObject, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    private static CommentVO createFacebookCommentFromJSON(String jsonString, Token at) throws JSONException, ForbiddenException {
        JSONObject object = new JSONObject(jsonString);
        if (object.has("error")) {
            throw new ForbiddenException("Facebook communication failed." + object.getString("error"), at.getAccountId());
        }
        String id = object.getString("id");
        String fromid = object.getString("fromid");
        long time = object.getLong("time");
        int likes = object.getInt("likes");
        String text = object.getString("text");
        return new CommentVO(id, fromid, time, text, likes);
    }

    private static CommentVO createVkontakteCommentFromJSON(String jsonString, Token at) throws JSONException, ForbiddenException {
        JSONObject object = new JSONObject(jsonString);
        if (object.has("error")) {
            throw new ForbiddenException("Vkontakte communication failed." + object.getString("error"), at.getAccountId());
        }
        String id = object.getString("cid");
        String fromid = object.getString("uid");
        Long unixTime = object.getLong("date");
        JSONObject likesJsonObject = object.getJSONObject("likes");
        int likes = likesJsonObject.getInt("count");
        String text = object.getString("text");
        return new CommentVO(id, fromid, unixTime, text, likes);
    }
}

