/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import constants.RankCollections;
import org.joda.time.DateTime;

public class ContextVO {
    @JsonProperty
    private String contextName;
    @JsonProperty
    private Rank rank;
    @JsonProperty
    private double score;
    @JsonProperty
    private long timestamp;

    @JsonCreator
    public ContextVO(@JsonProperty(value="contextName") String contextName, @JsonProperty(value="score") double score) {
        this.contextName = contextName;
        this.score = score;
        this.rank = RankCollections.getRankByScore(score);
        this.timestamp = DateTime.now().getMillis();
    }

    public ContextVO(ContextVO source) {
        this.contextName = source.contextName;
        this.rank = source.rank;
        this.score = source.score;
        this.timestamp = DateTime.now().getMillis();
    }

    @JsonIgnore
    public String getContextName() {
        return this.contextName;
    }

    @JsonIgnore
    public Rank getRank() {
        return this.rank;
    }

    @JsonIgnore
    public double getScore() {
        return this.score;
    }

    @JsonIgnore
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextVO contextVO = (ContextVO)o;
        return this.contextName.equals(contextVO.contextName);
    }

    @JsonIgnore
    public int hashCode() {
        return this.contextName.hashCode();
    }

    @JsonIgnore
    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextVO contextVO = (ContextVO)o;
        if (this.score != contextVO.score) {
            return false;
        }
        if (!this.contextName.equals(contextVO.contextName)) {
            return false;
        }
        if (!this.rank.equals(contextVO.rank)) {
            return false;
        }
        return this.timestamp == contextVO.timestamp;
    }

    @JsonIgnore
    public ContextVO plus(ContextVO anotherContext) {
        if (!this.contextName.equals(anotherContext.contextName)) {
            throw new IllegalArgumentException("context name is not equals");
        }
        double finalScore = this.score + anotherContext.getScore();
        return new ContextVO(this.contextName, finalScore);
    }

    @JsonIgnore
    public ContextVO applyPenalty(double penalty) {
        if (penalty == 1.0) {
            return this;
        }
        int finalScore = (int)((1.0 - penalty) * this.score);
        return new ContextVO(this.contextName, finalScore);
    }

    public static class Rank {
        @JsonProperty
        private final String rank_ru;
        @JsonProperty
        private final String rank_en;

        @JsonCreator
        public Rank(@JsonProperty(value="rank_ru") String rank_ru, @JsonProperty(value="rank_en") String rank_en) {
            this.rank_ru = rank_ru;
            this.rank_en = rank_en;
        }

        @JsonIgnore
        public String getRank_ru() {
            return this.rank_ru;
        }

        @JsonIgnore
        public String getRank_en() {
            return this.rank_en;
        }

        @JsonIgnore
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rank rank = (Rank)o;
            if (this.rank_en != null ? !this.rank_en.equals(rank.rank_en) : rank.rank_en != null) {
                return false;
            }
            return !(this.rank_ru != null ? !this.rank_ru.equals(rank.rank_ru) : rank.rank_ru != null);
        }

        @JsonIgnore
        public int hashCode() {
            int result = this.rank_ru != null ? this.rank_ru.hashCode() : 0;
            result = 31 * result + (this.rank_en != null ? this.rank_en.hashCode() : 0);
            return result;
        }
    }
}

