/*
 * Decompiled with CFR 0.152.
 */
package helpers.inside;

import constants.SocialNetworks;
import entities.common.CommentVO;
import entities.common.PostVO;
import entities.interfaces.Comment;
import entities.interfaces.Post;
import exceptions.ForbiddenException;
import helpers.inside.CommentHelper;
import identity.Token;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PostHelper {
    public static Post constructPost(String sourceObject, SocialNetworks socialNetwork, Token token) throws JSONException {
        switch (socialNetwork) {
            case Facebook: {
                return PostHelper.createFacebookPostFromJSON(sourceObject, token);
            }
            case Vkontakte: {
                return PostHelper.createVkontaktePostWithoutComments(sourceObject, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network in current method");
    }

    private static PostVO createFacebookPostFromJSON(String jsonString, Token at) throws JSONException, ForbiddenException {
        JSONObject object = new JSONObject(jsonString);
        if (object.has("error")) {
            throw new ForbiddenException("Facebook communication failed." + object.getString("error"), at.getAccountId());
        }
        String post_id = object.getString("post_id");
        String message = object.getString("message");
        String likesAsString = object.get("likes").toString();
        int likes = 0;
        if (likesAsString.startsWith("{")) {
            JSONObject likesJsonObject = object.getJSONObject("likes");
            likes = likesJsonObject.getInt("count");
        }
        JSONObject commentsJsonObject = object.getJSONObject("comments");
        JSONArray commentListJsonObject = commentsJsonObject.getJSONArray("comment_list");
        HashSet<Comment> comments = new HashSet<Comment>();
        for (int i = 0; i < commentListJsonObject.length(); ++i) {
            JSONObject eachJsonObject = commentListJsonObject.getJSONObject(i);
            CommentVO facebookPostCommentVO = (CommentVO)CommentHelper.constructComment(eachJsonObject.toString(), SocialNetworks.Facebook, at);
            comments.add(facebookPostCommentVO);
        }
        return new PostVO(post_id, message, likes, comments);
    }

    public static PostVO createVkontaktePostWithoutComments(String jsonString, Token at) throws JSONException, ForbiddenException {
        JSONObject object = new JSONObject(jsonString);
        if (object.has("error")) {
            throw new ForbiddenException("Vkontakte communication failed." + object.getString("error"), at.getAccountId());
        }
        String post_id = object.getString("id");
        String message = object.getString("text");
        JSONObject likesJsonObject = object.getJSONObject("likes");
        int likes = likesJsonObject.getInt("count");
        JSONObject commentsJsonObject = object.getJSONObject("comments");
        int commentsCount = commentsJsonObject.getInt("count");
        return new PostVO(post_id, message, likes, commentsCount);
    }
}

