/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import aws.sqs.SqsManager;
import calculator.DnaScoreCalculator;
import com.basho.riak.client.convert.RiakIndex;
import com.basho.riak.client.convert.RiakKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import constants.Dates;
import constants.SocialNetworks;
import constants.Tags;
import entities.common.ContextVO;
import entities.common.Level1AccountEntity;
import entities.common.UserProfileVO;
import entities.interfaces.Level2Account;
import entities.interfaces.UserState;
import exceptions.NetworkRegisterException;
import exceptions.ServiceException;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import riak.Riak;
import riak.RiakCommon;
import riak.RiakEntity;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import util.AccountIdGenerator;
import util.EventQueueBuilder;
import util.FriendsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RiakEntity(bucketName="dna.account", allowSiblings=true)
public class Level3DNAAccountEntity {
    public static final String CREATION_TIME_INDEX_NAME = "creationTime";
    @JsonProperty
    @RiakKey
    private final String level3DNAAccountId;
    @JsonProperty
    private final String socialNetworkName;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String gender;
    @JsonProperty
    private final String locale;
    @JsonProperty
    private final String email;
    @JsonProperty
    private final String pictureUrl;
    @JsonProperty
    private final boolean active;
    @JsonProperty
    private final Map<String, TreeSet<Transaction>> transactionSetForEachNetwork;
    @JsonProperty
    private final Map<String, ContextBundle> contextBundleForEachNetworkMap;
    @JsonProperty
    private final Map<String, FriendBundle> friendsBundleForEachNetworkMap;
    @JsonProperty
    private final Set<ContextVO> dnaContexts;
    @JsonProperty
    @RiakIndex(name="creationTime")
    private final String creationTime;
    @JsonProperty
    private final Map<String, Set<String>> accountLinks;

    @Deprecated
    @JsonCreator
    public Level3DNAAccountEntity(@JsonProperty(value="level3DNAAccountId") String level3DNAAccountId, @JsonProperty(value="socialNetworkName") String socialNetworkName, @JsonProperty(value="name") String name, @JsonProperty(value="gender") String gender, @JsonProperty(value="locale") String locale, @JsonProperty(value="email") String email, @JsonProperty(value="pictureUrl") String pictureUrl, @JsonProperty(value="active") boolean active, @JsonProperty(value="transactionSetForEachNetwork") Map<String, TreeSet<Transaction>> transactionSetForEachNetwork, @JsonProperty(value="contextBundleForEachNetworkMap") Map<String, ContextBundle> contextBundleForEachNetworkMap, @JsonProperty(value="friendsBundleForEachNetworkMap") Map<String, FriendBundle> friendsBundleForEachNetworkMap) {
        this.level3DNAAccountId = level3DNAAccountId;
        this.socialNetworkName = socialNetworkName;
        this.name = name;
        this.gender = gender;
        this.locale = locale;
        this.email = email;
        this.pictureUrl = pictureUrl;
        this.active = active;
        this.transactionSetForEachNetwork = new HashMap<String, TreeSet<Transaction>>();
        for (SocialNetworks eachSocialNetwork : SocialNetworks.values()) {
            TreeSet transactionTree = new TreeSet();
            this.transactionSetForEachNetwork.put(eachSocialNetwork.name(), transactionTree);
        }
        if (transactionSetForEachNetwork != null && !transactionSetForEachNetwork.isEmpty()) {
            for (String eachKey : transactionSetForEachNetwork.keySet()) {
                TreeSet<Transaction> transactionTreeFromGivenMap = transactionSetForEachNetwork.get(eachKey);
                if (transactionTreeFromGivenMap == null || transactionTreeFromGivenMap.isEmpty()) continue;
                this.transactionSetForEachNetwork.get(eachKey).addAll(transactionTreeFromGivenMap);
            }
        }
        this.contextBundleForEachNetworkMap = new HashMap<String, ContextBundle>();
        if (contextBundleForEachNetworkMap != null && !contextBundleForEachNetworkMap.isEmpty()) {
            for (String eachNetwork : contextBundleForEachNetworkMap.keySet()) {
                ContextBundle bundle = contextBundleForEachNetworkMap.get(eachNetwork);
                if (bundle == null) continue;
                this.contextBundleForEachNetworkMap.put(eachNetwork, bundle);
            }
        }
        this.dnaContexts = DnaScoreCalculator.calculateDnaScores(this.contextBundleForEachNetworkMap);
        this.friendsBundleForEachNetworkMap = new HashMap<String, FriendBundle>();
        if (friendsBundleForEachNetworkMap != null && !friendsBundleForEachNetworkMap.isEmpty()) {
            for (String eachNetwork : friendsBundleForEachNetworkMap.keySet()) {
                FriendBundle bundle = friendsBundleForEachNetworkMap.get(eachNetwork);
                if (bundle == null) continue;
                this.friendsBundleForEachNetworkMap.put(eachNetwork, bundle);
            }
        }
        this.creationTime = LocalDate.now().toString();
        this.accountLinks = new HashMap<String, Set<String>>();
    }

    @Deprecated
    public Level3DNAAccountEntity(String level3DNAAccountId, String socialNetworkName, String name, String gender, String locale, String email, String pictureUrl, boolean active, Map<String, TreeSet<Transaction>> transactionSetForEachNetwork, Map<String, ContextBundle> contextBundleForEachNetworkMap, Map<String, FriendBundle> friendsBundleForEachNetworkMap, String creationTime, Map<String, Set<String>> accountLinks) {
        this.level3DNAAccountId = level3DNAAccountId;
        this.socialNetworkName = socialNetworkName;
        this.name = name;
        this.gender = gender;
        this.locale = locale;
        this.email = email;
        this.pictureUrl = pictureUrl;
        this.active = active;
        this.transactionSetForEachNetwork = new HashMap<String, TreeSet<Transaction>>();
        for (SocialNetworks eachSocialNetwork : SocialNetworks.values()) {
            TreeSet transactionTree = new TreeSet();
            this.transactionSetForEachNetwork.put(eachSocialNetwork.name(), transactionTree);
        }
        if (transactionSetForEachNetwork != null && !transactionSetForEachNetwork.isEmpty()) {
            for (String eachKey : transactionSetForEachNetwork.keySet()) {
                TreeSet<Transaction> transactionTreeFromGivenMap = transactionSetForEachNetwork.get(eachKey);
                if (transactionTreeFromGivenMap == null || transactionTreeFromGivenMap.isEmpty()) continue;
                this.transactionSetForEachNetwork.get(eachKey).addAll(transactionTreeFromGivenMap);
            }
        }
        this.contextBundleForEachNetworkMap = new HashMap<String, ContextBundle>();
        if (contextBundleForEachNetworkMap != null && !contextBundleForEachNetworkMap.isEmpty()) {
            for (String eachNetwork : contextBundleForEachNetworkMap.keySet()) {
                ContextBundle bundle = contextBundleForEachNetworkMap.get(eachNetwork);
                if (bundle == null) continue;
                this.contextBundleForEachNetworkMap.put(eachNetwork, bundle);
            }
        }
        this.dnaContexts = DnaScoreCalculator.calculateDnaScores(this.contextBundleForEachNetworkMap);
        this.friendsBundleForEachNetworkMap = new HashMap<String, FriendBundle>();
        if (friendsBundleForEachNetworkMap != null && !friendsBundleForEachNetworkMap.isEmpty()) {
            for (String eachNetwork : friendsBundleForEachNetworkMap.keySet()) {
                FriendBundle bundle = friendsBundleForEachNetworkMap.get(eachNetwork);
                if (bundle == null) continue;
                this.friendsBundleForEachNetworkMap.put(eachNetwork, bundle);
            }
        }
        this.creationTime = creationTime;
        this.accountLinks = new HashMap<String, Set<String>>();
        if (accountLinks != null && !accountLinks.isEmpty()) {
            for (String eachKey : accountLinks.keySet()) {
                Set<String> eachValues = accountLinks.get(eachKey);
                if (eachValues == null || eachValues.isEmpty()) continue;
                HashSet<String> values = new HashSet<String>();
                values.addAll(eachValues);
                this.accountLinks.put(eachKey, values);
            }
        }
    }

    @JsonIgnore
    public String getLevel3DNAAccountId() {
        return this.level3DNAAccountId;
    }

    @JsonIgnore
    public String getSocialNetworkName() {
        return this.socialNetworkName;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getGender() {
        return this.gender;
    }

    @JsonIgnore
    public String getLocale() {
        return this.locale;
    }

    @JsonIgnore
    public String getEmail() {
        return this.email;
    }

    @JsonIgnore
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @JsonIgnore
    public boolean getActive() {
        return this.active;
    }

    @JsonIgnore
    public Map<String, TreeSet<Transaction>> getTransactionSetForEachNetwork() {
        HashMap<String, TreeSet<Transaction>> result = new HashMap<String, TreeSet<Transaction>>();
        for (SocialNetworks eachSocialNetwork : SocialNetworks.values()) {
            TreeSet transactionTree = new TreeSet();
            result.put(eachSocialNetwork.name(), transactionTree);
        }
        if (this.transactionSetForEachNetwork != null && !this.transactionSetForEachNetwork.isEmpty()) {
            for (String eachKey : this.transactionSetForEachNetwork.keySet()) {
                TreeSet<Transaction> transactionTreeFromGivenMap = this.transactionSetForEachNetwork.get(eachKey);
                if (transactionTreeFromGivenMap == null || transactionTreeFromGivenMap.isEmpty()) continue;
                result.get(eachKey).addAll(transactionTreeFromGivenMap);
            }
        }
        return result;
    }

    @JsonIgnore
    public Map<String, ContextBundle> getContextBundleForEachNetworkMap() {
        HashMap<String, ContextBundle> result = new HashMap<String, ContextBundle>();
        if (this.contextBundleForEachNetworkMap != null && !this.contextBundleForEachNetworkMap.isEmpty()) {
            for (String eachNetwork : this.contextBundleForEachNetworkMap.keySet()) {
                ContextBundle bundle = this.contextBundleForEachNetworkMap.get(eachNetwork);
                if (bundle == null) continue;
                result.put(eachNetwork, bundle);
            }
        }
        return result;
    }

    @JsonIgnore
    public Map<String, FriendBundle> getFriendsBundleForEachNetworkMap() {
        HashMap<String, FriendBundle> result = new HashMap<String, FriendBundle>();
        if (this.friendsBundleForEachNetworkMap != null && !this.friendsBundleForEachNetworkMap.isEmpty()) {
            for (String eachNetwork : this.friendsBundleForEachNetworkMap.keySet()) {
                FriendBundle bundle = this.friendsBundleForEachNetworkMap.get(eachNetwork);
                if (bundle == null) continue;
                result.put(eachNetwork, bundle);
            }
        }
        return result;
    }

    @JsonIgnore
    public String getCreationTime() {
        return this.creationTime;
    }

    @JsonIgnore
    public Set<ContextVO> getDnaContexts() {
        return new HashSet<ContextVO>(this.dnaContexts);
    }

    @JsonIgnore
    public Map<String, Set<String>> getAccountLinks() {
        HashMap<String, Set<String>> newAccountLinks = new HashMap<String, Set<String>>();
        if (this.accountLinks != null && !this.accountLinks.isEmpty()) {
            for (String eachKey : this.accountLinks.keySet()) {
                Set<String> eachValues = this.accountLinks.get(eachKey);
                if (eachValues == null || eachValues.isEmpty()) continue;
                HashSet<String> values = new HashSet<String>();
                values.addAll(eachValues);
                newAccountLinks.put(eachKey, values);
            }
        }
        return newAccountLinks;
    }

    @JsonIgnore
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Level3DNAAccountEntity that = (Level3DNAAccountEntity)o;
        return this.level3DNAAccountId.equals(that.level3DNAAccountId);
    }

    @JsonIgnore
    public int hashCode() {
        return this.level3DNAAccountId.hashCode();
    }

    @JsonIgnore
    public Future<Level3DNAAccountEntity> removeSocialNetwork(final Level2Account level2Account, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level3DNAAccountEntity.removeSocialNetwork");
        final Level3DNAAccountEntity oldOneLevel3Entity = this;
        Map<String, ContextBundle> newContextBundleMap = this.getContextBundleForEachNetworkMap();
        Map<String, TreeSet<Transaction>> newTransactionHistorySet = this.getTransactionSetForEachNetwork();
        if (newContextBundleMap.get(level2Account.getSocialNetworkName()) != null) {
            TreeSet<Transaction> transactionTreeSet = newTransactionHistorySet.get(level2Account.getSocialNetworkName());
            if (transactionTreeSet == null) {
                transactionTreeSet = new TreeSet();
            }
            transactionTreeSet.add(new Transaction(level2Account.getSocialNetworkName(), level2Account.getLevel2AcountId(), "remove"));
            newTransactionHistorySet.put(level2Account.getSocialNetworkName(), transactionTreeSet);
            newContextBundleMap.remove(level2Account.getSocialNetworkName());
        }
        Map<String, FriendBundle> newFriendBundle = this.getFriendsBundleForEachNetworkMap();
        newFriendBundle.remove(level2Account.getSocialNetworkName());
        Map<String, Set<String>> newAccountLinks = this.getAccountLinks();
        Set<String> idsByTag = newAccountLinks.get(Tags.LEVEL_2_ACCOUNTS.name());
        if (idsByTag != null) {
            idsByTag.remove(level2Account.getLevel2AcountId());
        }
        newAccountLinks.put(Tags.LEVEL_2_ACCOUNTS.name(), idsByTag);
        final Level3DNAAccountEntity result = new Level3DNAAccountEntity(this.level3DNAAccountId, this.socialNetworkName, this.name, this.gender, this.locale, this.email, this.pictureUrl, this.active, newTransactionHistorySet, newContextBundleMap, newFriendBundle, this.creationTime, newAccountLinks);
        Future resultFuture = RiakCommon.storeEntity(result, token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Void parameter) {
                return Futures.successful((Object)result);
            }
        }, Riak.getExecutionContext());
        Future afterEventsCalculatorfuture = resultFuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Level3DNAAccountEntity newOne) {
                return EventQueueBuilder.compare(oldOneLevel3Entity, newOne, token);
            }
        }, Riak.getExecutionContext());
        return afterEventsCalculatorfuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity attachToThisLevel3Account) {
                return level2Account.detachFromLevel3DNAAccount(token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Void parameter) {
                        return Futures.successful((Object)attachToThisLevel3Account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    @JsonIgnore
    public Future<Level3DNAAccountEntity> updateWithSocialNetwork(UserState userState, final Level2Account level2Account, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level3DNAAccountEntity.updateWithSocialNetwork");
        final Level3DNAAccountEntity oldOneLevel3Entity = this;
        final Map<String, ContextBundle> newContextBundleMap = this.getContextBundleForEachNetworkMap();
        if (newContextBundleMap.get(level2Account.getSocialNetworkName()) != null && !newContextBundleMap.get(level2Account.getSocialNetworkName()).getLevel2AccountId().equals(level2Account.getLevel2AcountId())) {
            throw new NetworkRegisterException(level2Account.getSocialNetworkName() + " already registered", token.getAccountId());
        }
        final Map<String, TreeSet<Transaction>> newTransactionHistorySet = this.getTransactionSetForEachNetwork();
        if (newContextBundleMap.get(level2Account.getSocialNetworkName()) == null) {
            TreeSet<Transaction> transactionTreeSet = newTransactionHistorySet.get(level2Account.getSocialNetworkName());
            if (transactionTreeSet == null) {
                transactionTreeSet = new TreeSet();
            }
            transactionTreeSet.add(new Transaction(level2Account.getSocialNetworkName(), level2Account.getLevel2AcountId(), "add"));
            newTransactionHistorySet.put(level2Account.getSocialNetworkName(), transactionTreeSet);
        }
        ContextBundle bundle = new ContextBundle(level2Account.getLevel2AcountId(), userState.getContexts());
        newContextBundleMap.put(level2Account.getSocialNetworkName(), bundle);
        final Map<String, Set<String>> newAccountLinks = this.getAccountLinks();
        Set<String> idsByTag = newAccountLinks.get(Tags.LEVEL_2_ACCOUNTS.name());
        if (idsByTag == null) {
            idsByTag = new HashSet<String>();
        }
        idsByTag.add(level2Account.getLevel2AcountId());
        newAccountLinks.put(Tags.LEVEL_2_ACCOUNTS.name(), idsByTag);
        final Map<String, FriendBundle> newFriendBundleMap = this.getFriendsBundleForEachNetworkMap();
        Future<FriendBundle> friendBundle = FriendsHelper.divideFriends(level2Account.getLevel2AcountId(), userState, token);
        Future resultFuture = friendBundle.flatMap((Function1)new Mapper<FriendBundle, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(FriendBundle calculatedBundle) {
                newFriendBundleMap.put(SocialNetworks.valueOf(level2Account.getSocialNetworkName()).name(), calculatedBundle);
                final Level3DNAAccountEntity result = new Level3DNAAccountEntity(Level3DNAAccountEntity.this.level3DNAAccountId, Level3DNAAccountEntity.this.socialNetworkName, Level3DNAAccountEntity.this.name, Level3DNAAccountEntity.this.gender, Level3DNAAccountEntity.this.locale, Level3DNAAccountEntity.this.email, Level3DNAAccountEntity.this.pictureUrl, Level3DNAAccountEntity.this.active, newTransactionHistorySet, newContextBundleMap, newFriendBundleMap, Level3DNAAccountEntity.this.creationTime, newAccountLinks);
                return RiakCommon.storeEntity(result, token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Void parameter) {
                        return Futures.successful((Object)result);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
        Future afterEventsCalculatorfuture = resultFuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Level3DNAAccountEntity newOne) {
                return EventQueueBuilder.compare(oldOneLevel3Entity, newOne, token);
            }
        }, Riak.getExecutionContext());
        return afterEventsCalculatorfuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity attachToThisLevel3Account) {
                Future<Void> attachToLevel2AccountFuture = level2Account.attachLevel3DNAAccount(attachToThisLevel3Account.getLevel3DNAAccountId(), token);
                return attachToLevel2AccountFuture.flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Void parameter) {
                        return Futures.successful((Object)attachToThisLevel3Account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    @JsonIgnore
    public Future<Level3DNAAccountEntity> inviteFriend(String socialNetworkFriendId, SocialNetworks socialNetwork, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level3DNAAccountEntity.inviteFriend");
        Map<String, FriendBundle> newBundleForEachNetworkMap = this.getFriendsBundleForEachNetworkMap();
        if (newBundleForEachNetworkMap.get(socialNetwork.name()) == null) {
            throw new ServiceException("There is no " + socialNetwork.name(), token.getAccountId());
        }
        FriendBundle currentBundle = newBundleForEachNetworkMap.get(socialNetwork.name());
        Set<String> currentInvitedSet = currentBundle.getInvitedFriends();
        currentInvitedSet.add(socialNetworkFriendId);
        Map<String, Long> timeWhenUserWasInvitedMap = currentBundle.getTimeWhenUserWasInvitedMap();
        timeWhenUserWasInvitedMap.put(socialNetworkFriendId, System.currentTimeMillis());
        FriendBundle newFriendsBundle = new FriendBundle(currentBundle.getLevel2AccountId(), currentBundle.getFriends(), currentBundle.getSocialDNAfriends(), currentInvitedSet, timeWhenUserWasInvitedMap);
        newBundleForEachNetworkMap.put(socialNetwork.name(), newFriendsBundle);
        final Level3DNAAccountEntity result = new Level3DNAAccountEntity(this.level3DNAAccountId, this.socialNetworkName, this.name, this.gender, this.locale, this.email, this.pictureUrl, this.active, this.transactionSetForEachNetwork, this.contextBundleForEachNetworkMap, newBundleForEachNetworkMap, this.creationTime, this.accountLinks);
        Future resultFuture = RiakCommon.storeEntity(result, token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Void parameter) {
                return Futures.successful((Object)result);
            }
        }, Riak.getExecutionContext());
        return resultFuture.andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    @JsonIgnore
    public Future<Level3DNAAccountEntity> attachLevel1Account(final Level1AccountEntity level1AccountEntity, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level3DNAAccountEntity.attachLevel1Account");
        Map<String, Set<String>> newAccountLinks = this.getAccountLinks();
        Set<String> idsByTag = newAccountLinks.get(Tags.LEVEL_1_ACCOUNTS.name());
        if (idsByTag == null) {
            idsByTag = new HashSet<String>();
        }
        idsByTag.add(level1AccountEntity.getLevel1AccountId());
        newAccountLinks.put(Tags.LEVEL_1_ACCOUNTS.name(), idsByTag);
        final Level3DNAAccountEntity result = new Level3DNAAccountEntity(this.level3DNAAccountId, this.socialNetworkName, this.name, this.gender, this.locale, this.email, this.pictureUrl, this.active, this.transactionSetForEachNetwork, this.contextBundleForEachNetworkMap, this.friendsBundleForEachNetworkMap, this.creationTime, newAccountLinks);
        Future resultFuture = RiakCommon.storeEntity(result, token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Void parameter) {
                return Futures.successful((Object)result);
            }
        }, Riak.getExecutionContext());
        return resultFuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity finalLevel3account) {
                return level1AccountEntity.attachLevel3DNAAccount(result.getLevel3DNAAccountId(), token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Void parameter) {
                        return Futures.successful((Object)finalLevel3account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    @JsonIgnore
    public Future<Level3DNAAccountEntity> detachLevel1Account(final Level1AccountEntity level1AccountEntity, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level3DNAAccountEntity.detachLevel1Account");
        Map<String, Set<String>> newAccountLinks = this.getAccountLinks();
        Set<String> idsByTag = newAccountLinks.get(Tags.LEVEL_1_ACCOUNTS.name());
        if (idsByTag != null) {
            idsByTag.remove(level1AccountEntity.getLevel1AccountId());
        }
        newAccountLinks.put(Tags.LEVEL_1_ACCOUNTS.name(), idsByTag);
        final Level3DNAAccountEntity result = new Level3DNAAccountEntity(this.level3DNAAccountId, this.socialNetworkName, this.name, this.gender, this.locale, this.email, this.pictureUrl, this.active, this.transactionSetForEachNetwork, this.contextBundleForEachNetworkMap, this.friendsBundleForEachNetworkMap, this.creationTime, newAccountLinks);
        Future resultFuture = RiakCommon.storeEntity(result, token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Void parameter) {
                return Futures.successful((Object)result);
            }
        }, Riak.getExecutionContext());
        return resultFuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity finalLevel3account) {
                return level1AccountEntity.detachFromLevel3DNAAccount(token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Void parameter) {
                        return Futures.successful((Object)finalLevel3account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Level3DNAAccountEntity> create(UserState userState, final Level1AccountEntity level1Account, final Level2Account level2Account, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level3DNAAccountEntity.create");
        final String level3DNAAccountId = AccountIdGenerator.createRandomIdWithSocialNetworkPrefix(SocialNetworks.SocialDNA);
        final String socialNetworkName = SocialNetworks.SocialDNA.name();
        final String name = userState.getMe().getName();
        final String gender = userState.getMe().getGender();
        final String locale = userState.getMe().getLocale();
        final String email = userState.getMe().getEmail();
        final String pictureUrl = userState.getMe().getPictureUrl();
        boolean active = true;
        final HashMap transactionLog = new HashMap();
        TreeSet<Transaction> treeSet = new TreeSet<Transaction>();
        Transaction transaction = new Transaction(level2Account.getSocialNetworkName(), level2Account.getLevel2AcountId(), "add");
        treeSet.add(transaction);
        transactionLog.put(level2Account.getSocialNetworkName(), treeSet);
        final HashMap<String, ContextBundle> contextBundleMap = new HashMap<String, ContextBundle>();
        ContextBundle bundle = new ContextBundle(level2Account.getLevel2AcountId(), userState.getContexts());
        contextBundleMap.put(level2Account.getSocialNetworkName(), bundle);
        final HashMap newAccountLinks = new HashMap();
        HashSet<String> level_1_set = new HashSet<String>();
        HashSet<String> level_2_set = new HashSet<String>();
        level_1_set.add(level1Account.getLevel1AccountId());
        level_2_set.add(level2Account.getLevel2AcountId());
        newAccountLinks.put(Tags.LEVEL_1_ACCOUNTS.name(), level_1_set);
        newAccountLinks.put(Tags.LEVEL_2_ACCOUNTS.name(), level_2_set);
        Future<FriendBundle> friendBundle = FriendsHelper.divideFriends(level2Account.getLevel2AcountId(), userState, token);
        Future resultFuture = friendBundle.flatMap((Function1)new Mapper<FriendBundle, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(FriendBundle calculatedBundle) {
                HashMap<String, FriendBundle> map = new HashMap<String, FriendBundle>();
                map.put(SocialNetworks.valueOf(level2Account.getSocialNetworkName()).name(), calculatedBundle);
                final Level3DNAAccountEntity result = new Level3DNAAccountEntity(level3DNAAccountId, socialNetworkName, name, gender, locale, email, pictureUrl, true, transactionLog, contextBundleMap, map, LocalDate.now().toString(), newAccountLinks);
                return RiakCommon.storeEntity(result, token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Void parameter) {
                        return Futures.successful((Object)result);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
        Future afterEventsCalculatorfuture = resultFuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Level3DNAAccountEntity dnaAccountEntity) {
                return EventQueueBuilder.welcome(dnaAccountEntity, token);
            }
        }, Riak.getExecutionContext());
        return afterEventsCalculatorfuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity attachToThisLevel3Account) {
                Future<Void> attachToLevel1AccountFuture = level1Account.attachLevel3DNAAccount(attachToThisLevel3Account.getLevel3DNAAccountId(), token);
                Future<Void> attachToLevel2AccountFuture = level2Account.attachLevel3DNAAccount(attachToThisLevel3Account.getLevel3DNAAccountId(), token);
                return Futures.sequence((Iterable)Lists.newArrayList((Object[])new Future[]{attachToLevel1AccountFuture, attachToLevel2AccountFuture}), (ExecutionContext)Riak.getExecutionContext()).flatMap((Function1)new Mapper<Iterable<Void>, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Iterable<Void> parameter) {
                        return Futures.successful((Object)attachToThisLevel3Account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity dnaAccountEntity) throws Throwable {
                SqsManager.putDnaAccountIdIntoQueue((String)dnaAccountEntity.getLevel3DNAAccountId());
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Level3DNAAccountEntity> fetch(String level3DNAAccountId, Token token) {
        return RiakCommon.fetchEntityById(level3DNAAccountId, Level3DNAAccountEntity.class, token);
    }

    public static Level3DNAAccountEntity fetchSync(String level3DNAAccountId, Token token) {
        return RiakCommon.fetchEntityByIdSync(level3DNAAccountId, Level3DNAAccountEntity.class, token);
    }

    @Deprecated
    public static Future<Level3DNAAccountEntity> createFromJunitWithGivenIdAndWithoutSaving(String level3dnaId, UserState userState, Level1AccountEntity level1Account, final Level2Account level2Account, Token token) throws Exception {
        final String level3DNAAccountId = level3dnaId;
        final String socialNetworkName = SocialNetworks.SocialDNA.name();
        final String name = userState.getMe().getName();
        final String gender = userState.getMe().getGender();
        final String locale = userState.getMe().getLocale();
        final String email = userState.getMe().getEmail();
        final String pictureUrl = userState.getMe().getPictureUrl();
        boolean active = true;
        final HashMap transactionLog = new HashMap();
        TreeSet<Transaction> treeSet = new TreeSet<Transaction>();
        Transaction transaction = new Transaction(level2Account.getSocialNetworkName(), level2Account.getLevel2AcountId(), "add");
        treeSet.add(transaction);
        transactionLog.put(level2Account.getSocialNetworkName(), treeSet);
        final HashMap<String, ContextBundle> contextBundleMap = new HashMap<String, ContextBundle>();
        ContextBundle bundle = new ContextBundle(level2Account.getLevel2AcountId(), userState.getContexts());
        contextBundleMap.put(level2Account.getSocialNetworkName(), bundle);
        final HashMap newAccountLinks = new HashMap();
        HashSet<String> level_1_set = new HashSet<String>();
        HashSet<String> level_2_set = new HashSet<String>();
        level_1_set.add(level1Account.getLevel1AccountId());
        level_2_set.add(level2Account.getLevel2AcountId());
        newAccountLinks.put(Tags.LEVEL_1_ACCOUNTS.name(), level_1_set);
        newAccountLinks.put(Tags.LEVEL_2_ACCOUNTS.name(), level_2_set);
        Future<FriendBundle> friendBundle = FriendsHelper.divideFriends(level2Account.getLevel2AcountId(), userState, token);
        Future resultFuture = friendBundle.flatMap((Function1)new Mapper<FriendBundle, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(FriendBundle calculatedBundle) {
                HashMap<String, FriendBundle> map = new HashMap<String, FriendBundle>();
                map.put(SocialNetworks.valueOf(level2Account.getSocialNetworkName()).name(), calculatedBundle);
                Level3DNAAccountEntity result = new Level3DNAAccountEntity(level3DNAAccountId, socialNetworkName, name, gender, locale, email, pictureUrl, true, transactionLog, contextBundleMap, map, LocalDate.now().toString(), newAccountLinks);
                return Futures.successful((Object)result);
            }
        }, Riak.getExecutionContext());
        final Level3DNAAccountEntity result = (Level3DNAAccountEntity)Await.result((Awaitable)resultFuture, (Duration)Duration.Inf());
        Future<Void> attachToLevel1AccountFuture = level1Account.attachLevel3DNAAccount(result.getLevel3DNAAccountId(), token);
        Future<Void> attachToLevel2AccountFuture = level2Account.attachLevel3DNAAccount(result.getLevel3DNAAccountId(), token);
        return Futures.sequence((Iterable)Lists.newArrayList((Object[])new Future[]{attachToLevel1AccountFuture, attachToLevel2AccountFuture}), (ExecutionContext)Riak.getExecutionContext()).flatMap((Function1)new Mapper<Iterable<Void>, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Iterable<Void> parameter) {
                return Futures.successful((Object)result);
            }
        }, Riak.getExecutionContext());
    }

    public static Future<List<String>> grabAllKeysByDate(LocalDate localDate, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level3DNAAccountEntity.grabAllKeysByDate");
        return RiakCommon.binaryIndexSearch(Level3DNAAccountEntity.class, CREATION_TIME_INDEX_NAME, localDate.toString(), token).andThen((PartialFunction)new OnComplete<List<String>>(){

            public void onComplete(Throwable throwable, List<String> strings) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Iterable<List<String>>> grabAllKeysFromBeginningOfTime(Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level3DNAAccountEntity.grabAllKeysFromBeginningOfTime");
        LocalDate now = LocalDate.now();
        LocalDate tmpDate = Dates.BEGINNING_OF_TIME.asDate();
        ArrayList<Future<List<String>>> futureList = new ArrayList<Future<List<String>>>();
        while (tmpDate.isBefore((ReadablePartial)now) || tmpDate.isEqual((ReadablePartial)now)) {
            futureList.add(Level3DNAAccountEntity.grabAllKeysByDate(tmpDate, token));
            tmpDate = tmpDate.plusDays(1);
        }
        return Futures.sequence(futureList, (ExecutionContext)Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Iterable<List<String>>>(){

            public void onComplete(Throwable throwable, Iterable<List<String>> listIterable) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FriendBundle
    implements Comparable<FriendBundle> {
        @JsonProperty
        private final String level2AccountId;
        @JsonProperty
        private final long whenWasAddedTimestamp;
        @JsonProperty
        private final Set<UserProfileVO> friends;
        @JsonProperty
        private final Set<SocialDnaProfile> socialDNAfriends;
        @JsonProperty
        private final Set<String> invitedFriends;
        @JsonProperty
        private final Map<String, Long> timeWhenUserWasInvitedMap;

        @JsonCreator
        public FriendBundle(@JsonProperty(value="level2AccountId") String level2AccountId, @JsonProperty(value="friends") Set<UserProfileVO> friends, @JsonProperty(value="socialDNAfriends") Set<SocialDnaProfile> socialDNAfriends) {
            this.level2AccountId = level2AccountId;
            this.whenWasAddedTimestamp = DateTime.now().getMillis();
            this.friends = new HashSet<UserProfileVO>();
            if (friends != null && !friends.isEmpty()) {
                this.friends.addAll(friends);
            }
            this.socialDNAfriends = new HashSet<SocialDnaProfile>();
            if (socialDNAfriends != null && !socialDNAfriends.isEmpty()) {
                this.socialDNAfriends.addAll(socialDNAfriends);
            }
            this.invitedFriends = new HashSet<String>();
            this.timeWhenUserWasInvitedMap = new HashMap<String, Long>();
        }

        public FriendBundle(String level2AccountId, Set<UserProfileVO> friends, Set<SocialDnaProfile> socialDNAfriends, Set<String> invitedFriends, Map<String, Long> timeWhenUserWasInvitedMap) {
            this.level2AccountId = level2AccountId;
            this.whenWasAddedTimestamp = DateTime.now().getMillis();
            this.friends = new HashSet<UserProfileVO>();
            if (friends != null && !friends.isEmpty()) {
                this.friends.addAll(friends);
            }
            this.socialDNAfriends = new HashSet<SocialDnaProfile>();
            if (socialDNAfriends != null && !socialDNAfriends.isEmpty()) {
                this.socialDNAfriends.addAll(socialDNAfriends);
            }
            this.invitedFriends = new HashSet<String>();
            if (invitedFriends != null && !invitedFriends.isEmpty()) {
                this.invitedFriends.addAll(invitedFriends);
            }
            this.timeWhenUserWasInvitedMap = new HashMap<String, Long>();
            if (timeWhenUserWasInvitedMap != null && !timeWhenUserWasInvitedMap.isEmpty()) {
                this.timeWhenUserWasInvitedMap.putAll(timeWhenUserWasInvitedMap);
            }
        }

        @JsonIgnore
        public String getLevel2AccountId() {
            return this.level2AccountId;
        }

        @JsonIgnore
        public long getWhenWasAddedTimestamp() {
            return this.whenWasAddedTimestamp;
        }

        @JsonIgnore
        public Set<UserProfileVO> getFriends() {
            return new TreeSet<UserProfileVO>(this.friends);
        }

        @JsonIgnore
        public Set<SocialDnaProfile> getSocialDNAfriends() {
            return new TreeSet<SocialDnaProfile>(this.socialDNAfriends);
        }

        @JsonIgnore
        public Set<String> getInvitedFriends() {
            return new HashSet<String>(this.invitedFriends);
        }

        @JsonIgnore
        public Map<String, Long> getTimeWhenUserWasInvitedMap() {
            HashMap<String, Long> result = new HashMap<String, Long>();
            result.putAll(this.timeWhenUserWasInvitedMap);
            return result;
        }

        @Override
        @JsonIgnore
        public int compareTo(FriendBundle o) {
            if (this.whenWasAddedTimestamp == o.whenWasAddedTimestamp) {
                return 0;
            }
            if (this.whenWasAddedTimestamp > o.whenWasAddedTimestamp) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextBundle
    implements Comparable<ContextBundle> {
        @JsonProperty
        private final String level2AccountId;
        @JsonProperty
        private long whenWasAddedTimestamp;
        @JsonProperty
        private final Set<ContextVO> contexts;

        @JsonCreator
        public ContextBundle(@JsonProperty(value="level2AccountId") String level2AccountId, @JsonProperty(value="contexts") Set<ContextVO> contexts) {
            this.level2AccountId = level2AccountId;
            this.whenWasAddedTimestamp = DateTime.now().getMillis();
            this.contexts = new HashSet<ContextVO>();
            if (contexts != null && !contexts.isEmpty()) {
                this.contexts.addAll(contexts);
            }
        }

        @JsonIgnore
        public String getLevel2AccountId() {
            return this.level2AccountId;
        }

        @JsonIgnore
        public long getWhenWasAddedTimestamp() {
            return this.whenWasAddedTimestamp;
        }

        @JsonIgnore
        public Set<ContextVO> getContexts() {
            return new HashSet<ContextVO>(this.contexts);
        }

        @Override
        @JsonIgnore
        public int compareTo(ContextBundle o) {
            if (this.whenWasAddedTimestamp == o.whenWasAddedTimestamp) {
                return 0;
            }
            if (this.whenWasAddedTimestamp > o.whenWasAddedTimestamp) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SocialDnaProfile
    implements Comparable<SocialDnaProfile> {
        @JsonProperty
        private final String level3dnaAccountId;
        @JsonProperty
        private final String name;
        @JsonProperty
        private final String gender;
        @JsonProperty
        private final String locale;
        @JsonProperty
        private final String email;
        @JsonProperty
        private final String pictureUrl;
        @JsonProperty
        private final Map<String, ContextBundle> contextBundleForEachNetworkMap;
        @JsonProperty
        private final Set<ContextVO> dnaContexts;

        @JsonCreator
        public SocialDnaProfile(@JsonProperty(value="id") String level3dnaAccountId, @JsonProperty(value="name") String name, @JsonProperty(value="gender") String gender, @JsonProperty(value="locale") String locale, @JsonProperty(value="email") String email, @JsonProperty(value="pictureUrl") String pictureUrl, @JsonProperty(value="contextBundleForEachNetworkMap") Map<String, ContextBundle> contextBundleForEachNetworkMap) {
            this.level3dnaAccountId = level3dnaAccountId;
            this.name = name;
            this.gender = gender;
            this.locale = locale;
            this.email = email;
            this.pictureUrl = pictureUrl;
            this.contextBundleForEachNetworkMap = new HashMap<String, ContextBundle>();
            if (contextBundleForEachNetworkMap != null && !contextBundleForEachNetworkMap.isEmpty()) {
                for (String eachNetwork : contextBundleForEachNetworkMap.keySet()) {
                    ContextBundle bundle = contextBundleForEachNetworkMap.get(eachNetwork);
                    if (bundle == null) continue;
                    this.contextBundleForEachNetworkMap.put(eachNetwork, bundle);
                }
            }
            this.dnaContexts = DnaScoreCalculator.calculateDnaScores(this.contextBundleForEachNetworkMap);
        }

        @JsonIgnore
        public String getLevel3dnaAccountId() {
            return this.level3dnaAccountId;
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public String getGender() {
            return this.gender;
        }

        @JsonIgnore
        public String getLocale() {
            return this.locale;
        }

        @JsonIgnore
        public String getEmail() {
            return this.email;
        }

        @JsonIgnore
        public String getPictureUrl() {
            return this.pictureUrl;
        }

        @JsonIgnore
        public Map<String, ContextBundle> getContextBundleForEachNetworkMap() {
            return this.contextBundleForEachNetworkMap;
        }

        @JsonIgnore
        public Set<ContextVO> getDnaContexts() {
            return this.dnaContexts;
        }

        @JsonIgnore
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SocialDnaProfile that = (SocialDnaProfile)o;
            return this.level3dnaAccountId.equals(that.level3dnaAccountId);
        }

        @JsonIgnore
        public int hashCode() {
            return this.level3dnaAccountId.hashCode();
        }

        @JsonIgnore
        public String generateHash() {
            StringBuilder hashBuilder = new StringBuilder(this.name);
            hashBuilder.append(this.gender);
            hashBuilder.append(this.pictureUrl);
            return Integer.toString(hashBuilder.toString().hashCode());
        }

        @Override
        @JsonIgnore
        public int compareTo(SocialDnaProfile other) {
            return this.level3dnaAccountId.compareTo(other.level3dnaAccountId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Transaction
    implements Comparable<Transaction> {
        public static final String ACTION_ADD = "add";
        public static final String ACTION_REMOVE = "remove";
        @JsonProperty
        private final String id = UUID.randomUUID().toString();
        @JsonProperty
        private final long timestamp = System.nanoTime();
        @JsonProperty
        private final String socialNetworkName;
        @JsonProperty
        private final String level2accountId;
        @JsonProperty
        private final String action;

        @Deprecated
        @JsonCreator
        public Transaction(@JsonProperty(value="socialNetworkName") String socialNetworkName, @JsonProperty(value="level2accountId") String level2accountId, @JsonProperty(value="action") String action) {
            this.socialNetworkName = socialNetworkName;
            this.level2accountId = level2accountId;
            this.action = action;
        }

        @JsonIgnore
        public String getSocialNetworkName() {
            return this.socialNetworkName;
        }

        @JsonIgnore
        public String getLevel2accountId() {
            return this.level2accountId;
        }

        @JsonIgnore
        public String getAction() {
            return this.action;
        }

        @JsonIgnore
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        @JsonIgnore
        public int compareTo(Transaction o) {
            if (this.timestamp == o.timestamp) {
                return 0;
            }
            if (this.timestamp > o.timestamp) {
                return 1;
            }
            return -1;
        }

        @JsonIgnore
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Transaction that = (Transaction)o;
            return this.id.equals(that.id);
        }

        @JsonIgnore
        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

