/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import entities.common.FormulaArgumentsEntity;
import exceptions.ServiceException;
import identity.Token;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCache {
    private static final Logger logger = LoggerFactory.getLogger(DataCache.class);
    private static final String FRIENDS = "friends";
    private static final String SUBSCRIBERS = "subscribers";
    private static final String POSTS = "posts";
    private static final String OTHER_COMMENTS_ON_USER_POST = "otherCommentsOnUserPost";
    private static final String OTHER_LIKES_ON_USER_POST = "otherLikesOnUserPost";
    private static final String OTHER_LIKES_ON_USER_COMMENTS = "otherLikesOnUserComments";
    private static final LoadingCache<String, NormalDistribution> normalDitributionCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, NormalDistribution>(){

        public NormalDistribution load(String key) throws Exception {
            FormulaArgumentsEntity argumentsEntity = FormulaArgumentsEntity.fetchSync(Token.backGroundAccessToke());
            if (argumentsEntity == null) {
                argumentsEntity = FormulaArgumentsEntity.defaultValue();
                logger.debug("Could not fetch FormulaArgumentsEntity from DB : use default : " + argumentsEntity);
            } else {
                logger.debug("FormulaArgumentsEntity was fetched : " + argumentsEntity);
            }
            NormalDistribution normalDistribution = null;
            if (key.equals(DataCache.FRIENDS)) {
                normalDistribution = new NormalDistribution(argumentsEntity.getFriendsMean(), argumentsEntity.getFriendsStandartDeviation());
                logger.debug("Construct NormalDistribution for friends");
            } else if (key.equals(DataCache.SUBSCRIBERS)) {
                normalDistribution = new NormalDistribution(argumentsEntity.getSubscribersMean(), argumentsEntity.getSubscribersStandartDeviation());
                logger.debug("Construct NormalDistribution for subscribers");
            } else if (key.equals(DataCache.POSTS)) {
                normalDistribution = new NormalDistribution(argumentsEntity.getPostsMean(), argumentsEntity.getPostsStandartDeviation());
                logger.debug("Construct NormalDistribution for posts");
            } else if (key.equals(DataCache.OTHER_COMMENTS_ON_USER_POST)) {
                normalDistribution = new NormalDistribution(argumentsEntity.getOtherCommentsOnUserPostMean(), argumentsEntity.getOtherCommentsOnUserPostStandartDeviation());
                logger.debug("Construct NormalDistribution for otherCommentsOnUserPost");
            } else if (key.equals(DataCache.OTHER_LIKES_ON_USER_POST)) {
                normalDistribution = new NormalDistribution(argumentsEntity.getOtherLikesOnUserPostMean(), argumentsEntity.getOtherLikesOnUserPostStandartDeviation());
                logger.debug("Construct NormalDistribution for otherLikesOnUserPost");
            } else if (key.equals(DataCache.OTHER_LIKES_ON_USER_COMMENTS)) {
                normalDistribution = new NormalDistribution(argumentsEntity.getOtherLikesOnUserCommentsMean(), argumentsEntity.getOtherLikesOnUserCommentsStandartDeviation());
                logger.debug("Construct NormalDistribution for otherLikesOnUserComments");
            }
            return normalDistribution;
        }
    });

    public static NormalDistribution getFriendsNormalDistribution(Token token) {
        try {
            return (NormalDistribution)normalDitributionCache.get((Object)FRIENDS);
        }
        catch (ExecutionException e) {
            throw new ServiceException("Error while loading friends NormalDistribution from cache", (Throwable)e, token.getAccountId());
        }
    }

    public static NormalDistribution getSubscribersNormalDistribution(Token token) {
        try {
            return (NormalDistribution)normalDitributionCache.get((Object)SUBSCRIBERS);
        }
        catch (ExecutionException e) {
            throw new ServiceException("Error while loading subscribers NormalDistribution from cache", (Throwable)e, token.getAccountId());
        }
    }

    public static NormalDistribution getPostsNormalDistribution(Token token) {
        try {
            return (NormalDistribution)normalDitributionCache.get((Object)POSTS);
        }
        catch (ExecutionException e) {
            throw new ServiceException("Error while loading posts NormalDistribution from cache", (Throwable)e, token.getAccountId());
        }
    }

    public static NormalDistribution getOtherCommentsOnUserPostNormalDistribution(Token token) {
        try {
            return (NormalDistribution)normalDitributionCache.get((Object)OTHER_COMMENTS_ON_USER_POST);
        }
        catch (ExecutionException e) {
            throw new ServiceException("Error while loading otherCommentsOnUserPost NormalDistribution from cache", (Throwable)e, token.getAccountId());
        }
    }

    public static NormalDistribution getOtherLikesOnUserPostNormalDistribution(Token token) {
        try {
            return (NormalDistribution)normalDitributionCache.get((Object)OTHER_LIKES_ON_USER_POST);
        }
        catch (ExecutionException e) {
            throw new ServiceException("Error while loading otherLikesOnUserPost NormalDistribution from cache", (Throwable)e, token.getAccountId());
        }
    }

    public static NormalDistribution getOtherLikesOnUserCommentsNormalDistribution(Token token) {
        try {
            return (NormalDistribution)normalDitributionCache.get((Object)OTHER_LIKES_ON_USER_COMMENTS);
        }
        catch (ExecutionException e) {
            throw new ServiceException("Error while loading otherLikesOnUserComments NormalDistribution from cache", (Throwable)e, token.getAccountId());
        }
    }
}

