/*
 * Decompiled with CFR 0.152.
 */
package riak;

import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import com.basho.riak.client.IRiakClient;
import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakLink;
import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.cap.ConflictResolver;
import com.basho.riak.client.convert.JSONConverter;
import com.basho.riak.client.query.WalkResult;
import com.basho.riak.client.query.indexes.BinIndex;
import com.basho.riak.client.query.indexes.RiakIndex;
import constants.SocialNetworks;
import entities.common.Level1AccountEntity;
import entities.common.Level2AccountEntity;
import exceptions.EntityNotFoundException;
import exceptions.ServiceException;
import identity.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import riak.Riak;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakCommon {
    public static <T> Future<Void> deleteEntity(final T entity, final Token token) {
        return Futures.future((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RiakCommon.deleteEntitySync(entity, token);
                return null;
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }

    public static <T> void deleteEntitySync(T entity, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.deleteEntitySync : " + entity.getClass().getName()));
        try {
            if (entity == null || token == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            String finalBucketName = Riak.getFinalBucketName(entity.getClass());
            IRiakClient pbRiakClient = Riak.pbcClient();
            Bucket bucket = pbRiakClient.fetchBucket(finalBucketName).lazyLoadBucketProperties().execute();
            bucket.delete(entity).execute();
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during storing " + entity.getClass().getName(), throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static <T> Future<T> fetchEntityById(final String id, final Class<T> clazz, final Token token) {
        return Futures.future((Callable)new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RiakCommon.fetchEntityByIdSync(id, clazz, token);
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }

    public static <T> T fetchEntityByIdSync(String id, Class<T> clazz, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.fetchEntityByIdSync : " + clazz.getName()));
        try {
            Object result;
            if (id == null || id.isEmpty() || clazz == null || token == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            String finalBucketName = Riak.getFinalBucketName(clazz);
            IRiakClient pbRiakClient = Riak.pbcClient();
            Bucket bucket = pbRiakClient.fetchBucket(finalBucketName).lazyLoadBucketProperties().execute();
            ConflictResolver<T> conflictResolver = Riak.getConflictResolver(clazz);
            if (conflictResolver == null) {
                Object result2;
                Object object = result2 = bucket.fetch(id, clazz).execute();
                return (T)object;
            }
            Object object = result = bucket.fetch(id, clazz).withResolver(conflictResolver).execute();
            return (T)object;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during fetching " + clazz.getName(), throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static <T> Future<Void> storeEntity(final T entity, final Token token) {
        return Futures.future((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RiakCommon.storeEntitySync(entity, token);
                return null;
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }

    public static <T> void storeEntitySync(T entity, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.storeEntitySync : " + entity.getClass().getName()));
        try {
            if (entity == null || token == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            String finalBucketName = Riak.getFinalBucketName(entity.getClass());
            IRiakClient pbRiakClient = Riak.pbcClient();
            Bucket bucket = pbRiakClient.fetchBucket(finalBucketName).lazyLoadBucketProperties().execute();
            ConflictResolver<?> conflictResolver = Riak.getConflictResolver(entity.getClass());
            if (conflictResolver == null) {
                bucket.store(entity).returnBody(false).execute();
            } else {
                bucket.store(entity).returnBody(true).withResolver(conflictResolver).execute();
            }
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during storing " + entity.getClass().getName(), throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static Future<Map<String, Object>> linkWalk(final String fromEntityId, final Class fromClazz, final Class targetClazz, final String tag, final Token token) {
        return Futures.future((Callable)new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                return RiakCommon.linkWalkSync(fromEntityId, fromClazz, targetClazz, tag, token);
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }

    public static Map<String, Object> linkWalkSync(String fromEntityId, Class fromClazz, Class targetClazz, String tag, Token token) {
        String targetClassName = targetClazz != null ? targetClazz.getName() : "null";
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.linkWalkSync fromClazz : " + fromClazz.getName() + ": targetClazz : " + targetClassName + " tag : " + tag));
        String finalFromBucketName = null;
        String finalTargetBucketName = null;
        String finalTag = null;
        try {
            if (fromEntityId == null || fromEntityId.isEmpty() || fromClazz == null || token == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            finalFromBucketName = Riak.getFinalBucketName(fromClazz);
            finalTargetBucketName = targetClazz != null ? Riak.getFinalBucketName(targetClazz) : "_";
            finalTag = tag != null ? tag : "_";
            IRiakClient httpClient = Riak.httpClient();
            Bucket bucket = httpClient.fetchBucket(finalFromBucketName).lazyLoadBucketProperties().execute();
            ConflictResolver conflictResolver = Riak.getConflictResolver(fromClazz);
            IRiakObject fromRiakObject = null;
            Object obj = bucket.fetch(fromEntityId, fromClazz).withResolver(conflictResolver).execute();
            bucket.store(fromEntityId, obj).withResolver(conflictResolver).execute();
            fromRiakObject = (IRiakObject)bucket.fetch(fromEntityId).execute();
            WalkResult walkResult = httpClient.walk(fromRiakObject).addStep(finalTargetBucketName, finalTag).execute();
            HashMap<String, Object> linkWalkResultContainer = new HashMap<String, Object>();
            for (Collection eachCollection : walkResult) {
                for (IRiakObject eachObject : eachCollection) {
                    List<Level2AccountEntity> level2FacebookAccountEntityList;
                    Level2AccountEntity level2FacebookAccountEntity;
                    JSONConverter jsonConverter;
                    String key = eachObject.getKey();
                    if (key.startsWith(SocialNetworks.Facebook.name())) {
                        jsonConverter = new JSONConverter(Level2AccountEntity.class, Riak.getFinalBucketName(Level2AccountEntity.class));
                        level2FacebookAccountEntity = (Level2AccountEntity)jsonConverter.toDomain(eachObject);
                        level2FacebookAccountEntityList = null;
                        level2FacebookAccountEntityList = linkWalkResultContainer.get(SocialNetworks.Facebook.name()) != null ? (List)linkWalkResultContainer.get(SocialNetworks.Facebook.name()) : new ArrayList<Level2AccountEntity>();
                        level2FacebookAccountEntityList.add(level2FacebookAccountEntity);
                        linkWalkResultContainer.put(SocialNetworks.Facebook.name(), level2FacebookAccountEntityList);
                        continue;
                    }
                    if (key.startsWith(SocialNetworks.Vkontakte.name())) {
                        jsonConverter = new JSONConverter(Level2AccountEntity.class, Riak.getFinalBucketName(Level2AccountEntity.class));
                        level2FacebookAccountEntity = (Level2AccountEntity)jsonConverter.toDomain(eachObject);
                        level2FacebookAccountEntityList = null;
                        level2FacebookAccountEntityList = linkWalkResultContainer.get(SocialNetworks.Vkontakte.name()) != null ? (List)linkWalkResultContainer.get(SocialNetworks.Vkontakte.name()) : new ArrayList();
                        level2FacebookAccountEntityList.add(level2FacebookAccountEntity);
                        linkWalkResultContainer.put(SocialNetworks.Vkontakte.name(), level2FacebookAccountEntityList);
                        continue;
                    }
                    if (!key.startsWith("BA")) continue;
                    jsonConverter = new JSONConverter(Level1AccountEntity.class, Riak.getFinalBucketName(Level1AccountEntity.class));
                    Level1AccountEntity level1account = (Level1AccountEntity)jsonConverter.toDomain(eachObject);
                    List level1AccountEntityList = null;
                    level1AccountEntityList = linkWalkResultContainer.get("BA") != null ? (List)linkWalkResultContainer.get("BA") : new ArrayList();
                    level1AccountEntityList.add(level1account);
                    linkWalkResultContainer.put("BA", level1AccountEntityList);
                }
            }
            HashMap<String, Object> hashMap = linkWalkResultContainer;
            return hashMap;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during link walking from : " + finalFromBucketName + " to : " + finalTargetBucketName, throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static Future<Void> addLinkTo(final String fromId, final Class fromClazz, final Class toAccountClazz, final String targetAccountId, final String tag, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.addLinkTo toAccountClazz : " + toAccountClazz.getName() + " tag : " + tag));
        return Futures.future((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (fromId == null || fromId.isEmpty() || fromClazz == null || toAccountClazz == null || targetAccountId == null || targetAccountId.isEmpty() || tag == null || tag.isEmpty() || token == null) {
                    throw new IllegalArgumentException("Argument null or empty string");
                }
                String finalFromBucketName = Riak.getFinalBucketName(fromClazz);
                String finalToBucketName = Riak.getFinalBucketName(toAccountClazz);
                IRiakClient httpClient = Riak.httpClient();
                try {
                    Bucket bucket = httpClient.fetchBucket(finalFromBucketName).execute();
                    ConflictResolver conflictResolver = Riak.getConflictResolver(fromClazz);
                    IRiakObject fromObject = null;
                    Object obj = bucket.fetch(fromId, fromClazz).withResolver(conflictResolver).execute();
                    bucket.store(fromId, obj).withResolver(conflictResolver).execute();
                    fromObject = (IRiakObject)bucket.fetch(fromId).execute();
                    if (fromObject == null) {
                        throw new EntityNotFoundException("Error during make a link from : " + finalFromBucketName + " to : " + finalToBucketName, token.getAccountId());
                    }
                    fromObject.addLink(new RiakLink(finalToBucketName, targetAccountId, tag));
                    bucket.store((Object)fromObject).returnBody(false).execute();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new ServiceException("Error during linking Level2FacebookAccountEntity", throwable, token.getAccountId());
                }
            }
        }, (ExecutionContext)Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Void>(){

            public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static List<String> binaryIndexSearchSync(Class clazz, String indexName, String indexValue, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)("DB: RiakCommon.binaryIndexSearchSync : " + clazz.getName()));
        try {
            List result;
            if (indexName == null || indexName.isEmpty() || clazz == null || token == null || indexValue == null) {
                throw new IllegalArgumentException("Argument null or empty string");
            }
            String finalBucketName = Riak.getFinalBucketName(clazz);
            IRiakClient pbRiakClient = Riak.pbcClient();
            Bucket bucket = pbRiakClient.fetchBucket(finalBucketName).lazyLoadBucketProperties().execute();
            List list = result = bucket.fetchIndex((RiakIndex)BinIndex.named((String)indexName)).withValue((Object)indexValue).execute();
            return list;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Error during search by binary index " + clazz.getName(), throwable, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
    }

    public static Future<List<String>> binaryIndexSearch(final Class clazz, final String indexName, final String indexValue, final Token token) {
        return Futures.future((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return RiakCommon.binaryIndexSearchSync(clazz, indexName, indexValue, token);
            }
        }, (ExecutionContext)Riak.getExecutionContext());
    }
}

