/*
 * Decompiled with CFR 0.152.
 */
package entities.vk;

import com.basho.riak.client.convert.RiakKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import entities.common.ContextVO;
import entities.common.PostVO;
import entities.common.UserProfileVO;
import entities.interfaces.UserState;
import java.util.HashSet;
import java.util.Set;
import riak.RiakEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RiakEntity(bucketName="vk.user.state", lastWriteWins=true)
public class VkUserStateEntity
implements UserState {
    @JsonProperty
    @RiakKey
    private final String userStateId;
    @JsonProperty
    private final String socialNetworkUserId;
    @JsonProperty
    private final String socialNetworkName;
    @JsonProperty
    private final UserProfileVO me;
    @JsonProperty
    private final Set<UserProfileVO> friends;
    @JsonProperty
    private final Set<UserProfileVO> subscribers;
    @JsonProperty
    private final Set<PostVO> posts;
    @JsonProperty
    private final Set<String> allLikedObjectId;
    @JsonProperty
    private final Set<ContextVO> contexts;

    @Deprecated
    @JsonCreator
    public VkUserStateEntity(@JsonProperty(value="userStateId") String userStateId, @JsonProperty(value="socialNetworkUserId") String socialNetworkUserId, @JsonProperty(value="socialNetworkName") String socialNetworkName, @JsonProperty(value="me") UserProfileVO me, @JsonProperty(value="friends") Set<UserProfileVO> friends, @JsonProperty(value="subscribers") Set<UserProfileVO> subscribers, @JsonProperty(value="posts") Set<PostVO> posts, @JsonProperty(value="allLikedObjectId") Set<String> allLikedObjectId, @JsonProperty(value="contexts") Set<ContextVO> contexts) {
        this.userStateId = userStateId;
        this.socialNetworkUserId = socialNetworkUserId;
        this.socialNetworkName = socialNetworkName;
        this.me = me;
        this.friends = new HashSet<UserProfileVO>();
        if (friends != null && !friends.isEmpty()) {
            this.friends.addAll(friends);
        }
        this.subscribers = new HashSet<UserProfileVO>();
        if (subscribers != null && !subscribers.isEmpty()) {
            this.subscribers.addAll(subscribers);
        }
        this.posts = new HashSet<PostVO>();
        if (posts != null && !posts.isEmpty()) {
            this.posts.addAll(posts);
        }
        this.allLikedObjectId = new HashSet<String>();
        if (allLikedObjectId != null && !allLikedObjectId.isEmpty()) {
            this.allLikedObjectId.addAll(allLikedObjectId);
        }
        this.contexts = new HashSet<ContextVO>();
        if (contexts != null && !contexts.isEmpty()) {
            this.contexts.addAll(contexts);
        }
    }

    @Override
    public String getUserStateId() {
        return this.userStateId;
    }

    @Override
    public String getSocialNetworkUserId() {
        return this.socialNetworkUserId;
    }

    @Override
    public String getSocialNetworkName() {
        return this.socialNetworkName;
    }

    @Override
    public Set<String> getAllLikedObjectId() {
        HashSet<String> result = new HashSet<String>();
        if (this.allLikedObjectId != null && !this.allLikedObjectId.isEmpty()) {
            result.addAll(this.allLikedObjectId);
        }
        return result;
    }

    @Override
    public UserProfileVO getMe() {
        return this.me;
    }

    public Set<UserProfileVO> getFriends() {
        HashSet<UserProfileVO> result = new HashSet<UserProfileVO>();
        if (this.friends != null && !this.friends.isEmpty()) {
            result.addAll(this.friends);
        }
        return result;
    }

    public Set<UserProfileVO> getSubscribers() {
        HashSet<UserProfileVO> result = new HashSet<UserProfileVO>();
        if (this.subscribers != null && !this.subscribers.isEmpty()) {
            result.addAll(this.subscribers);
        }
        return result;
    }

    public Set<PostVO> getPosts() {
        HashSet<PostVO> result = new HashSet<PostVO>();
        if (this.posts != null && !this.posts.isEmpty()) {
            result.addAll(this.posts);
        }
        return result;
    }

    @Override
    public Set<ContextVO> getContexts() {
        HashSet<ContextVO> result = new HashSet<ContextVO>();
        if (this.contexts != null && !this.contexts.isEmpty()) {
            result.addAll(this.contexts);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VkUserStateEntity that = (VkUserStateEntity)o;
        return this.userStateId.equals(that.userStateId);
    }

    public int hashCode() {
        return this.userStateId.hashCode();
    }

    @Override
    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VkUserStateEntity that = (VkUserStateEntity)o;
        if (!this.allLikedObjectId.equals(that.allLikedObjectId)) {
            return false;
        }
        if (!this.friends.equals(that.friends)) {
            return false;
        }
        if (!this.me.equals(that.me)) {
            return false;
        }
        if (!this.posts.equals(that.posts)) {
            return false;
        }
        if (!this.socialNetworkUserId.equals(that.socialNetworkUserId)) {
            return false;
        }
        if (!this.socialNetworkName.equals(that.socialNetworkName)) {
            return false;
        }
        if (!this.subscribers.equals(that.subscribers)) {
            return false;
        }
        return this.userStateId.equals(that.userStateId);
    }
}

