/*
 * Decompiled with CFR 0.152.
 */
package constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EventCollection {
    WELCOME("Welcome", "Your score is %s", "\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c", "\u0412\u0430\u0448\u0430 \u0432\u043b\u0438\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c %s", "https://s3-eu-west-1.amazonaws.com/social-dna-events/Welcome-01.png", "https://s3-eu-west-1.amazonaws.com/social-dna-events/Welcome_x2-01.png"),
    INCREASE_OWN_SCORE("Your Influence score has increased", "+ %s", "\u0412\u0430\u0448\u0430 \u0432\u043b\u0438\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u043b\u0430\u0441\u044c", "+ %s", "https://s3-eu-west-1.amazonaws.com/social-dna-events/PointsUp-01.png", "https://s3-eu-west-1.amazonaws.com/social-dna-events/PointsUp_x2-01.png"),
    DECREASE_OWN_SCORE("Your Influence score has decreased", "- %s", "\u0412\u0430\u0448\u0430 \u0432\u043b\u0438\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u043c\u0435\u043d\u044c\u0448\u0438\u043b\u0430\u0441\u044c", "- %s", "https://s3-eu-west-1.amazonaws.com/social-dna-events/PointsDown-01.png", "https://s3-eu-west-1.amazonaws.com/social-dna-events/PointsDown_x2-01.png"),
    CONNECT_SOCIAL_NETWORK("You have added a social network", "+ %s", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0435\u0442\u044c", "+ %s", "https://s3-eu-west-1.amazonaws.com/social-dna-events/AddNetwork-01.png", "https://s3-eu-west-1.amazonaws.com/social-dna-events/AddNetwork_x2-01.png"),
    DISCONNECT_SOCIAL_NETWORK("You have disconnected a social network", "- %s", "\u0421\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0435\u0442\u044c \u0431\u044b\u043b\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430", "- %s", "https://s3-eu-west-1.amazonaws.com/social-dna-events/NetworkDisconnect-01.png", "https://s3-eu-west-1.amazonaws.com/social-dna-events/NetworkDisconnect_x2-01.png"),
    NEW_RANK_PLUS("You have achieved a new rank", "%s", "\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043d\u043e\u0432\u043e\u0435 \u0437\u0432\u0430\u043d\u0438\u0435", "%s", "https://s3-eu-west-1.amazonaws.com/social-dna-events/RankUp-01.png", "https://s3-eu-west-1.amazonaws.com/social-dna-events/RankUp_x2-01.png"),
    NEW_RANK_MINUS("You have achieved a new rank", "%s", "\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043d\u043e\u0432\u043e\u0435 \u0437\u0432\u0430\u043d\u0438\u0435", "%s", "https://s3-eu-west-1.amazonaws.com/social-dna-events/RankDown-01.png", "https://s3-eu-west-1.amazonaws.com/social-dna-events/RankDown_x2-01.png"),
    FRIEND_HAS_JOINED("Your friend has joined", "%s", "\u0412\u0430\u0448 \u0434\u0440\u0443\u0433 \u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u0441\u044f \u043a \u0441\u0435\u0442\u0438", "%s", "https://s3-eu-west-1.amazonaws.com/social-dna-events/AddFriend-01.png", "https://s3-eu-west-1.amazonaws.com/social-dna-events/AddFriend_x2-01.png");

    private String title_en;
    private String description_en;
    private String title_ru;
    private String description_ru;
    private String pictureUrl;
    private String pictureRetinaUrl;

    private EventCollection(String title_en, String description_en, String title_ru, String description_ru, String pictureUrl, String pictureRetinaUrl) {
        this.title_en = title_en;
        this.description_en = description_en;
        this.title_ru = title_ru;
        this.description_ru = description_ru;
        this.pictureUrl = pictureUrl;
        this.pictureRetinaUrl = pictureRetinaUrl;
    }

    public String getTitle_en() {
        return this.title_en;
    }

    public String getDescription_en(double finalScore) {
        if (finalScore < 0.0) {
            return String.format(this.description_en, finalScore);
        }
        return String.format(this.description_en, finalScore);
    }

    public String getDescriptionWithoutScores_en(String rank) {
        return String.format(this.description_en, rank);
    }

    public String getTitle_ru() {
        return this.title_ru;
    }

    public String getDescription_ru(double finalScore) {
        if (finalScore < 0.0) {
            return String.format(this.description_ru, finalScore);
        }
        return String.format(this.description_ru, finalScore);
    }

    public String getDescriptionWithoutScores_ru(String rank) {
        return String.format(this.description_ru, rank);
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public String getPictureRetinaUrl() {
        return this.pictureRetinaUrl;
    }
}

