/*
 * Decompiled with CFR 0.152.
 */
package util;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import constants.Contexts;
import constants.EventCollection;
import entities.common.ContextVO;
import entities.common.EventQueueEntity;
import entities.common.EventVO;
import entities.common.Level3DNAAccountEntity;
import identity.Token;
import java.util.Set;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import riak.Riak;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventQueueBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EventQueueBuilder.class);

    public static Future<Level3DNAAccountEntity> welcome(final Level3DNAAccountEntity dnaAccountEntity, final Token token) {
        logger.info("welcome() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: EventQueueBuilder.welcome");
        Future constructEvent = Futures.future((Callable)new Callable<EventVO>(){

            @Override
            public EventVO call() throws Exception {
                ContextVO finalMainContext = EventQueueBuilder.findMainContext(dnaAccountEntity.getDnaContexts());
                EventCollection eventCollection = EventCollection.WELCOME;
                EventVO event = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescription_ru(finalMainContext.getScore()), eventCollection.getTitle_en(), eventCollection.getDescription_en(finalMainContext.getScore()), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                return event;
            }
        }, (ExecutionContext)Riak.getExecutionContext());
        return constructEvent.flatMap((Function1)new Mapper<EventVO, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(EventVO event) {
                return EventQueueEntity.addEvent(dnaAccountEntity.getLevel3DNAAccountId(), event, token).flatMap((Function1)new Mapper<EventQueueEntity, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(EventQueueEntity parameter) {
                        return Futures.successful((Object)dnaAccountEntity);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity dnaAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Level3DNAAccountEntity> compare(final Level3DNAAccountEntity old, final Level3DNAAccountEntity newOne, final Token token) {
        logger.info("compare() : start");
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: EventQueueBuilder.compare");
        Future finalScoreFuture = Futures.future((Callable)new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                Set<ContextVO> oldContexts = old.getDnaContexts();
                Set<ContextVO> newContexts = newOne.getDnaContexts();
                ContextVO oldMainContext = EventQueueBuilder.findMainContext(oldContexts);
                ContextVO newMainContext = EventQueueBuilder.findMainContext(newContexts);
                if (oldMainContext == null || newMainContext == null) {
                    return 0.0;
                }
                double resultScore = newMainContext.getScore() - oldMainContext.getScore();
                return resultScore;
            }
        }, (ExecutionContext)Riak.getExecutionContext());
        return finalScoreFuture.flatMap((Function1)new Mapper<Double, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(Double finalScore) {
                EventCollection eventCollection = null;
                if (finalScore >= 1.0) {
                    eventCollection = EventCollection.INCREASE_OWN_SCORE;
                } else if (finalScore <= -1.0) {
                    eventCollection = EventCollection.DECREASE_OWN_SCORE;
                }
                ContextVO finalMainContext = EventQueueBuilder.findMainContext(newOne.getDnaContexts());
                if (eventCollection != null && finalMainContext != null) {
                    EventVO event = new EventVO(eventCollection.getTitle_ru(), eventCollection.getDescription_ru(finalMainContext.getScore()), eventCollection.getTitle_en(), eventCollection.getDescription_en(finalMainContext.getScore()), eventCollection.getPictureUrl(), eventCollection.getPictureRetinaUrl());
                    return EventQueueEntity.addEvent(newOne.getLevel3DNAAccountId(), event, token).flatMap((Function1)new Mapper<EventQueueEntity, Future<Level3DNAAccountEntity>>(){

                        public Future<Level3DNAAccountEntity> apply(EventQueueEntity parameter) {
                            return Futures.successful((Object)newOne);
                        }
                    }, Riak.getExecutionContext());
                }
                return Futures.successful((Object)newOne);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    private static ContextVO findMainContext(Set<ContextVO> contexts) {
        for (ContextVO eachContext : contexts) {
            if (!eachContext.getContextName().equals(Contexts.MAIN.name())) continue;
            return eachContext;
        }
        return null;
    }
}

