/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import entities.interfaces.Comment;
import entities.interfaces.Post;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostVO
implements Post {
    @JsonProperty
    private final String postId;
    @JsonProperty
    private final String message;
    @JsonProperty
    private final int likes;
    @JsonProperty
    private final Set<Comment> comments;

    @Deprecated
    @JsonCreator
    public PostVO(@JsonProperty(value="postId") String postId, @JsonProperty(value="message") String message, @JsonProperty(value="likes") int likes, @JsonProperty(value="comments") Set<Comment> comments) {
        this.postId = postId;
        this.message = message;
        this.likes = likes;
        this.comments = new HashSet<Comment>();
        if (comments != null && !comments.isEmpty()) {
            this.comments.addAll(comments);
        }
    }

    @Override
    public String getPostId() {
        return this.postId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getLikes() {
        return this.likes;
    }

    @Override
    public Set<Comment> getComments() {
        HashSet<Comment> result = new HashSet<Comment>();
        if (this.comments != null && !this.comments.isEmpty()) {
            result.addAll(this.comments);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostVO postVO = (PostVO)o;
        return this.postId.equals(postVO.postId);
    }

    public int hashCode() {
        return this.postId.hashCode();
    }

    @Override
    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostVO postVO = (PostVO)o;
        if (this.likes != postVO.likes) {
            return false;
        }
        if (this.message != null ? !this.message.equals(postVO.message) : postVO.message != null) {
            return false;
        }
        if (!this.postId.equals(postVO.postId)) {
            return false;
        }
        return this.comments.equals(postVO.comments);
    }
}

