/*
 * Decompiled with CFR 0.152.
 */
package calculator;

import constants.Contexts;
import entities.common.ContextVO;
import entities.common.Level3DNAAccountEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnaScoreCalculator {
    private static final Logger logger = LoggerFactory.getLogger(DnaScoreCalculator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ContextVO> calculateDnaScores(Map<String, Level3DNAAccountEntity.ContextBundle> contextBundleMap) {
        JMonitor monitor = JMonitorFactory.start((String)"DATA: DnaScoreCalculator.calculateDnaScores");
        try {
            boolean enablePenalty;
            if (contextBundleMap.isEmpty()) {
                HashSet<ContextVO> hashSet = new HashSet<ContextVO>();
                return hashSet;
            }
            double penalty = 1.0;
            boolean bl = enablePenalty = contextBundleMap.values().size() <= 1;
            if (enablePenalty) {
                penalty = 0.25;
            }
            logger.debug("penalty will be : " + penalty);
            HashMap<String, ContextVO> contextVOMap = new HashMap<String, ContextVO>();
            for (Level3DNAAccountEntity.ContextBundle eachContextBundle : contextBundleMap.values()) {
                Set<ContextVO> eachContextSet = eachContextBundle.getContexts();
                for (ContextVO eachContext : eachContextSet) {
                    ContextVO contextFromMap = (ContextVO)contextVOMap.get(eachContext.getContextName());
                    contextFromMap = contextFromMap == null ? new ContextVO(eachContext) : contextFromMap.plus(eachContext);
                    contextVOMap.put(contextFromMap.getContextName(), contextFromMap);
                }
            }
            ContextVO mainContext = (ContextVO)contextVOMap.get(Contexts.MAIN.name());
            mainContext = mainContext.applyPenalty(penalty);
            contextVOMap.put(Contexts.MAIN.name(), mainContext);
            HashSet<ContextVO> hashSet = new HashSet<ContextVO>(contextVOMap.values());
            return hashSet;
        }
        finally {
            monitor.stop();
        }
    }
}

