/*
 * Decompiled with CFR 0.152.
 */
package util;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import com.basho.riak.client.RiakLink;
import com.google.common.collect.Lists;
import constants.SocialNetworks;
import constants.Tags;
import entities.common.Level1AccountEntity;
import entities.common.Level2AccountEntity;
import entities.common.Level3DNAAccountEntity;
import entities.interfaces.Level2Account;
import exceptions.ServiceException;
import identity.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import riak.Riak;
import riak.RiakCommon;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import util.AccountIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNAAccountConflictResolver {
    public static Future<Level3DNAAccountEntity> mergeTwoConflictsAccounts(final Level3DNAAccountEntity firstLevel3Account, final Level3DNAAccountEntity secondLevel3Account, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: DNAAccountConflictResolver.mergeTwoConflictsAccounts");
        Future level3DNAAccountEntityFuture = Futures.future((Callable)new Callable<Level3DNAAccountEntity>(){

            @Override
            public Level3DNAAccountEntity call() throws Exception {
                return DNAAccountConflictResolver.resolve(Lists.newArrayList((Object[])new Level3DNAAccountEntity[]{firstLevel3Account, secondLevel3Account}), true);
            }
        }, (ExecutionContext)Riak.getExecutionContext());
        Future storeLevelNewLevel3 = level3DNAAccountEntityFuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity mergedLevel3account) {
                return RiakCommon.storeEntity(mergedLevel3account, token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Void parameter) {
                        return Futures.successful((Object)mergedLevel3account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
        Future reatachAllLevel2AccountsFuture = storeLevelNewLevel3.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity mergedLevel3Account) {
                ArrayList<Future> reatachLevel2FutureList = new ArrayList<Future>();
                for (RiakLink eachLink : mergedLevel3Account.getRiakLinks()) {
                    if (!eachLink.getBucket().equals(Riak.getFinalBucketName(Level2AccountEntity.class))) continue;
                    Future<Level2Account> level2AccountFuture = Level2AccountEntity.fetch(eachLink.getKey(), token);
                    Future attachLevel3Future = level2AccountFuture.flatMap((Function1)new Mapper<Level2Account, Future<Void>>(){

                        public Future<Void> apply(Level2Account fetchedLevel2account) {
                            return fetchedLevel2account.attachLevel3DNAAccount(mergedLevel3Account.getLevel3DNAAccountId(), token);
                        }
                    }, Riak.getExecutionContext());
                    reatachLevel2FutureList.add(attachLevel3Future);
                }
                return Futures.sequence(reatachLevel2FutureList, (ExecutionContext)Riak.getExecutionContext()).flatMap((Function1)new Mapper<Iterable<Void>, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Iterable<Void> parameter) {
                        return Futures.successful((Object)mergedLevel3Account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
        Future reatachAllLevel1Future = reatachAllLevel2AccountsFuture.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity mergedLevel3Account) {
                ArrayList<Future> reatachLevel1FutureList = new ArrayList<Future>();
                for (RiakLink eachLink : mergedLevel3Account.getRiakLinks()) {
                    if (!eachLink.getBucket().equals(Riak.getFinalBucketName(Level1AccountEntity.class))) continue;
                    Future<Level1AccountEntity> level1account = Level1AccountEntity.fetch(eachLink.getKey(), token);
                    Future attachLevel3Future = level1account.flatMap((Function1)new Mapper<Level1AccountEntity, Future<Void>>(){

                        public Future<Void> apply(Level1AccountEntity fetchedLevel1account) {
                            return fetchedLevel1account.attachLevel3DNAAccount(mergedLevel3Account.getLevel3DNAAccountId(), token);
                        }
                    }, Riak.getExecutionContext());
                    reatachLevel1FutureList.add(attachLevel3Future);
                }
                return Futures.sequence(reatachLevel1FutureList, (ExecutionContext)Riak.getExecutionContext()).flatMap((Function1)new Mapper<Iterable<Void>, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Iterable<Void> parameter) {
                        return Futures.successful((Object)mergedLevel3Account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
        Future deleteFirstAccount = reatachAllLevel1Future.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity mergedLevel3account) {
                return RiakCommon.deleteEntity(firstLevel3Account, token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Void parameter) {
                        return Futures.successful((Object)mergedLevel3account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
        Future deleteSecondAccount = deleteFirstAccount.flatMap((Function1)new Mapper<Level3DNAAccountEntity, Future<Level3DNAAccountEntity>>(){

            public Future<Level3DNAAccountEntity> apply(final Level3DNAAccountEntity mergedLevel3account) {
                return RiakCommon.deleteEntity(secondLevel3Account, token).flatMap((Function1)new Mapper<Void, Future<Level3DNAAccountEntity>>(){

                    public Future<Level3DNAAccountEntity> apply(Void parameter) {
                        return Futures.successful((Object)mergedLevel3account);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
        return deleteSecondAccount.andThen((PartialFunction)new OnComplete<Level3DNAAccountEntity>(){

            public void onComplete(Throwable throwable, Level3DNAAccountEntity level3DNAAccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Level3DNAAccountEntity resolve(List<Level3DNAAccountEntity> siblings, boolean shouldWeCreateNewIdForAccount) {
        ArrayList<Level3DNAAccountEntity> activeSiblings = new ArrayList<Level3DNAAccountEntity>();
        for (Level3DNAAccountEntity eachSibling : siblings) {
            if (!eachSibling.getActive()) continue;
            activeSiblings.add(eachSibling);
        }
        if (activeSiblings.isEmpty()) {
            return DNAAccountConflictResolver.mergeDisabledOnlyAccounts(siblings);
        }
        if (activeSiblings.size() == 1) {
            return (Level3DNAAccountEntity)activeSiblings.get(0);
        }
        Level3DNAAccountEntity firstSibling = (Level3DNAAccountEntity)activeSiblings.get(0);
        String level3DNAAccountId = firstSibling.getLevel3DNAAccountId();
        if (shouldWeCreateNewIdForAccount) {
            level3DNAAccountId = AccountIdGenerator.createRandomIdWithSocialNetworkPrefix(SocialNetworks.SocialDNA);
        }
        String socialNetworkName = firstSibling.getSocialNetworkName();
        String name = firstSibling.getName();
        String gender = firstSibling.getGender();
        String locale = firstSibling.getLocale();
        String email = firstSibling.getEmail();
        String pictureUrl = firstSibling.getPictureUrl();
        boolean active = true;
        String creationTime = firstSibling.getCreationTime();
        Map<String, TreeSet<Level3DNAAccountEntity.Transaction>> combinedTransactionHistory = DNAAccountConflictResolver.collectTransactionHistoryFromAllSiblingsInOnePlace(activeSiblings);
        Map<String, TreeSet<Level3DNAAccountEntity.ContextBundle>> combinedContextBundledFromAllSiblings = DNAAccountConflictResolver.collectContextBundlesFromAllSiblingsInOnePlace(activeSiblings);
        Map<String, String> activeLevel2AccountIds = DNAAccountConflictResolver.filterLevel2AccountsUsingTransactionHistory(combinedTransactionHistory);
        Map<String, Level3DNAAccountEntity.ContextBundle> finalContextBundleMap = DNAAccountConflictResolver.findLatestContextsForEachNetwork(activeLevel2AccountIds, combinedContextBundledFromAllSiblings);
        Map<String, TreeSet<Level3DNAAccountEntity.FriendBundle>> combinedFriendBundle = DNAAccountConflictResolver.collectFriendBundlesFromAllSiblingsInOnePlace(activeSiblings);
        Map<String, Level3DNAAccountEntity.FriendBundle> finalFriendBundle = DNAAccountConflictResolver.findLatestFriendForEachNetwork(activeLevel2AccountIds, combinedFriendBundle);
        List<RiakLink> allRiakLinks = DNAAccountConflictResolver.collectRiakLinksFromAllSiblingsInOnePlace(activeSiblings);
        HashSet<RiakLink> riakLinks = DNAAccountConflictResolver.filterRiakLinksUsingActiveLevel2AccountsOnly(activeLevel2AccountIds, allRiakLinks);
        Level3DNAAccountEntity resultEntity = new Level3DNAAccountEntity(level3DNAAccountId, socialNetworkName, name, gender, locale, email, pictureUrl, active, combinedTransactionHistory, finalContextBundleMap, finalFriendBundle, creationTime, riakLinks);
        return resultEntity;
    }

    private static HashSet<RiakLink> filterRiakLinksUsingActiveLevel2AccountsOnly(Map<String, String> activeLevel2Accounts, Collection<RiakLink> sourceRiakLinks) {
        HashSet<String> activeLevel2AccountIds = new HashSet<String>(activeLevel2Accounts.values());
        HashSet<RiakLink> result = new HashSet<RiakLink>();
        for (RiakLink eachRiakLink : sourceRiakLinks) {
            if (eachRiakLink.getTag().equals(Tags.LEVEL_1_ACCOUNTS.name())) {
                System.out.println();
                result.add(new RiakLink(eachRiakLink.getBucket(), eachRiakLink.getKey(), eachRiakLink.getTag()));
                continue;
            }
            if (activeLevel2AccountIds.contains(eachRiakLink.getKey())) {
                result.add(new RiakLink(eachRiakLink.getBucket(), eachRiakLink.getKey(), eachRiakLink.getTag()));
                continue;
            }
            DNAAccountConflictResolver.detachLevel2Account(eachRiakLink);
        }
        return result;
    }

    private static void detachLevel2Account(RiakLink linkOnLevel2Account) {
        Class clazz = Riak.getClassByFinalBucketName(linkOnLevel2Account.getBucket());
        Level2Account level2Account = (Level2Account)RiakCommon.fetchEntityByIdSync(linkOnLevel2Account.getKey(), clazz, Token.backGroundAccessToke());
        level2Account.detachFromLevel3DNAAccountSync(Token.backGroundAccessToke());
    }

    private static Map<String, String> filterLevel2AccountsUsingTransactionHistory(Map<String, TreeSet<Level3DNAAccountEntity.Transaction>> combinedHistory) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String eachNetworkName : combinedHistory.keySet()) {
            TreeSet<TmpLevel2IdHolder> tmpSet = new TreeSet<TmpLevel2IdHolder>();
            TreeSet<Level3DNAAccountEntity.Transaction> combinedHistoryForGivenNetwork = combinedHistory.get(eachNetworkName);
            for (Level3DNAAccountEntity.Transaction eachTransaction : combinedHistoryForGivenNetwork) {
                TmpLevel2IdHolder tmpLevel2IdHolder = new TmpLevel2IdHolder(eachTransaction.getLevel2accountId(), eachTransaction.getTimestamp());
                if (eachTransaction.getAction().equals("add")) {
                    if (tmpSet.contains(tmpLevel2IdHolder)) {
                        tmpSet.remove(tmpLevel2IdHolder);
                        tmpSet.add(tmpLevel2IdHolder);
                        continue;
                    }
                    tmpSet.add(tmpLevel2IdHolder);
                    continue;
                }
                if (eachTransaction.getAction().equals("remove")) {
                    if (!tmpSet.contains(tmpLevel2IdHolder)) continue;
                    tmpSet.remove(tmpLevel2IdHolder);
                    continue;
                }
                throw new ServiceException("Unknown transactions action", "conflictResolver");
            }
            if (tmpSet.isEmpty()) continue;
            result.put(eachNetworkName, ((TmpLevel2IdHolder)tmpSet.first()).getLevel2accountId());
        }
        return result;
    }

    private static Map<String, Level3DNAAccountEntity.FriendBundle> findLatestFriendForEachNetwork(Map<String, String> activeLevel2IdMap, Map<String, TreeSet<Level3DNAAccountEntity.FriendBundle>> combinedFriendBundle) {
        HashMap<String, Level3DNAAccountEntity.FriendBundle> result = new HashMap<String, Level3DNAAccountEntity.FriendBundle>();
        for (String eachNetworkName : activeLevel2IdMap.keySet()) {
            String activeLevel2AccountId = activeLevel2IdMap.get(eachNetworkName);
            String keyForBundleSet = eachNetworkName + "." + activeLevel2AccountId;
            TreeSet<Level3DNAAccountEntity.FriendBundle> bundleTreeSet = combinedFriendBundle.get(keyForBundleSet);
            if (bundleTreeSet == null || bundleTreeSet.isEmpty()) continue;
            Level3DNAAccountEntity.FriendBundle resultBundle = bundleTreeSet.first();
            result.put(eachNetworkName, resultBundle);
        }
        return result;
    }

    private static Map<String, Level3DNAAccountEntity.ContextBundle> findLatestContextsForEachNetwork(Map<String, String> activeLevel2IdMap, Map<String, TreeSet<Level3DNAAccountEntity.ContextBundle>> bundles) {
        HashMap<String, Level3DNAAccountEntity.ContextBundle> result = new HashMap<String, Level3DNAAccountEntity.ContextBundle>();
        for (String eachNetworkName : activeLevel2IdMap.keySet()) {
            String activeLevel2AccountId = activeLevel2IdMap.get(eachNetworkName);
            String keyForBundleSet = eachNetworkName + "." + activeLevel2AccountId;
            TreeSet<Level3DNAAccountEntity.ContextBundle> bundleTreeSet = bundles.get(keyForBundleSet);
            if (bundleTreeSet == null || bundleTreeSet.isEmpty()) continue;
            Level3DNAAccountEntity.ContextBundle resultBundle = bundleTreeSet.first();
            result.put(eachNetworkName, resultBundle);
        }
        return result;
    }

    private static List<RiakLink> collectRiakLinksFromAllSiblingsInOnePlace(List<Level3DNAAccountEntity> siblings) {
        ArrayList<RiakLink> result = new ArrayList<RiakLink>();
        for (Level3DNAAccountEntity eachLevel3Account : siblings) {
            if (eachLevel3Account.getRiakLinks() == null || eachLevel3Account.getRiakLinks().isEmpty()) continue;
            result.addAll(eachLevel3Account.getRiakLinks());
        }
        return result;
    }

    private static Map<String, TreeSet<Level3DNAAccountEntity.Transaction>> collectTransactionHistoryFromAllSiblingsInOnePlace(List<Level3DNAAccountEntity> siblings) {
        HashMap<String, TreeSet<Level3DNAAccountEntity.Transaction>> combinedMap = new HashMap<String, TreeSet<Level3DNAAccountEntity.Transaction>>();
        for (SocialNetworks eachSocialNetwork : SocialNetworks.values()) {
            TreeSet transactionTree = new TreeSet();
            combinedMap.put(eachSocialNetwork.name(), transactionTree);
        }
        for (Level3DNAAccountEntity eachSibling : siblings) {
            Map<String, TreeSet<Level3DNAAccountEntity.Transaction>> eachMap = eachSibling.getTransactionSetForEachNetwork();
            for (String eachKey : eachMap.keySet()) {
                ((TreeSet)combinedMap.get(eachKey)).addAll((Collection)eachMap.get(eachKey));
            }
        }
        return combinedMap;
    }

    private static Map<String, TreeSet<Level3DNAAccountEntity.ContextBundle>> collectContextBundlesFromAllSiblingsInOnePlace(List<Level3DNAAccountEntity> siblings) {
        HashMap<String, TreeSet<Level3DNAAccountEntity.ContextBundle>> contextBundlesFromAllSiblings = new HashMap<String, TreeSet<Level3DNAAccountEntity.ContextBundle>>();
        for (Level3DNAAccountEntity eachSibling : siblings) {
            Map<String, Level3DNAAccountEntity.ContextBundle> contextBundleMap = eachSibling.getContextBundleForEachNetworkMap();
            for (String networkName : contextBundleMap.keySet()) {
                Level3DNAAccountEntity.ContextBundle contextBundle = contextBundleMap.get(networkName);
                if (contextBundle == null) continue;
                String finalKeyInMap = networkName + "." + contextBundle.getLevel2AccountId();
                TreeSet<Level3DNAAccountEntity.ContextBundle> finalTree = (TreeSet<Level3DNAAccountEntity.ContextBundle>)contextBundlesFromAllSiblings.get(finalKeyInMap);
                if (finalTree == null) {
                    finalTree = new TreeSet<Level3DNAAccountEntity.ContextBundle>();
                }
                finalTree.add(contextBundle);
                contextBundlesFromAllSiblings.put(finalKeyInMap, finalTree);
            }
        }
        return contextBundlesFromAllSiblings;
    }

    private static Map<String, TreeSet<Level3DNAAccountEntity.FriendBundle>> collectFriendBundlesFromAllSiblingsInOnePlace(List<Level3DNAAccountEntity> siblings) {
        HashMap<String, TreeSet<Level3DNAAccountEntity.FriendBundle>> friendBundlesFromAllSiblings = new HashMap<String, TreeSet<Level3DNAAccountEntity.FriendBundle>>();
        for (Level3DNAAccountEntity eachSibling : siblings) {
            Map<String, Level3DNAAccountEntity.FriendBundle> friendBundleMap = eachSibling.getFriendsBundleForEachNetworkMap();
            for (String networkName : friendBundleMap.keySet()) {
                Level3DNAAccountEntity.FriendBundle friendBundle = friendBundleMap.get(networkName);
                if (friendBundle == null) continue;
                String finalKeyInMap = networkName + "." + friendBundle.getLevel2AccountId();
                TreeSet<Level3DNAAccountEntity.FriendBundle> finalTree = (TreeSet<Level3DNAAccountEntity.FriendBundle>)friendBundlesFromAllSiblings.get(finalKeyInMap);
                if (finalTree == null) {
                    finalTree = new TreeSet<Level3DNAAccountEntity.FriendBundle>();
                }
                finalTree.add(friendBundle);
                friendBundlesFromAllSiblings.put(finalKeyInMap, finalTree);
            }
        }
        return friendBundlesFromAllSiblings;
    }

    private static Level3DNAAccountEntity mergeDisabledOnlyAccounts(List<Level3DNAAccountEntity> disabledSiblings) {
        if (disabledSiblings.isEmpty()) {
            return null;
        }
        return disabledSiblings.get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TmpLevel2IdHolder
    implements Comparable<TmpLevel2IdHolder> {
        private String level2accountId;
        private long whenWasAdded;

        public TmpLevel2IdHolder(String level2accountId, long whenWasAdded) {
            this.level2accountId = level2accountId;
            this.whenWasAdded = whenWasAdded;
        }

        @Override
        public int compareTo(TmpLevel2IdHolder o) {
            if (this.whenWasAdded == o.whenWasAdded) {
                return 0;
            }
            if (this.whenWasAdded > o.whenWasAdded) {
                return -1;
            }
            return 1;
        }

        public String getLevel2accountId() {
            return this.level2accountId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TmpLevel2IdHolder that = (TmpLevel2IdHolder)o;
            return this.level2accountId.equals(that.level2accountId);
        }

        public int hashCode() {
            return this.level2accountId.hashCode();
        }
    }
}

