/*
 * Decompiled with CFR 0.152.
 */
package helpers.inside;

import constants.SocialNetworks;
import entities.common.UserProfileVO;
import entities.interfaces.UserProfile;
import exceptions.ForbiddenException;
import identity.Token;
import org.json.JSONException;
import org.json.JSONObject;

public class UserProfileHelper {
    public static UserProfile constructUserProfile(String sourceObject, SocialNetworks socialNetwork, Token token) throws JSONException {
        switch (socialNetwork) {
            case Facebook: {
                return UserProfileHelper.createFacebookUserProfileFromFqlJSON(sourceObject, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    private static UserProfileVO createFacebookUserProfileFromFqlJSON(String jsonString, Token token) throws JSONException, ForbiddenException {
        JSONObject object = new JSONObject(jsonString);
        if (object.has("error")) {
            throw new ForbiddenException("Facebook communication failed." + object.getString("error"), token.getAccountId());
        }
        String id = object.getString("uid");
        String name = object.getString("name");
        String gender = null;
        if (object.has("sex") && !object.getString("sex").equalsIgnoreCase("null")) {
            gender = object.getString("sex");
        }
        String locale = null;
        if (object.has("locale") && !object.getString("locale").equalsIgnoreCase("null")) {
            locale = object.getString("locale");
        }
        String email = null;
        if (object.has("email") && !object.getString("email").equalsIgnoreCase("null")) {
            email = object.getString("email");
        }
        String pictureUrl = null;
        if (object.has("pic") && !object.getString("pic").equalsIgnoreCase("null")) {
            pictureUrl = object.getString("pic");
        }
        int friendCount = 0;
        if (object.has("friend_count")) {
            String friendCountString = object.getString("friend_count");
            friendCount = friendCountString != null && !friendCountString.equalsIgnoreCase("null") ? Integer.parseInt(friendCountString) : -1;
        }
        return new UserProfileVO(id, name, gender, locale, email, pictureUrl, friendCount, SocialNetworks.Facebook.name());
    }
}

