/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.OnComplete;
import calculator.NetworksScoreCalculator;
import constants.SocialNetworks;
import entities.common.ContextVO;
import entities.common.PostVO;
import entities.common.UserProfileVO;
import entities.fb.FbUserStateEntity;
import entities.interfaces.NetworkProvider;
import entities.interfaces.Post;
import entities.interfaces.UserProfile;
import entities.interfaces.UserState;
import exceptions.ServiceException;
import helpers.inside.NetworkProviderFactory;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import riak.Riak;
import riak.RiakCommon;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import util.AccountIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserStateHelper {
    private static MessageDispatcher dispatcher = null;

    public static void initialize(MessageDispatcher messageDispatcher) {
        dispatcher = messageDispatcher;
    }

    private static void isInitialized() {
        if (dispatcher == null) {
            throw new ServiceException("UserStateHelper has not been initialized correctly", null);
        }
    }

    public static UserState constructUserStateFromSocialNetworkWithAccessTokenSync(String socialNetworkAccessToken, SocialNetworks socialNetwork, Token token) {
        UserStateHelper.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return UserStateHelper.createFromFacebookByAccessTokenSync(socialNetworkAccessToken, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static Future<UserState> constructUserStateFromSocialNetworkWithAccessToken(String socialNetworkAccessToken, SocialNetworks socialNetwork, Token token) {
        UserStateHelper.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return UserStateHelper.createFromFacebookByAccessToken(socialNetworkAccessToken, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static Future<Map<String, Boolean>> checkPermissionsStatusFromSocialNetworkByAccessToken(String socialNetworkAccessToken, SocialNetworks socialNetwork, List<String> permissions, Token token) {
        UserStateHelper.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return UserStateHelper.checkPermissionsStatusFromFacebookByAccessToken(socialNetworkAccessToken, permissions, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static Future<UserState> fetchUserState(String userStateId, SocialNetworks socialNetwork, Token token) {
        UserStateHelper.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return RiakCommon.fetchEntityById(userStateId, FbUserStateEntity.class, token).flatMap((Function1)new Mapper<FbUserStateEntity, Future<UserState>>(){

                    public Future<UserState> apply(FbUserStateEntity fbUserStateEntity) {
                        return Futures.successful((Object)fbUserStateEntity);
                    }
                }, (ExecutionContext)dispatcher);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static UserState fetchUserStateSync(String userStateId, SocialNetworks socialNetwork, Token token) {
        UserStateHelper.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return RiakCommon.fetchEntityByIdSync(userStateId, FbUserStateEntity.class, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    private static Future<Map<String, Boolean>> checkPermissionsStatusFromFacebookByAccessToken(String socialNetworkAccessToken, List<String> permissions, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"Network: UserStateHelper.checkPermissionsStatusFromFacebookByAccessToken");
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Facebook, dispatcher);
        return provider.checkPermissionsStatusByAccessToken(socialNetworkAccessToken, permissions, token).andThen((PartialFunction)new OnComplete<Map<String, Boolean>>(){

            public void onComplete(Throwable throwable, Map<String, Boolean> stringBooleanMap) throws Throwable {
                monitor.stop();
            }
        }, (ExecutionContext)dispatcher);
    }

    private static Future<UserState> createFromFacebookByAccessToken(String facebookAccessToken, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"Network: UserStateHelper.createFromFacebookByAccessToken");
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Facebook, dispatcher);
        ArrayList<Future<Map<String, Object>>> futures = new ArrayList<Future<Map<String, Object>>>();
        Future<Map<String, Object>> fetchMeFuture = UserStateHelper.meFuture(facebookAccessToken, provider, token);
        futures.add(fetchMeFuture);
        Future<Map<String, Object>> fetchFriendsFuture = UserStateHelper.friendsFuture(facebookAccessToken, provider, token);
        futures.add(fetchFriendsFuture);
        Future<Map<String, Object>> fetchSubscribersFuture = UserStateHelper.subscribersFuture(facebookAccessToken, provider, token);
        futures.add(fetchSubscribersFuture);
        Future<Map<String, Object>> fetchPostsFuture = UserStateHelper.postsFuture(facebookAccessToken, provider, token);
        futures.add(fetchPostsFuture);
        Future<Map<String, Object>> fetchAllLikedObjectIdFuture = UserStateHelper.likesFuture(facebookAccessToken, provider, token);
        futures.add(fetchAllLikedObjectIdFuture);
        Future finalFuture = Futures.sequence(futures, (ExecutionContext)dispatcher);
        Future createUserStateEntityFuture = finalFuture.flatMap((Function1)new Mapper<Iterable<Map<String, Object>>, Future<UserState>>(){

            public Future<UserState> apply(final Iterable<Map<String, Object>> resultMap) {
                return Futures.future((Callable)new Callable<UserState>(){

                    @Override
                    public UserState call() throws Exception {
                        UserProfile me = null;
                        Set friends = null;
                        Set subscribers = null;
                        Set posts = null;
                        Set allLikedObjectId = null;
                        for (Map eachMap : resultMap) {
                            if (eachMap.get("me") != null) {
                                me = (UserProfile)eachMap.get("me");
                                continue;
                            }
                            if (eachMap.get("friends") != null) {
                                friends = (Set)eachMap.get("friends");
                                continue;
                            }
                            if (eachMap.get("subscribers") != null) {
                                subscribers = (Set)eachMap.get("subscribers");
                                continue;
                            }
                            if (eachMap.get("posts") != null) {
                                posts = (Set)eachMap.get("posts");
                                continue;
                            }
                            if (eachMap.get("likes") == null) continue;
                            allLikedObjectId = (Set)eachMap.get("likes");
                        }
                        String userStateId = AccountIdGenerator.createIdBasedOnSocialNetworkWithDate(me.getId(), SocialNetworks.Facebook);
                        Set<ContextVO> contexts = NetworksScoreCalculator.calculateScores(me.getId(), friends, subscribers, posts, SocialNetworks.Facebook, token);
                        UserProfileVO meVO = new UserProfileVO(me.getId(), me.getName(), me.getGender(), me.getLocale(), me.getEmail(), me.getPictureUrl(), me.getFriendCount(), SocialNetworks.Facebook.name());
                        HashSet<UserProfileVO> friendsVO = new HashSet<UserProfileVO>();
                        if (friends != null && !friends.isEmpty()) {
                            for (UserProfile eachFriend : friends) {
                                friendsVO.add(new UserProfileVO(eachFriend.getId(), eachFriend.getName(), eachFriend.getGender(), eachFriend.getLocale(), eachFriend.getEmail(), eachFriend.getPictureUrl(), eachFriend.getFriendCount(), SocialNetworks.Facebook.name()));
                            }
                        }
                        HashSet<UserProfileVO> subscribersVO = new HashSet<UserProfileVO>();
                        if (subscribers != null && !subscribers.isEmpty()) {
                            for (UserProfile eachSubscriber : subscribers) {
                                subscribersVO.add(new UserProfileVO(eachSubscriber.getId(), eachSubscriber.getName(), eachSubscriber.getGender(), eachSubscriber.getLocale(), eachSubscriber.getEmail(), eachSubscriber.getPictureUrl(), eachSubscriber.getFriendCount(), SocialNetworks.Facebook.name()));
                            }
                        }
                        HashSet<PostVO> postsVO = new HashSet<PostVO>();
                        if (posts != null && !posts.isEmpty()) {
                            for (Post eachPost : posts) {
                                postsVO.add(new PostVO(eachPost.getPostId(), eachPost.getMessage(), eachPost.getLikes(), eachPost.getComments()));
                            }
                        }
                        FbUserStateEntity userState = new FbUserStateEntity(userStateId, meVO.getId(), SocialNetworks.Facebook.name(), meVO, friendsVO, subscribersVO, postsVO, allLikedObjectId, contexts);
                        return userState;
                    }
                }, (ExecutionContext)dispatcher);
            }
        }, (ExecutionContext)dispatcher).andThen((PartialFunction)new OnComplete<UserState>(){

            public void onComplete(Throwable throwable, UserState userState) throws Throwable {
                monitor.stop();
            }
        }, (ExecutionContext)dispatcher);
        return createUserStateEntityFuture.flatMap((Function1)new Mapper<UserState, Future<UserState>>(){

            public Future<UserState> apply(final UserState createdEntity) {
                return RiakCommon.storeEntity(createdEntity, token).flatMap((Function1)new Mapper<Void, Future<UserState>>(){

                    public Future<UserState> apply(Void parameter) {
                        return Futures.successful((Object)createdEntity);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
    }

    private static UserState createFromFacebookByAccessTokenSync(String fbAccessToken, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)"Network: UserStateHelper.createFromFacebookByAccessTokenSync");
        FbUserStateEntity userState = null;
        try {
            NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Facebook, dispatcher);
            UserProfile me = provider.fetchUserProfileByAccessTokenSync(fbAccessToken, token);
            Set<UserProfile> friends = provider.fetchUserFriendsByAccessTokenSync(fbAccessToken, token);
            Set<UserProfile> subscribers = provider.fetchUserSubscribersByAccessTokenSync(fbAccessToken, token);
            Set<Post> posts = provider.fetchUserPostsFromOwnWallByAccessTokenSync(fbAccessToken, token);
            Set<String> allLikedObjectId = provider.fetchUserAllUserLikesByAccessTokenSync(fbAccessToken, token);
            String userStateId = AccountIdGenerator.createIdBasedOnSocialNetworkWithDate(me.getId(), SocialNetworks.Facebook);
            Set<ContextVO> contexts = NetworksScoreCalculator.calculateScores(me.getId(), friends, subscribers, posts, SocialNetworks.Facebook, token);
            UserProfileVO meVO = new UserProfileVO(me.getId(), me.getName(), me.getGender(), me.getLocale(), me.getEmail(), me.getPictureUrl(), me.getFriendCount(), SocialNetworks.Facebook.name());
            HashSet<UserProfileVO> friendsVO = new HashSet<UserProfileVO>();
            if (friends != null && !friends.isEmpty()) {
                for (UserProfile eachFriend : friends) {
                    friendsVO.add(new UserProfileVO(eachFriend.getId(), eachFriend.getName(), eachFriend.getGender(), eachFriend.getLocale(), eachFriend.getEmail(), eachFriend.getPictureUrl(), eachFriend.getFriendCount(), SocialNetworks.Facebook.name()));
                }
            }
            HashSet<UserProfileVO> subscribersVO = new HashSet<UserProfileVO>();
            if (subscribers != null && !subscribers.isEmpty()) {
                for (UserProfile eachSubscriber : subscribers) {
                    subscribersVO.add(new UserProfileVO(eachSubscriber.getId(), eachSubscriber.getName(), eachSubscriber.getGender(), eachSubscriber.getLocale(), eachSubscriber.getEmail(), eachSubscriber.getPictureUrl(), eachSubscriber.getFriendCount(), SocialNetworks.Facebook.name()));
                }
            }
            HashSet<PostVO> postsVO = new HashSet<PostVO>();
            if (posts != null && !posts.isEmpty()) {
                for (Post eachPost : posts) {
                    postsVO.add(new PostVO(eachPost.getPostId(), eachPost.getMessage(), eachPost.getLikes(), eachPost.getComments()));
                }
            }
            userState = new FbUserStateEntity(userStateId, meVO.getId(), SocialNetworks.Facebook.name(), meVO, friendsVO, subscribersVO, postsVO, allLikedObjectId, contexts);
        }
        catch (Exception e) {
            throw new ServiceException("Error in Connecting to FB", (Throwable)e, token.getAccountId());
        }
        finally {
            monitor.stop();
        }
        RiakCommon.storeEntitySync(userState, token);
        return userState;
    }

    private static Future<Map<String, Object>> meFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"Network: UserStateHelper.meFuture");
        return provider.fetchUserProfileByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<UserProfile, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final UserProfile me) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("me", me);
                        return resultMap;
                    }
                }, (ExecutionContext)dispatcher);
            }
        }, (ExecutionContext)dispatcher).andThen((PartialFunction)new OnComplete<Map<String, Object>>(){

            public void onComplete(Throwable throwable, Map<String, Object> stringObjectMap) throws Throwable {
                monitor.stop();
            }
        }, (ExecutionContext)dispatcher);
    }

    private static Future<Map<String, Object>> friendsFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"Network: UserStateHelper.friendsFuture");
        return provider.fetchUserFriendsByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<Set<UserProfile>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<UserProfile> friends) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("friends", friends);
                        return resultMap;
                    }
                }, (ExecutionContext)dispatcher);
            }
        }, (ExecutionContext)dispatcher).andThen((PartialFunction)new OnComplete<Map<String, Object>>(){

            public void onComplete(Throwable throwable, Map<String, Object> stringObjectMap) throws Throwable {
                monitor.stop();
            }
        }, (ExecutionContext)dispatcher);
    }

    private static Future<Map<String, Object>> subscribersFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"Network: UserStateHelper.subscribersFuture");
        return provider.fetchUserSubscribersByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<Set<UserProfile>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<UserProfile> subscribers) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("subscribers", subscribers);
                        return resultMap;
                    }
                }, (ExecutionContext)dispatcher);
            }
        }, (ExecutionContext)dispatcher).andThen((PartialFunction)new OnComplete<Map<String, Object>>(){

            public void onComplete(Throwable throwable, Map<String, Object> stringObjectMap) throws Throwable {
                monitor.stop();
            }
        }, (ExecutionContext)dispatcher);
    }

    private static Future<Map<String, Object>> postsFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"Network: UserStateHelper.postsFuture");
        return provider.fetchUserPostsFromOwnWallByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<Set<Post>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<Post> posts) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("posts", posts);
                        return resultMap;
                    }
                }, (ExecutionContext)dispatcher);
            }
        }, (ExecutionContext)dispatcher).andThen((PartialFunction)new OnComplete<Map<String, Object>>(){

            public void onComplete(Throwable throwable, Map<String, Object> stringObjectMap) throws Throwable {
                monitor.stop();
            }
        }, (ExecutionContext)dispatcher);
    }

    private static Future<Map<String, Object>> likesFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"Network: UserStateHelper.likesFuture");
        return provider.fetchUserAllUserLikesByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<Set<String>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<String> likes) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("likes", likes);
                        return resultMap;
                    }
                }, (ExecutionContext)dispatcher);
            }
        }, (ExecutionContext)dispatcher).andThen((PartialFunction)new OnComplete<Map<String, Object>>(){

            public void onComplete(Throwable throwable, Map<String, Object> stringObjectMap) throws Throwable {
                monitor.stop();
            }
        }, (ExecutionContext)dispatcher);
    }
}

