/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import com.basho.riak.client.cap.ConflictResolver;
import com.google.common.collect.Lists;
import constants.SocialNetworks;
import entities.common.StateHistoryEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateHistoryEntityConflictResolver
implements ConflictResolver<StateHistoryEntity> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateHistoryEntity resolve(Collection<StateHistoryEntity> siblings) {
        if (siblings.size() > 1) {
            JMonitor monitor = JMonitorFactory.start((String)"DATA: StateHistoryEntityConflictResolver.resolve");
            try {
                ArrayList stateHistoryEntityList = Lists.newArrayList(siblings);
                HashMap<String, Set<String>> historyForEachNetwork = new HashMap<String, Set<String>>();
                for (SocialNetworks eachNetwork : SocialNetworks.values()) {
                    HashSet set = new HashSet();
                    historyForEachNetwork.put(eachNetwork.name(), set);
                }
                for (StateHistoryEntity eachSibling : stateHistoryEntityList) {
                    for (String eachKey : eachSibling.getHistoryForEachNetwork().keySet()) {
                        ((Set)historyForEachNetwork.get(eachKey)).addAll((Collection)eachSibling.getHistoryForEachNetwork().get(eachKey));
                    }
                }
                StateHistoryEntity stateHistoryEntity = new StateHistoryEntity(((StateHistoryEntity)stateHistoryEntityList.get(0)).getHistoryId(), historyForEachNetwork);
                return stateHistoryEntity;
            }
            finally {
                monitor.stop();
            }
        }
        if (siblings.size() == 1) {
            return siblings.iterator().next();
        }
        return null;
    }
}

