/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import com.basho.riak.client.convert.RiakIndex;
import com.basho.riak.client.convert.RiakKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import constants.Dates;
import identity.Token;
import java.util.ArrayList;
import java.util.List;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import riak.Riak;
import riak.RiakCommon;
import riak.RiakEntity;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RiakEntity(bucketName="level1.account", lastWriteWins=true)
public class Level1AccountEntity {
    public static final String ACCOUNT_PREFIX = "BA";
    public static final String CREATION_TIME_INDEX_NAME = "creationTime";
    @JsonProperty
    @RiakKey
    private final String level1AccountId;
    @JsonProperty
    private final String level3DNAAccountId;
    @JsonProperty
    @RiakIndex(name="creationTime")
    private final String creationTime;

    @Deprecated
    @JsonCreator
    public Level1AccountEntity(@JsonProperty(value="level1AccountId") String level1AccountId) {
        this.level1AccountId = level1AccountId;
        this.level3DNAAccountId = null;
        this.creationTime = LocalDate.now().toString();
    }

    @Deprecated
    public Level1AccountEntity(Level1AccountEntity baseAccount, String level3DNAAccountId) {
        this.level1AccountId = baseAccount.getLevel1AccountId();
        this.creationTime = baseAccount.getCreationTime();
        this.level3DNAAccountId = level3DNAAccountId;
    }

    public String getLevel1AccountId() {
        return this.level1AccountId;
    }

    public String getLevel3DNAAccountId() {
        return this.level3DNAAccountId;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Level1AccountEntity that = (Level1AccountEntity)o;
        return this.level1AccountId.equals(that.level1AccountId);
    }

    public int hashCode() {
        return this.level1AccountId.hashCode();
    }

    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Level1AccountEntity that = (Level1AccountEntity)o;
        if (!this.level1AccountId.equals(that.level1AccountId)) {
            return false;
        }
        return !(this.level3DNAAccountId != null ? !this.level3DNAAccountId.equals(that.level3DNAAccountId) : that.level3DNAAccountId != null);
    }

    public Future<Void> attachLevel3DNAAccount(String level3DNAAccountId, Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level1AccountEntity.attachLevel3DNAAccount");
        Level1AccountEntity newLevel1Account = new Level1AccountEntity(this, level3DNAAccountId);
        return RiakCommon.storeEntity(newLevel1Account, token).andThen((PartialFunction)new OnComplete<Void>(){

            public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public Future<Void> detachFromLevel3DNAAccount(Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level1AccountEntity.detachFromLevel3DNAAccount");
        Level1AccountEntity newLevel1Account = new Level1AccountEntity(this, null);
        return RiakCommon.storeEntity(newLevel1Account, token).andThen((PartialFunction)new OnComplete<Void>(){

            public void onComplete(Throwable throwable, Void aVoid) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<Level1AccountEntity> fetch(String level1AccountId, Token token) {
        return RiakCommon.fetchEntityById(level1AccountId, Level1AccountEntity.class, token);
    }

    public static Future<Level1AccountEntity> fetchOrCreate(final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level1AccountEntity.fetchOrCreate");
        return RiakCommon.fetchEntityById(token.getAccountId(), Level1AccountEntity.class, token).flatMap((Function1)new Mapper<Level1AccountEntity, Future<Level1AccountEntity>>(){

            public Future<Level1AccountEntity> apply(Level1AccountEntity fetchedLevel1account) {
                if (fetchedLevel1account == null) {
                    return Level1AccountEntity.create(token);
                }
                return Futures.successful((Object)fetchedLevel1account);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level1AccountEntity>(){

            public void onComplete(Throwable throwable, Level1AccountEntity level1AccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Level1AccountEntity fetchSync(String level1AccountId, Token token) {
        return RiakCommon.fetchEntityByIdSync(level1AccountId, Level1AccountEntity.class, token);
    }

    public static Future<Level1AccountEntity> create(Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level1AccountEntity.create");
        final Level1AccountEntity level1AccountEntity = new Level1AccountEntity(token.getAccountId());
        return RiakCommon.storeEntity(level1AccountEntity, token).flatMap((Function1)new Mapper<Void, Future<Level1AccountEntity>>(){

            public Future<Level1AccountEntity> apply(Void parameter) {
                return Futures.successful((Object)level1AccountEntity);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Level1AccountEntity>(){

            public void onComplete(Throwable throwable, Level1AccountEntity level1AccountEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    public static Future<List<String>> grabAllKeysByDate(LocalDate localDate, Token token) {
        return RiakCommon.binaryIndexSearch(Level1AccountEntity.class, CREATION_TIME_INDEX_NAME, localDate.toString(), token);
    }

    public static Future<Iterable<List<String>>> grabAllKeysFromBeginningOfTime(Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: Level1AccountEntity.grabAllKeysFromBeginningOfTime");
        LocalDate now = LocalDate.now();
        LocalDate tmpDate = Dates.BEGINNING_OF_TIME.asDate();
        ArrayList<Future<List<String>>> futureList = new ArrayList<Future<List<String>>>();
        while (tmpDate.isBefore((ReadablePartial)now) || tmpDate.isEqual((ReadablePartial)now)) {
            futureList.add(Level1AccountEntity.grabAllKeysByDate(tmpDate, token));
            tmpDate = tmpDate.plusDays(1);
        }
        return Futures.sequence(futureList, (ExecutionContext)Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<Iterable<List<String>>>(){

            public void onComplete(Throwable throwable, Iterable<List<String>> listIterable) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }
}

