/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventVO
implements Comparable<EventVO> {
    @JsonProperty
    private final String eventCode;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final String pictureUrl;
    @JsonProperty
    private final long timeStamp;
    @JsonProperty
    private final String eventId;

    @JsonCreator
    public EventVO(@JsonProperty(value="eventCode") String eventCode, @JsonProperty(value="description") String description, @JsonProperty(value="pictureUrl") String pictureUrl) {
        this.eventCode = eventCode;
        this.description = description;
        this.pictureUrl = pictureUrl;
        this.timeStamp = DateTime.now().getMillis();
        this.eventId = UUID.randomUUID().toString();
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getEventId() {
        return this.eventId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventVO eventVO = (EventVO)o;
        return this.eventId.equals(eventVO.eventId);
    }

    public int hashCode() {
        return this.eventId.hashCode();
    }

    @Override
    public int compareTo(EventVO o) {
        if (this.timeStamp == o.timeStamp) {
            return 0;
        }
        if (this.timeStamp > o.timeStamp) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "EventVO{eventCode='" + this.eventCode + '\'' + ", description='" + this.description + '\'' + ", pictureUrl='" + this.pictureUrl + '\'' + ", timeStamp=" + this.timeStamp + ", eventId='" + this.eventId + '\'' + '}';
    }
}

