/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import com.basho.riak.client.convert.RiakKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import entities.common.EventVO;
import identity.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.Callable;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import riak.Riak;
import riak.RiakCommon;
import riak.RiakEntity;
import scala.Function1;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RiakEntity(bucketName="event.queue", lastWriteWins=true)
public class EventQueueEntity {
    public static int MAX_HISTORY_SIZE = 10000;
    public static int MAX_QUEUEU_SIZE = 10000;
    public static int PERIOD = 5000;
    public static final String SEPARATOR = ".";
    @RiakKey
    private final String eventQueueId;
    @JsonProperty
    private final PriorityQueue<EventVO> queue;
    @JsonProperty
    private final Set<EventVO> history;
    @JsonProperty
    private final int previousArchivedEventQueueIdx;

    @JsonCreator
    public EventQueueEntity(@JsonProperty(value="eventQueueId") String eventQueueId, @JsonProperty(value="queue") PriorityQueue<EventVO> queue, @JsonProperty(value="history") Set<EventVO> history, @JsonProperty(value="previousArchivedEventQueueIdx") int previousArchivedEventQueueIdx) {
        this.eventQueueId = eventQueueId;
        this.queue = new PriorityQueue();
        if (queue != null && !queue.isEmpty()) {
            this.queue.addAll(queue);
        }
        this.history = new HashSet<EventVO>();
        if (history != null && !history.isEmpty()) {
            this.history.addAll(history);
        }
        this.previousArchivedEventQueueIdx = previousArchivedEventQueueIdx;
    }

    public String getEventQueueId() {
        return this.eventQueueId;
    }

    public PriorityQueue<EventVO> getQueue() {
        return new PriorityQueue<EventVO>(this.queue);
    }

    public Set<EventVO> getHistory() {
        return new HashSet<EventVO>(this.history);
    }

    public int getPreviousArchivedEventQueueIdx() {
        return this.previousArchivedEventQueueIdx;
    }

    public static Future<EventQueueEntity> addEvent(final String level3dnaId, final EventVO event, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: EventQueueEntity.addEvent");
        Future<EventQueueEntity> fetchEventQueueFuture = RiakCommon.fetchEntityById(level3dnaId, EventQueueEntity.class, token);
        Future result = fetchEventQueueFuture.flatMap((Function1)new Mapper<EventQueueEntity, Future<EventQueueEntity>>(){

            public Future<EventQueueEntity> apply(EventQueueEntity fetchedEntity) {
                EventQueueEntity newEntity = null;
                if (fetchedEntity == null) {
                    PriorityQueue<EventVO> newQueue = new PriorityQueue<EventVO>();
                    newQueue.add(event);
                    newEntity = new EventQueueEntity(level3dnaId, newQueue, null, 0);
                } else {
                    PriorityQueue<EventVO> newQueue = fetchedEntity.getQueue();
                    newQueue.add(event);
                    newEntity = new EventQueueEntity(level3dnaId, newQueue, fetchedEntity.history, fetchedEntity.previousArchivedEventQueueIdx);
                }
                return EventQueueEntity.store(newEntity, token);
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<EventQueueEntity>(){

            public void onComplete(Throwable throwable, EventQueueEntity eventQueueEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
        return result;
    }

    public static Future<List<EventVO>> nextEvents(String level3dnaId, final int amount, final Token token) {
        if (amount <= 0) {
            throw new IllegalArgumentException("amount should be > 0");
        }
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: EventQueueEntity.nextEvents");
        Future<EventQueueEntity> fetchEventQueueFuture = RiakCommon.fetchEntityById(level3dnaId, EventQueueEntity.class, token);
        return fetchEventQueueFuture.flatMap((Function1)new Mapper<EventQueueEntity, Future<List<EventVO>>>(){

            public Future<List<EventVO>> apply(EventQueueEntity fetchedEntity) {
                final ArrayList<EventVO> result = new ArrayList<EventVO>();
                if (fetchedEntity == null) {
                    return Futures.successful(result);
                }
                PriorityQueue<EventVO> queue = fetchedEntity.getQueue();
                for (int i = 0; i < amount; ++i) {
                    EventVO event = queue.poll();
                    if (event == null) continue;
                    result.add(event);
                }
                Set<EventVO> newHistory = fetchedEntity.getHistory();
                newHistory.addAll(result);
                EventQueueEntity newEntity = new EventQueueEntity(fetchedEntity.eventQueueId, queue, newHistory, fetchedEntity.previousArchivedEventQueueIdx);
                return EventQueueEntity.store(newEntity, token).flatMap((Function1)new Mapper<EventQueueEntity, Future<List<EventVO>>>(){

                    public Future<List<EventVO>> apply(EventQueueEntity parameter) {
                        return Futures.successful((Object)result);
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext()).andThen((PartialFunction)new OnComplete<List<EventVO>>(){

            public void onComplete(Throwable throwable, List<EventVO> eventVOs) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }

    private static Future<EventQueueEntity> store(final EventQueueEntity source, Token token) {
        if (source.history.size() >= MAX_HISTORY_SIZE || source.queue.size() >= MAX_QUEUEU_SIZE) {
            return EventQueueEntity.archiveEntity(source, token);
        }
        return RiakCommon.storeEntity(source, token).flatMap((Function1)new Mapper<Void, Future<EventQueueEntity>>(){

            public Future<EventQueueEntity> apply(Void parameter) {
                return Futures.successful((Object)source);
            }
        }, Riak.getExecutionContext());
    }

    private static Future<EventQueueEntity> archiveEntity(final EventQueueEntity source, final Token token) {
        final JMonitor monitor = JMonitorFactory.start((String)"DATA: EventQueueEntity.archiveEntity");
        Future archivedEntityAndStoreFuture = Futures.future((Callable)new Callable<EventQueueEntity>(){

            @Override
            public EventQueueEntity call() throws Exception {
                int newIndex = source.previousArchivedEventQueueIdx + 1;
                String newKey = source.eventQueueId + EventQueueEntity.SEPARATOR + newIndex;
                PriorityQueue<EventVO> newQueue = new PriorityQueue<EventVO>();
                PriorityQueue<EventVO> sourceQueue = source.getQueue();
                if (sourceQueue.size() >= MAX_QUEUEU_SIZE) {
                    for (int i = 0; i < PERIOD; ++i) {
                        newQueue.add(sourceQueue.poll());
                    }
                }
                HashSet<EventVO> newHistory = new HashSet<EventVO>(source.history);
                return new EventQueueEntity(newKey, newQueue, newHistory, source.previousArchivedEventQueueIdx);
            }
        }, (ExecutionContext)Riak.getExecutionContext()).flatMap((Function1)new Mapper<EventQueueEntity, Future<Void>>(){

            public Future<Void> apply(EventQueueEntity createdArchivedEntity) {
                return RiakCommon.storeEntity(createdArchivedEntity, token);
            }
        }, Riak.getExecutionContext());
        Future newEntityFuture = archivedEntityAndStoreFuture.flatMap((Function1)new Mapper<Void, Future<EventQueueEntity>>(){

            public Future<EventQueueEntity> apply(Void parameter) {
                return Futures.future((Callable)new Callable<EventQueueEntity>(){

                    @Override
                    public EventQueueEntity call() throws Exception {
                        String newKey = source.eventQueueId;
                        int newPreviousArchivedEventQueueIdx = source.previousArchivedEventQueueIdx + 1;
                        PriorityQueue<EventVO> newQueue = source.getQueue();
                        if (newQueue.size() >= MAX_QUEUEU_SIZE) {
                            for (int i = 0; i < PERIOD; ++i) {
                                newQueue.poll();
                            }
                        }
                        HashSet<EventVO> newHistory = new HashSet<EventVO>();
                        return new EventQueueEntity(newKey, newQueue, newHistory, newPreviousArchivedEventQueueIdx);
                    }
                }, (ExecutionContext)Riak.getExecutionContext()).flatMap((Function1)new Mapper<EventQueueEntity, Future<EventQueueEntity>>(){

                    public Future<EventQueueEntity> apply(final EventQueueEntity newEntity) {
                        return RiakCommon.storeEntity(newEntity, token).flatMap((Function1)new Mapper<Void, Future<EventQueueEntity>>(){

                            public Future<EventQueueEntity> apply(Void parameter) {
                                return Futures.successful((Object)newEntity);
                            }
                        }, Riak.getExecutionContext());
                    }
                }, Riak.getExecutionContext());
            }
        }, Riak.getExecutionContext());
        return newEntityFuture.andThen((PartialFunction)new OnComplete<EventQueueEntity>(){

            public void onComplete(Throwable throwable, EventQueueEntity eventQueueEntity) throws Throwable {
                monitor.stop();
            }
        }, Riak.getExecutionContext());
    }
}

