/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;

public class ContextVO {
    @JsonProperty
    private String contextName;
    @JsonProperty
    private String rank;
    @JsonProperty
    private double score;
    @JsonProperty
    private long timestamp;

    @JsonCreator
    public ContextVO(@JsonProperty(value="contextName") String contextName, @JsonProperty(value="rank") String rank, @JsonProperty(value="score") double score) {
        this.contextName = contextName;
        this.rank = rank;
        this.score = score;
        this.timestamp = DateTime.now().getMillis();
    }

    public ContextVO(ContextVO source) {
        this.contextName = source.contextName;
        this.rank = source.rank;
        this.score = source.score;
        this.timestamp = DateTime.now().getMillis();
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getRank() {
        return this.rank;
    }

    public double getScore() {
        return this.score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextVO contextVO = (ContextVO)o;
        return this.contextName.equals(contextVO.contextName);
    }

    public int hashCode() {
        return this.contextName.hashCode();
    }

    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextVO contextVO = (ContextVO)o;
        if (this.score != contextVO.score) {
            return false;
        }
        if (!this.contextName.equals(contextVO.contextName)) {
            return false;
        }
        if (!this.rank.equals(contextVO.rank)) {
            return false;
        }
        return this.timestamp == contextVO.timestamp;
    }

    public ContextVO plus(ContextVO anotherContext) {
        if (!this.contextName.equals(anotherContext.contextName)) {
            throw new IllegalArgumentException("context name is not equals");
        }
        double finalScore = this.score + anotherContext.getScore();
        return new ContextVO(this.contextName, this.rank, finalScore);
    }

    public ContextVO applyPenalty(double penalty) {
        int finalScore = (int)((1.0 - penalty) * this.score);
        return new ContextVO(this.contextName, this.rank, finalScore);
    }
}

