/*
 * Decompiled with CFR 0.152.
 */
package calculator;

import constants.Contexts;
import constants.SocialNetworks;
import entities.common.ContextVO;
import entities.interfaces.Comment;
import entities.interfaces.Post;
import entities.interfaces.UserProfile;
import identity.Token;
import java.util.HashSet;
import java.util.Set;
import jmonitor.JMonitor;
import jmonitor.JMonitorFactory;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.DataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworksScoreCalculator {
    private static final Logger logger = LoggerFactory.getLogger(NetworksScoreCalculator.class);

    public static Set<ContextVO> calculateScores(String socialNetworkUserId, Set<UserProfile> friends, Set<UserProfile> subscribers, Set<Post> posts, SocialNetworks socialNetwork, Token token) {
        switch (socialNetwork) {
            case Facebook: {
                return NetworksScoreCalculator.calculateFacebookScores(socialNetworkUserId, friends, subscribers, posts, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ContextVO> calculateFacebookScores(String socialNetworkUserId, Set<UserProfile> friends, Set<UserProfile> subscribers, Set<Post> posts, Token token) {
        JMonitor monitor = JMonitorFactory.start((String)"DATA: NetworksScoreCalculator.calculateFacebookScores");
        try {
            HashSet<ContextVO> result = new HashSet<ContextVO>();
            double numberOfFriends = friends.size();
            NormalDistribution friendNormalDistribution = DataCache.getFriendsNormalDistribution(token);
            logger.debug("numberOfFriends : " + numberOfFriends);
            double numberOfSubscribers = subscribers.size();
            NormalDistribution subscribersNormalDistribution = DataCache.getSubscribersNormalDistribution(token);
            logger.debug("numberOfSubscribers : " + numberOfSubscribers);
            double friendsCumulativeProbability = friendNormalDistribution.cumulativeProbability(numberOfFriends);
            ContextVO tmpContext = new ContextVO(Contexts.friendsCumulativeProbability.name(), "defaultRank", friendsCumulativeProbability);
            result.add(tmpContext);
            double subscribersCumulativeProbability = subscribersNormalDistribution.cumulativeProbability(numberOfSubscribers);
            tmpContext = new ContextVO(Contexts.subscribersCumulativeProbability.name(), "defaultRank", subscribersCumulativeProbability);
            result.add(tmpContext);
            double breadthSubScore = 0.7 * friendsCumulativeProbability + 0.3 * subscribersCumulativeProbability;
            tmpContext = new ContextVO(Contexts.breadthSubScore.name(), "defaultRank", breadthSubScore);
            result.add(tmpContext);
            logger.debug("friendsCumulativeProbability : " + friendsCumulativeProbability);
            logger.debug("subscribersCumulativeProbability : " + subscribersCumulativeProbability);
            logger.debug("breadthSubScore : " + breadthSubScore);
            double numberOfPost = posts.size();
            NormalDistribution numberOfPostNormalDistribution = DataCache.getPostsNormalDistribution(token);
            logger.debug("numberOfPost : " + numberOfPost);
            double activitySubScore = numberOfPostNormalDistribution.cumulativeProbability(numberOfPost);
            tmpContext = new ContextVO(Contexts.activitySubScore.name(), "defaultRank", activitySubScore);
            result.add(tmpContext);
            logger.debug("activityScore : " + activitySubScore);
            double othersCommentOnUserPost = 0.0;
            double othersLikesOnUserPost = 0.0;
            double othersLikesOnUserComment = 0.0;
            for (Post eachPost : posts) {
                othersLikesOnUserPost += (double)eachPost.getLikes();
                for (Comment eachComment : eachPost.getComments()) {
                    if (eachComment.getFromId().equals(socialNetworkUserId)) {
                        othersLikesOnUserComment += (double)eachComment.getLikes();
                        continue;
                    }
                    othersCommentOnUserPost += 1.0;
                }
            }
            NormalDistribution othersCommentOnUserPostNormalDistribution = DataCache.getOtherCommentsOnUserPostNormalDistribution(token);
            NormalDistribution othersLikesOnUserPostNormalDistribution = DataCache.getOtherLikesOnUserPostNormalDistribution(token);
            NormalDistribution othersLikesOnUserCommentNormalDistribution = DataCache.getOtherLikesOnUserCommentsNormalDistribution(token);
            logger.debug("othersLikesOnUserPost : " + othersLikesOnUserPost);
            logger.debug("othersCommentOnUserPost : " + othersCommentOnUserPost);
            logger.debug("othersLikesOnUserComment : " + othersLikesOnUserComment);
            double othersCommentOnUserPostCumulativeProbability = othersCommentOnUserPostNormalDistribution.cumulativeProbability(othersCommentOnUserPost);
            tmpContext = new ContextVO(Contexts.othersCommentOnUserPostCumulativeProbability.name(), "defaultRank", othersCommentOnUserPostCumulativeProbability);
            result.add(tmpContext);
            double othersLikesOnUserPostCumulativeProbability = othersLikesOnUserPostNormalDistribution.cumulativeProbability(othersLikesOnUserPost);
            tmpContext = new ContextVO(Contexts.othersLikesOnUserPostCumulativeProbability.name(), "defaultRank", othersLikesOnUserPostCumulativeProbability);
            result.add(tmpContext);
            double othersLikesOnUserCommentCumulativeProbability = othersLikesOnUserCommentNormalDistribution.cumulativeProbability(othersLikesOnUserComment);
            tmpContext = new ContextVO(Contexts.othersLikesOnUserCommentCumulativeProbability.name(), "defaultRank", othersLikesOnUserCommentCumulativeProbability);
            result.add(tmpContext);
            double authoritySubScore = 0.6 * othersCommentOnUserPostCumulativeProbability + 0.2 * othersLikesOnUserPostCumulativeProbability + 0.2 * othersLikesOnUserCommentCumulativeProbability;
            tmpContext = new ContextVO(Contexts.authoritySubScore.name(), "defaultRank", authoritySubScore);
            result.add(tmpContext);
            logger.debug("othersCommentOnUserPostCumulativeProbability : " + othersCommentOnUserPostCumulativeProbability);
            logger.debug("othersLikesOnUserPostCumulativeProbability : " + othersLikesOnUserPostCumulativeProbability);
            logger.debug("othersLikesOnUserCommentCumulativeProbability : " + othersLikesOnUserCommentCumulativeProbability);
            logger.debug("authoritySubScore : " + authoritySubScore);
            double dnaInfluence = 0.3 * (breadthSubScore * 100.0) + 0.3 * (activitySubScore * 100.0) + 0.4 * (authoritySubScore * 100.0);
            tmpContext = new ContextVO(Contexts.dnaInfluence.name(), "defaultRank", dnaInfluence);
            result.add(tmpContext);
            logger.debug("Calculate dnaInfluence using : 0.3 * (breadthSubScore * 100) + 0.3 * (activitySubScore * 100) + 0.4 * (authoritySubScore * 100)");
            logger.debug("dnaInfluence : " + dnaInfluence);
            int finalDnaInfluence = (int)dnaInfluence;
            logger.debug("Final dnaInfluence : " + finalDnaInfluence);
            ContextVO mainContext = new ContextVO(Contexts.MAIN.name(), "defaultRank", finalDnaInfluence);
            result.add(mainContext);
            HashSet<ContextVO> hashSet = result;
            return hashSet;
        }
        finally {
            monitor.stop();
        }
    }
}

