/*
 * Decompiled with CFR 0.152.
 */
package sqs.manage;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import identity.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sqs.base.model.BaseMessage;
import sqs.manage.Sqs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqsCommon {
    private static final Logger logger = LoggerFactory.getLogger(SqsCommon.class);

    public static <T extends BaseMessage> void putIntoQueue(List<T> messageList, Token token) {
        AmazonSQS sqs = Sqs.getSqsClient();
        String queueUrl = Sqs.getQueueUrl(((BaseMessage)messageList.get(0)).getClass());
        try {
            ArrayList<SendMessageBatchRequestEntry> entryList = new ArrayList<SendMessageBatchRequestEntry>();
            for (BaseMessage eachMessage : messageList) {
                SendMessageBatchRequestEntry entry = new SendMessageBatchRequestEntry(UUID.randomUUID().toString(), eachMessage.getBody());
                entryList.add(entry);
                if (entryList.size() != 10) continue;
                SendMessageBatchRequest sendMessageBatchRequest = new SendMessageBatchRequest(queueUrl, entryList);
                sqs.sendMessageBatch(sendMessageBatchRequest);
                entryList.clear();
            }
            if (!entryList.isEmpty()) {
                SendMessageBatchRequest sendMessageBatchRequest = new SendMessageBatchRequest(queueUrl, entryList);
                sqs.sendMessageBatch(sendMessageBatchRequest);
            }
        }
        catch (Throwable throwable) {
            Sqs.throwServiceException("Error during putIntoQueue", throwable, token);
        }
    }

    public static <T extends BaseMessage> void putIntoQueue(T message, Token token) {
        AmazonSQS sqs = Sqs.getSqsClient();
        String queueUrl = Sqs.getQueueUrl(message.getClass());
        try {
            SendMessageRequest sendMessageRequest = new SendMessageRequest(queueUrl, message.getBody());
            sqs.sendMessage(sendMessageRequest);
        }
        catch (Throwable throwable) {
            Sqs.throwServiceException("Error during putIntoQueue", throwable, token);
        }
    }

    public static <T extends BaseMessage> List<Message> fetchFromQueue(Class<T> clazz, Token token) {
        AmazonSQS sqs = Sqs.getSqsClient();
        String queueUrl = Sqs.getQueueUrl(clazz);
        try {
            ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(queueUrl);
            receiveMessageRequest.setMaxNumberOfMessages(Integer.valueOf(10));
            List messages = sqs.receiveMessage(receiveMessageRequest).getMessages();
            return messages;
        }
        catch (Throwable throwable) {
            Sqs.throwServiceException("Error during fetchFromQueue", throwable, token);
            return null;
        }
    }

    public static <T extends BaseMessage> void deleteFromQueue(List<Message> messageList, Class<T> clazz, Token token) {
        AmazonSQS sqs = Sqs.getSqsClient();
        String queueUrl = Sqs.getQueueUrl(clazz);
        try {
            ArrayList<DeleteMessageBatchRequestEntry> entryList = new ArrayList<DeleteMessageBatchRequestEntry>();
            for (Message eachMessage : messageList) {
                DeleteMessageBatchRequestEntry entry = new DeleteMessageBatchRequestEntry(UUID.randomUUID().toString(), eachMessage.getReceiptHandle());
                entryList.add(entry);
                if (entryList.size() != 10) continue;
                DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest(queueUrl, entryList);
                sqs.deleteMessageBatch(deleteMessageBatchRequest);
                entryList.clear();
            }
            if (!entryList.isEmpty()) {
                DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest(queueUrl, entryList);
                sqs.deleteMessageBatch(deleteMessageBatchRequest);
            }
        }
        catch (Throwable throwable) {
            Sqs.throwServiceException("Error during deleteFromQueue", throwable, token);
        }
    }

    public static <T extends BaseMessage> void deleteFromQueue(Message message, Class<T> clazz, Token token) {
        AmazonSQS sqs = Sqs.getSqsClient();
        String queueUrl = Sqs.getQueueUrl(clazz);
        try {
            DeleteMessageRequest deleteMessageRequest = new DeleteMessageRequest(queueUrl, message.getReceiptHandle());
            sqs.deleteMessage(deleteMessageRequest);
        }
        catch (Throwable throwable) {
            Sqs.throwServiceException("Error during deleteFromQueue", throwable, token);
        }
    }
}

