/*
 * Decompiled with CFR 0.152.
 */
package sqs.manage;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import exceptions.ServiceException;
import identity.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sqs.annotation.SqsMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sqs {
    private static final Logger logger = LoggerFactory.getLogger(Sqs.class);
    private static AmazonSQS sqs;
    private static String environmentName;
    private static Set<String> existingQueueUrls;
    private static Map<String, String> queueUrlMapping;

    public static AmazonSQS getSqsClient() {
        Sqs.isInitialized();
        return sqs;
    }

    public static void initialize(String envName, String regionName) {
        logger.info("Initialize SQS with env name : " + envName + " and region : " + regionName);
        try {
            sqs = new AmazonSQSClient((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider());
            Region region = Region.getRegion((Regions)Regions.valueOf((String)regionName));
            sqs.setRegion(region);
            environmentName = envName;
        }
        catch (Throwable throwable) {
            throw new ServiceException("SQS has not been initialized correctly", throwable, null);
        }
        existingQueueUrls = Sqs.fetchExistingQueue(environmentName);
        queueUrlMapping = new HashMap<String, String>();
    }

    private static Set<String> fetchExistingQueue(String envName) {
        HashSet<String> urlSet = new HashSet<String>();
        try {
            for (String queueUrl : sqs.listQueues().getQueueUrls()) {
                if (!queueUrl.contains(envName + "-")) continue;
                urlSet.add(queueUrl);
            }
            return urlSet;
        }
        catch (RuntimeException ex) {
            Sqs.throwServiceException("Error while fetchExistingQueue with env : " + envName, ex, null);
            return null;
        }
    }

    private static void isInitialized() {
        if (sqs == null || environmentName == null || queueUrlMapping == null) {
            throw new ServiceException("SQS has not been initialized correctly", null);
        }
    }

    private static String findUrlForQueue(String queueName) {
        Sqs.isInitialized();
        for (String eachUrl : existingQueueUrls) {
            if (!eachUrl.contains(queueName)) continue;
            return eachUrl;
        }
        return null;
    }

    public static <T> void addSqsMessageClass(Class<T> clazz) {
        logger.info("Add sqs message class : " + clazz.getName());
        Sqs.isInitialized();
        if (clazz.getAnnotation(SqsMessage.class) == null) {
            throw new ServiceException(clazz.getName() + " is not the sqs message", null);
        }
        String queue = clazz.getAnnotation(SqsMessage.class).queueName();
        String existingUrl = Sqs.findUrlForQueue(queue);
        if (existingUrl != null) {
            queueUrlMapping.put(queue, existingUrl);
            return;
        }
        String finalQueueName = environmentName + "-" + queue;
        String queueUrl = Sqs.createQueue(finalQueueName);
        queueUrlMapping.put(queue, queueUrl);
    }

    private static String createQueue(String finalQueueName) {
        logger.info("createQueue : " + finalQueueName);
        Sqs.isInitialized();
        try {
            CreateQueueRequest createQueueRequest = new CreateQueueRequest(finalQueueName);
            String myQueueUrl = sqs.createQueue(createQueueRequest).getQueueUrl();
            return myQueueUrl;
        }
        catch (RuntimeException ex) {
            Sqs.throwServiceException("Error during createQueue : " + finalQueueName, ex, null);
            return null;
        }
    }

    public static <T> String getQueueUrl(Class<T> clazz) {
        Sqs.isInitialized();
        if (clazz.getAnnotation(SqsMessage.class) == null) {
            throw new ServiceException(clazz.getName() + " is not the sqs message", null);
        }
        String queue = clazz.getAnnotation(SqsMessage.class).queueName();
        String url = queueUrlMapping.get(queue);
        if (url == null) {
            throw new ServiceException(clazz.getName() + " was not properly added", null);
        }
        return url;
    }

    public static void throwServiceException(String title, Throwable source, Token token) {
        if (source instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)source;
            StringBuilder errorBuilder = new StringBuilder(title);
            errorBuilder.append(" : ");
            errorBuilder.append("Caught an AmazonServiceException, which means your request made it ");
            errorBuilder.append("to AWS, but was rejected with an error response for some reason.");
            errorBuilder.append("Error Message:");
            errorBuilder.append(ase.getMessage());
            errorBuilder.append(" ");
            errorBuilder.append("HTTP Status Code:");
            errorBuilder.append(ase.getStatusCode());
            errorBuilder.append(" ");
            errorBuilder.append("AWS Error Code:");
            errorBuilder.append(ase.getErrorCode());
            errorBuilder.append(" ");
            errorBuilder.append("Error Type:");
            errorBuilder.append(ase.getErrorType());
            errorBuilder.append(" ");
            errorBuilder.append("Request ID:");
            errorBuilder.append(ase.getRequestId());
            throw new ServiceException(errorBuilder.toString(), (Throwable)ase, token != null ? token.getAccountId() : null);
        }
        if (source instanceof AmazonClientException) {
            AmazonClientException ace = (AmazonClientException)source;
            StringBuilder errorBuilder = new StringBuilder(title);
            errorBuilder.append(" : ");
            errorBuilder.append("aught an AmazonClientException, which means the client encountered ");
            errorBuilder.append("a serious internal problem while trying to communicate with AWS, ");
            errorBuilder.append("such as not being able to access the network.");
            errorBuilder.append("Error Message:");
            errorBuilder.append(ace.getMessage());
            throw new ServiceException(errorBuilder.toString(), (Throwable)ace, token != null ? token.getAccountId() : null);
        }
        throw new ServiceException("", source, null);
    }
}

