/*
 * Decompiled with CFR 0.152.
 */
package sqs.helpers;

import org.joda.time.LocalDateTime;
import sqs.annotation.SqsMessage;
import sqs.base.model.BaseMessage;

@SqsMessage(queueName="error-log")
public class ErrorMessage
implements BaseMessage {
    private final String httpErrorCode;
    private final String reasonCode;
    private final String errorMessage;
    private final String accountId;
    private final String time;

    public ErrorMessage(String httpErrorCode, String reasonCode, String errorMessage, String accountId) {
        this.httpErrorCode = httpErrorCode;
        this.reasonCode = reasonCode;
        this.errorMessage = errorMessage;
        this.accountId = accountId;
        this.time = LocalDateTime.now().toString();
    }

    public String getBody() {
        StringBuilder bodyBuilder = new StringBuilder("{");
        bodyBuilder.append(this.strPair("httpErrorCode", this.httpErrorCode));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("reasonCode", this.reasonCode));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("errorMessage", this.errorMessage));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("accountId", this.accountId));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("accountId", this.accountId));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("time", this.time));
        bodyBuilder.append("}");
        return bodyBuilder.toString();
    }

    private String strPair(String name, String value) {
        StringBuilder builder = new StringBuilder("\"");
        builder.append(name);
        builder.append("\":\"");
        builder.append(value);
        builder.append("\"");
        return builder.toString();
    }
}

