/*
 * Decompiled with CFR 0.152.
 */
package sqs.helpers;

import org.joda.time.LocalDateTime;
import sqs.annotation.SqsMessage;
import sqs.base.model.BaseMessage;

@SqsMessage(queueName="audit-log")
public class AuditMessage
implements BaseMessage {
    private final String className;
    private final String methodName;
    private final String state;
    private final String message;
    private final String accountId;
    private final String time;

    public AuditMessage(String className, String methodName, String state, String message, String accountId) {
        this.className = className;
        this.methodName = methodName;
        this.state = state;
        this.message = message;
        this.accountId = accountId;
        this.time = LocalDateTime.now().toString();
    }

    public String getBody() {
        StringBuilder bodyBuilder = new StringBuilder("{");
        bodyBuilder.append(this.strPair("className", this.className));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("methodName", this.methodName));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("state", this.state));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("message", this.message));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("accountId", this.accountId));
        bodyBuilder.append(",");
        bodyBuilder.append(this.strPair("time", this.time));
        bodyBuilder.append("}");
        return bodyBuilder.toString();
    }

    private String strPair(String name, String value) {
        StringBuilder builder = new StringBuilder("\"");
        builder.append(name);
        builder.append("\":\"");
        builder.append(value);
        builder.append("\"");
        return builder.toString();
    }
}

