/*
 * Decompiled with CFR 0.152.
 */
package util;

import constants.SocialNetworks;
import db.model.DnaUserProfileEntity;
import db.model.fb.FacebookProfileMetaInfo;
import db.model.fb.FacebookUserProfileEntity;
import db.model.vk.VkontakteProfileMetaInfo;
import db.model.vk.VkontakteUserProfileEntity;
import entities.interfaces.Comment;
import entities.interfaces.Post;
import entities.interfaces.UserState;
import java.util.HashSet;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapper {
    private static final Logger logger = LoggerFactory.getLogger(Mapper.class);

    public static FacebookProfileMetaInfo mapToFacebookProfileMetaInfo(UserState userState) {
        logger.info("mapToFacebookProfileMetaInfo : start");
        Integer othersCommentOnUserPost = 0;
        Integer othersLikesOnUserPost = 0;
        Integer othersLikesOnUserComment = 0;
        LocalDateTime updateDateTime = LocalDateTime.now();
        String accountId = userState.getMe().getId();
        Integer numberOfFriends = userState.getMe().getFriendCount();
        Integer numberOfSubscribers = userState.getSubscribers() != null ? userState.getSubscribers().size() : 0;
        Integer numberOfPost = userState.getPosts() != null ? userState.getPosts().size() : 0;
        if (userState.getPosts() != null && !userState.getPosts().isEmpty()) {
            for (Post eachPost : userState.getPosts()) {
                othersLikesOnUserPost = othersLikesOnUserPost + eachPost.getLikes();
                for (Comment eachComment : eachPost.getComments()) {
                    if (eachComment.getFromId().equals(accountId)) {
                        othersLikesOnUserComment = othersLikesOnUserComment + eachComment.getLikes();
                        continue;
                    }
                    Integer n = othersCommentOnUserPost;
                    Integer n2 = othersCommentOnUserPost = Integer.valueOf(othersCommentOnUserPost + 1);
                }
            }
        }
        return new FacebookProfileMetaInfo(accountId, numberOfFriends, numberOfSubscribers, numberOfPost, othersCommentOnUserPost, othersLikesOnUserPost, othersLikesOnUserComment, updateDateTime);
    }

    public static VkontakteProfileMetaInfo mapToVkontakteProfileMetaInfo(UserState userState) {
        logger.info("mapToVkontakteProfileMetaInfo : start");
        Integer othersCommentOnUserPost = 0;
        Integer othersLikesOnUserPost = 0;
        Integer othersLikesOnUserComment = 0;
        LocalDateTime updateDateTime = LocalDateTime.now();
        String accountId = userState.getMe().getId();
        Integer numberOfFriends = userState.getMe().getFriendCount();
        Integer numberOfSubscribers = userState.getSubscribers() != null ? userState.getSubscribers().size() : 0;
        Integer numberOfPost = userState.getPosts() != null ? userState.getPosts().size() : 0;
        if (userState.getPosts() != null && !userState.getPosts().isEmpty()) {
            for (Post eachPost : userState.getPosts()) {
                othersLikesOnUserPost = othersLikesOnUserPost + eachPost.getLikes();
                for (Comment eachComment : eachPost.getComments()) {
                    if (eachComment.getFromId().equals(accountId)) {
                        othersLikesOnUserComment = othersLikesOnUserComment + eachComment.getLikes();
                        continue;
                    }
                    Integer n = othersCommentOnUserPost;
                    Integer n2 = othersCommentOnUserPost = Integer.valueOf(othersCommentOnUserPost + 1);
                }
            }
        }
        return new VkontakteProfileMetaInfo(accountId, numberOfFriends, numberOfSubscribers, numberOfPost, othersCommentOnUserPost, othersLikesOnUserPost, othersLikesOnUserComment, updateDateTime);
    }

    public static FacebookUserProfileEntity mapToFacebookUserProfileEntity(UserState userState, String dnaAccountId) {
        logger.info("mapToFacebookProfileMetaInfo : start");
        String accountId = userState.getMe().getId();
        String name = userState.getMe().getName();
        String gender = userState.getMe().getGender();
        String locale = userState.getMe().getLocale();
        String email = userState.getMe().getEmail();
        String pictureUrl = userState.getMe().getPictureUrl();
        return new FacebookUserProfileEntity(accountId, name, gender, locale, email, pictureUrl, dnaAccountId);
    }

    public static VkontakteUserProfileEntity mapToVkontakteUserProfileEntity(UserState userState, String dnaAccountId) {
        logger.info("mapToVkontakteUserProfileEntity : start");
        String accountId = userState.getMe().getId();
        String name = userState.getMe().getName();
        String gender = userState.getMe().getGender();
        String locale = userState.getMe().getLocale();
        String email = userState.getMe().getEmail();
        String pictureUrl = userState.getMe().getPictureUrl();
        return new VkontakteUserProfileEntity(accountId, name, gender, locale, email, pictureUrl, dnaAccountId);
    }

    public static DnaUserProfileEntity createNewDnaUserProfileEntity(String dnaAccountId, UserState userState, Long scores, String level1accountId) {
        String name = userState.getMe().getName();
        String gender = userState.getMe().getGender();
        String locale = userState.getMe().getLocale();
        String email = userState.getMe().getEmail();
        String pictureUrl = userState.getMe().getPictureUrl();
        String fbAccountId = null;
        LocalDateTime timeWhenFbWasAttached = null;
        String vkAccountId = null;
        LocalDateTime timeWhenVkWasAttached = null;
        HashSet<String> level1ids = new HashSet<String>();
        Boolean fbActive = null;
        Boolean vkActive = null;
        SocialNetworks mainNetwork = null;
        if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook) {
            fbAccountId = userState.getMe().getId();
            timeWhenFbWasAttached = LocalDateTime.now();
            fbActive = Boolean.TRUE;
            mainNetwork = SocialNetworks.Facebook;
        } else if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte) {
            vkAccountId = userState.getMe().getId();
            timeWhenVkWasAttached = LocalDateTime.now();
            vkActive = Boolean.TRUE;
            mainNetwork = SocialNetworks.Vkontakte;
        }
        level1ids.add(level1accountId);
        return new DnaUserProfileEntity(dnaAccountId, name, gender, locale, email, pictureUrl, scores, fbAccountId, timeWhenFbWasAttached, fbActive, vkAccountId, timeWhenVkWasAttached, vkActive, LocalDateTime.now(), level1ids, mainNetwork);
    }
}

