/*
 * Decompiled with CFR 0.152.
 */
package services;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import calculator.DnaScoreCalculator;
import calculator.NetworksScoreCalculator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import constants.SocialNetworks;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import db.model.CounterEntity;
import db.model.DnaAccountIDBucketEntity;
import db.model.DnaFriendsEntity;
import db.model.DnaUserProfileEntity;
import db.model.DnaUserProfileHistoryEntity;
import db.model.Level1AccountEntity;
import db.model.SocialFriendsEntity;
import db.model.fb.FacebookFormulaArgumentsEntity;
import db.model.fb.FacebookInfluenceEntity;
import db.model.fb.FacebookProfileMetaInfo;
import db.model.fb.FacebookTokenEntity;
import db.model.fb.FacebookUserProfileEntity;
import db.model.vk.VkontakteFormulaArgumentsEntity;
import db.model.vk.VkontakteInfluenceEntity;
import db.model.vk.VkontakteProfileMetaInfo;
import db.model.vk.VkontakteTokenEntity;
import db.model.vk.VkontakteUserProfileEntity;
import entities.interfaces.UserState;
import exceptions.NetworkRegisterException;
import executors.BigBird;
import helpers.SocialGrabber;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import services.DnaAccountService;
import util.EventQueueBuilder;
import util.FriendsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistratorService {
    private static final Logger logger = LoggerFactory.getLogger(RegistratorService.class);
    public static final String USER_STATE_SOURCE = "USER_STATE_SOURCE";
    public static final String LEVEL1_ACCOUNT_SOURCE = "LEVEL1_ACCOUNT_SOURCE";
    public static final String FRIENDS_ONLY_SOURCE = "FRIENDS_ONLY_SOURCE";
    public static final String USER_STATE_SOURCE_BUT_WITH_UPDATED_TOKEN = "USER_STATE_SOURCE_BUT_WITH_UPDATED_TOKEN";
    private static final String ACCOUNT_CONTAINER_BASED_ON_USER_STATE = "ACCOUNT_CONTAINER_BASED_ON_USER_STATE";
    private static final String ACCOUNT_CONTAINER_BASED_ON_LEVEL1_ACCOUNT = "ACCOUNT_CONTAINER_BASED_ON_LEVEL1_ACCOUNT";
    private static final String WHAT_TO_DO = "WHAT_TO_DO";
    private static final String NEW_SOCIAL_ACCOUNT_ON_NEW_DEVICE = "New Social Account on new device";
    private static final String ATTACH_EXISTING_DNA_ACCOUNT_TO_NEW_DEVICE = "Attach existing DNA Account to new device";
    private static final String ATTACH_NEW_SOCIAL_ACCOUNT_TO_EXISTING_DNA_ACOUNT = "Attach new Social Account to existing DNA Account";
    private static final String JUST_UPDATE_ACCESS_TOKEN_AND_RETURN_EXISTING_DNA_ACCOUNT = "There is Level1Account with the same DNA Account, so just update access token for Social Network";
    private static final String MERGE_TWO_DIFFERENT_DNA_ACCOUNTS = "Merge two different Dna Accounts (one attached to Level1Account and another to UserState)";

    public static Future<DnaUserProfileEntity> addNetwork(final String socialNetworkAccessToken, final String numberOfSecondsUntilTokenExpire, final String refreshDate, final SocialNetworks socialNetwork, final Token token) {
        logger.info("addNetwork : start");
        Future<AccountContainer> fillContainerUsingUserStateFuture = RegistratorService.fillContainerUsingUserStateWithDnaFriendsOnly(socialNetworkAccessToken, socialNetwork, token);
        Future<AccountContainer> fillContainerUsingLevel1AccountFuture = RegistratorService.fillContainerUsingLevel1AccountWithDnaFriendsOnly(token);
        ArrayList futureList = Lists.newArrayList((Object[])new Future[]{fillContainerUsingLevel1AccountFuture, fillContainerUsingUserStateFuture});
        Future iterableFuture = Futures.sequence((Iterable)futureList, (ExecutionContext)BigBird.commonExecutionContext());
        return iterableFuture.flatMap((Function1)new Mapper<Iterable<AccountContainer>, Future<DnaUserProfileEntity>>(){

            public Future<DnaUserProfileEntity> apply(final Iterable<AccountContainer> accountContainers) {
                Future whatToDoFuture = Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        UserState userState;
                        AccountContainer accountContainerBasedOnUserState = null;
                        AccountContainer accountContainerBasedOnLevel1Account = null;
                        for (AccountContainer eachContainer : accountContainers) {
                            if (eachContainer.source.equals(RegistratorService.USER_STATE_SOURCE)) {
                                accountContainerBasedOnUserState = eachContainer;
                                continue;
                            }
                            if (!eachContainer.source.equals(RegistratorService.LEVEL1_ACCOUNT_SOURCE)) continue;
                            accountContainerBasedOnLevel1Account = eachContainer;
                        }
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put(RegistratorService.ACCOUNT_CONTAINER_BASED_ON_LEVEL1_ACCOUNT, accountContainerBasedOnLevel1Account);
                        resultMap.put(RegistratorService.ACCOUNT_CONTAINER_BASED_ON_USER_STATE, accountContainerBasedOnUserState);
                        if (accountContainerBasedOnLevel1Account.level1AccountEntity == null && accountContainerBasedOnUserState.dnaUserProfileEntity == null) {
                            logger.info("Result of fetching Level1Account and UserState : New Social Account on new device");
                            resultMap.put(RegistratorService.WHAT_TO_DO, RegistratorService.NEW_SOCIAL_ACCOUNT_ON_NEW_DEVICE);
                            return resultMap;
                        }
                        if (accountContainerBasedOnLevel1Account.level1AccountEntity == null && accountContainerBasedOnUserState.dnaUserProfileEntity != null) {
                            logger.info("Result of fetching Level1Account and UserState : Attach existing DNA Account to new device");
                            resultMap.put(RegistratorService.WHAT_TO_DO, RegistratorService.ATTACH_EXISTING_DNA_ACCOUNT_TO_NEW_DEVICE);
                            return resultMap;
                        }
                        if (accountContainerBasedOnLevel1Account.dnaUserProfileEntity != null && accountContainerBasedOnUserState.dnaUserProfileEntity == null) {
                            userState = accountContainerBasedOnUserState.userState;
                            if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook && accountContainerBasedOnLevel1Account.facebookUserProfileEntity != null && !accountContainerBasedOnLevel1Account.facebookUserProfileEntity.getAccountId().equals(userState.getMe().getId())) {
                                throw new NetworkRegisterException("User already registered Facebook account", token.getAccountId());
                            }
                            if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte && accountContainerBasedOnLevel1Account.vkontakteUserProfileEntity != null && !accountContainerBasedOnLevel1Account.vkontakteUserProfileEntity.getAccountId().equals(userState.getMe().getId())) {
                                throw new NetworkRegisterException("User already registered Vkontakte account", token.getAccountId());
                            }
                            logger.info("Result of fetching Level1Account and UserState : Attach new Social Account to existing DNA Account");
                            resultMap.put(RegistratorService.WHAT_TO_DO, RegistratorService.ATTACH_NEW_SOCIAL_ACCOUNT_TO_EXISTING_DNA_ACOUNT);
                            return resultMap;
                        }
                        if (accountContainerBasedOnLevel1Account.dnaUserProfileEntity != null && accountContainerBasedOnUserState.dnaUserProfileEntity != null && accountContainerBasedOnLevel1Account.dnaUserProfileEntity.getAccountId().equals(accountContainerBasedOnUserState.dnaUserProfileEntity.getAccountId())) {
                            logger.info("Result of fetching Level1Account and UserState : There is Level1Account with the same DNA Account, so just update access token for Social Network");
                            resultMap.put(RegistratorService.WHAT_TO_DO, RegistratorService.JUST_UPDATE_ACCESS_TOKEN_AND_RETURN_EXISTING_DNA_ACCOUNT);
                            return resultMap;
                        }
                        if (accountContainerBasedOnLevel1Account.dnaUserProfileEntity != null && accountContainerBasedOnUserState.dnaUserProfileEntity != null && !accountContainerBasedOnLevel1Account.dnaUserProfileEntity.getAccountId().equals(accountContainerBasedOnUserState.dnaUserProfileEntity.getAccountId())) {
                            logger.info("Result of fetching Level1Account and UserState : Merge two different Dna Accounts (one attached to Level1Account and another to UserState)");
                            userState = accountContainerBasedOnUserState.userState;
                            if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook && accountContainerBasedOnLevel1Account.facebookUserProfileEntity != null) {
                                throw new NetworkRegisterException("User already registered Facebook account", token.getAccountId());
                            }
                            if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte && accountContainerBasedOnLevel1Account.vkontakteUserProfileEntity != null) {
                                throw new NetworkRegisterException("User already registered Vkontakte account", token.getAccountId());
                            }
                            resultMap.put(RegistratorService.WHAT_TO_DO, RegistratorService.MERGE_TWO_DIFFERENT_DNA_ACCOUNTS);
                            return resultMap;
                        }
                        if (accountContainerBasedOnLevel1Account.dnaUserProfileEntity != null && accountContainerBasedOnUserState.dnaUserProfileEntity != null && accountContainerBasedOnLevel1Account.dnaUserProfileEntity.getAccountId().equals(accountContainerBasedOnUserState.dnaUserProfileEntity.getAccountId())) {
                            logger.info("Result of fetching Level1Account and UserState : There is Level1Account with the same DNA Account, so just update access token for Social Network");
                            resultMap.put(RegistratorService.WHAT_TO_DO, RegistratorService.JUST_UPDATE_ACCESS_TOKEN_AND_RETURN_EXISTING_DNA_ACCOUNT);
                            return resultMap;
                        }
                        throw new IllegalStateException("Error on first step : There is no logic for current state");
                    }
                }, (ExecutionContext)BigBird.commonExecutionContext());
                return whatToDoFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<DnaUserProfileEntity>>(){

                    public Future<DnaUserProfileEntity> apply(Map<String, Object> whatToDoMap) {
                        AccountContainer accountContainerBasedOnUserState = (AccountContainer)whatToDoMap.get(RegistratorService.ACCOUNT_CONTAINER_BASED_ON_USER_STATE);
                        AccountContainer accountContainerBasedOnLevel1Account = (AccountContainer)whatToDoMap.get(RegistratorService.ACCOUNT_CONTAINER_BASED_ON_LEVEL1_ACCOUNT);
                        String whatToDo = (String)whatToDoMap.get(RegistratorService.WHAT_TO_DO);
                        if (whatToDo.equals(RegistratorService.NEW_SOCIAL_ACCOUNT_ON_NEW_DEVICE)) {
                            return RegistratorService.createNewAccountOnNewDevice(accountContainerBasedOnUserState.userState, socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDate, token);
                        }
                        if (whatToDo.equals(RegistratorService.ATTACH_EXISTING_DNA_ACCOUNT_TO_NEW_DEVICE)) {
                            return RegistratorService.attachExistingDnaAccountToNewDevice(accountContainerBasedOnUserState, socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDate, token);
                        }
                        if (whatToDo.equals(RegistratorService.ATTACH_NEW_SOCIAL_ACCOUNT_TO_EXISTING_DNA_ACOUNT)) {
                            return RegistratorService.attachNewSocialAccountToExistingDnaAccount(accountContainerBasedOnUserState, accountContainerBasedOnLevel1Account, socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDate, token);
                        }
                        if (whatToDo.equals(RegistratorService.JUST_UPDATE_ACCESS_TOKEN_AND_RETURN_EXISTING_DNA_ACCOUNT)) {
                            SocialNetworks network = SocialNetworks.valueOf((String)accountContainerBasedOnUserState.getUserState().getMe().getSocialNetworkName());
                            if (network == SocialNetworks.Facebook && !accountContainerBasedOnUserState.getDnaUserProfileEntity().isFbActive().booleanValue() || socialNetwork == SocialNetworks.Vkontakte && !accountContainerBasedOnUserState.getDnaUserProfileEntity().isVkActive().booleanValue()) {
                                return RegistratorService.updateAccessTokenMarkSocialNetworkActiveInDnaAccountAndReturnDnaAccount(accountContainerBasedOnUserState, socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDate, token).flatMap((Function1)new Mapper<AccountContainer, Future<DnaUserProfileEntity>>(){

                                    public Future<DnaUserProfileEntity> apply(final AccountContainer accountContainer) {
                                        return Futures.future((Callable)new Callable<DnaUserProfileEntity>(){

                                            @Override
                                            public DnaUserProfileEntity call() throws Exception {
                                                return accountContainer.dnaUserProfileEntity;
                                            }
                                        }, (ExecutionContext)BigBird.commonExecutionContext());
                                    }
                                }, BigBird.commonExecutionContext());
                            }
                            return RegistratorService.justUpdateAccessTokenAndReturnDnaAccount(accountContainerBasedOnUserState, socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDate, token).flatMap((Function1)new Mapper<AccountContainer, Future<DnaUserProfileEntity>>(){

                                public Future<DnaUserProfileEntity> apply(final AccountContainer accountContainer) {
                                    return Futures.future((Callable)new Callable<DnaUserProfileEntity>(){

                                        @Override
                                        public DnaUserProfileEntity call() throws Exception {
                                            return accountContainer.dnaUserProfileEntity;
                                        }
                                    }, (ExecutionContext)BigBird.commonExecutionContext());
                                }
                            }, BigBird.commonExecutionContext());
                        }
                        if (whatToDo.equals(RegistratorService.MERGE_TWO_DIFFERENT_DNA_ACCOUNTS)) {
                            return RegistratorService.mergeTwoDifferentDnaAccounts(accountContainerBasedOnUserState, accountContainerBasedOnLevel1Account, socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDate, token);
                        }
                        throw new IllegalStateException("Error on first step : There is no logic for current state");
                    }
                }, BigBird.commonExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<DnaUserProfileEntity> mergeTwoDifferentDnaAccounts(final AccountContainer containerBasedOnUserState, final AccountContainer containerBasedOnLevel1Account, String socialNetworkAccessToken, String numberOfSecondsUntilTokenExpire, String refreshDateAsString, final Token token) {
        logger.info("mergeTwoDifferentDnaAccounts : start");
        logger.info("mergeTwoDifferentDnaAccounts : first update access token");
        final SocialNetworks networkToRemap = SocialNetworks.valueOf((String)containerBasedOnUserState.userState.getSocialNetworkName());
        Future<AccountContainer> updatedContainerBasedOnUserStateFuture = RegistratorService.justUpdateAccessTokenAndReturnDnaAccount(containerBasedOnUserState, socialNetworkAccessToken, numberOfSecondsUntilTokenExpire, refreshDateAsString, token);
        Future fullAccountContainerBasedOnUserStateFuture = Futures.future((Callable)new Callable<AccountContainer>(){

            @Override
            public AccountContainer call() throws Exception {
                return DnaAccountService.fillContainerWithAllInfoBasedOnDnaAccountInIt(containerBasedOnUserState, true, token);
            }
        }, (ExecutionContext)BigBird.awsExecutionContext());
        Future fullAccountContainerBasedOnLevel1Future = Futures.future((Callable)new Callable<AccountContainer>(){

            @Override
            public AccountContainer call() throws Exception {
                return DnaAccountService.fillContainerWithAllInfoBasedOnDnaAccountInIt(containerBasedOnLevel1Account, false, token);
            }
        }, (ExecutionContext)BigBird.awsExecutionContext());
        ArrayList futureList = Lists.newArrayList((Object[])new Future[]{updatedContainerBasedOnUserStateFuture, fullAccountContainerBasedOnUserStateFuture, fullAccountContainerBasedOnLevel1Future});
        Future iterableFuture = Futures.sequence((Iterable)futureList, (ExecutionContext)BigBird.awsExecutionContext());
        Future remapFuture = iterableFuture.flatMap((Function1)new Mapper<Iterable<AccountContainer>, Future<DnaUserProfileEntity>>(){

            public Future<DnaUserProfileEntity> apply(final Iterable<AccountContainer> containers) {
                return Futures.future((Callable)new Callable<DnaUserProfileEntity>(){

                    @Override
                    public DnaUserProfileEntity call() throws Exception {
                        AccountContainer fullAccountContainerBasedOnUserState = null;
                        AccountContainer fullAccountContainerBasedOnLevel1 = null;
                        for (AccountContainer eachContainer : containers) {
                            if (eachContainer.getSource().equals(RegistratorService.USER_STATE_SOURCE)) {
                                fullAccountContainerBasedOnUserState = eachContainer;
                                continue;
                            }
                            if (!eachContainer.getSource().equals(RegistratorService.LEVEL1_ACCOUNT_SOURCE)) continue;
                            fullAccountContainerBasedOnLevel1 = eachContainer;
                        }
                        Map<String, AccountContainer> friendsContainer = DnaAccountService.createContainerWithFriendsOnlyRelatedToSocialNetwork(fullAccountContainerBasedOnUserState, networkToRemap, token);
                        friendsContainer.put(fullAccountContainerBasedOnLevel1.getSource(), fullAccountContainerBasedOnLevel1);
                        AccountContainer containerWithResult = DnaAccountService.remapAccountFromBasedOnUserStateToBasedOnLevel1(friendsContainer, networkToRemap, token);
                        return containerWithResult.dnaUserProfileEntity;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
        return remapFuture;
    }

    private static DateTimeFormatter getFormatter() {
        return DateTimeFormat.forPattern((String)"yyyy'-'MM'-'dd' 'HH':'mm':'ss' 'Z");
    }

    public static Future<DnaUserProfileEntity> createNewAccountOnNewDevice(final UserState userState, final String socialNetworkAccessToken, final String numberOfSecondsUntilTokenExpire, final String refreshDateAsString, final Token token) {
        logger.info("createNewAccountOnNewDevice : start");
        final String dnaAccountId = SocialNetworks.valueOf((String)userState.getSocialNetworkName()).getTableIdPrefix() + userState.getMe().getId();
        Future<List<Object>> friendsListFuture = FriendsUtil.devideFriends(userState, dnaAccountId, token);
        return friendsListFuture.flatMap((Function1)new Mapper<List<Object>, Future<DnaUserProfileEntity>>(){

            public Future<DnaUserProfileEntity> apply(final List<Object> mixedFriendList) {
                return Futures.future((Callable)new Callable<DnaUserProfileEntity>(){

                    @Override
                    public DnaUserProfileEntity call() throws Exception {
                        LocalDateTime timeWhenTokenWillBeExpired = numberOfSecondsUntilTokenExpire != null && !numberOfSecondsUntilTokenExpire.equals("0") ? LocalDateTime.now().plusSeconds(Integer.parseInt(numberOfSecondsUntilTokenExpire)) : null;
                        LocalDateTime refreshDateTime = null;
                        if (refreshDateAsString != null && !refreshDateAsString.isEmpty()) {
                            try {
                                refreshDateTime = LocalDateTime.parse((String)refreshDateAsString, (DateTimeFormatter)RegistratorService.getFormatter());
                            }
                            catch (Exception ex) {
                                logger.error("createNewAccountOnNewDevice : Error when parse refresh date : " + refreshDateAsString, (Throwable)ex);
                            }
                        }
                        HashMap tableKeyMap = new HashMap();
                        ArrayList<SocialFriendsEntity> socialFriendsEntities = new ArrayList<SocialFriendsEntity>();
                        ArrayList<DnaFriendsEntity> dnaFriendsEntities = new ArrayList<DnaFriendsEntity>();
                        for (Object eachFriend : mixedFriendList) {
                            if (eachFriend instanceof SocialFriendsEntity) {
                                socialFriendsEntities.add((SocialFriendsEntity)eachFriend);
                                continue;
                            }
                            if (!(eachFriend instanceof DnaUserProfileEntity)) continue;
                            DnaUserProfileEntity friendProfile = (DnaUserProfileEntity)eachFriend;
                            DnaFriendsEntity dnaFriendsEntity = new DnaFriendsEntity(dnaAccountId, friendProfile.getAccountId(), friendProfile.getScores(), friendProfile.getName(), friendProfile.getGender(), friendProfile.getLocale(), friendProfile.getEmail(), friendProfile.getPictureUrl(), friendProfile.getTimeWhenAccountWasCreated());
                            dnaFriendsEntities.add(dnaFriendsEntity);
                        }
                        if (!socialFriendsEntities.isEmpty()) {
                            logger.info("createNewAccountOnNewDevice : first save SocialFriendsEntity's");
                            SocialFriendsEntity.saveList(socialFriendsEntities, (Token)token);
                        }
                        if (!dnaFriendsEntities.isEmpty()) {
                            logger.info("createNewAccountOnNewDevice : next save DnaFriendsEntity's");
                            DnaFriendsEntity.saveList(dnaFriendsEntities, (Token)token);
                        }
                        DnaUserProfileEntity dnaUserProfileEntity = null;
                        if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook) {
                            logger.info("createNewAccountOnNewDevice : create all entities based on Facebook profile");
                            String fbAccountId = userState.getMe().getId();
                            FacebookFormulaArgumentsEntity facebookFormulaArgumentsEntity = FacebookFormulaArgumentsEntity.fetch((Token)token);
                            FacebookProfileMetaInfo facebookProfileMetaInfo = util.Mapper.mapToFacebookProfileMetaInfo(userState);
                            FacebookInfluenceEntity facebookInfluenceEntity = NetworksScoreCalculator.calculateFbInfluence((FacebookProfileMetaInfo)facebookProfileMetaInfo, (FacebookFormulaArgumentsEntity)facebookFormulaArgumentsEntity);
                            FacebookUserProfileEntity facebookUserProfileEntity = util.Mapper.mapToFacebookUserProfileEntity(userState, dnaAccountId);
                            FacebookTokenEntity facebookTokenEntity = new FacebookTokenEntity(fbAccountId, socialNetworkAccessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now());
                            String level1accountId = token.getAccountId();
                            Level1AccountEntity level1AccountEntity = new Level1AccountEntity(level1accountId, dnaAccountId);
                            ArrayList<FacebookInfluenceEntity> listInfluences = new ArrayList<FacebookInfluenceEntity>();
                            listInfluences.add(facebookInfluenceEntity);
                            Double scores = DnaScoreCalculator.calculateDnaScores(listInfluences);
                            dnaUserProfileEntity = util.Mapper.createNewDnaUserProfileEntity(dnaAccountId, userState, scores.longValue(), level1accountId);
                            String facebookProfileMetaInfoTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
                            String facebookInfluenceEntityTableName = Dynamo.getFinalTableName(FacebookInfluenceEntity.class);
                            String facebookUserProfileEntityTableName = Dynamo.getFinalTableName(FacebookUserProfileEntity.class);
                            String facebookTokenEntityTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
                            String level1AccountEntityTableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
                            String dnaUserProfileEntityTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
                            ArrayList<Map> facebookProfileMetaInfoItems = new ArrayList<Map>();
                            facebookProfileMetaInfoItems.add(facebookProfileMetaInfo.toAttributeMap());
                            tableKeyMap.put(facebookProfileMetaInfoTableName, facebookProfileMetaInfoItems);
                            ArrayList<Map> facebookInfluenceEntityItems = new ArrayList<Map>();
                            facebookInfluenceEntityItems.add(facebookInfluenceEntity.toAttributeMap());
                            tableKeyMap.put(facebookInfluenceEntityTableName, facebookInfluenceEntityItems);
                            ArrayList<Map> facebookUserProfileEntityItems = new ArrayList<Map>();
                            facebookUserProfileEntityItems.add(facebookUserProfileEntity.toAttributeMap());
                            tableKeyMap.put(facebookUserProfileEntityTableName, facebookUserProfileEntityItems);
                            ArrayList<Map> facebookTokenEntityItems = new ArrayList<Map>();
                            facebookTokenEntityItems.add(facebookTokenEntity.toAttributeMap());
                            tableKeyMap.put(facebookTokenEntityTableName, facebookTokenEntityItems);
                            ArrayList<Map> level1AccountEntityItems = new ArrayList<Map>();
                            level1AccountEntityItems.add(level1AccountEntity.toAttributeMap());
                            tableKeyMap.put(level1AccountEntityTableName, level1AccountEntityItems);
                            ArrayList<Map> dnaUserProfileEntityItems = new ArrayList<Map>();
                            dnaUserProfileEntityItems.add(dnaUserProfileEntity.toAttributeMap());
                            tableKeyMap.put(dnaUserProfileEntityTableName, dnaUserProfileEntityItems);
                        } else if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte) {
                            logger.info("createNewAccountOnNewDevice : create all entities based on Vkontakte profile");
                            String vkAccountId = userState.getMe().getId();
                            VkontakteFormulaArgumentsEntity vkotakteFormulaArgumentsEntity = VkontakteFormulaArgumentsEntity.fetch((Token)token);
                            VkontakteProfileMetaInfo vkontakteProfileMetaInfo = util.Mapper.mapToVkontakteProfileMetaInfo(userState);
                            VkontakteInfluenceEntity vkontakteInfluenceEntity = NetworksScoreCalculator.calculateVkInfluence((VkontakteProfileMetaInfo)vkontakteProfileMetaInfo, (VkontakteFormulaArgumentsEntity)vkotakteFormulaArgumentsEntity);
                            VkontakteUserProfileEntity vkontakteUserProfileEntity = util.Mapper.mapToVkontakteUserProfileEntity(userState, dnaAccountId);
                            VkontakteTokenEntity vkontakteTokenEntity = new VkontakteTokenEntity(vkAccountId, socialNetworkAccessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now());
                            String level1accountId = token.getAccountId();
                            Level1AccountEntity level1AccountEntity = new Level1AccountEntity(level1accountId, dnaAccountId);
                            ArrayList<VkontakteInfluenceEntity> listInfluences = new ArrayList<VkontakteInfluenceEntity>();
                            listInfluences.add(vkontakteInfluenceEntity);
                            Double scores = DnaScoreCalculator.calculateDnaScores(listInfluences);
                            dnaUserProfileEntity = util.Mapper.createNewDnaUserProfileEntity(dnaAccountId, userState, scores.longValue(), level1accountId);
                            String vkontakteProfileMetaInfoTableName = Dynamo.getFinalTableName(VkontakteProfileMetaInfo.class);
                            String vkontakteInfluenceEntityTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
                            String vkontakteUserProfileEntityTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
                            String vkontakteTokenEntityTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
                            String level1AccountEntityTableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
                            String dnaUserProfileEntityTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
                            ArrayList<Map> vkontakteProfileMetaInfoItems = new ArrayList<Map>();
                            vkontakteProfileMetaInfoItems.add(vkontakteProfileMetaInfo.toAttributeMap());
                            tableKeyMap.put(vkontakteProfileMetaInfoTableName, vkontakteProfileMetaInfoItems);
                            ArrayList<Map> vkontakteInfluenceEntityItems = new ArrayList<Map>();
                            vkontakteInfluenceEntityItems.add(vkontakteInfluenceEntity.toAttributeMap());
                            tableKeyMap.put(vkontakteInfluenceEntityTableName, vkontakteInfluenceEntityItems);
                            ArrayList<Map> vkontakteUserProfileEntityItems = new ArrayList<Map>();
                            vkontakteUserProfileEntityItems.add(vkontakteUserProfileEntity.toAttributeMap());
                            tableKeyMap.put(vkontakteUserProfileEntityTableName, vkontakteUserProfileEntityItems);
                            ArrayList<Map> vkontakteTokenEntityItems = new ArrayList<Map>();
                            vkontakteTokenEntityItems.add(vkontakteTokenEntity.toAttributeMap());
                            tableKeyMap.put(vkontakteTokenEntityTableName, vkontakteTokenEntityItems);
                            ArrayList<Map> level1AccountEntityItems = new ArrayList<Map>();
                            level1AccountEntityItems.add(level1AccountEntity.toAttributeMap());
                            tableKeyMap.put(level1AccountEntityTableName, level1AccountEntityItems);
                            ArrayList<Map> dnaUserProfileEntityItems = new ArrayList<Map>();
                            dnaUserProfileEntityItems.add(dnaUserProfileEntity.toAttributeMap());
                            tableKeyMap.put(dnaUserProfileEntityTableName, dnaUserProfileEntityItems);
                        }
                        String dnaUserProfileHistoryEntityTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
                        DnaUserProfileHistoryEntity dnaUserProfileHistoryEntity = new DnaUserProfileHistoryEntity(dnaUserProfileEntity);
                        ArrayList<Map> dnaUserProfileHistoryEntityItems = new ArrayList<Map>();
                        dnaUserProfileHistoryEntityItems.add(dnaUserProfileHistoryEntity.toAttributeMap());
                        tableKeyMap.put(dnaUserProfileHistoryEntityTableName, dnaUserProfileHistoryEntityItems);
                        logger.info("createNewAccountOnNewDevice : make batchWrite request");
                        DynamoCommon.batchWrite(tableKeyMap, (Token)token);
                        CounterEntity.nextGlobalCounter((String)"created-dna-accounts", (Token)token);
                        DnaAccountIDBucketEntity.addToBucket((String)dnaUserProfileEntity.getAccountId(), (Token)token);
                        logger.info("createNewAccountOnNewDevice : build event queue");
                        EventQueueBuilder.buildAndSaveEventQueue(null, null, dnaUserProfileEntity, dnaFriendsEntities, (Token)token);
                        return dnaUserProfileEntity;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<DnaUserProfileEntity> attachExistingDnaAccountToNewDevice(final AccountContainer containerBasedOnUserState, final String socialNetworkAccessToken, final String numberOfSecondsUntilTokenExpire, final String refreshDateAsString, final Token token) {
        logger.info("attachExistingDnaAccountToNewDevice : start");
        return Futures.future((Callable)new Callable<DnaUserProfileEntity>(){

            @Override
            public DnaUserProfileEntity call() throws Exception {
                Map item;
                String tableName;
                HashMap<String, ArrayList> tableKeyMap = new HashMap<String, ArrayList>();
                LocalDateTime timeWhenTokenWillBeExpired = numberOfSecondsUntilTokenExpire != null && !numberOfSecondsUntilTokenExpire.equals("0") ? LocalDateTime.now().plusSeconds(Integer.parseInt(numberOfSecondsUntilTokenExpire)) : null;
                LocalDateTime refreshDateTime = null;
                if (refreshDateAsString != null && !refreshDateAsString.isEmpty()) {
                    try {
                        refreshDateTime = LocalDateTime.parse((String)refreshDateAsString, (DateTimeFormatter)RegistratorService.getFormatter());
                    }
                    catch (Exception ex) {
                        logger.error("attachExistingDnaAccountToNewDevice: Error when parse refresh date : " + refreshDateAsString, (Throwable)ex);
                    }
                }
                UserState userState = containerBasedOnUserState.userState;
                DnaUserProfileEntity oldDnaUserProfileEntity = containerBasedOnUserState.dnaUserProfileEntity;
                if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook) {
                    logger.info("attachExistingDnaAccountToNewDevice : lets update access token for Facebook account");
                    FacebookTokenEntity facebookTokenEntity = containerBasedOnUserState.facebookTokenEntity;
                    FacebookTokenEntity updatedFacebookTokenEntity = new FacebookTokenEntity(facebookTokenEntity.getAccountId(), socialNetworkAccessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now());
                    tableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
                    item = updatedFacebookTokenEntity.toAttributeMap();
                    tableKeyMap.put(tableName, Lists.newArrayList((Object[])new Map[]{item}));
                } else if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte) {
                    logger.info("attachExistingDnaAccountToNewDevice : lets update access token for Vkontakte account");
                    VkontakteTokenEntity vkontakteTokenEntity = containerBasedOnUserState.vkontakteTokenEntity;
                    VkontakteTokenEntity updatedVkontakteTokenEntity = new VkontakteTokenEntity(vkontakteTokenEntity.getAccountId(), socialNetworkAccessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now());
                    tableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
                    item = updatedVkontakteTokenEntity.toAttributeMap();
                    tableKeyMap.put(tableName, Lists.newArrayList((Object[])new Map[]{item}));
                }
                logger.info("attachExistingDnaAccountToNewDevice : link new Level1AccountEntity with DnaUserProfileEntity");
                HashSet<String> level1Ids = new HashSet<String>();
                level1Ids.addAll(oldDnaUserProfileEntity.getLevel1ids());
                level1Ids.add(token.getAccountId());
                DnaUserProfileEntity newDnaUserProfile = new DnaUserProfileEntity(oldDnaUserProfileEntity.getAccountId(), oldDnaUserProfileEntity.getName(), oldDnaUserProfileEntity.getGender(), oldDnaUserProfileEntity.getLocale(), oldDnaUserProfileEntity.getEmail(), oldDnaUserProfileEntity.getPictureUrl(), oldDnaUserProfileEntity.getScores(), oldDnaUserProfileEntity.getFbAccountId(), oldDnaUserProfileEntity.getTimeWhenFbWasAttached(), oldDnaUserProfileEntity.isFbActive(), oldDnaUserProfileEntity.getVkAccountId(), oldDnaUserProfileEntity.getTimeWhenVkWasAttached(), oldDnaUserProfileEntity.isVkActive(), oldDnaUserProfileEntity.getTimeWhenAccountWasCreated(), level1Ids, oldDnaUserProfileEntity.getMainSocialNetwork());
                tableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
                item = newDnaUserProfile.toAttributeMap();
                tableKeyMap.put(tableName, Lists.newArrayList((Object[])new Map[]{item}));
                logger.info("attachExistingDnaAccountToNewDevice : create new Level1AccountEntity");
                Level1AccountEntity newLevel1AccountEntity = new Level1AccountEntity(token.getAccountId(), newDnaUserProfile.getAccountId());
                tableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
                item = newLevel1AccountEntity.toAttributeMap();
                tableKeyMap.put(tableName, Lists.newArrayList((Object[])new Map[]{item}));
                logger.info("attachExistingDnaAccountToNewDevice : make batchWrite to save new Level1AccountEntity and updated TokenEntity");
                DynamoCommon.batchWrite(tableKeyMap, (Token)token);
                return newDnaUserProfile;
            }
        }, (ExecutionContext)BigBird.awsExecutionContext());
    }

    public static Future<AccountContainer> justUpdateAccessTokenAndReturnDnaAccount(final AccountContainer containerBasedOnUserState, final String socialNetworkAccessToken, final String numberOfSecondsUntilTokenExpire, final String refreshDateAsString, final Token token) {
        logger.info("justUpdateAccessTokenAndReturnDnaAccount : start");
        return Futures.future((Callable)new Callable<AccountContainer>(){

            @Override
            public AccountContainer call() throws Exception {
                AccountContainer result = containerBasedOnUserState;
                UserState userState = containerBasedOnUserState.userState;
                LocalDateTime timeWhenTokenWillBeExpired = numberOfSecondsUntilTokenExpire != null && !numberOfSecondsUntilTokenExpire.equals("0") ? LocalDateTime.now().plusSeconds(Integer.parseInt(numberOfSecondsUntilTokenExpire)) : null;
                LocalDateTime refreshDateTime = null;
                if (refreshDateAsString != null && !refreshDateAsString.isEmpty()) {
                    try {
                        refreshDateTime = LocalDateTime.parse((String)refreshDateAsString, (DateTimeFormatter)RegistratorService.getFormatter());
                    }
                    catch (Exception ex) {
                        logger.error("justUpdateAccessTokenAndReturnDnaAccount: Error when parse refresh date : " + refreshDateAsString, (Throwable)ex);
                    }
                }
                if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook) {
                    logger.info("justUpdateAccessTokenAndReturnDnaAccount : update FacebookTokenEntity");
                    FacebookTokenEntity newFacebookTokenEntity = FacebookTokenEntity.updateToken((String)userState.getMe().getId(), (String)socialNetworkAccessToken, (LocalDateTime)timeWhenTokenWillBeExpired, (LocalDateTime)refreshDateTime, (Token)token);
                    result = result.withFacebookTokenEntity(newFacebookTokenEntity);
                } else if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte) {
                    logger.info("justUpdateAccessTokenAndReturnDnaAccount : update VkontakteTokenEntity");
                    VkontakteTokenEntity newVkontakteTokenEntity = VkontakteTokenEntity.updateToken((String)userState.getMe().getId(), (String)socialNetworkAccessToken, (LocalDateTime)timeWhenTokenWillBeExpired, (LocalDateTime)refreshDateTime, (Token)token);
                    result = result.withVkontakteTokenEntity(newVkontakteTokenEntity);
                }
                logger.info("justUpdateAccessTokenAndReturnDnaAccount : return  AccountContainer with new token in it");
                return result.withSource(RegistratorService.USER_STATE_SOURCE_BUT_WITH_UPDATED_TOKEN);
            }
        }, (ExecutionContext)BigBird.awsExecutionContext());
    }

    public static Future<AccountContainer> updateAccessTokenMarkSocialNetworkActiveInDnaAccountAndReturnDnaAccount(final AccountContainer containerBasedOnUserState, final String socialNetworkAccessToken, final String numberOfSecondsUntilTokenExpire, final String refreshDateAsString, final Token token) {
        logger.info("updateAccessTokenMarkSocialNetworkActiveInDnaAccountAndReturnDnaAccount : start");
        return Futures.future((Callable)new Callable<AccountContainer>(){

            @Override
            public AccountContainer call() throws Exception {
                AccountContainer result = containerBasedOnUserState;
                UserState userState = containerBasedOnUserState.userState;
                LocalDateTime timeWhenTokenWillBeExpired = numberOfSecondsUntilTokenExpire != null && !numberOfSecondsUntilTokenExpire.equals("0") ? LocalDateTime.now().plusSeconds(Integer.parseInt(numberOfSecondsUntilTokenExpire)) : null;
                LocalDateTime refreshDateTime = null;
                if (refreshDateAsString != null && !refreshDateAsString.isEmpty()) {
                    try {
                        refreshDateTime = LocalDateTime.parse((String)refreshDateAsString, (DateTimeFormatter)RegistratorService.getFormatter());
                    }
                    catch (Exception ex) {
                        logger.error("updateAccessTokenMarkSocialNetworkActiveInDnaAccountAndReturnDnaAccount: Error when parse refresh date : " + refreshDateAsString, (Throwable)ex);
                    }
                }
                SocialNetworks network = SocialNetworks.valueOf((String)userState.getSocialNetworkName());
                HashMap tableItems = new HashMap();
                String dnaUserProfileTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
                String facebookTokenTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
                String vkontakteTokenTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
                DnaUserProfileEntity oldDnaUserProfileEntity = result.getDnaUserProfileEntity();
                ArrayList<Map> newDnaUserProfileList = new ArrayList<Map>();
                tableItems.put(dnaUserProfileTableName, newDnaUserProfileList);
                if (network == SocialNetworks.Facebook) {
                    logger.info("updateAccessTokenMarkSocialNetworkActiveInDnaAccountAndReturnDnaAccount : update FacebookTokenEntity and activate Facebook in DnaUserProfileEntity");
                    DnaUserProfileEntity newDnaUserProfileEntity = new DnaUserProfileEntity(oldDnaUserProfileEntity.getAccountId(), oldDnaUserProfileEntity.getName(), oldDnaUserProfileEntity.getGender(), oldDnaUserProfileEntity.getLocale(), oldDnaUserProfileEntity.getEmail(), oldDnaUserProfileEntity.getPictureUrl(), oldDnaUserProfileEntity.getScores(), oldDnaUserProfileEntity.getFbAccountId(), oldDnaUserProfileEntity.getTimeWhenFbWasAttached(), Boolean.TRUE, oldDnaUserProfileEntity.getVkAccountId(), oldDnaUserProfileEntity.getTimeWhenVkWasAttached(), oldDnaUserProfileEntity.isVkActive(), oldDnaUserProfileEntity.getTimeWhenAccountWasCreated(), oldDnaUserProfileEntity.getLevel1ids(), oldDnaUserProfileEntity.getMainSocialNetwork());
                    newDnaUserProfileList.add(newDnaUserProfileEntity.toAttributeMap());
                    FacebookTokenEntity newFacebookTokenEntity = new FacebookTokenEntity(userState.getMe().getId(), socialNetworkAccessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now());
                    ArrayList<Map> newFacebookTokenList = new ArrayList<Map>();
                    newFacebookTokenList.add(newFacebookTokenEntity.toAttributeMap());
                    tableItems.put(facebookTokenTableName, newFacebookTokenList);
                    result = result.withDnaUserProfileEntity(newDnaUserProfileEntity);
                    result = result.withFacebookTokenEntity(newFacebookTokenEntity);
                } else if (network == SocialNetworks.Vkontakte) {
                    logger.info("updateAccessTokenMarkSocialNetworkActiveInDnaAccountAndReturnDnaAccount : update VkontakteTokenEntity and activate Facebook in DnaUserProfileEntity");
                    DnaUserProfileEntity newDnaUserProfileEntity = new DnaUserProfileEntity(oldDnaUserProfileEntity.getAccountId(), oldDnaUserProfileEntity.getName(), oldDnaUserProfileEntity.getGender(), oldDnaUserProfileEntity.getLocale(), oldDnaUserProfileEntity.getEmail(), oldDnaUserProfileEntity.getPictureUrl(), oldDnaUserProfileEntity.getScores(), oldDnaUserProfileEntity.getFbAccountId(), oldDnaUserProfileEntity.getTimeWhenFbWasAttached(), oldDnaUserProfileEntity.isFbActive(), oldDnaUserProfileEntity.getVkAccountId(), oldDnaUserProfileEntity.getTimeWhenVkWasAttached(), Boolean.TRUE, oldDnaUserProfileEntity.getTimeWhenAccountWasCreated(), oldDnaUserProfileEntity.getLevel1ids(), oldDnaUserProfileEntity.getMainSocialNetwork());
                    newDnaUserProfileList.add(newDnaUserProfileEntity.toAttributeMap());
                    VkontakteTokenEntity newVkontakteTokenEntity = new VkontakteTokenEntity(userState.getMe().getId(), socialNetworkAccessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now());
                    ArrayList<Map> newVkontakteTokenList = new ArrayList<Map>();
                    newVkontakteTokenList.add(newVkontakteTokenEntity.toAttributeMap());
                    tableItems.put(vkontakteTokenTableName, newVkontakteTokenList);
                    result = result.withDnaUserProfileEntity(newDnaUserProfileEntity);
                    result = result.withVkontakteTokenEntity(newVkontakteTokenEntity);
                } else {
                    throw new IllegalArgumentException("There is no network with name " + network.name());
                }
                logger.info("updateAccessTokenMarkSocialNetworkActiveInDnaAccountAndReturnDnaAccount : make batchWrite to update token and activate network");
                DynamoCommon.batchWrite(tableItems, (Token)token);
                logger.info("updateAccessTokenMarkSocialNetworkActiveInDnaAccountAndReturnDnaAccount : return  AccountContainer with new token in it");
                return result.withSource(RegistratorService.USER_STATE_SOURCE_BUT_WITH_UPDATED_TOKEN);
            }
        }, (ExecutionContext)BigBird.awsExecutionContext());
    }

    public static Future<DnaUserProfileEntity> attachNewSocialAccountToExistingDnaAccount(AccountContainer containerBasedOnUserState, final AccountContainer containerBasedOnLevel1Account, final String socialNetworkAccessToken, final String numberOfSecondsUntilTokenExpire, final String refreshDateAsString, final Token token) {
        logger.info("attachNewSocialAccountToExistingDnaAccount : start");
        final UserState userState = containerBasedOnUserState.userState;
        final String dnaAccountId = containerBasedOnLevel1Account.dnaUserProfileEntity.getAccountId();
        Future<List<Object>> friendsListFuture = FriendsUtil.devideFriends(userState, dnaAccountId, token);
        return friendsListFuture.flatMap((Function1)new Mapper<List<Object>, Future<DnaUserProfileEntity>>(){

            public Future<DnaUserProfileEntity> apply(final List<Object> mixedFriendList) {
                return Futures.future((Callable)new Callable<DnaUserProfileEntity>(){

                    @Override
                    public DnaUserProfileEntity call() throws Exception {
                        LocalDateTime timeWhenTokenWillBeExpired = numberOfSecondsUntilTokenExpire != null && !numberOfSecondsUntilTokenExpire.equals("0") ? LocalDateTime.now().plusSeconds(Integer.parseInt(numberOfSecondsUntilTokenExpire)) : null;
                        LocalDateTime refreshDateTime = null;
                        if (refreshDateAsString != null && !refreshDateAsString.isEmpty()) {
                            try {
                                refreshDateTime = LocalDateTime.parse((String)refreshDateAsString, (DateTimeFormatter)RegistratorService.getFormatter());
                            }
                            catch (Exception ex) {
                                logger.error("attachNewSocialAccountToExistingDnaAccount: Error when parse refresh date : " + refreshDateAsString, (Throwable)ex);
                            }
                        }
                        HashMap tableKeyMap = new HashMap();
                        ArrayList<SocialFriendsEntity> socialFriendsEntities = new ArrayList<SocialFriendsEntity>();
                        ArrayList<DnaFriendsEntity> dnaFriendsEntities = new ArrayList<DnaFriendsEntity>();
                        for (Object eachFriend : mixedFriendList) {
                            if (eachFriend instanceof SocialFriendsEntity) {
                                socialFriendsEntities.add((SocialFriendsEntity)eachFriend);
                                continue;
                            }
                            if (!(eachFriend instanceof DnaUserProfileEntity)) continue;
                            DnaUserProfileEntity friendProfile = (DnaUserProfileEntity)eachFriend;
                            DnaFriendsEntity dnaFriendsEntity = new DnaFriendsEntity(dnaAccountId, friendProfile.getAccountId(), friendProfile.getScores(), friendProfile.getName(), friendProfile.getGender(), friendProfile.getLocale(), friendProfile.getEmail(), friendProfile.getPictureUrl(), friendProfile.getTimeWhenAccountWasCreated());
                            dnaFriendsEntities.add(dnaFriendsEntity);
                        }
                        if (!socialFriendsEntities.isEmpty()) {
                            logger.info("attachNewSocialAccountToExistingDnaAccount : first save SocialFriendsEntity's");
                            SocialFriendsEntity.saveList(socialFriendsEntities, (Token)token);
                        }
                        if (!dnaFriendsEntities.isEmpty()) {
                            logger.info("attachNewSocialAccountToExistingDnaAccount : next save DnaFriendsEntity's");
                            DnaFriendsEntity.saveList(dnaFriendsEntities, (Token)token);
                        }
                        DnaUserProfileEntity oldDnaUserProfileEntity = containerBasedOnLevel1Account.dnaUserProfileEntity;
                        ImmutableList oldDnaFriendList = containerBasedOnLevel1Account.dnaFriendsEntityList;
                        ArrayList<Object> listInfluences = new ArrayList<Object>();
                        DnaUserProfileEntity finalDnaUserProfileEntity = null;
                        if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook) {
                            logger.info("attachNewSocialAccountToExistingDnaAccount : create all entities based on Facebook profile");
                            String fbAccountId = userState.getMe().getId();
                            FacebookFormulaArgumentsEntity facebookFormulaArgumentsEntity = FacebookFormulaArgumentsEntity.fetch((Token)token);
                            FacebookProfileMetaInfo facebookProfileMetaInfo = util.Mapper.mapToFacebookProfileMetaInfo(userState);
                            FacebookInfluenceEntity facebookInfluenceEntity = NetworksScoreCalculator.calculateFbInfluence((FacebookProfileMetaInfo)facebookProfileMetaInfo, (FacebookFormulaArgumentsEntity)facebookFormulaArgumentsEntity);
                            FacebookUserProfileEntity facebookUserProfileEntity = util.Mapper.mapToFacebookUserProfileEntity(userState, dnaAccountId);
                            FacebookTokenEntity facebookTokenEntity = new FacebookTokenEntity(fbAccountId, socialNetworkAccessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now());
                            String level1accountId = token.getAccountId();
                            Level1AccountEntity level1AccountEntity = new Level1AccountEntity(level1accountId, dnaAccountId);
                            VkontakteInfluenceEntity vkontakteInfluenceEntity = containerBasedOnLevel1Account.vkontakteInfluenceEntity;
                            listInfluences.add(vkontakteInfluenceEntity);
                            listInfluences.add(facebookInfluenceEntity);
                            Double scores = DnaScoreCalculator.calculateDnaScores(listInfluences);
                            finalDnaUserProfileEntity = new DnaUserProfileEntity(oldDnaUserProfileEntity.getAccountId(), oldDnaUserProfileEntity.getName(), oldDnaUserProfileEntity.getGender(), oldDnaUserProfileEntity.getLocale(), oldDnaUserProfileEntity.getEmail(), oldDnaUserProfileEntity.getPictureUrl(), Long.valueOf(scores.longValue()), fbAccountId, LocalDateTime.now(), Boolean.TRUE, oldDnaUserProfileEntity.getVkAccountId(), oldDnaUserProfileEntity.getTimeWhenVkWasAttached(), oldDnaUserProfileEntity.isVkActive(), oldDnaUserProfileEntity.getTimeWhenAccountWasCreated(), oldDnaUserProfileEntity.getLevel1ids(), oldDnaUserProfileEntity.getMainSocialNetwork());
                            String facebookProfileMetaInfoTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
                            String facebookInfluenceEntityTableName = Dynamo.getFinalTableName(FacebookInfluenceEntity.class);
                            String facebookUserProfileEntityTableName = Dynamo.getFinalTableName(FacebookUserProfileEntity.class);
                            String facebookTokenEntityTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
                            String level1AccountEntityTableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
                            String dnaUserProfileEntityTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
                            ArrayList<Map> facebookProfileMetaInfoItems = new ArrayList<Map>();
                            facebookProfileMetaInfoItems.add(facebookProfileMetaInfo.toAttributeMap());
                            tableKeyMap.put(facebookProfileMetaInfoTableName, facebookProfileMetaInfoItems);
                            ArrayList<Map> facebookInfluenceEntityItems = new ArrayList<Map>();
                            facebookInfluenceEntityItems.add(facebookInfluenceEntity.toAttributeMap());
                            tableKeyMap.put(facebookInfluenceEntityTableName, facebookInfluenceEntityItems);
                            ArrayList<Map> facebookUserProfileEntityItems = new ArrayList<Map>();
                            facebookUserProfileEntityItems.add(facebookUserProfileEntity.toAttributeMap());
                            tableKeyMap.put(facebookUserProfileEntityTableName, facebookUserProfileEntityItems);
                            ArrayList<Map> facebookTokenEntityItems = new ArrayList<Map>();
                            facebookTokenEntityItems.add(facebookTokenEntity.toAttributeMap());
                            tableKeyMap.put(facebookTokenEntityTableName, facebookTokenEntityItems);
                            ArrayList<Map> level1AccountEntityItems = new ArrayList<Map>();
                            level1AccountEntityItems.add(level1AccountEntity.toAttributeMap());
                            tableKeyMap.put(level1AccountEntityTableName, level1AccountEntityItems);
                            ArrayList<Map> dnaUserProfileEntityItems = new ArrayList<Map>();
                            dnaUserProfileEntityItems.add(finalDnaUserProfileEntity.toAttributeMap());
                            tableKeyMap.put(dnaUserProfileEntityTableName, dnaUserProfileEntityItems);
                        } else if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte) {
                            logger.info("attachNewSocialAccountToExistingDnaAccount : create all entities based on Vkontakte profile");
                            String vkAccountId = userState.getMe().getId();
                            VkontakteFormulaArgumentsEntity vkotakteFormulaArgumentsEntity = VkontakteFormulaArgumentsEntity.fetch((Token)token);
                            VkontakteProfileMetaInfo vkontakteProfileMetaInfo = util.Mapper.mapToVkontakteProfileMetaInfo(userState);
                            VkontakteInfluenceEntity vkontakteInfluenceEntity = NetworksScoreCalculator.calculateVkInfluence((VkontakteProfileMetaInfo)vkontakteProfileMetaInfo, (VkontakteFormulaArgumentsEntity)vkotakteFormulaArgumentsEntity);
                            VkontakteUserProfileEntity vkontakteUserProfileEntity = util.Mapper.mapToVkontakteUserProfileEntity(userState, dnaAccountId);
                            VkontakteTokenEntity vkontakteTokenEntity = new VkontakteTokenEntity(vkAccountId, socialNetworkAccessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now());
                            String level1accountId = token.getAccountId();
                            Level1AccountEntity level1AccountEntity = new Level1AccountEntity(level1accountId, dnaAccountId);
                            FacebookInfluenceEntity facebookInfluenceEntity = containerBasedOnLevel1Account.facebookInfluenceEntity;
                            listInfluences.add(vkontakteInfluenceEntity);
                            listInfluences.add(facebookInfluenceEntity);
                            Double scores = DnaScoreCalculator.calculateDnaScores(listInfluences);
                            finalDnaUserProfileEntity = new DnaUserProfileEntity(oldDnaUserProfileEntity.getAccountId(), oldDnaUserProfileEntity.getName(), oldDnaUserProfileEntity.getGender(), oldDnaUserProfileEntity.getLocale(), oldDnaUserProfileEntity.getEmail(), oldDnaUserProfileEntity.getPictureUrl(), Long.valueOf(scores.longValue()), oldDnaUserProfileEntity.getFbAccountId(), oldDnaUserProfileEntity.getTimeWhenFbWasAttached(), oldDnaUserProfileEntity.isFbActive(), vkAccountId, LocalDateTime.now(), Boolean.TRUE, oldDnaUserProfileEntity.getTimeWhenAccountWasCreated(), oldDnaUserProfileEntity.getLevel1ids(), oldDnaUserProfileEntity.getMainSocialNetwork());
                            String vkontakteProfileMetaInfoTableName = Dynamo.getFinalTableName(VkontakteProfileMetaInfo.class);
                            String vkontakteInfluenceEntityTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
                            String vkontakteUserProfileEntityTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
                            String vkontakteTokenEntityTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
                            String level1AccountEntityTableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
                            String dnaUserProfileEntityTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
                            ArrayList<Map> vkontakteProfileMetaInfoItems = new ArrayList<Map>();
                            vkontakteProfileMetaInfoItems.add(vkontakteProfileMetaInfo.toAttributeMap());
                            tableKeyMap.put(vkontakteProfileMetaInfoTableName, vkontakteProfileMetaInfoItems);
                            ArrayList<Map> vkontakteInfluenceEntityItems = new ArrayList<Map>();
                            vkontakteInfluenceEntityItems.add(vkontakteInfluenceEntity.toAttributeMap());
                            tableKeyMap.put(vkontakteInfluenceEntityTableName, vkontakteInfluenceEntityItems);
                            ArrayList<Map> vkontakteUserProfileEntityItems = new ArrayList<Map>();
                            vkontakteUserProfileEntityItems.add(vkontakteUserProfileEntity.toAttributeMap());
                            tableKeyMap.put(vkontakteUserProfileEntityTableName, vkontakteUserProfileEntityItems);
                            ArrayList<Map> vkontakteTokenEntityItems = new ArrayList<Map>();
                            vkontakteTokenEntityItems.add(vkontakteTokenEntity.toAttributeMap());
                            tableKeyMap.put(vkontakteTokenEntityTableName, vkontakteTokenEntityItems);
                            ArrayList<Map> level1AccountEntityItems = new ArrayList<Map>();
                            level1AccountEntityItems.add(level1AccountEntity.toAttributeMap());
                            tableKeyMap.put(level1AccountEntityTableName, level1AccountEntityItems);
                            ArrayList<Map> dnaUserProfileEntityItems = new ArrayList<Map>();
                            dnaUserProfileEntityItems.add(finalDnaUserProfileEntity.toAttributeMap());
                            tableKeyMap.put(dnaUserProfileEntityTableName, dnaUserProfileEntityItems);
                        }
                        logger.info("attachNewSocialAccountToExistingDnaAccount : make batchWrite request");
                        String dnaUserProfileHistoryEntityTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
                        DnaUserProfileHistoryEntity dnaUserProfileHistoryEntity = new DnaUserProfileHistoryEntity(finalDnaUserProfileEntity);
                        ArrayList<Map> dnaUserProfileHistoryEntityItems = new ArrayList<Map>();
                        dnaUserProfileHistoryEntityItems.add(dnaUserProfileHistoryEntity.toAttributeMap());
                        tableKeyMap.put(dnaUserProfileHistoryEntityTableName, dnaUserProfileHistoryEntityItems);
                        DynamoCommon.batchWrite(tableKeyMap, (Token)token);
                        logger.info("attachNewSocialAccountToExistingDnaAccount : build events queue");
                        EventQueueBuilder.buildAndSaveEventQueue((DnaUserProfileEntity)oldDnaUserProfileEntity, (List)oldDnaFriendList, finalDnaUserProfileEntity, dnaFriendsEntities, (Token)token);
                        return finalDnaUserProfileEntity;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<AccountContainer> fillContainerUsingUserStateWithDnaFriendsOnly(String socialNetworkAccessToken, SocialNetworks socialNetwork, final Token token) {
        logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : fill container based on UserState");
        Future userStateFuture = SocialGrabber.constructUserStateFromSocialNetworkWithAccessToken((String)socialNetworkAccessToken, (SocialNetworks)socialNetwork, (Token)token);
        Future accountContainerWithoutDnaProfileFuture = userStateFuture.flatMap((Function1)new Mapper<UserState, Future<AccountContainer>>(){

            public Future<AccountContainer> apply(final UserState userState) {
                return Futures.future((Callable)new Callable<AccountContainer>(){

                    @Override
                    public AccountContainer call() throws Exception {
                        Map item;
                        HashMap<String, AttributeValue> key;
                        ArrayList keyList;
                        logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : userState was constructed : accountId : " + userState.getMe().getId() + " social network : " + userState.getSocialNetworkName());
                        logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : construct batch request to DynamoDB based on user state");
                        AccountContainer accountContainer = AccountContainer.cleanAccountContainer(RegistratorService.USER_STATE_SOURCE);
                        accountContainer = accountContainer.withUserState(userState);
                        String accountId = userState.getMe().getId();
                        HashMap tableKeys = new HashMap();
                        String facebookInfluenceEntityTableName = Dynamo.getFinalTableName(FacebookInfluenceEntity.class);
                        String facebookProfileMetaInfoTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
                        String facebookTokenEntityTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
                        String facebookUserProfileEntityTableName = Dynamo.getFinalTableName(FacebookUserProfileEntity.class);
                        String vkontakteInfluenceEntityTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
                        String vkontakteProfileMetaInfoTableName = Dynamo.getFinalTableName(VkontakteProfileMetaInfo.class);
                        String vkontakteTokenEntityTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
                        String vkontakteUserProfileEntityTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
                        if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook) {
                            keyList = new ArrayList();
                            key = new HashMap<String, AttributeValue>();
                            keyList.add(key);
                            tableKeys.put(facebookInfluenceEntityTableName, keyList);
                            key.put("ID", new AttributeValue().withS(accountId));
                            tableKeys.put(facebookProfileMetaInfoTableName, keyList);
                            tableKeys.put(facebookTokenEntityTableName, keyList);
                            tableKeys.put(facebookUserProfileEntityTableName, keyList);
                        } else if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte) {
                            keyList = new ArrayList();
                            key = new HashMap();
                            keyList.add(key);
                            tableKeys.put(vkontakteInfluenceEntityTableName, keyList);
                            key.put("ID", new AttributeValue().withS(accountId));
                            tableKeys.put(vkontakteProfileMetaInfoTableName, keyList);
                            tableKeys.put(vkontakteTokenEntityTableName, keyList);
                            tableKeys.put(vkontakteUserProfileEntityTableName, keyList);
                        }
                        logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : make batchRequest");
                        Map response = DynamoCommon.batchGet(tableKeys, (Token)token);
                        logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there are " + response.keySet().size() + " tables in response");
                        List facebookInfluenceEntityList = (List)response.get(facebookInfluenceEntityTableName);
                        List facebookProfileMetaInfoList = (List)response.get(facebookProfileMetaInfoTableName);
                        List facebookTokenEntityList = (List)response.get(facebookTokenEntityTableName);
                        List facebookUserProfileEntityList = (List)response.get(facebookUserProfileEntityTableName);
                        List vkontakteInfluenceEntityList = (List)response.get(vkontakteInfluenceEntityTableName);
                        List vkontakteProfileMetaInfoList = (List)response.get(vkontakteProfileMetaInfoTableName);
                        List vkontakteTokenEntityList = (List)response.get(vkontakteTokenEntityTableName);
                        List vkontakteUserProfileEntityList = (List)response.get(vkontakteUserProfileEntityTableName);
                        if (facebookInfluenceEntityList != null && !facebookInfluenceEntityList.isEmpty()) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there is FacebookInfluenceEntity in response : put it into AccountContainer");
                            item = (Map)facebookInfluenceEntityList.get(0);
                            accountContainer = accountContainer.withFacebookInfluenceEntity(FacebookInfluenceEntity.fromAttributeMap((Map)item));
                        }
                        if (facebookProfileMetaInfoList != null && !facebookProfileMetaInfoList.isEmpty()) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there is FacebookProfileMetaInfo in response : put it into AccountContainer");
                            item = (Map)facebookProfileMetaInfoList.get(0);
                            accountContainer = accountContainer.withFacebookProfileMetaInfo(FacebookProfileMetaInfo.fromAttributeMap((Map)item));
                        }
                        if (facebookTokenEntityList != null && !facebookTokenEntityList.isEmpty()) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there is FacebookTokenEntity in response : put it into AccountContainer");
                            item = (Map)facebookTokenEntityList.get(0);
                            accountContainer = accountContainer.withFacebookTokenEntity(FacebookTokenEntity.fromAttributeMap((Map)item));
                        }
                        if (facebookUserProfileEntityList != null && !facebookUserProfileEntityList.isEmpty()) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there is FacebookUserProfileEntity in response : put it into AccountContainer");
                            item = (Map)facebookUserProfileEntityList.get(0);
                            accountContainer = accountContainer.withFacebookUserProfileEntity(FacebookUserProfileEntity.fromAttributeMap((Map)item));
                        }
                        if (vkontakteInfluenceEntityList != null && !vkontakteInfluenceEntityList.isEmpty()) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there is VkontakteInfluenceEntity in response : put it into AccountContainer");
                            item = (Map)vkontakteInfluenceEntityList.get(0);
                            accountContainer = accountContainer.withVkontakteInfluenceEntity(VkontakteInfluenceEntity.fromAttributeMap((Map)item));
                        }
                        if (vkontakteProfileMetaInfoList != null && !vkontakteProfileMetaInfoList.isEmpty()) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there is VkontakteProfileMetaInfo in response : put it into AccountContainer");
                            item = (Map)vkontakteProfileMetaInfoList.get(0);
                            accountContainer = accountContainer.withVkontakteProfileMetaInfo(VkontakteProfileMetaInfo.fromAttributeMap((Map)item));
                        }
                        if (vkontakteTokenEntityList != null && !vkontakteTokenEntityList.isEmpty()) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there is VkontakteTokenEntity in response : put it into AccountContainer");
                            item = (Map)vkontakteTokenEntityList.get(0);
                            accountContainer = accountContainer.withVkontakteTokenEntity(VkontakteTokenEntity.fromAttributeMap((Map)item));
                        }
                        if (vkontakteUserProfileEntityList != null && !vkontakteUserProfileEntityList.isEmpty()) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there is VkontakteUserProfileEntity in response : put it into AccountContainer");
                            item = (Map)vkontakteUserProfileEntityList.get(0);
                            accountContainer = accountContainer.withVkontakteUserProfileEntity(VkontakteUserProfileEntity.fromAttributeMap((Map)item));
                        }
                        return accountContainer;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
        Future accountContainerWithDnaProfileFuture = accountContainerWithoutDnaProfileFuture.flatMap((Function1)new Mapper<AccountContainer, Future<AccountContainer>>(){

            public Future<AccountContainer> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<AccountContainer>(){

                    @Override
                    public AccountContainer call() throws Exception {
                        String dnaId = null;
                        AccountContainer resultAccountContainer = accountContainer;
                        if (SocialNetworks.valueOf((String)accountContainer.userState.getSocialNetworkName()) == SocialNetworks.Facebook) {
                            if (accountContainer.facebookUserProfileEntity != null) {
                                dnaId = accountContainer.facebookUserProfileEntity.getDnaId();
                                logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : found dnaAccountId : " + dnaId + " lets fetch them");
                            }
                        } else if (SocialNetworks.valueOf((String)accountContainer.userState.getSocialNetworkName()) == SocialNetworks.Vkontakte && accountContainer.vkontakteUserProfileEntity != null) {
                            dnaId = accountContainer.vkontakteUserProfileEntity.getDnaId();
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : found dnaAccountId : " + dnaId + " lets fetch them");
                        }
                        if (dnaId == null) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : there is no DnaUserProfileEntity in the system");
                            return accountContainer;
                        }
                        DnaUserProfileEntity dnaUserProfileEntity = DnaUserProfileEntity.fetchById((String)dnaId, (Token)token);
                        if (dnaUserProfileEntity != null) {
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : DnaUserProfileEntity was fetched");
                            resultAccountContainer = resultAccountContainer.withDnaUserProfileEntity(dnaUserProfileEntity);
                            logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : fetch DNA friends and put them into account container");
                            List dnaFriends = DnaFriendsEntity.findAllFriendsSortedByFriendId((String)dnaId, (Token)token);
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there are : " + dnaFriends.size() + " DNA friends");
                            resultAccountContainer = resultAccountContainer.withDnaFriendsEntity(dnaFriends);
                            return resultAccountContainer;
                        }
                        logger.info("fillContainerUsingUserStateWithDnaFriendsOnly : DnaUserProfileEntity is null");
                        return resultAccountContainer;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
        return accountContainerWithDnaProfileFuture;
    }

    public static Future<AccountContainer> fillContainerUsingLevel1AccountWithDnaFriendsOnly(final Token token) {
        logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : fill container based on level1account");
        Future fetchLevel1AccountFuture = Futures.future((Callable)new Callable<Level1AccountEntity>(){

            @Override
            public Level1AccountEntity call() throws Exception {
                logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : fetch Level1AccountEntity");
                Level1AccountEntity level1AccountEntity = Level1AccountEntity.fetchByToken((Token)token);
                return level1AccountEntity;
            }
        }, (ExecutionContext)BigBird.awsExecutionContext());
        Future accountContainerFuture = fetchLevel1AccountFuture.flatMap((Function1)new Mapper<Level1AccountEntity, Future<AccountContainer>>(){

            public Future<AccountContainer> apply(final Level1AccountEntity fetchedLevel1Account) {
                return Futures.future((Callable)new Callable<AccountContainer>(){

                    @Override
                    public AccountContainer call() throws Exception {
                        Map item;
                        HashMap<String, AttributeValue> key;
                        ArrayList keyList;
                        String accountId;
                        AccountContainer accountContainer = AccountContainer.cleanAccountContainer(RegistratorService.LEVEL1_ACCOUNT_SOURCE);
                        if (fetchedLevel1Account == null) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is no Level1AccountEntity : it's new device");
                            return accountContainer;
                        }
                        accountContainer = accountContainer.withLevel1AccountEntity(fetchedLevel1Account);
                        logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : found Level1AccountEntity for this device : construct batch request to DynamoDB");
                        HashMap tableKeys = new HashMap();
                        String facebookInfluenceEntityTableName = Dynamo.getFinalTableName(FacebookInfluenceEntity.class);
                        String facebookProfileMetaInfoTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
                        String facebookTokenEntityTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
                        String facebookUserProfileEntityTableName = Dynamo.getFinalTableName(FacebookUserProfileEntity.class);
                        String vkontakteInfluenceEntityTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
                        String vkontakteProfileMetaInfoTableName = Dynamo.getFinalTableName(VkontakteProfileMetaInfo.class);
                        String vkontakteTokenEntityTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
                        String vkontakteUserProfileEntityTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
                        logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : fetch DnaUserAccount first");
                        DnaUserProfileEntity dnaUserProfileEntity = DnaUserProfileEntity.fetchById((String)fetchedLevel1Account.getDnaAccountId(), (Token)token);
                        accountContainer = accountContainer.withDnaUserProfileEntity(dnaUserProfileEntity);
                        logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : fetch DNA friends and put them into account container");
                        List dnaFriends = DnaFriendsEntity.findAllFriendsSortedByFriendId((String)fetchedLevel1Account.getDnaAccountId(), (Token)token);
                        logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there are : " + dnaFriends.size() + " DNA friends");
                        accountContainer = accountContainer.withDnaFriendsEntity(dnaFriends);
                        if (dnaUserProfileEntity.getFbAccountId() != null && !dnaUserProfileEntity.getFbAccountId().isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is FacebookAccount attached to this Level1AccountEntity : add all Facebook's info info request");
                            accountId = dnaUserProfileEntity.getFbAccountId();
                            keyList = new ArrayList();
                            key = new HashMap<String, AttributeValue>();
                            keyList.add(key);
                            tableKeys.put(facebookInfluenceEntityTableName, keyList);
                            key.put("ID", new AttributeValue().withS(accountId));
                            tableKeys.put(facebookProfileMetaInfoTableName, keyList);
                            tableKeys.put(facebookTokenEntityTableName, keyList);
                            tableKeys.put(facebookUserProfileEntityTableName, keyList);
                        }
                        if (dnaUserProfileEntity.getVkAccountId() != null && !dnaUserProfileEntity.getVkAccountId().isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is VkontakteAccount attached to this Level1AccountEntity : add all Vkontakte's info info request");
                            accountId = dnaUserProfileEntity.getVkAccountId();
                            keyList = new ArrayList();
                            key = new HashMap();
                            keyList.add(key);
                            tableKeys.put(vkontakteInfluenceEntityTableName, keyList);
                            key.put("ID", new AttributeValue().withS(accountId));
                            tableKeys.put(vkontakteProfileMetaInfoTableName, keyList);
                            tableKeys.put(vkontakteTokenEntityTableName, keyList);
                            tableKeys.put(vkontakteUserProfileEntityTableName, keyList);
                        }
                        if (tableKeys.isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : we do not have any social account, so return container with Level1 and DnaUserProfile only");
                            return accountContainer;
                        }
                        logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : make batchRequest");
                        Map response = DynamoCommon.batchGet(tableKeys, (Token)token);
                        logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there are " + response.keySet().size() + " tables in response");
                        List facebookInfluenceEntityList = (List)response.get(facebookInfluenceEntityTableName);
                        List facebookProfileMetaInfoList = (List)response.get(facebookProfileMetaInfoTableName);
                        List facebookTokenEntityList = (List)response.get(facebookTokenEntityTableName);
                        List facebookUserProfileEntityList = (List)response.get(facebookUserProfileEntityTableName);
                        List vkontakteInfluenceEntityList = (List)response.get(vkontakteInfluenceEntityTableName);
                        List vkontakteProfileMetaInfoList = (List)response.get(vkontakteProfileMetaInfoTableName);
                        List vkontakteTokenEntityList = (List)response.get(vkontakteTokenEntityTableName);
                        List vkontakteUserProfileEntityList = (List)response.get(vkontakteUserProfileEntityTableName);
                        if (facebookInfluenceEntityList != null && !facebookInfluenceEntityList.isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is FacebookInfluenceEntity in response : put it into AccountContainer");
                            item = (Map)facebookInfluenceEntityList.get(0);
                            accountContainer = accountContainer.withFacebookInfluenceEntity(FacebookInfluenceEntity.fromAttributeMap((Map)item));
                        }
                        if (facebookProfileMetaInfoList != null && !facebookProfileMetaInfoList.isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is FacebookProfileMetaInfo in response : put it into AccountContainer");
                            item = (Map)facebookProfileMetaInfoList.get(0);
                            accountContainer = accountContainer.withFacebookProfileMetaInfo(FacebookProfileMetaInfo.fromAttributeMap((Map)item));
                        }
                        if (facebookTokenEntityList != null && !facebookTokenEntityList.isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is FacebookTokenEntity in response : put it into AccountContainer");
                            item = (Map)facebookTokenEntityList.get(0);
                            accountContainer = accountContainer.withFacebookTokenEntity(FacebookTokenEntity.fromAttributeMap((Map)item));
                        }
                        if (facebookUserProfileEntityList != null && !facebookUserProfileEntityList.isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is FacebookUserProfileEntity in response : put it into AccountContainer");
                            item = (Map)facebookUserProfileEntityList.get(0);
                            accountContainer = accountContainer.withFacebookUserProfileEntity(FacebookUserProfileEntity.fromAttributeMap((Map)item));
                        }
                        if (vkontakteInfluenceEntityList != null && !vkontakteInfluenceEntityList.isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is VkontakteInfluenceEntity in response : put it into AccountContainer");
                            item = (Map)vkontakteInfluenceEntityList.get(0);
                            accountContainer = accountContainer.withVkontakteInfluenceEntity(VkontakteInfluenceEntity.fromAttributeMap((Map)item));
                        }
                        if (vkontakteProfileMetaInfoList != null && !vkontakteProfileMetaInfoList.isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is VkontakteProfileMetaInfo in response : put it into AccountContainer");
                            item = (Map)vkontakteProfileMetaInfoList.get(0);
                            accountContainer = accountContainer.withVkontakteProfileMetaInfo(VkontakteProfileMetaInfo.fromAttributeMap((Map)item));
                        }
                        if (vkontakteTokenEntityList != null && !vkontakteTokenEntityList.isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is VkontakteTokenEntity in response : put it into AccountContainer");
                            item = (Map)vkontakteTokenEntityList.get(0);
                            accountContainer = accountContainer.withVkontakteTokenEntity(VkontakteTokenEntity.fromAttributeMap((Map)item));
                        }
                        if (vkontakteUserProfileEntityList != null && !vkontakteUserProfileEntityList.isEmpty()) {
                            logger.info("fillContainerUsingLevel1AccountWithDnaFriendsOnly : there is VkontakteUserProfileEntity in response : put it into AccountContainer");
                            item = (Map)vkontakteUserProfileEntityList.get(0);
                            accountContainer = accountContainer.withVkontakteUserProfileEntity(VkontakteUserProfileEntity.fromAttributeMap((Map)item));
                        }
                        return accountContainer;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
        return accountContainerFuture;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AccountContainer {
        private final String source;
        private final UserState userState;
        private final Level1AccountEntity level1AccountEntity;
        private final ImmutableList<SocialFriendsEntity> socialFriendsEntityList;
        private final ImmutableList<DnaFriendsEntity> dnaFriendsEntityList;
        private final DnaUserProfileEntity dnaUserProfileEntity;
        private final FacebookTokenEntity facebookTokenEntity;
        private final FacebookUserProfileEntity facebookUserProfileEntity;
        private final FacebookProfileMetaInfo facebookProfileMetaInfo;
        private final FacebookInfluenceEntity facebookInfluenceEntity;
        private final VkontakteTokenEntity vkontakteTokenEntity;
        private final VkontakteUserProfileEntity vkontakteUserProfileEntity;
        private final VkontakteProfileMetaInfo vkontakteProfileMetaInfo;
        private final VkontakteInfluenceEntity vkontakteInfluenceEntity;

        private AccountContainer(String source, UserState userState, Level1AccountEntity level1AccountEntity, List<SocialFriendsEntity> socialFriendsEntityList, List<DnaFriendsEntity> dnaFriendsEntityList, DnaUserProfileEntity dnaUserProfileEntity, FacebookTokenEntity facebookTokenEntity, FacebookUserProfileEntity facebookUserProfileEntity, FacebookProfileMetaInfo facebookProfileMetaInfo, FacebookInfluenceEntity facebookInfluenceEntity, VkontakteTokenEntity vkontakteTokenEntity, VkontakteUserProfileEntity vkontakteUserProfileEntity, VkontakteProfileMetaInfo vkontakteProfileMetaInfo, VkontakteInfluenceEntity vkontakteInfluenceEntity) {
            this.source = source;
            this.userState = userState;
            this.level1AccountEntity = level1AccountEntity;
            this.socialFriendsEntityList = socialFriendsEntityList != null ? ImmutableList.copyOf(socialFriendsEntityList) : null;
            this.dnaFriendsEntityList = dnaFriendsEntityList != null ? ImmutableList.copyOf(dnaFriendsEntityList) : null;
            this.dnaUserProfileEntity = dnaUserProfileEntity;
            this.facebookTokenEntity = facebookTokenEntity;
            this.facebookUserProfileEntity = facebookUserProfileEntity;
            this.facebookProfileMetaInfo = facebookProfileMetaInfo;
            this.facebookInfluenceEntity = facebookInfluenceEntity;
            this.vkontakteTokenEntity = vkontakteTokenEntity;
            this.vkontakteUserProfileEntity = vkontakteUserProfileEntity;
            this.vkontakteProfileMetaInfo = vkontakteProfileMetaInfo;
            this.vkontakteInfluenceEntity = vkontakteInfluenceEntity;
        }

        public static AccountContainer cleanAccountContainer(String source) {
            return new AccountContainer(source, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        public AccountContainer withSource(String source) {
            return new AccountContainer(source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withUserState(UserState userState) {
            return new AccountContainer(this.source, userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withLevel1AccountEntity(Level1AccountEntity level1AccountEntity) {
            return new AccountContainer(this.source, this.userState, level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withSocialFriendsEntity(List<SocialFriendsEntity> socialFriendsEntity) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, socialFriendsEntity, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withDnaFriendsEntity(List<DnaFriendsEntity> dnaFriendsEntity) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, dnaFriendsEntity, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withDnaUserProfileEntity(DnaUserProfileEntity dnaUserProfileEntity) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withFacebookTokenEntity(FacebookTokenEntity facebookTokenEntity) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withFacebookUserProfileEntity(FacebookUserProfileEntity facebookUserProfileEntity) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withFacebookProfileMetaInfo(FacebookProfileMetaInfo facebookProfileMetaInfo) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withFacebookInfluenceEntity(FacebookInfluenceEntity facebookInfluenceEntity) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withVkontakteTokenEntity(VkontakteTokenEntity vkontakteTokenEntity) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withVkontakteUserProfileEntity(VkontakteUserProfileEntity vkontakteUserProfileEntity) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withVkontakteProfileMetaInfo(VkontakteProfileMetaInfo vkontaktekProfileMetaInfo) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, vkontaktekProfileMetaInfo, this.vkontakteInfluenceEntity);
        }

        public AccountContainer withVkontakteInfluenceEntity(VkontakteInfluenceEntity vkontakteInfluenceEntity) {
            return new AccountContainer(this.source, this.userState, this.level1AccountEntity, (List<SocialFriendsEntity>)this.socialFriendsEntityList, (List<DnaFriendsEntity>)this.dnaFriendsEntityList, this.dnaUserProfileEntity, this.facebookTokenEntity, this.facebookUserProfileEntity, this.facebookProfileMetaInfo, this.facebookInfluenceEntity, this.vkontakteTokenEntity, this.vkontakteUserProfileEntity, this.vkontakteProfileMetaInfo, vkontakteInfluenceEntity);
        }

        public String getSource() {
            return this.source;
        }

        public UserState getUserState() {
            return this.userState;
        }

        public Level1AccountEntity getLevel1AccountEntity() {
            return this.level1AccountEntity;
        }

        public List<SocialFriendsEntity> getSocialFriendsEntityList() {
            return this.socialFriendsEntityList;
        }

        public List<DnaFriendsEntity> getDnaFriendsEntityList() {
            return this.dnaFriendsEntityList;
        }

        public DnaUserProfileEntity getDnaUserProfileEntity() {
            return this.dnaUserProfileEntity;
        }

        public FacebookTokenEntity getFacebookTokenEntity() {
            return this.facebookTokenEntity;
        }

        public FacebookUserProfileEntity getFacebookUserProfileEntity() {
            return this.facebookUserProfileEntity;
        }

        public FacebookProfileMetaInfo getFacebookProfileMetaInfo() {
            return this.facebookProfileMetaInfo;
        }

        public FacebookInfluenceEntity getFacebookInfluenceEntity() {
            return this.facebookInfluenceEntity;
        }

        public VkontakteTokenEntity getVkontakteTokenEntity() {
            return this.vkontakteTokenEntity;
        }

        public VkontakteUserProfileEntity getVkontakteUserProfileEntity() {
            return this.vkontakteUserProfileEntity;
        }

        public VkontakteProfileMetaInfo getVkontakteProfileMetaInfo() {
            return this.vkontakteProfileMetaInfo;
        }

        public VkontakteInfluenceEntity getVkontakteInfluenceEntity() {
            return this.vkontakteInfluenceEntity;
        }
    }
}

