/*
 * Decompiled with CFR 0.152.
 */
package services;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.common.collect.Lists;
import constants.LocaleCollection;
import constants.RankCollections;
import constants.SocialNetworks;
import db.model.DnaFriendsEntity;
import db.model.DnaUserProfileEntity;
import db.model.Level1AccountEntity;
import db.model.SocialFriendsEntity;
import db.model.StandartEventEntity;
import db.model.fb.FacebookTokenEntity;
import db.model.fb.FacebookUserProfileEntity;
import db.model.vk.VkontakteTokenEntity;
import db.model.vk.VkontakteUserProfileEntity;
import exceptions.EntityNotFoundException;
import exceptions.RelatedObjectNotExistException;
import executors.BigBird;
import helpers.SocialGrabber;
import identity.Token;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import services.DnaAccountService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Level2AccountService {
    private static final Logger logger = LoggerFactory.getLogger(Level2AccountService.class);

    public static Future<AccountContainer> fillWithLevel1ANDDnaAccountByTokenOrThrowEntityNotFound(final Token token) {
        return Level2AccountService.fillWithLevel1AccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<AccountContainer>>(){

            public Future<AccountContainer> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<AccountContainer>(){

                    @Override
                    public AccountContainer call() throws Exception {
                        logger.info("fillWithLevel1ANDDnaAccountByTokenOrThrowEntityNotFound");
                        AccountContainer resultContainer = accountContainer;
                        DnaUserProfileEntity dnaUserProfileEntity = DnaUserProfileEntity.fetchById((String)resultContainer.getLevel1AccountEntity().getDnaAccountId(), (Token)token);
                        if (dnaUserProfileEntity == null) {
                            throw new EntityNotFoundException("Error : fillWithLevel1ANDDnaAccountByTokenOrThrowEntityNotFound : DnaUserProfileEntity does not exist", token.getAccountId());
                        }
                        resultContainer = resultContainer.withDnaUserProfileEntity(dnaUserProfileEntity);
                        return resultContainer;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<AccountContainer> fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound(final SocialNetworks network, final Token token) {
        return Level2AccountService.fillWithLevel1AccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<AccountContainer>>(){

            public Future<AccountContainer> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<AccountContainer>(){

                    @Override
                    public AccountContainer call() throws Exception {
                        logger.info("fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound : social network : " + network.name());
                        AccountContainer resultContainer = accountContainer;
                        DnaUserProfileEntity dnaUserProfileEntity = DnaUserProfileEntity.fetchById((String)resultContainer.getLevel1AccountEntity().getDnaAccountId(), (Token)token);
                        if (dnaUserProfileEntity == null) {
                            throw new EntityNotFoundException("Error : fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound : DnaUserProfileEntity does not exist", token.getAccountId());
                        }
                        resultContainer = resultContainer.withDnaUserProfileEntity(dnaUserProfileEntity);
                        if (network == SocialNetworks.Facebook) {
                            if (dnaUserProfileEntity.getFbAccountId() == null) {
                                throw new EntityNotFoundException("Error : fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound : FacebookTokenEntity does not exist", token.getAccountId());
                            }
                            FacebookTokenEntity tokenEntity = FacebookTokenEntity.fetchById((String)dnaUserProfileEntity.getFbAccountId(), (Token)token);
                            if (tokenEntity == null) {
                                throw new EntityNotFoundException("Error : fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound : FacebookTokenEntity does not exist", token.getAccountId());
                            }
                            resultContainer = resultContainer.withFacebookTokenEntity(tokenEntity);
                            return resultContainer;
                        }
                        if (network == SocialNetworks.Vkontakte) {
                            if (dnaUserProfileEntity.getVkAccountId() == null) {
                                throw new EntityNotFoundException("Error : fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound : VkontakteTokenEntity does not exist", token.getAccountId());
                            }
                            VkontakteTokenEntity tokenEntity = VkontakteTokenEntity.fetchById((String)dnaUserProfileEntity.getVkAccountId(), (Token)token);
                            if (tokenEntity == null) {
                                throw new EntityNotFoundException("Error : fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound : VkontakteTokenEntity does not exist", token.getAccountId());
                            }
                            resultContainer = resultContainer.withVkontakteTokenEntity(tokenEntity);
                            return resultContainer;
                        }
                        throw new IllegalArgumentException("Error : fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound : There is no such network : " + network.name());
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<AccountContainer> fillWithLevel1AccountByTokenOrThrowEntityNotFound(final Token token) {
        return Futures.future((Callable)new Callable<AccountContainer>(){

            @Override
            public AccountContainer call() throws Exception {
                logger.info("fillWithLevel1AccountByTokenOrThrowEntityNotFound : start");
                Level1AccountEntity level1AccountEntity = Level1AccountEntity.fetchByToken((Token)token);
                if (level1AccountEntity == null) {
                    throw new EntityNotFoundException("Error : fillWithLevel1AccountByTokenOrThrowEntityNotFound : Level1AccountEntity does not exist", token.getAccountId());
                }
                AccountContainer accountContainer = AccountContainer.defaultAccountContainer();
                accountContainer = accountContainer.withlevel1AccountEntity(level1AccountEntity);
                return accountContainer;
            }
        }, (ExecutionContext)BigBird.awsExecutionContext());
    }

    public static Future<Void> deactivateSocialNetworkOrThrowEntityNotFound(final SocialNetworks network, final Token token) {
        return Level2AccountService.fillWithLevel1AccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<Void>>(){

            public Future<Void> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        logger.info("deactivateSocialNetworkOrThrowEntityNotFound : start");
                        Level1AccountEntity level1AccountEntity = accountContainer.getLevel1AccountEntity();
                        String dnaId = level1AccountEntity.getDnaAccountId();
                        DnaUserProfileEntity.deactivateSocialNetwork((String)dnaId, (SocialNetworks)network, (Token)token);
                        return null;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<String> fetchSocialAccessTokenOrThrowEntityNotFound(final SocialNetworks network, Token token) {
        return Level2AccountService.fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound(network, token).flatMap((Function1)new Mapper<AccountContainer, Future<String>>(){

            public Future<String> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        logger.info("fetchSocialAccessTokenOrThrowEntityNotFound : start");
                        switch (network) {
                            case Facebook: {
                                return accountContainer.getFacebookTokenEntity().getAccessToken();
                            }
                            case Vkontakte: {
                                return accountContainer.getVkontakteTokenEntity().getAccessToken();
                            }
                        }
                        throw new IllegalArgumentException("Error : fetchSocialAccessTokenOrThrowEntityNotFound : There is no such network : " + network.name());
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<DnaUserProfileEntity> switchMainNetworkOrThrowEntityNotFound(final SocialNetworks network, final Token token) {
        return Level2AccountService.fillWithLevel1ANDDnaAccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<DnaUserProfileEntity>>(){

            public Future<DnaUserProfileEntity> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<DnaUserProfileEntity>(){

                    @Override
                    public DnaUserProfileEntity call() throws Exception {
                        logger.info("switchMainNetworkOrThrowEntityNotFound : start");
                        DnaUserProfileEntity oldDnaUserProfileEntity = accountContainer.getDnaUserProfileEntity();
                        switch (network) {
                            case Facebook: {
                                if (oldDnaUserProfileEntity.getFbAccountId() == null) {
                                    throw new EntityNotFoundException("Error : switchMainNetworkOrThrowEntityNotFound : Facebook does not connected", token.getAccountId());
                                }
                                FacebookUserProfileEntity userProfileEntity = FacebookUserProfileEntity.fetchById((String)oldDnaUserProfileEntity.getFbAccountId(), (Token)token);
                                if (userProfileEntity == null) {
                                    throw new EntityNotFoundException("Error : switchMainNetworkOrThrowEntityNotFound : Facebook does not connected", token.getAccountId());
                                }
                                return DnaUserProfileEntity.updateProfileUserInfo((String)oldDnaUserProfileEntity.getAccountId(), (String)userProfileEntity.getName(), (String)userProfileEntity.getGender(), (String)userProfileEntity.getLocale(), (String)userProfileEntity.getEmail(), (String)userProfileEntity.getPictureUrl(), (SocialNetworks)SocialNetworks.Facebook, (Token)token);
                            }
                            case Vkontakte: {
                                if (oldDnaUserProfileEntity.getVkAccountId() == null) {
                                    throw new EntityNotFoundException("Error : switchMainNetworkOrThrowEntityNotFound : Vkontakte does not connected", token.getAccountId());
                                }
                                VkontakteUserProfileEntity userProfileEntity = VkontakteUserProfileEntity.fetchById((String)oldDnaUserProfileEntity.getVkAccountId(), (Token)token);
                                if (userProfileEntity == null) {
                                    throw new EntityNotFoundException("Error : switchMainNetworkOrThrowEntityNotFound : Vkontakte does not connected", token.getAccountId());
                                }
                                return DnaUserProfileEntity.updateProfileUserInfo((String)oldDnaUserProfileEntity.getAccountId(), (String)userProfileEntity.getName(), (String)userProfileEntity.getGender(), (String)userProfileEntity.getLocale(), (String)userProfileEntity.getEmail(), (String)userProfileEntity.getPictureUrl(), (SocialNetworks)SocialNetworks.Vkontakte, (Token)token);
                            }
                        }
                        throw new IllegalArgumentException("Error : switchMainNetworkOrThrowEntityNotFound : There is no such network : " + network.name());
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<DnaUserProfileEntity> dnaOwnProfileOrThrowEntityNotFound(Token token) {
        return Level2AccountService.fillWithLevel1ANDDnaAccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<DnaUserProfileEntity>>(){

            public Future<DnaUserProfileEntity> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<DnaUserProfileEntity>(){

                    @Override
                    public DnaUserProfileEntity call() throws Exception {
                        logger.info("dnaOwnProfileOrThrowEntityNotFound : return DnaUserProfileEntity from container");
                        return accountContainer.getDnaUserProfileEntity();
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<List<SocialFriendsEntity>> socialNetworkFriendsSortedByNameOrThrowEntityNotFoundOrRelatedObjectNotExistException(final String startFromSocialFriendId, final SocialNetworks network, final int count, final Token token) {
        return Level2AccountService.fillWithLevel1AccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<List<SocialFriendsEntity>>>(){

            public Future<List<SocialFriendsEntity>> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<List<SocialFriendsEntity>>(){

                    @Override
                    public List<SocialFriendsEntity> call() throws Exception {
                        logger.info("socialNetworkFriendsSortedByNameOrThrowEntityNotFoundOrRelatedObjectNotExistException : start");
                        Level1AccountEntity level1AccountEntity = accountContainer.getLevel1AccountEntity();
                        if (level1AccountEntity.getDnaAccountId() == null) {
                            throw new EntityNotFoundException("Error : socialNetworkFriendsSortedByNameOrThrowEntityNotFoundOrRelatedObjectNotExistException : there is no dnaAccountId", token.getAccountId());
                        }
                        String dnaId = level1AccountEntity.getDnaAccountId();
                        if (startFromSocialFriendId == null) {
                            logger.info("socialNetworkFriendsSortedByNameOrThrowEntityNotFoundOrRelatedObjectNotExistException : fetch social friends from start : count : " + count);
                            List resultList = SocialFriendsEntity.findAllFriendsSortedByFriendName((String)dnaId, null, null, (int)count, (Token)token);
                            logger.info("socialNetworkFriendsSortedByNameOrThrowEntityNotFoundOrRelatedObjectNotExistException : return friends.size() = " + resultList.size());
                            return resultList;
                        }
                        logger.info("socialNetworkFriendsSortedByNameOrThrowEntityNotFoundOrRelatedObjectNotExistException : first fetch social friend by id");
                        String socialFriendIdWithTablePrefix = network.getTableIdPrefix().concat(startFromSocialFriendId);
                        SocialFriendsEntity socialFriendsEntity = SocialFriendsEntity.fetchById((String)dnaId, (String)socialFriendIdWithTablePrefix, (Token)token);
                        if (socialFriendsEntity == null) {
                            throw new RelatedObjectNotExistException("Error : socialNetworkFriendsSortedByNameOrThrowEntityNotFoundOrRelatedObjectNotExistException : there is no social friend with this id : " + socialFriendIdWithTablePrefix, token.getAccountId());
                        }
                        String startFromName = socialFriendsEntity.getName();
                        List resultList = SocialFriendsEntity.findAllFriendsSortedByFriendName((String)dnaId, (String)socialFriendIdWithTablePrefix, (String)startFromName, (int)count, (Token)token);
                        logger.info("socialNetworkFriendsSortedByNameOrThrowEntityNotFoundOrRelatedObjectNotExistException : return friends.size() = " + resultList.size());
                        return resultList;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<List<DnaFriendsEntity>> dnaFriendsSortedByScoreInDescOrderOrThrowEntityNotFoundOrRelatedObjectNotExistException(final Long startFromScore, final String lastFriendId, final Integer count, final Token token) {
        return Level2AccountService.fillWithLevel1AccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<List<DnaFriendsEntity>>>(){

            public Future<List<DnaFriendsEntity>> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<List<DnaFriendsEntity>>(){

                    @Override
                    public List<DnaFriendsEntity> call() throws Exception {
                        logger.info("dnaFriendsSortedByScoreInDescOrderOrThrowEntityNotFoundOrRelatedObjectNotExistException : start");
                        Level1AccountEntity level1AccountEntity = accountContainer.getLevel1AccountEntity();
                        if (level1AccountEntity.getDnaAccountId() == null) {
                            throw new EntityNotFoundException("Error : dnaFriendsSortedByScoreInDescOrderOrThrowEntityNotFoundOrRelatedObjectNotExistException : there is no dnaAccountId", token.getAccountId());
                        }
                        String dnaId = level1AccountEntity.getDnaAccountId();
                        if (lastFriendId == null) {
                            logger.info("dnaFriendsSortedByScoreInDescOrderOrThrowEntityNotFoundOrRelatedObjectNotExistException : fetch dna friends from start : count : " + count);
                            List resultList = DnaFriendsEntity.findAllFriendsSortedByFriendScoresInDescOrder((String)dnaId, (Long)startFromScore, null, null, (Integer)count, (Token)token);
                            logger.info("dnaFriendsSortedByScoreInDescOrderOrThrowEntityNotFoundOrRelatedObjectNotExistException : return friends.size() = " + resultList.size());
                            return resultList;
                        }
                        logger.info("dnaFriendsSortedByScoreInDescOrderOrThrowEntityNotFoundOrRelatedObjectNotExistException : first fetch dna friend by id");
                        DnaFriendsEntity dnaFriendsEntity = DnaFriendsEntity.fetchById((String)dnaId, (String)lastFriendId, (Token)token);
                        if (dnaFriendsEntity == null) {
                            throw new RelatedObjectNotExistException("Error : dnaFriendsSortedByScoreInDescOrderOrThrowEntityNotFoundOrRelatedObjectNotExistException : there is no social friend with this id : " + lastFriendId, token.getAccountId());
                        }
                        Long lastFriendScore = dnaFriendsEntity.getScores();
                        List resultList = DnaFriendsEntity.findAllFriendsSortedByFriendScoresInDescOrder((String)dnaId, (Long)startFromScore, (String)lastFriendId, (Long)lastFriendScore, (Integer)count, (Token)token);
                        logger.info("dnaFriendsSortedByScoreInDescOrderOrThrowEntityNotFoundOrRelatedObjectNotExistException : return friends.size() = " + resultList.size());
                        return resultList;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<List<SocialFriendsEntity>> socialNetworkFriendsSortedByFriendIdOrThrowEntityNotFoundOrRelatedObjectNotExistException(final String startFromSocialFriendId, final SocialNetworks network, final int count, final Token token) {
        return Level2AccountService.fillWithLevel1AccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<List<SocialFriendsEntity>>>(){

            public Future<List<SocialFriendsEntity>> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<List<SocialFriendsEntity>>(){

                    @Override
                    public List<SocialFriendsEntity> call() throws Exception {
                        logger.info("socialNetworkFriendsSortedByFriendIdOrThrowEntityNotFoundOrRelatedObjectNotExistException : start");
                        Level1AccountEntity level1AccountEntity = accountContainer.getLevel1AccountEntity();
                        if (level1AccountEntity.getDnaAccountId() == null) {
                            throw new EntityNotFoundException("Error : socialNetworkFriendsSortedByFriendIdOrThrowEntityNotFoundOrRelatedObjectNotExistException : there is no dnaAccountId", token.getAccountId());
                        }
                        String dnaId = level1AccountEntity.getDnaAccountId();
                        if (startFromSocialFriendId == null) {
                            logger.info("socialNetworkFriendsSortedByFriendIdOrThrowEntityNotFoundOrRelatedObjectNotExistException : fetch social friends from start : count : " + count);
                            List resultList = SocialFriendsEntity.findAllFriendsSortedByFriendId((String)dnaId, null, (int)count, (Token)token);
                            logger.info("socialNetworkFriendsSortedByFriendIdOrThrowEntityNotFoundOrRelatedObjectNotExistException : return friends.size() = " + resultList.size());
                            return resultList;
                        }
                        logger.info("socialNetworkFriendsSortedByFriendIdOrThrowEntityNotFoundOrRelatedObjectNotExistException : first fetch social friend by id");
                        String socialFriendIdWithTablePrefix = network.getTableIdPrefix().concat(startFromSocialFriendId);
                        SocialFriendsEntity socialFriendsEntity = SocialFriendsEntity.fetchById((String)dnaId, (String)socialFriendIdWithTablePrefix, (Token)token);
                        if (socialFriendsEntity == null) {
                            throw new RelatedObjectNotExistException("Error : socialNetworkFriendsSortedByFriendIdOrThrowEntityNotFoundOrRelatedObjectNotExistException : there is no social friend with this id : " + socialFriendIdWithTablePrefix, token.getAccountId());
                        }
                        List resultList = SocialFriendsEntity.findAllFriendsSortedByFriendId((String)dnaId, (String)socialFriendIdWithTablePrefix, (int)count, (Token)token);
                        logger.info("socialNetworkFriendsSortedByFriendIdOrThrowEntityNotFoundOrRelatedObjectNotExistException : return friends.size() = " + resultList.size());
                        return resultList;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<List<StandartEventEntity>> eventListOrThrowEntityNotFoundOrRelatedObjectNotExistException(final Long startFromId, final int count, final Token token) {
        return Level2AccountService.fillWithLevel1AccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<List<StandartEventEntity>>>(){

            public Future<List<StandartEventEntity>> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<List<StandartEventEntity>>(){

                    @Override
                    public List<StandartEventEntity> call() throws Exception {
                        logger.info("eventListOrThrowEntityNotFoundOrRelatedObjectNotExistException : start");
                        Level1AccountEntity level1AccountEntity = accountContainer.getLevel1AccountEntity();
                        String dnaId = level1AccountEntity.getDnaAccountId();
                        List result = StandartEventEntity.findAllEventsSortedByIndexInDescOrder((String)dnaId, (Long)startFromId, (int)count, (Token)token);
                        return result;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<Void> inviteSocialFriendOrThrowEntityNotFoundOrRelatedObjectNotExistException(final String friendId, final SocialNetworks network, final Token token) {
        return Level2AccountService.fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound(network, token).flatMap((Function1)new Mapper<AccountContainer, Future<Void>>(){

            public Future<Void> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        logger.info("inviteSocialFriend : " + friendId + " social network : " + network.name());
                        String dnaId = accountContainer.getDnaUserProfileEntity().getAccountId();
                        String finalFriendId = network.getTableIdPrefix().concat(friendId);
                        SocialFriendsEntity socialFriend = SocialFriendsEntity.fetchById((String)dnaId, (String)finalFriendId, (Token)token);
                        if (socialFriend == null) {
                            throw new RelatedObjectNotExistException("Error : inviteSocialFriendOrThrowEntityNotFoundOrRelatedObjectNotExistException : Social friend with this id does not exist friendId : " + friendId, token.getAccountId());
                        }
                        SocialFriendsEntity.inviteFriend((String)dnaId, (String)finalFriendId, (Token)token);
                        return null;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<Void> shareOnOwnWallOrThrowException(final SocialNetworks network, final String eventCode, final LocaleCollection locale, final Token token) {
        return Level2AccountService.fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound(network, token).flatMap((Function1)new Mapper<AccountContainer, Future<Void>>(){

            public Future<Void> apply(AccountContainer accountContainer) {
                logger.info("shareOnOwnWallOrThrowException : start");
                String socialAccessToken = null;
                if (network == SocialNetworks.Facebook) {
                    socialAccessToken = accountContainer.getFacebookTokenEntity().getAccessToken();
                } else if (network == SocialNetworks.Vkontakte) {
                    socialAccessToken = accountContainer.getVkontakteTokenEntity().getAccessToken();
                } else {
                    throw new IllegalArgumentException("Error : shareOnOwnWallOrThrowException : There is no such network : " + network.name());
                }
                int scores = accountContainer.getDnaUserProfileEntity().getScores().intValue();
                String rank = null;
                if (locale == LocaleCollection.en) {
                    rank = RankCollections.getRankByScore((double)new Double(scores)).getRank_en();
                } else if (locale == LocaleCollection.ru) {
                    rank = RankCollections.getRankByScore((double)new Double(scores)).getRank_ru();
                } else {
                    throw new IllegalArgumentException("Error : shareOnOwnWallOrThrowException : There is no such locale : " + locale.name());
                }
                return SocialGrabber.shareOnOwnWall((SocialNetworks)network, (String)eventCode, (String)locale.name(), (String)socialAccessToken, (String)rank, (int)scores, (Token)token);
            }
        }, BigBird.socialNetworkExecutionContext());
    }

    public static Future<Void> updateAccessTokenForSocialNetworkOrThrowEntityNotFound(final String socialAccessToken, final String numberOfSecondsUntilTokenExpire, final String refreshDateAsString, final SocialNetworks socialNetwork, final Token token) {
        return Level2AccountService.fillWithLevel1ANDSocialTokenEntityANDDnaAccountOrThrowEntityNotFound(socialNetwork, token).flatMap((Function1)new Mapper<AccountContainer, Future<Void>>(){

            public Future<Void> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        logger.info("updateAccessTokenForSocialNetworkOrThrowEntityNotFound : network : " + socialNetwork.name());
                        LocalDateTime timeWhenTokenWillBeExpired = numberOfSecondsUntilTokenExpire != null && !numberOfSecondsUntilTokenExpire.equals("0") ? LocalDateTime.now().plusSeconds(Integer.parseInt(numberOfSecondsUntilTokenExpire)) : null;
                        LocalDateTime refreshDateTime = null;
                        if (refreshDateAsString != null && !refreshDateAsString.isEmpty()) {
                            try {
                                refreshDateTime = LocalDateTime.parse((String)refreshDateAsString);
                            }
                            catch (Exception ex) {
                                logger.error("updateAccessTokenForSocialNetworkOrThrowEntityNotFound : Error when parse refresh date : " + refreshDateAsString, (Throwable)ex);
                            }
                        }
                        if (socialNetwork == SocialNetworks.Facebook) {
                            FacebookTokenEntity facebookTokenEntity = accountContainer.getFacebookTokenEntity();
                            FacebookTokenEntity.updateToken((String)facebookTokenEntity.getAccountId(), (String)socialAccessToken, (LocalDateTime)timeWhenTokenWillBeExpired, (LocalDateTime)refreshDateTime, (Token)token);
                        } else if (socialNetwork == SocialNetworks.Vkontakte) {
                            VkontakteTokenEntity vkontakteTokenEntity = accountContainer.getVkontakteTokenEntity();
                            VkontakteTokenEntity.updateToken((String)vkontakteTokenEntity.getAccountId(), (String)socialAccessToken, (LocalDateTime)timeWhenTokenWillBeExpired, (LocalDateTime)refreshDateTime, (Token)token);
                        } else {
                            throw new IllegalArgumentException("Error : updateAccessTokenForSocialNetworkOrThrowEntityNotFound : There is no such network : " + socialNetwork.name());
                        }
                        return null;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<DnaUserProfileEntity> deleteNetworkOrThrowEntityNotFound(final SocialNetworks network, final Token token) {
        return Level2AccountService.fillWithLevel1AccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<DnaUserProfileEntity>>(){

            public Future<DnaUserProfileEntity> apply(final AccountContainer accountContainerWithLevel1) {
                return Futures.future((Callable)new Callable<DnaUserProfileEntity>(){

                    @Override
                    public DnaUserProfileEntity call() throws Exception {
                        if (accountContainerWithLevel1.getLevel1AccountEntity().getDnaAccountId() == null) {
                            throw new EntityNotFoundException("Error : deleteNetworkOrThrowEntityNotFound : There is no dnaAccountId", token.getAccountId());
                        }
                        return DnaAccountService.disableNetwork(accountContainerWithLevel1.getLevel1AccountEntity().getDnaAccountId(), network, token);
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static Future<Void> logoutOrThrowEntityNotFound(final Token token) {
        return Level2AccountService.fillWithLevel1ANDDnaAccountByTokenOrThrowEntityNotFound(token).flatMap((Function1)new Mapper<AccountContainer, Future<Void>>(){

            public Future<Void> apply(final AccountContainer accountContainer) {
                return Futures.future((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        logger.info("logoutOrThrowEntityNotFound : start");
                        Level1AccountEntity level1AccountEntity = accountContainer.getLevel1AccountEntity();
                        DnaUserProfileEntity dnaUserProfileEntity = accountContainer.getDnaUserProfileEntity();
                        logger.info("logoutOrThrowEntityNotFound : delete level1account");
                        Level1AccountEntity.deleteItems((List)Lists.newArrayList((Object[])new Level1AccountEntity[]{level1AccountEntity}), (Token)token);
                        logger.info("logoutOrThrowEntityNotFound : logout from DnaUserProfile");
                        DnaUserProfileEntity.dettachLevel1Account((String)dnaUserProfileEntity.getAccountId(), (String)level1AccountEntity.getLevel1accountId(), (Token)token);
                        return null;
                    }
                }, (ExecutionContext)BigBird.awsExecutionContext());
            }
        }, BigBird.awsExecutionContext());
    }

    public static class AccountContainer {
        final Level1AccountEntity level1AccountEntity;
        final DnaUserProfileEntity dnaUserProfileEntity;
        final FacebookTokenEntity facebookTokenEntity;
        final VkontakteTokenEntity vkontakteTokenEntity;

        private AccountContainer(Level1AccountEntity level1AccountEntity, DnaUserProfileEntity dnaUserProfileEntity, FacebookTokenEntity facebookTokenEntity, VkontakteTokenEntity vkontakteTokenEntity) {
            this.level1AccountEntity = level1AccountEntity;
            this.dnaUserProfileEntity = dnaUserProfileEntity;
            this.facebookTokenEntity = facebookTokenEntity;
            this.vkontakteTokenEntity = vkontakteTokenEntity;
        }

        public DnaUserProfileEntity getDnaUserProfileEntity() {
            return this.dnaUserProfileEntity;
        }

        public FacebookTokenEntity getFacebookTokenEntity() {
            return this.facebookTokenEntity;
        }

        public VkontakteTokenEntity getVkontakteTokenEntity() {
            return this.vkontakteTokenEntity;
        }

        public Level1AccountEntity getLevel1AccountEntity() {
            return this.level1AccountEntity;
        }

        public static AccountContainer defaultAccountContainer() {
            return new AccountContainer(null, null, null, null);
        }

        public AccountContainer withlevel1AccountEntity(Level1AccountEntity level1AccountEntity1) {
            return new AccountContainer(level1AccountEntity1, this.dnaUserProfileEntity, this.facebookTokenEntity, this.vkontakteTokenEntity);
        }

        public AccountContainer withDnaUserProfileEntity(DnaUserProfileEntity dnaUserProfileEntity) {
            return new AccountContainer(this.level1AccountEntity, dnaUserProfileEntity, this.facebookTokenEntity, this.vkontakteTokenEntity);
        }

        public AccountContainer withFacebookTokenEntity(FacebookTokenEntity facebookTokenEntity) {
            return new AccountContainer(this.level1AccountEntity, this.dnaUserProfileEntity, facebookTokenEntity, this.vkontakteTokenEntity);
        }

        public AccountContainer withVkontakteTokenEntity(VkontakteTokenEntity vkontakteTokenEntity) {
            return new AccountContainer(this.level1AccountEntity, this.dnaUserProfileEntity, this.facebookTokenEntity, vkontakteTokenEntity);
        }
    }
}

