/*
 * Decompiled with CFR 0.152.
 */
package services;

import calculator.DnaScoreCalculator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import constants.SocialNetworks;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import db.model.DnaFriendsEntity;
import db.model.DnaUserProfileEntity;
import db.model.DnaUserProfileHistoryEntity;
import db.model.SocialFriendsEntity;
import db.model.fb.FacebookInfluenceEntity;
import db.model.fb.FacebookProfileMetaInfo;
import db.model.fb.FacebookTokenEntity;
import db.model.fb.FacebookUserProfileEntity;
import db.model.vk.VkontakteInfluenceEntity;
import db.model.vk.VkontakteProfileMetaInfo;
import db.model.vk.VkontakteTokenEntity;
import db.model.vk.VkontakteUserProfileEntity;
import exceptions.EntityNotFoundException;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import services.RegistratorService;
import util.EventQueueBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnaAccountService {
    private static final Logger logger = LoggerFactory.getLogger(DnaAccountService.class);

    public static DnaUserProfileEntity disableNetwork(String dnaId, SocialNetworks socialNetworkToDisable, Token token) {
        logger.info("disableNetwork : " + socialNetworkToDisable.name());
        logger.info("disableNetwork : first fetch DnaUserProfileEntity");
        DnaUserProfileEntity oldDnaUserProfileEntity = DnaUserProfileEntity.fetchById((String)dnaId, (Token)token);
        if (oldDnaUserProfileEntity == null) {
            throw new EntityNotFoundException("Error throw disable network", token.getAccountId());
        }
        if (socialNetworkToDisable == SocialNetworks.Facebook && oldDnaUserProfileEntity.getFbAccountId() == null) {
            return oldDnaUserProfileEntity;
        }
        if (socialNetworkToDisable == SocialNetworks.Vkontakte && oldDnaUserProfileEntity.getVkAccountId() == null) {
            return oldDnaUserProfileEntity;
        }
        RegistratorService.AccountContainer accountContainer = RegistratorService.AccountContainer.cleanAccountContainer("LEVEL1_ACCOUNT_SOURCE");
        accountContainer = accountContainer.withDnaUserProfileEntity(oldDnaUserProfileEntity);
        accountContainer = DnaAccountService.fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly(accountContainer, socialNetworkToDisable, token);
        HashMap<String, ArrayList> tableKeyMapForDelete = new HashMap<String, ArrayList>();
        HashMap<String, ArrayList> tableItemMapForPut = new HashMap<String, ArrayList>();
        logger.info("disableNetwork : recalculate scores");
        ArrayList<Object> influenceList = new ArrayList<Object>();
        if (socialNetworkToDisable == SocialNetworks.Facebook && accountContainer.getVkontakteInfluenceEntity() != null) {
            influenceList.add(accountContainer.getVkontakteInfluenceEntity());
        } else if (socialNetworkToDisable == SocialNetworks.Vkontakte && accountContainer.getFacebookInfluenceEntity() != null) {
            influenceList.add(accountContainer.getFacebookInfluenceEntity());
        }
        Double newScores = DnaScoreCalculator.calculateDnaScores(influenceList);
        logger.info("disableNetwork : new scores : " + newScores.intValue());
        logger.info("disableNetwork : create a history entity");
        DnaUserProfileEntity newDnaUserProfile = null;
        if (socialNetworkToDisable == SocialNetworks.Facebook) {
            newDnaUserProfile = new DnaUserProfileEntity(oldDnaUserProfileEntity.getAccountId(), oldDnaUserProfileEntity.getName(), oldDnaUserProfileEntity.getGender(), oldDnaUserProfileEntity.getLocale(), oldDnaUserProfileEntity.getEmail(), oldDnaUserProfileEntity.getPictureUrl(), Long.valueOf(newScores.longValue()), null, null, null, oldDnaUserProfileEntity.getVkAccountId(), oldDnaUserProfileEntity.getTimeWhenVkWasAttached(), oldDnaUserProfileEntity.isVkActive(), oldDnaUserProfileEntity.getTimeWhenAccountWasCreated(), oldDnaUserProfileEntity.getLevel1ids(), oldDnaUserProfileEntity.getMainSocialNetwork());
        } else if (socialNetworkToDisable == SocialNetworks.Vkontakte) {
            newDnaUserProfile = new DnaUserProfileEntity(oldDnaUserProfileEntity.getAccountId(), oldDnaUserProfileEntity.getName(), oldDnaUserProfileEntity.getGender(), oldDnaUserProfileEntity.getLocale(), oldDnaUserProfileEntity.getEmail(), oldDnaUserProfileEntity.getPictureUrl(), Long.valueOf(newScores.longValue()), oldDnaUserProfileEntity.getFbAccountId(), oldDnaUserProfileEntity.getTimeWhenFbWasAttached(), oldDnaUserProfileEntity.isFbActive(), null, null, null, oldDnaUserProfileEntity.getTimeWhenAccountWasCreated(), oldDnaUserProfileEntity.getLevel1ids(), oldDnaUserProfileEntity.getMainSocialNetwork());
        }
        DnaUserProfileHistoryEntity historyEntity = new DnaUserProfileHistoryEntity(newDnaUserProfile);
        String dnaUserProfileEntityTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        String dnaUserProfileHistoryEntityName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        tableItemMapForPut.put(dnaUserProfileEntityTableName, Lists.newArrayList((Object[])new Map[]{newDnaUserProfile.toAttributeMap()}));
        tableItemMapForPut.put(dnaUserProfileHistoryEntityName, Lists.newArrayList((Object[])new Map[]{historyEntity.toAttributeMap()}));
        logger.info("disableNetwork : make batchWrite to put new profile and history");
        DynamoCommon.batchWrite(tableItemMapForPut, (Token)token);
        logger.info("disableNetwork : build events");
        EventQueueBuilder.buildAndSaveEventQueue((DnaUserProfileEntity)oldDnaUserProfileEntity, null, (DnaUserProfileEntity)newDnaUserProfile, null, (Token)token);
        if (socialNetworkToDisable == SocialNetworks.Facebook) {
            tableKeyMapForDelete.put(Dynamo.getFinalTableName(FacebookInfluenceEntity.class), Lists.newArrayList((Object[])new Map[]{accountContainer.getFacebookInfluenceEntity().keyMap()}));
            tableKeyMapForDelete.put(Dynamo.getFinalTableName(FacebookProfileMetaInfo.class), Lists.newArrayList((Object[])new Map[]{accountContainer.getFacebookProfileMetaInfo().keyMap()}));
            tableKeyMapForDelete.put(Dynamo.getFinalTableName(FacebookTokenEntity.class), Lists.newArrayList((Object[])new Map[]{accountContainer.getFacebookTokenEntity().keyMap()}));
            tableKeyMapForDelete.put(Dynamo.getFinalTableName(FacebookUserProfileEntity.class), Lists.newArrayList((Object[])new Map[]{accountContainer.getFacebookUserProfileEntity().keyMap()}));
        } else if (socialNetworkToDisable == SocialNetworks.Vkontakte) {
            tableKeyMapForDelete.put(Dynamo.getFinalTableName(VkontakteInfluenceEntity.class), Lists.newArrayList((Object[])new Map[]{accountContainer.getVkontakteInfluenceEntity().keyMap()}));
            tableKeyMapForDelete.put(Dynamo.getFinalTableName(VkontakteProfileMetaInfo.class), Lists.newArrayList((Object[])new Map[]{accountContainer.getVkontakteProfileMetaInfo().keyMap()}));
            tableKeyMapForDelete.put(Dynamo.getFinalTableName(VkontakteTokenEntity.class), Lists.newArrayList((Object[])new Map[]{accountContainer.getVkontakteTokenEntity().keyMap()}));
            tableKeyMapForDelete.put(Dynamo.getFinalTableName(VkontakteUserProfileEntity.class), Lists.newArrayList((Object[])new Map[]{accountContainer.getVkontakteUserProfileEntity().keyMap()}));
        }
        logger.info("disableNetwork : make batchDelete to remove everything related to " + socialNetworkToDisable.name());
        DynamoCommon.batchDelete(tableKeyMapForDelete, (Token)token);
        List<SocialFriendsEntity> socialFriendsEntities = accountContainer.getSocialFriendsEntityList();
        if (socialFriendsEntities != null && !socialFriendsEntities.isEmpty()) {
            logger.info("disableNetwork : delete all SocialFriends related to " + socialNetworkToDisable.name());
            SocialFriendsEntity.deleteItems(socialFriendsEntities, (Token)token);
        }
        return newDnaUserProfile;
    }

    public static RegistratorService.AccountContainer remapAccountFromBasedOnUserStateToBasedOnLevel1(Map<String, RegistratorService.AccountContainer> containerMap, SocialNetworks networkToRemap, Token token) {
        logger.info("remapAccountFromBasedOnUserStateToBasedOnLevel1 : start");
        RegistratorService.AccountContainer fullAccountContainerBaseOnUserState = containerMap.get("USER_STATE_SOURCE");
        RegistratorService.AccountContainer friendsAccountContainerBase = containerMap.get("FRIENDS_ONLY_SOURCE");
        RegistratorService.AccountContainer accountContainerBaseOnLevel1 = containerMap.get("LEVEL1_ACCOUNT_SOURCE");
        HashMap tableKey = new HashMap();
        String dnaUserProfileEntityTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        String facebookUserProfileEntityTableName = Dynamo.getFinalTableName(FacebookUserProfileEntity.class);
        String vkontakteUserProfileEntityTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
        DnaUserProfileEntity newDnaUserProfileBasedOnUserState = null;
        DnaUserProfileEntity newDnaUserProfileBasedOnLevel1 = null;
        ArrayList<Object> newInfluenceListForUserStateBasedAccount = new ArrayList<Object>();
        if (networkToRemap == SocialNetworks.Facebook && fullAccountContainerBaseOnUserState.getVkontakteInfluenceEntity() != null) {
            newInfluenceListForUserStateBasedAccount.add(fullAccountContainerBaseOnUserState.getVkontakteInfluenceEntity());
        } else if (networkToRemap == SocialNetworks.Vkontakte && fullAccountContainerBaseOnUserState.getFacebookInfluenceEntity() != null) {
            newInfluenceListForUserStateBasedAccount.add(fullAccountContainerBaseOnUserState.getFacebookInfluenceEntity());
        }
        Double newScoreForAccountBasedOnUserState = newInfluenceListForUserStateBasedAccount.isEmpty() ? 0.0 : DnaScoreCalculator.calculateDnaScores(newInfluenceListForUserStateBasedAccount);
        DnaUserProfileEntity oldDnaUserProfileBasedOnUserState = fullAccountContainerBaseOnUserState.getDnaUserProfileEntity();
        if (networkToRemap == SocialNetworks.Facebook) {
            newDnaUserProfileBasedOnUserState = new DnaUserProfileEntity(oldDnaUserProfileBasedOnUserState.getAccountId(), oldDnaUserProfileBasedOnUserState.getName(), oldDnaUserProfileBasedOnUserState.getGender(), oldDnaUserProfileBasedOnUserState.getLocale(), oldDnaUserProfileBasedOnUserState.getEmail(), oldDnaUserProfileBasedOnUserState.getPictureUrl(), Long.valueOf(newScoreForAccountBasedOnUserState.longValue()), null, null, null, oldDnaUserProfileBasedOnUserState.getVkAccountId(), oldDnaUserProfileBasedOnUserState.getTimeWhenVkWasAttached(), oldDnaUserProfileBasedOnUserState.isVkActive(), oldDnaUserProfileBasedOnUserState.getTimeWhenAccountWasCreated(), oldDnaUserProfileBasedOnUserState.getLevel1ids(), oldDnaUserProfileBasedOnUserState.getMainSocialNetwork());
        } else if (networkToRemap == SocialNetworks.Vkontakte) {
            newDnaUserProfileBasedOnUserState = new DnaUserProfileEntity(oldDnaUserProfileBasedOnUserState.getAccountId(), oldDnaUserProfileBasedOnUserState.getName(), oldDnaUserProfileBasedOnUserState.getGender(), oldDnaUserProfileBasedOnUserState.getLocale(), oldDnaUserProfileBasedOnUserState.getEmail(), oldDnaUserProfileBasedOnUserState.getPictureUrl(), Long.valueOf(newScoreForAccountBasedOnUserState.longValue()), oldDnaUserProfileBasedOnUserState.getFbAccountId(), oldDnaUserProfileBasedOnUserState.getTimeWhenFbWasAttached(), oldDnaUserProfileBasedOnUserState.isFbActive(), null, null, null, oldDnaUserProfileBasedOnUserState.getTimeWhenAccountWasCreated(), oldDnaUserProfileBasedOnUserState.getLevel1ids(), oldDnaUserProfileBasedOnUserState.getMainSocialNetwork());
        }
        ArrayList<Object> newInfluenceListForLevel1BasedAccount = new ArrayList<Object>();
        if (networkToRemap == SocialNetworks.Facebook) {
            newInfluenceListForLevel1BasedAccount.add(fullAccountContainerBaseOnUserState.getFacebookInfluenceEntity());
            if (accountContainerBaseOnLevel1.getVkontakteInfluenceEntity() != null) {
                newInfluenceListForLevel1BasedAccount.add(accountContainerBaseOnLevel1.getVkontakteInfluenceEntity());
            }
        } else if (networkToRemap == SocialNetworks.Vkontakte) {
            newInfluenceListForLevel1BasedAccount.add(fullAccountContainerBaseOnUserState.getVkontakteInfluenceEntity());
            if (accountContainerBaseOnLevel1.getFacebookInfluenceEntity() != null) {
                newInfluenceListForLevel1BasedAccount.add(accountContainerBaseOnLevel1.getFacebookInfluenceEntity());
            }
        }
        Double newScoreForAccountBasedOnLevel1 = newInfluenceListForLevel1BasedAccount.isEmpty() ? 0.0 : DnaScoreCalculator.calculateDnaScores(newInfluenceListForLevel1BasedAccount);
        DnaUserProfileEntity oldDnaUserProfileBasedOnLevel1 = accountContainerBaseOnLevel1.getDnaUserProfileEntity();
        if (networkToRemap == SocialNetworks.Facebook) {
            newDnaUserProfileBasedOnLevel1 = new DnaUserProfileEntity(oldDnaUserProfileBasedOnLevel1.getAccountId(), oldDnaUserProfileBasedOnLevel1.getName(), oldDnaUserProfileBasedOnLevel1.getGender(), oldDnaUserProfileBasedOnLevel1.getLocale(), oldDnaUserProfileBasedOnLevel1.getEmail(), oldDnaUserProfileBasedOnLevel1.getPictureUrl(), Long.valueOf(newScoreForAccountBasedOnLevel1.longValue()), oldDnaUserProfileBasedOnUserState.getFbAccountId(), LocalDateTime.now(), Boolean.TRUE, oldDnaUserProfileBasedOnLevel1.getVkAccountId(), oldDnaUserProfileBasedOnLevel1.getTimeWhenVkWasAttached(), oldDnaUserProfileBasedOnLevel1.isVkActive(), oldDnaUserProfileBasedOnLevel1.getTimeWhenAccountWasCreated(), oldDnaUserProfileBasedOnLevel1.getLevel1ids(), oldDnaUserProfileBasedOnLevel1.getMainSocialNetwork());
        } else if (networkToRemap == SocialNetworks.Vkontakte) {
            newDnaUserProfileBasedOnLevel1 = new DnaUserProfileEntity(oldDnaUserProfileBasedOnLevel1.getAccountId(), oldDnaUserProfileBasedOnLevel1.getName(), oldDnaUserProfileBasedOnLevel1.getGender(), oldDnaUserProfileBasedOnLevel1.getLocale(), oldDnaUserProfileBasedOnLevel1.getEmail(), oldDnaUserProfileBasedOnLevel1.getPictureUrl(), Long.valueOf(newScoreForAccountBasedOnLevel1.longValue()), oldDnaUserProfileBasedOnLevel1.getFbAccountId(), oldDnaUserProfileBasedOnLevel1.getTimeWhenFbWasAttached(), oldDnaUserProfileBasedOnLevel1.isFbActive(), oldDnaUserProfileBasedOnUserState.getVkAccountId(), LocalDateTime.now(), Boolean.TRUE, oldDnaUserProfileBasedOnLevel1.getTimeWhenAccountWasCreated(), oldDnaUserProfileBasedOnLevel1.getLevel1ids(), oldDnaUserProfileBasedOnLevel1.getMainSocialNetwork());
        }
        ArrayList<Map> dnaItems = new ArrayList<Map>();
        dnaItems.add(newDnaUserProfileBasedOnUserState.toAttributeMap());
        dnaItems.add(newDnaUserProfileBasedOnLevel1.toAttributeMap());
        tableKey.put(dnaUserProfileEntityTableName, dnaItems);
        String newDnaId = oldDnaUserProfileBasedOnLevel1.getAccountId();
        ArrayList<Map> remapedItems = new ArrayList<Map>();
        if (networkToRemap == SocialNetworks.Facebook) {
            FacebookUserProfileEntity facebookUserProfileEntity = fullAccountContainerBaseOnUserState.getFacebookUserProfileEntity();
            FacebookUserProfileEntity newFacebookUserProfileEntity = FacebookUserProfileEntity.createCopyMappedToDifferentDnaAccount((FacebookUserProfileEntity)facebookUserProfileEntity, (String)newDnaId);
            remapedItems.add(newFacebookUserProfileEntity.toAttributeMap());
            tableKey.put(facebookUserProfileEntityTableName, remapedItems);
        } else if (networkToRemap == SocialNetworks.Vkontakte) {
            VkontakteUserProfileEntity vkontakteUserProfileEntity = fullAccountContainerBaseOnUserState.getVkontakteUserProfileEntity();
            VkontakteUserProfileEntity newVkontakteUserProfileEntity = VkontakteUserProfileEntity.createCopyMappedToDifferentDnaAccount((VkontakteUserProfileEntity)vkontakteUserProfileEntity, (String)newDnaId);
            remapedItems.add(newVkontakteUserProfileEntity.toAttributeMap());
            tableKey.put(vkontakteUserProfileEntityTableName, remapedItems);
        }
        String dnaUserProfileHistoryEntityTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        DnaUserProfileHistoryEntity dnaUserProfileHistoryEntityBasedOnLevel1 = new DnaUserProfileHistoryEntity(newDnaUserProfileBasedOnLevel1);
        DnaUserProfileHistoryEntity dnaUserProfileHistoryEntityBasedOnUserState = new DnaUserProfileHistoryEntity(newDnaUserProfileBasedOnUserState);
        ArrayList<Map> dnaUserProfileHistoryEntityItems = new ArrayList<Map>();
        dnaUserProfileHistoryEntityItems.add(dnaUserProfileHistoryEntityBasedOnLevel1.toAttributeMap());
        dnaUserProfileHistoryEntityItems.add(dnaUserProfileHistoryEntityBasedOnUserState.toAttributeMap());
        tableKey.put(dnaUserProfileHistoryEntityTableName, dnaUserProfileHistoryEntityItems);
        logger.info("remapAccountFromBasedOnUserStateToBasedOnLevel1 : make batchWrite to write new Dna accounts and remaped social account");
        DynamoCommon.batchWrite(tableKey, (Token)token);
        if (!friendsAccountContainerBase.getSocialFriendsEntityList().isEmpty()) {
            logger.info("remapAccountFromBasedOnUserStateToBasedOnLevel1 : delete related social friends from account based on user state");
            SocialFriendsEntity.deleteItems(friendsAccountContainerBase.getSocialFriendsEntityList(), (Token)token);
            ArrayList<SocialFriendsEntity> newFriends = new ArrayList<SocialFriendsEntity>();
            for (SocialFriendsEntity socialFriendsEntity : friendsAccountContainerBase.getSocialFriendsEntityList()) {
                newFriends.add(SocialFriendsEntity.createCopyMappedToDifferentDnaAccount((SocialFriendsEntity)socialFriendsEntity, (String)newDnaId));
            }
            logger.info("remapAccountFromBasedOnUserStateToBasedOnLevel1 : add related social friends to account based on Level1");
            SocialFriendsEntity.saveList(newFriends, (Token)token);
        }
        ArrayList<DnaFriendsEntity> newDnaFriends = new ArrayList<DnaFriendsEntity>();
        if (!friendsAccountContainerBase.getDnaFriendsEntityList().isEmpty()) {
            for (DnaFriendsEntity dnaFriendsEntity : friendsAccountContainerBase.getDnaFriendsEntityList()) {
                newDnaFriends.add(DnaFriendsEntity.createCopyMappedToDifferentDnaAccount((DnaFriendsEntity)dnaFriendsEntity, (String)newDnaId));
            }
            logger.info("remapAccountFromBasedOnUserStateToBasedOnLevel1 : copy related dna friends to account based on Level1");
            DnaFriendsEntity.saveList(newDnaFriends, (Token)token);
        }
        logger.info("remapAccountFromBasedOnUserStateToBasedOnLevel1 : add new dna account into container based on level1 and return them");
        accountContainerBaseOnLevel1 = accountContainerBaseOnLevel1.withDnaUserProfileEntity(newDnaUserProfileBasedOnLevel1);
        logger.info("remapAccountFromBasedOnUserStateToBasedOnLevel1 : build events queue for both accounts");
        EventQueueBuilder.buildAndSaveEventQueue((DnaUserProfileEntity)oldDnaUserProfileBasedOnLevel1, accountContainerBaseOnLevel1.getDnaFriendsEntityList(), (DnaUserProfileEntity)newDnaUserProfileBasedOnLevel1, newDnaFriends, (Token)token);
        EventQueueBuilder.buildAndSaveEventQueue((DnaUserProfileEntity)oldDnaUserProfileBasedOnUserState, null, (DnaUserProfileEntity)newDnaUserProfileBasedOnUserState, null, (Token)token);
        return accountContainerBaseOnLevel1;
    }

    public static Map<String, RegistratorService.AccountContainer> createContainerWithFriendsOnlyRelatedToSocialNetwork(RegistratorService.AccountContainer fullAccountContainerBase, SocialNetworks networkToRemap, Token token) {
        logger.info("createContainerWithFriendsOnlyRelatedToSocialNetwork : start");
        HashSet<String> sourcedFriendsIds = new HashSet<String>();
        ArrayList<SocialFriendsEntity> relatedSocialFriends = new ArrayList<SocialFriendsEntity>();
        for (SocialFriendsEntity eachFriend : fullAccountContainerBase.getSocialFriendsEntityList()) {
            if (!eachFriend.getFriendId().startsWith(networkToRemap.getTableIdPrefix())) continue;
            relatedSocialFriends.add(eachFriend);
            sourcedFriendsIds.add(eachFriend.getFriendId().replaceFirst(networkToRemap.getTableIdPrefix(), ""));
        }
        logger.info("createContainerWithFriendsOnlyRelatedToSocialNetwork : there is " + relatedSocialFriends.size() + " related social friends");
        ArrayList<DnaFriendsEntity> filteredDnaFriends = new ArrayList<DnaFriendsEntity>();
        ArrayList<String> dnaFriendsId = new ArrayList<String>();
        List dnaProfiles = new ArrayList();
        for (DnaFriendsEntity eachFriend : fullAccountContainerBase.getDnaFriendsEntityList()) {
            dnaFriendsId.add(eachFriend.getFriendId());
        }
        HashSet<String> dnaIdsThatRealyCouldBeOurFriends = new HashSet<String>();
        if (!dnaFriendsId.isEmpty()) {
            logger.info("createContainerWithFriendsOnlyRelatedToSocialNetwork : ask all DnaUserProfiles with ids that we have in our dnaFriends ids : " + dnaFriendsId.size());
            dnaProfiles = DnaUserProfileEntity.fetchByIdList(dnaFriendsId, (Token)token);
            logger.info("createContainerWithFriendsOnlyRelatedToSocialNetwork : there are " + dnaProfiles.size() + " profiles : filter them");
            for (DnaUserProfileEntity eachProfile : dnaProfiles) {
                String socialId;
                if (networkToRemap == SocialNetworks.Facebook) {
                    socialId = eachProfile.getFbAccountId();
                    if (socialId == null || !sourcedFriendsIds.contains(socialId)) continue;
                    dnaIdsThatRealyCouldBeOurFriends.add(eachProfile.getAccountId());
                    continue;
                }
                if (networkToRemap != SocialNetworks.Vkontakte || (socialId = eachProfile.getVkAccountId()) == null || !sourcedFriendsIds.contains(socialId)) continue;
                dnaIdsThatRealyCouldBeOurFriends.add(eachProfile.getAccountId());
            }
        }
        logger.info("createContainerWithFriendsOnlyRelatedToSocialNetwork : after filtering there are " + dnaIdsThatRealyCouldBeOurFriends.size() + " dna's id that could be our real DNA frined");
        for (DnaFriendsEntity eachFriend : fullAccountContainerBase.getDnaFriendsEntityList()) {
            if (!dnaIdsThatRealyCouldBeOurFriends.contains(eachFriend.getFriendId())) continue;
            filteredDnaFriends.add(eachFriend);
        }
        logger.info("createContainerWithFriendsOnlyRelatedToSocialNetwork : finaly we have " + filteredDnaFriends.size() + " dna's friends related to this social account");
        RegistratorService.AccountContainer resultContainer = RegistratorService.AccountContainer.cleanAccountContainer("FRIENDS_ONLY_SOURCE");
        resultContainer = resultContainer.withSocialFriendsEntity(relatedSocialFriends);
        resultContainer = resultContainer.withDnaFriendsEntity(filteredDnaFriends);
        HashMap<String, RegistratorService.AccountContainer> resultMap = new HashMap<String, RegistratorService.AccountContainer>();
        resultMap.put(resultContainer.getSource(), resultContainer);
        resultMap.put(fullAccountContainerBase.getSource(), fullAccountContainerBase);
        return resultMap;
    }

    public static RegistratorService.AccountContainer fillContainerWithAllInfoBasedOnDnaAccountInIt(RegistratorService.AccountContainer accountContainerBase, boolean fillWithFriends, Token token) {
        Map item;
        HashMap<String, AttributeValue> key;
        ArrayList keyList;
        String accountId;
        logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : start");
        RegistratorService.AccountContainer resultContainer = accountContainerBase;
        DnaUserProfileEntity dnaUserProfileEntity = resultContainer.getDnaUserProfileEntity();
        if (fillWithFriends && resultContainer.getDnaFriendsEntityList() == null) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with DnaFriends");
            List dnaFriendsEntityList = DnaFriendsEntity.findAllFriendsSortedByFriendId((String)dnaUserProfileEntity.getAccountId(), (Token)token);
            resultContainer = resultContainer.withDnaFriendsEntity(dnaFriendsEntityList);
        }
        if (fillWithFriends && resultContainer.getSocialFriendsEntityList() == null) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with SocialFriends");
            List socialFriendsEntitieList = SocialFriendsEntity.findAllFriendsSortedByFriendId((String)dnaUserProfileEntity.getAccountId(), (Token)token);
            resultContainer = resultContainer.withSocialFriendsEntity(socialFriendsEntitieList);
        }
        HashMap tableKeys = new HashMap();
        String facebookInfluenceEntityTableName = Dynamo.getFinalTableName(FacebookInfluenceEntity.class);
        String facebookProfileMetaInfoTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
        String facebookTokenEntityTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
        String facebookUserProfileEntityTableName = Dynamo.getFinalTableName(FacebookUserProfileEntity.class);
        String vkontakteInfluenceEntityTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
        String vkontakteProfileMetaInfoTableName = Dynamo.getFinalTableName(VkontakteProfileMetaInfo.class);
        String vkontakteTokenEntityTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
        String vkontakteUserProfileEntityTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
        if (dnaUserProfileEntity.getFbAccountId() != null && !dnaUserProfileEntity.getFbAccountId().isEmpty()) {
            accountId = dnaUserProfileEntity.getFbAccountId();
            keyList = new ArrayList();
            key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(accountId));
            keyList.add(key);
            if (resultContainer.getFacebookInfluenceEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with FacebookInfluenceEntity");
                tableKeys.put(facebookInfluenceEntityTableName, keyList);
            }
            if (resultContainer.getFacebookProfileMetaInfo() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with FacebookProfileMetaInfo");
                tableKeys.put(facebookProfileMetaInfoTableName, keyList);
            }
            if (resultContainer.getFacebookTokenEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with FacebookTokenEntity");
                tableKeys.put(facebookTokenEntityTableName, keyList);
            }
            if (resultContainer.getFacebookUserProfileEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with FacebookUserProfileEntity");
                tableKeys.put(facebookUserProfileEntityTableName, keyList);
            }
        }
        if (dnaUserProfileEntity.getVkAccountId() != null && !dnaUserProfileEntity.getVkAccountId().isEmpty()) {
            accountId = dnaUserProfileEntity.getVkAccountId();
            keyList = new ArrayList();
            key = new HashMap();
            key.put("ID", new AttributeValue().withS(accountId));
            keyList.add(key);
            if (resultContainer.getVkontakteInfluenceEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with VkontakteInfluenceEntity");
                tableKeys.put(vkontakteInfluenceEntityTableName, keyList);
            }
            if (resultContainer.getVkontakteProfileMetaInfo() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with VkontakteProfileMetaInfo");
                tableKeys.put(vkontakteProfileMetaInfoTableName, keyList);
            }
            if (resultContainer.getVkontakteTokenEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with VkontakteTokenEntity");
                tableKeys.put(vkontakteTokenEntityTableName, keyList);
            }
            if (resultContainer.getVkontakteUserProfileEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : fill with VkontakteUserProfileEntity");
                tableKeys.put(vkontakteUserProfileEntityTableName, keyList);
            }
        }
        if (tableKeys.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : have everything into conatiner already : just return them");
            return resultContainer;
        }
        logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : make batchRequest");
        Map response = DynamoCommon.batchGet(tableKeys, (Token)token);
        logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : there are " + response.keySet().size() + " tables in response");
        List facebookInfluenceEntityList = (List)response.get(facebookInfluenceEntityTableName);
        List facebookProfileMetaInfoList = (List)response.get(facebookProfileMetaInfoTableName);
        List facebookTokenEntityList = (List)response.get(facebookTokenEntityTableName);
        List facebookUserProfileEntityList = (List)response.get(facebookUserProfileEntityTableName);
        List vkontakteInfluenceEntityList = (List)response.get(vkontakteInfluenceEntityTableName);
        List vkontakteProfileMetaInfoList = (List)response.get(vkontakteProfileMetaInfoTableName);
        List vkontakteTokenEntityList = (List)response.get(vkontakteTokenEntityTableName);
        List vkontakteUserProfileEntityList = (List)response.get(vkontakteUserProfileEntityTableName);
        if (facebookInfluenceEntityList != null && !facebookInfluenceEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : there is FacebookInfluenceEntity in response : put it into AccountContainer");
            item = (Map)facebookInfluenceEntityList.get(0);
            resultContainer = resultContainer.withFacebookInfluenceEntity(FacebookInfluenceEntity.fromAttributeMap((Map)item));
        }
        if (facebookProfileMetaInfoList != null && !facebookProfileMetaInfoList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : there is FacebookProfileMetaInfo in response : put it into AccountContainer");
            item = (Map)facebookProfileMetaInfoList.get(0);
            resultContainer = resultContainer.withFacebookProfileMetaInfo(FacebookProfileMetaInfo.fromAttributeMap((Map)item));
        }
        if (facebookTokenEntityList != null && !facebookTokenEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : there is FacebookTokenEntity in response : put it into AccountContainer");
            item = (Map)facebookTokenEntityList.get(0);
            resultContainer = resultContainer.withFacebookTokenEntity(FacebookTokenEntity.fromAttributeMap((Map)item));
        }
        if (facebookUserProfileEntityList != null && !facebookUserProfileEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : there is FacebookUserProfileEntity in response : put it into AccountContainer");
            item = (Map)facebookUserProfileEntityList.get(0);
            resultContainer = resultContainer.withFacebookUserProfileEntity(FacebookUserProfileEntity.fromAttributeMap((Map)item));
        }
        if (vkontakteInfluenceEntityList != null && !vkontakteInfluenceEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : there is VkontakteInfluenceEntity in response : put it into AccountContainer");
            item = (Map)vkontakteInfluenceEntityList.get(0);
            resultContainer = resultContainer.withVkontakteInfluenceEntity(VkontakteInfluenceEntity.fromAttributeMap((Map)item));
        }
        if (vkontakteProfileMetaInfoList != null && !vkontakteProfileMetaInfoList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : there is VkontakteProfileMetaInfo in response : put it into AccountContainer");
            item = (Map)vkontakteProfileMetaInfoList.get(0);
            resultContainer = resultContainer.withVkontakteProfileMetaInfo(VkontakteProfileMetaInfo.fromAttributeMap((Map)item));
        }
        if (vkontakteTokenEntityList != null && !vkontakteTokenEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : there is VkontakteTokenEntity in response : put it into AccountContainer");
            item = (Map)vkontakteTokenEntityList.get(0);
            resultContainer = resultContainer.withVkontakteTokenEntity(VkontakteTokenEntity.fromAttributeMap((Map)item));
        }
        if (vkontakteUserProfileEntityList != null && !vkontakteUserProfileEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInIt : there is VkontakteUserProfileEntity in response : put it into AccountContainer");
            item = (Map)vkontakteUserProfileEntityList.get(0);
            resultContainer = resultContainer.withVkontakteUserProfileEntity(VkontakteUserProfileEntity.fromAttributeMap((Map)item));
        }
        return resultContainer;
    }

    public static RegistratorService.AccountContainer fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly(RegistratorService.AccountContainer accountContainerBase, SocialNetworks network, Token token) {
        Map item;
        HashMap<String, AttributeValue> key;
        ArrayList keyList;
        String accountId;
        logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : network for friends : " + network.name());
        RegistratorService.AccountContainer resultContainer = accountContainerBase;
        DnaUserProfileEntity dnaUserProfileEntity = resultContainer.getDnaUserProfileEntity();
        if (resultContainer.getSocialFriendsEntityList() == null) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : fill with SocialFriends from : " + network.name());
            List socialFriendsEntitieList = SocialFriendsEntity.findAllFriendsSortedByFriendIdForSocialNetwork((String)dnaUserProfileEntity.getAccountId(), (SocialNetworks)network, (Token)token);
            resultContainer = resultContainer.withSocialFriendsEntity(socialFriendsEntitieList);
        }
        HashMap tableKeys = new HashMap();
        String facebookInfluenceEntityTableName = Dynamo.getFinalTableName(FacebookInfluenceEntity.class);
        String facebookProfileMetaInfoTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
        String facebookTokenEntityTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
        String facebookUserProfileEntityTableName = Dynamo.getFinalTableName(FacebookUserProfileEntity.class);
        String vkontakteInfluenceEntityTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
        String vkontakteProfileMetaInfoTableName = Dynamo.getFinalTableName(VkontakteProfileMetaInfo.class);
        String vkontakteTokenEntityTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
        String vkontakteUserProfileEntityTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
        if (dnaUserProfileEntity.getFbAccountId() != null && !dnaUserProfileEntity.getFbAccountId().isEmpty()) {
            accountId = dnaUserProfileEntity.getFbAccountId();
            keyList = new ArrayList();
            key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(accountId));
            keyList.add(key);
            if (resultContainer.getFacebookInfluenceEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : fill with FacebookInfluenceEntity");
                tableKeys.put(facebookInfluenceEntityTableName, keyList);
            }
            if (resultContainer.getFacebookProfileMetaInfo() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : fill with FacebookProfileMetaInfo");
                tableKeys.put(facebookProfileMetaInfoTableName, keyList);
            }
            if (resultContainer.getFacebookTokenEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : fill with FacebookTokenEntity");
                tableKeys.put(facebookTokenEntityTableName, keyList);
            }
            if (resultContainer.getFacebookUserProfileEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : fill with FacebookUserProfileEntity");
                tableKeys.put(facebookUserProfileEntityTableName, keyList);
            }
        }
        if (dnaUserProfileEntity.getVkAccountId() != null && !dnaUserProfileEntity.getVkAccountId().isEmpty()) {
            accountId = dnaUserProfileEntity.getVkAccountId();
            keyList = new ArrayList();
            key = new HashMap();
            key.put("ID", new AttributeValue().withS(accountId));
            keyList.add(key);
            if (resultContainer.getVkontakteInfluenceEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : fill with VkontakteInfluenceEntity");
                tableKeys.put(vkontakteInfluenceEntityTableName, keyList);
            }
            if (resultContainer.getVkontakteProfileMetaInfo() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : fill with VkontakteProfileMetaInfo");
                tableKeys.put(vkontakteProfileMetaInfoTableName, keyList);
            }
            if (resultContainer.getVkontakteTokenEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : fill with VkontakteTokenEntity");
                tableKeys.put(vkontakteTokenEntityTableName, keyList);
            }
            if (resultContainer.getVkontakteUserProfileEntity() == null) {
                logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : fill with VkontakteUserProfileEntity");
                tableKeys.put(vkontakteUserProfileEntityTableName, keyList);
            }
        }
        if (tableKeys.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : have everything into conatiner already : just return them");
            return resultContainer;
        }
        logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : make batchRequest");
        Map response = DynamoCommon.batchGet(tableKeys, (Token)token);
        logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : there are " + response.keySet().size() + " tables in response");
        List facebookInfluenceEntityList = (List)response.get(facebookInfluenceEntityTableName);
        List facebookProfileMetaInfoList = (List)response.get(facebookProfileMetaInfoTableName);
        List facebookTokenEntityList = (List)response.get(facebookTokenEntityTableName);
        List facebookUserProfileEntityList = (List)response.get(facebookUserProfileEntityTableName);
        List vkontakteInfluenceEntityList = (List)response.get(vkontakteInfluenceEntityTableName);
        List vkontakteProfileMetaInfoList = (List)response.get(vkontakteProfileMetaInfoTableName);
        List vkontakteTokenEntityList = (List)response.get(vkontakteTokenEntityTableName);
        List vkontakteUserProfileEntityList = (List)response.get(vkontakteUserProfileEntityTableName);
        if (facebookInfluenceEntityList != null && !facebookInfluenceEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : there is FacebookInfluenceEntity in response : put it into AccountContainer");
            item = (Map)facebookInfluenceEntityList.get(0);
            resultContainer = resultContainer.withFacebookInfluenceEntity(FacebookInfluenceEntity.fromAttributeMap((Map)item));
        }
        if (facebookProfileMetaInfoList != null && !facebookProfileMetaInfoList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : there is FacebookProfileMetaInfo in response : put it into AccountContainer");
            item = (Map)facebookProfileMetaInfoList.get(0);
            resultContainer = resultContainer.withFacebookProfileMetaInfo(FacebookProfileMetaInfo.fromAttributeMap((Map)item));
        }
        if (facebookTokenEntityList != null && !facebookTokenEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : there is FacebookTokenEntity in response : put it into AccountContainer");
            item = (Map)facebookTokenEntityList.get(0);
            resultContainer = resultContainer.withFacebookTokenEntity(FacebookTokenEntity.fromAttributeMap((Map)item));
        }
        if (facebookUserProfileEntityList != null && !facebookUserProfileEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : there is FacebookUserProfileEntity in response : put it into AccountContainer");
            item = (Map)facebookUserProfileEntityList.get(0);
            resultContainer = resultContainer.withFacebookUserProfileEntity(FacebookUserProfileEntity.fromAttributeMap((Map)item));
        }
        if (vkontakteInfluenceEntityList != null && !vkontakteInfluenceEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : there is VkontakteInfluenceEntity in response : put it into AccountContainer");
            item = (Map)vkontakteInfluenceEntityList.get(0);
            resultContainer = resultContainer.withVkontakteInfluenceEntity(VkontakteInfluenceEntity.fromAttributeMap((Map)item));
        }
        if (vkontakteProfileMetaInfoList != null && !vkontakteProfileMetaInfoList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : there is VkontakteProfileMetaInfo in response : put it into AccountContainer");
            item = (Map)vkontakteProfileMetaInfoList.get(0);
            resultContainer = resultContainer.withVkontakteProfileMetaInfo(VkontakteProfileMetaInfo.fromAttributeMap((Map)item));
        }
        if (vkontakteTokenEntityList != null && !vkontakteTokenEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : there is VkontakteTokenEntity in response : put it into AccountContainer");
            item = (Map)vkontakteTokenEntityList.get(0);
            resultContainer = resultContainer.withVkontakteTokenEntity(VkontakteTokenEntity.fromAttributeMap((Map)item));
        }
        if (vkontakteUserProfileEntityList != null && !vkontakteUserProfileEntityList.isEmpty()) {
            logger.info("fillContainerWithAllInfoBasedOnDnaAccountInItWithSocialFriendsForSpecificNetworkOnly : there is VkontakteUserProfileEntity in response : put it into AccountContainer");
            item = (Map)vkontakteUserProfileEntityList.get(0);
            resultContainer = resultContainer.withVkontakteUserProfileEntity(VkontakteUserProfileEntity.fromAttributeMap((Map)item));
        }
        return resultContainer;
    }
}

