/*
 * Decompiled with CFR 0.152.
 */
package util;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import constants.SocialNetworks;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import db.model.DnaUserProfileEntity;
import db.model.SocialFriendsEntity;
import db.model.fb.FacebookUserProfileEntity;
import db.model.vk.VkontakteUserProfileEntity;
import entities.interfaces.UserProfile;
import entities.interfaces.UserState;
import executors.BigBird;
import identity.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FriendsUtil {
    private static final Logger logger = LoggerFactory.getLogger(FriendsUtil.class);

    public static Future<List<Object>> devideFriends(final UserState userState, final String dnaAccountId, Token token) {
        logger.info("devideFriends : start");
        return FriendsUtil.fetchDnaFriends(userState, token).flatMap((Function1)new Mapper<Map<String, DnaUserProfileEntity>, Future<List<Object>>>(){

            public Future<List<Object>> apply(final Map<String, DnaUserProfileEntity> dnaFriends) {
                return Futures.future((Callable)new Callable<List<Object>>(){

                    @Override
                    public List<Object> call() throws Exception {
                        ArrayList<Object> resultList = new ArrayList<Object>();
                        int dnaFriendsCount = 0;
                        int socialFriendCount = 0;
                        for (UserProfile eachProfile : userState.getFriends()) {
                            DnaUserProfileEntity dnaFriend = (DnaUserProfileEntity)dnaFriends.get(eachProfile.getId());
                            if (dnaFriend != null) {
                                ++dnaFriendsCount;
                                resultList.add(dnaFriend);
                                continue;
                            }
                            String idPrefix = SocialNetworks.valueOf((String)userState.getSocialNetworkName()).getTableIdPrefix();
                            String socialFriendIdInTable = idPrefix.concat(eachProfile.getId());
                            SocialFriendsEntity socialFriendsEntity = new SocialFriendsEntity(dnaAccountId, socialFriendIdInTable, eachProfile.getName(), eachProfile.getGender(), eachProfile.getLocale(), eachProfile.getEmail(), eachProfile.getPictureUrl(), eachProfile.getSocialNetworkName(), 0L);
                            ++socialFriendCount;
                            resultList.add(socialFriendsEntity);
                        }
                        logger.info("devideFriends : found dnaFriendsCount : " + dnaFriendsCount + " socialFriendCount : " + socialFriendCount);
                        return resultList;
                    }
                }, (ExecutionContext)BigBird.commonExecutionContext());
            }
        }, BigBird.commonExecutionContext());
    }

    public static Future<Map<String, DnaUserProfileEntity>> fetchDnaFriends(final UserState userState, final Token token) {
        logger.info("fetchDnaFriends : start");
        return Futures.future((Callable)new Callable<Map<String, DnaUserProfileEntity>>(){

            @Override
            public Map<String, DnaUserProfileEntity> call() throws Exception {
                List existingItems;
                Map response;
                HashMap<String, DnaUserProfileEntity> resultMap = new HashMap<String, DnaUserProfileEntity>();
                String finalTableName = null;
                if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte) {
                    finalTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
                } else if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook) {
                    finalTableName = Dynamo.getFinalTableName(FacebookUserProfileEntity.class);
                }
                HashMap keyMap = new HashMap();
                ArrayList keys = new ArrayList();
                keyMap.put(finalTableName, keys);
                HashMap finalResponse = new HashMap();
                int itemCounter = 0;
                for (UserProfile eachProfile : userState.getFriends()) {
                    HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
                    key.put("ID", new AttributeValue().withS(eachProfile.getId()));
                    keys.add(key);
                    if (++itemCounter < 24) continue;
                    itemCounter = 0;
                    response = DynamoCommon.batchGet(keyMap, (Token)token);
                    keyMap = new HashMap();
                    keys = new ArrayList();
                    keyMap.put(finalTableName, keys);
                    for (String eachTable : response.keySet()) {
                        existingItems = (ArrayList)finalResponse.get(eachTable);
                        if (existingItems == null) {
                            existingItems = new ArrayList();
                            finalResponse.put(eachTable, existingItems);
                        }
                        existingItems.addAll((Collection)response.get(eachTable));
                    }
                }
                if (itemCounter > 0) {
                    Map response2 = DynamoCommon.batchGet(keyMap, (Token)token);
                    keyMap = new HashMap();
                    keys = new ArrayList();
                    keyMap.put(finalTableName, keys);
                    for (String eachTable : response2.keySet()) {
                        ArrayList existingItems2 = (ArrayList)finalResponse.get(eachTable);
                        if (existingItems2 == null) {
                            existingItems2 = new ArrayList();
                            finalResponse.put(eachTable, existingItems2);
                        }
                        existingItems2.addAll((Collection)response2.get(eachTable));
                    }
                }
                if (finalResponse == null || finalResponse.isEmpty()) {
                    logger.info("fetchDnaFriends : empty result from batch request : there are no friends for this social network in out system");
                    return resultMap;
                }
                List accounts = (ArrayList)finalResponse.get(finalTableName);
                if (accounts == null) {
                    accounts = new ArrayList();
                }
                logger.info("fetchDnaFriends : result from batch request : there are " + accounts.size() + " friends from social network in our system");
                finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
                keyMap = new HashMap();
                keys = new ArrayList();
                keyMap.put(finalTableName, keys);
                finalResponse = new HashMap();
                logger.info("fetchDnaFriends : now create request to fetch all DnaUserProfileEntitys of these friends");
                itemCounter = 0;
                for (Map eachItem : accounts) {
                    HashMap<String, AttributeValue> key;
                    if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte) {
                        VkontakteUserProfileEntity vkItem = VkontakteUserProfileEntity.fromAttributeMap((Map)eachItem);
                        key = new HashMap<String, AttributeValue>();
                        key.put("ID", new AttributeValue().withS(vkItem.getDnaId()));
                        keys.add(key);
                        ++itemCounter;
                    } else if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Facebook) {
                        FacebookUserProfileEntity fbItem = FacebookUserProfileEntity.fromAttributeMap((Map)eachItem);
                        key = new HashMap();
                        key.put("ID", new AttributeValue().withS(fbItem.getDnaId()));
                        keys.add(key);
                        ++itemCounter;
                    }
                    if (itemCounter < 24) continue;
                    itemCounter = 0;
                    response = DynamoCommon.batchGet(keyMap, (Token)token);
                    keyMap = new HashMap();
                    keys = new ArrayList();
                    keyMap.put(finalTableName, keys);
                    for (String eachTable : response.keySet()) {
                        existingItems = (List)finalResponse.get(eachTable);
                        if (existingItems == null) {
                            existingItems = new ArrayList();
                            finalResponse.put(eachTable, existingItems);
                        }
                        existingItems.addAll((Collection)response.get(eachTable));
                    }
                }
                if (itemCounter > 0) {
                    Map response3 = DynamoCommon.batchGet(keyMap, (Token)token);
                    keyMap = new HashMap();
                    keys = new ArrayList();
                    keyMap.put(finalTableName, keys);
                    for (String eachTable : response3.keySet()) {
                        ArrayList existingItems3 = (ArrayList)finalResponse.get(eachTable);
                        if (existingItems3 == null) {
                            existingItems3 = new ArrayList();
                            finalResponse.put(eachTable, existingItems3);
                        }
                        existingItems3.addAll((Collection)response3.get(eachTable));
                    }
                }
                if ((accounts = (List)finalResponse.get(finalTableName)) == null) {
                    accounts = new ArrayList();
                }
                logger.info("fetchDnaFriends : there are " + accounts.size() + " DnaUserProfileEntitys in our system");
                for (Map eachItem : accounts) {
                    DnaUserProfileEntity item = DnaUserProfileEntity.fromAttributeMap((Map)eachItem);
                    if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) == SocialNetworks.Vkontakte) {
                        resultMap.put(item.getVkAccountId(), item);
                        continue;
                    }
                    if (SocialNetworks.valueOf((String)userState.getSocialNetworkName()) != SocialNetworks.Facebook) continue;
                    resultMap.put(item.getFbAccountId(), item);
                }
                return resultMap;
            }
        }, (ExecutionContext)BigBird.awsExecutionContext());
    }
}

