/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.google.common.collect.Lists;
import constants.EventCollection;
import constants.RankCollections;
import constants.SocialNetworks;
import db.model.CounterEntity;
import db.model.DnaFriendsEntity;
import db.model.DnaUserProfileEntity;
import db.model.StandartEventEntity;
import identity.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventQueueBuilder {
    public static final String EVENT_COUNTER_NAME = "events";
    private static final Logger logger = LoggerFactory.getLogger(EventQueueBuilder.class);

    public static void buildAndSaveEventQueue(DnaUserProfileEntity oldProfile, List<DnaFriendsEntity> oldFriendList, DnaUserProfileEntity newProfile, List<DnaFriendsEntity> newFriendList, Token token) {
        ArrayList<StandartEventEntity> result = new ArrayList<StandartEventEntity>();
        String dnaId = newProfile.getAccountId();
        Long eventIndex = null;
        if (oldProfile == null) {
            logger.info("buildAndSaveEventQueue : add WELCOME");
            eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
            StandartEventEntity welcome = new StandartEventEntity(dnaId, eventIndex, newProfile.getTimeWhenAccountWasCreated(), EventCollection.WELCOME.name(), newProfile.getScores().toString());
            result.add(welcome);
            RankCollections rank = RankCollections.getRankByScore((double)newProfile.getScores().longValue());
            logger.info("buildAndSaveEventQueue : add NEW_RANK_PLUS");
            eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
            StandartEventEntity rankPlus = new StandartEventEntity(dnaId, eventIndex, newProfile.getTimeWhenAccountWasCreated().plusMillis(1), EventCollection.NEW_RANK_PLUS.name(), rank.name());
            result.add(rankPlus);
        } else {
            StandartEventEntity increaseScore;
            if (oldProfile.getVkAccountId() == null && newProfile.getVkAccountId() != null) {
                logger.info("buildAndSaveEventQueue : add CONNECT_SOCIAL_NETWORK : Vkontakte");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity connectVk = new StandartEventEntity(dnaId, eventIndex, newProfile.getTimeWhenVkWasAttached(), EventCollection.CONNECT_SOCIAL_NETWORK.name(), SocialNetworks.Vkontakte.name());
                result.add(connectVk);
            } else if (oldProfile.getVkAccountId() != null && newProfile.getVkAccountId() == null) {
                logger.info("buildAndSaveEventQueue : add DISCONNECT_SOCIAL_NETWORK : Vkontakte");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity removeVk = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.DISCONNECT_SOCIAL_NETWORK.name(), SocialNetworks.Vkontakte.name());
                result.add(removeVk);
            }
            if (oldProfile.getVkAccountId() != null && oldProfile.isVkActive().booleanValue() && newProfile.getVkAccountId() != null && !newProfile.isVkActive().booleanValue()) {
                logger.info("buildAndSaveEventQueue : add SOCIAL_NETWORK_NOT_ACTIVE : Vkontakte");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity vkNotActive = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.SOCIAL_NETWORK_NOT_ACTIVE.name(), SocialNetworks.Vkontakte.name());
                result.add(vkNotActive);
            }
            if (oldProfile.getFbAccountId() == null && newProfile.getFbAccountId() != null) {
                logger.info("buildAndSaveEventQueue : add CONNECT_SOCIAL_NETWORK : Facebook");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity connectFb = new StandartEventEntity(dnaId, eventIndex, newProfile.getTimeWhenFbWasAttached(), EventCollection.CONNECT_SOCIAL_NETWORK.name(), SocialNetworks.Facebook.name());
                result.add(connectFb);
            } else if (oldProfile.getFbAccountId() != null && newProfile.getFbAccountId() == null) {
                logger.info("buildAndSaveEventQueue : add DISCONNECT_SOCIAL_NETWORK : Facebook");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity removeFb = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.DISCONNECT_SOCIAL_NETWORK.name(), SocialNetworks.Facebook.name());
                result.add(removeFb);
            }
            if (oldProfile.getFbAccountId() != null && oldProfile.isFbActive().booleanValue() && newProfile.getFbAccountId() != null && !newProfile.isFbActive().booleanValue()) {
                logger.info("buildAndSaveEventQueue : add SOCIAL_NETWORK_NOT_ACTIVE : Facebook");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity fbNotActive = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.SOCIAL_NETWORK_NOT_ACTIVE.name(), SocialNetworks.Facebook.name());
                result.add(fbNotActive);
            }
            Long oldScores = oldProfile.getScores();
            Long newScores = newProfile.getScores();
            int delta = newScores.intValue() - oldScores.intValue();
            if (delta < 0) {
                delta = -1 * delta;
            }
            RankCollections oldRank = RankCollections.getRankByScore((double)oldScores.longValue());
            RankCollections newRank = RankCollections.getRankByScore((double)newScores.longValue());
            if (delta != 0 && newScores > oldScores) {
                logger.info("buildAndSaveEventQueue : add INCREASE_OWN_SCORE");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                increaseScore = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.INCREASE_OWN_SCORE.name(), Integer.toString(delta));
                result.add(increaseScore);
                if (newRank != oldRank) {
                    logger.info("buildAndSaveEventQueue : add NEW_RANK_PLUS");
                    eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                    StandartEventEntity rankPlus = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.NEW_RANK_PLUS.name(), newRank.name());
                    result.add(rankPlus);
                }
            } else if (delta != 0 && newScores < oldScores) {
                logger.info("buildAndSaveEventQueue : add DECREASE_OWN_SCORE");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                increaseScore = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.DECREASE_OWN_SCORE.name(), Integer.toString(delta));
                result.add(increaseScore);
                if (newRank != oldRank) {
                    logger.info("buildAndSaveEventQueue : add NEW_RANK_MINUS");
                    eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                    StandartEventEntity rankMinus = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.NEW_RANK_MINUS.name(), newRank.name());
                    result.add(rankMinus);
                }
            }
        }
        List<DnaFriendsEntity> dnaFriendList = EventQueueBuilder.findNewFriends(oldFriendList, newFriendList);
        logger.info("buildAndSaveEventQueue : add FRIEND_HAS_JOINED : count :" + dnaFriendList.size());
        for (DnaFriendsEntity eachFriend : dnaFriendList) {
            eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
            StandartEventEntity friendHasJoined = new StandartEventEntity(dnaId, eventIndex, eachFriend.getTimeWhenDnaAccountWasCreated(), EventCollection.FRIEND_HAS_JOINED.name(), eachFriend.getName());
            result.add(friendHasJoined);
        }
        logger.info("buildAndSaveEventQueue : now save event list");
        StandartEventEntity.saveList(result, token);
    }

    public static void buildAndSaveEventQueue(DnaUserProfileEntity oldProfile, DnaUserProfileEntity newProfile, List<DnaFriendsEntity> newFriendList, Token token) {
        ArrayList<StandartEventEntity> result = new ArrayList<StandartEventEntity>();
        String dnaId = newProfile.getAccountId();
        Long eventIndex = null;
        if (oldProfile == null) {
            logger.info("buildAndSaveEventQueue : add WELCOME");
            eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
            StandartEventEntity welcome = new StandartEventEntity(dnaId, eventIndex, newProfile.getTimeWhenAccountWasCreated(), EventCollection.WELCOME.name(), newProfile.getScores().toString());
            result.add(welcome);
            RankCollections rank = RankCollections.getRankByScore((double)newProfile.getScores().longValue());
            logger.info("buildAndSaveEventQueue : add NEW_RANK_PLUS");
            eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
            StandartEventEntity rankPlus = new StandartEventEntity(dnaId, eventIndex, newProfile.getTimeWhenAccountWasCreated().plusMillis(1), EventCollection.NEW_RANK_PLUS.name(), rank.name());
            result.add(rankPlus);
        } else {
            StandartEventEntity increaseScore;
            if (oldProfile.getVkAccountId() == null && newProfile.getVkAccountId() != null) {
                logger.info("buildAndSaveEventQueue : add CONNECT_SOCIAL_NETWORK : Vkontakte");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity connectVk = new StandartEventEntity(dnaId, eventIndex, newProfile.getTimeWhenVkWasAttached(), EventCollection.CONNECT_SOCIAL_NETWORK.name(), SocialNetworks.Vkontakte.name());
                result.add(connectVk);
            } else if (oldProfile.getVkAccountId() != null && newProfile.getVkAccountId() == null) {
                logger.info("buildAndSaveEventQueue : add DISCONNECT_SOCIAL_NETWORK : Vkontakte");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity removeVk = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.DISCONNECT_SOCIAL_NETWORK.name(), SocialNetworks.Vkontakte.name());
                result.add(removeVk);
            }
            if (oldProfile.getVkAccountId() != null && oldProfile.isVkActive().booleanValue() && newProfile.getVkAccountId() != null && !newProfile.isVkActive().booleanValue()) {
                logger.info("buildAndSaveEventQueue : add SOCIAL_NETWORK_NOT_ACTIVE : Vkontakte");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity vkNotActive = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.SOCIAL_NETWORK_NOT_ACTIVE.name(), SocialNetworks.Vkontakte.name());
                result.add(vkNotActive);
            }
            if (oldProfile.getFbAccountId() == null && newProfile.getFbAccountId() != null) {
                logger.info("buildAndSaveEventQueue : add CONNECT_SOCIAL_NETWORK : Facebook");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity connectFb = new StandartEventEntity(dnaId, eventIndex, newProfile.getTimeWhenFbWasAttached(), EventCollection.CONNECT_SOCIAL_NETWORK.name(), SocialNetworks.Facebook.name());
                result.add(connectFb);
            } else if (oldProfile.getFbAccountId() != null && newProfile.getFbAccountId() == null) {
                logger.info("buildAndSaveEventQueue : add DISCONNECT_SOCIAL_NETWORK : Facebook");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity removeFb = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.DISCONNECT_SOCIAL_NETWORK.name(), SocialNetworks.Facebook.name());
                result.add(removeFb);
            }
            if (oldProfile.getFbAccountId() != null && oldProfile.isFbActive().booleanValue() && newProfile.getFbAccountId() != null && !newProfile.isFbActive().booleanValue()) {
                logger.info("buildAndSaveEventQueue : add SOCIAL_NETWORK_NOT_ACTIVE : Facebook");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                StandartEventEntity fbNotActive = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.SOCIAL_NETWORK_NOT_ACTIVE.name(), SocialNetworks.Facebook.name());
                result.add(fbNotActive);
            }
            Long oldScores = oldProfile.getScores();
            Long newScores = newProfile.getScores();
            int delta = newScores.intValue() - oldScores.intValue();
            if (delta < 0) {
                delta = -1 * delta;
            }
            RankCollections oldRank = RankCollections.getRankByScore((double)oldScores.longValue());
            RankCollections newRank = RankCollections.getRankByScore((double)newScores.longValue());
            if (delta != 0 && newScores > oldScores) {
                logger.info("buildAndSaveEventQueue : add INCREASE_OWN_SCORE");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                increaseScore = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.INCREASE_OWN_SCORE.name(), Integer.toString(delta));
                result.add(increaseScore);
                if (newRank != oldRank) {
                    logger.info("buildAndSaveEventQueue : add NEW_RANK_PLUS");
                    eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                    StandartEventEntity rankPlus = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.NEW_RANK_PLUS.name(), newRank.name());
                    result.add(rankPlus);
                }
            } else if (delta != 0 && newScores < oldScores) {
                logger.info("buildAndSaveEventQueue : add DECREASE_OWN_SCORE");
                eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                increaseScore = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.DECREASE_OWN_SCORE.name(), Integer.toString(delta));
                result.add(increaseScore);
                if (newRank != oldRank) {
                    logger.info("buildAndSaveEventQueue : add NEW_RANK_MINUS");
                    eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
                    StandartEventEntity rankMinus = new StandartEventEntity(dnaId, eventIndex, LocalDateTime.now(), EventCollection.NEW_RANK_MINUS.name(), newRank.name());
                    result.add(rankMinus);
                }
            }
        }
        ArrayList<DnaFriendsEntity> finalNewFriendList = new ArrayList<DnaFriendsEntity>();
        if (newFriendList != null) {
            finalNewFriendList.addAll(newFriendList);
        }
        logger.info("buildAndSaveEventQueue : add FRIEND_HAS_JOINED : count :" + finalNewFriendList.size());
        for (DnaFriendsEntity eachFriend : finalNewFriendList) {
            eventIndex = CounterEntity.next(EVENT_COUNTER_NAME, dnaId, token);
            StandartEventEntity friendHasJoined = new StandartEventEntity(dnaId, eventIndex, eachFriend.getTimeWhenDnaAccountWasCreated(), EventCollection.FRIEND_HAS_JOINED.name(), eachFriend.getName());
            result.add(friendHasJoined);
        }
        logger.info("buildAndSaveEventQueue : now save event list");
        StandartEventEntity.saveList(result, token);
    }

    private static List<DnaFriendsEntity> findNewFriends(List<DnaFriendsEntity> oldFriendList, List<DnaFriendsEntity> newFriendList) {
        if (newFriendList == null || newFriendList.isEmpty()) {
            return new ArrayList<DnaFriendsEntity>();
        }
        if (oldFriendList == null || oldFriendList.isEmpty()) {
            return Lists.newArrayList(newFriendList);
        }
        HashSet<String> oldFriendIds = new HashSet<String>();
        for (DnaFriendsEntity eachFriend : oldFriendList) {
            oldFriendIds.add(eachFriend.getFriendId());
        }
        ArrayList<DnaFriendsEntity> result = new ArrayList<DnaFriendsEntity>();
        for (DnaFriendsEntity eachFriend : newFriendList) {
            if (oldFriendIds.contains(eachFriend.getFriendId())) continue;
            result.add(eachFriend);
        }
        return result;
    }
}

