/*
 * Decompiled with CFR 0.152.
 */
package db.model.fb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import db.model.base.BaseProfileMetaInfo;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="facebook.profile.meta.info", rangeKeyName="APPLICATION")
public class FacebookProfileMetaInfo
extends BaseProfileMetaInfo {
    private static final Logger logger = LoggerFactory.getLogger(FacebookProfileMetaInfo.class);

    public FacebookProfileMetaInfo(String accountId, Integer numberOfFriends, Integer numberOfSubscribers, Integer numberOfPost, Integer othersCommentOnUserPost, Integer othersLikesOnUserPost, Integer othersLikesOnUserComment, LocalDateTime updateDateTime, String application) {
        super(accountId, numberOfFriends, numberOfSubscribers, numberOfPost, othersCommentOnUserPost, othersLikesOnUserPost, othersLikesOnUserComment, updateDateTime, application);
    }

    public static FacebookProfileMetaInfo createCopy(FacebookProfileMetaInfo facebookProfileMetaInfo) {
        return new FacebookProfileMetaInfo(facebookProfileMetaInfo.getAccountId(), facebookProfileMetaInfo.getNumberOfFriends(), facebookProfileMetaInfo.getNumberOfSubscribers(), facebookProfileMetaInfo.getNumberOfPost(), facebookProfileMetaInfo.getOthersCommentOnUserPost(), facebookProfileMetaInfo.getOthersLikesOnUserPost(), facebookProfileMetaInfo.getOthersLikesOnUserComment(), facebookProfileMetaInfo.getUpdateDateTime(), facebookProfileMetaInfo.getApplication());
    }

    public static FacebookProfileMetaInfo fromAttributeMap(Map<String, AttributeValue> map) {
        String fbAccountId = map.get("ID").getS();
        String application = map.get("APPLICATION").getS();
        Integer numberOfFriends = map.get("FRIENDS") != null ? Integer.valueOf(map.get("FRIENDS").getN()) : null;
        Integer numberOfSubscribers = map.get("SUBSCRIBERS") != null ? Integer.valueOf(map.get("SUBSCRIBERS").getN()) : null;
        Integer numberOfPost = map.get("POSTS") != null ? Integer.valueOf(map.get("POSTS").getN()) : null;
        Integer othersCommentOnUserPost = map.get("OTHER_COMMENTS_ON_USER_POSTS") != null ? Integer.valueOf(map.get("OTHER_COMMENTS_ON_USER_POSTS").getN()) : null;
        Integer othersLikesOnUserPost = map.get("OTHER_LIKES_ON_USER_POSTS") != null ? Integer.valueOf(map.get("OTHER_LIKES_ON_USER_POSTS").getN()) : null;
        Integer othersLikesOnUserComment = map.get("OTHER_LIKES_ON_USER_COMMENTS") != null ? Integer.valueOf(map.get("OTHER_LIKES_ON_USER_COMMENTS").getN()) : null;
        LocalDateTime updateTime = map.get("UPDATE_TIME") != null ? LocalDateTime.parse((String)map.get("UPDATE_TIME").getS()) : null;
        return new FacebookProfileMetaInfo(fbAccountId, numberOfFriends, numberOfSubscribers, numberOfPost, othersCommentOnUserPost, othersLikesOnUserPost, othersLikesOnUserComment, updateTime, application);
    }

    public static FacebookProfileMetaInfo createOrUpdate(FacebookProfileMetaInfo facebookProfileMetaInfo, Token token) {
        logger.debug("createOrUpdate");
        String finalTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
        Map<String, AttributeValue> attributeValueMap = facebookProfileMetaInfo.toAttributeMap();
        DynamoCommon.putItem(finalTableName, attributeValueMap, token);
        return facebookProfileMetaInfo;
    }

    public static FacebookProfileMetaInfo fetchById(String fbAccountId, Token token) {
        logger.debug("fetchById");
        String finalTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(fbAccountId));
        key.put("APPLICATION", new AttributeValue().withS(token.getSourceApplication()));
        Map<String, AttributeValue> attributeValueMap = DynamoCommon.fetchItem(finalTableName, key, token);
        if (attributeValueMap == null) {
            return null;
        }
        return FacebookProfileMetaInfo.fromAttributeMap(attributeValueMap);
    }

    public static void deleteItems(List<FacebookProfileMetaInfo> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (FacebookProfileMetaInfo eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getAccountId()));
            key.put("APPLICATION", new AttributeValue().withS(eachItem.getApplication()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    @Deprecated
    public static List<FacebookProfileMetaInfo> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(FacebookProfileMetaInfo.class);
        ArrayList<FacebookProfileMetaInfo> level1AccountEntityList = new ArrayList<FacebookProfileMetaInfo>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", "FRIENDS", "SUBSCRIBERS", "POSTS", "OTHER_COMMENTS_ON_USER_POSTS", "OTHER_LIKES_ON_USER_POSTS", "OTHER_LIKES_ON_USER_COMMENTS", "UPDATE_TIME", "APPLICATION"}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                level1AccountEntityList.add(FacebookProfileMetaInfo.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return level1AccountEntityList;
    }
}

