/*
 * Decompiled with CFR 0.152.
 */
package db.model.base;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseToken {
    public static final String ACCESS_TOKEN_ATTR_NAME = "ACCESS_TOKEN";
    public static final String TIME_WHEN_TOKEN_WILL_BE_EXPIRED_ATTR_NAME = "EXPIRE_TIME";
    public static final String REFRESH_DATE_ATTR_NAME = "REFRESH_DATE";
    public static final String TIME_WHEN_TOKEN_WAS_UPDATED = "WAS_UPDATED_AT";
    private String accountId;
    private String accessToken;
    private LocalDateTime timeWhenTokenWillBeExpired;
    private LocalDateTime refreshDateTime;
    private LocalDateTime timeWhenTokenWasUpdated;
    private String application;

    public BaseToken(String accountId, String accessToken, LocalDateTime timeWhenTokenWillBeExpired, LocalDateTime refreshDateTime, LocalDateTime timeWhenTokenWasUpdated, String application) {
        this.accountId = accountId;
        this.accessToken = accessToken;
        this.timeWhenTokenWillBeExpired = timeWhenTokenWillBeExpired;
        this.refreshDateTime = refreshDateTime;
        this.timeWhenTokenWasUpdated = timeWhenTokenWasUpdated;
        this.application = application;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public LocalDateTime getTimeWhenTokenWillBeExpired() {
        return this.timeWhenTokenWillBeExpired;
    }

    public LocalDateTime getRefreshDateTime() {
        return this.refreshDateTime;
    }

    public LocalDateTime getTimeWhenTokenWasUpdated() {
        return this.timeWhenTokenWasUpdated;
    }

    public String getApplication() {
        return this.application;
    }

    public Map<String, AttributeValue> keyMap() {
        HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
        keyMap.put("ID", new AttributeValue().withS(this.accountId));
        keyMap.put("APPLICATION", new AttributeValue().withS(this.application));
        return keyMap;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.accountId));
        map.put("APPLICATION", new AttributeValue().withS(this.application));
        if (this.accessToken != null && !this.accessToken.isEmpty()) {
            map.put(ACCESS_TOKEN_ATTR_NAME, new AttributeValue().withS(this.accessToken));
        }
        if (this.timeWhenTokenWillBeExpired != null) {
            map.put(TIME_WHEN_TOKEN_WILL_BE_EXPIRED_ATTR_NAME, new AttributeValue().withS(this.timeWhenTokenWillBeExpired.toString()));
        }
        if (this.refreshDateTime != null) {
            map.put(REFRESH_DATE_ATTR_NAME, new AttributeValue().withS(this.refreshDateTime.toString()));
        }
        if (this.timeWhenTokenWasUpdated != null) {
            map.put(TIME_WHEN_TOKEN_WAS_UPDATED, new AttributeValue().withS(this.timeWhenTokenWasUpdated.toString()));
        }
        return map;
    }

    public Map<String, AttributeValue> getKey() {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(this.accountId));
        key.put("APPLICATION", new AttributeValue().withS(this.application));
        return key;
    }
}

